/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.imexp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTDrawing;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTTwoCellAnchor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalReference;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalReferences;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.w3c.dom.Node;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.DataValidation;
import org.zkoss.poi.ss.usermodel.DataValidationConstraint;
import org.zkoss.poi.ss.usermodel.Name;
import org.zkoss.poi.ss.usermodel.Picture;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.SheetProtection;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.usermodel.ZssChartX;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.ss.usermodel.charts.XYDataSerie;
import org.zkoss.poi.ss.usermodel.charts.XYZDataSerie;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.poi.xssf.model.ExternalLink;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.XSSFChartX;
import org.zkoss.poi.xssf.usermodel.XSSFClientAnchor;
import org.zkoss.poi.xssf.usermodel.XSSFDrawing;
import org.zkoss.poi.xssf.usermodel.XSSFName;
import org.zkoss.poi.xssf.usermodel.XSSFPictureHelper;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;
import org.zkoss.poi.xssf.usermodel.charts.XSSFArea3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFAreaChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBar3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBarChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBubbleChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumn3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumnChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFDoughnutChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLine3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLineChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPie3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPieChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFScatChartData;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SSheetProtection;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.chart.SGeneralChartData;
import org.zkoss.zss.model.chart.SSeries;
import org.zkoss.zss.model.impl.AbstractDataValidationAdv;
import org.zkoss.zss.range.impl.imexp.AbstractExcelImporter;
import org.zkoss.zss.range.impl.imexp.ImExpUtils;
import org.zkoss.zss.range.impl.imexp.PoiEnumConversion;
import org.zkoss.zss.range.impl.imexp.UnitUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelXlsxImporter
extends AbstractExcelImporter {
    private static final Logger logger = Logger.getLogger(ExcelXlsxImporter.class.getName());

    @Override
    protected Workbook createPoiBook(InputStream is) throws IOException {
        return new XSSFWorkbook(is);
    }

    @Override
    protected void importExternalBookLinks() {
        try {
            ArrayList<String> bookNames = new ArrayList<String>();
            XSSFWorkbook xssfBook = (XSSFWorkbook)this.workbook;
            CTWorkbook ctBook = xssfBook.getCTWorkbook();
            CTExternalReferences externalReferences = ctBook.getExternalReferences();
            if (externalReferences != null) {
                List exRefs = externalReferences.getExternalReferenceList();
                for (CTExternalReference exRef : exRefs) {
                    ExternalLink link = (ExternalLink)xssfBook.getRelationById(exRef.getId());
                    bookNames.add(link.getBookName());
                }
            }
            if (bookNames.size() > 0) {
                this.book.setAttribute("$ZSS_EXTERNAL_BOOK_NAMES$", bookNames);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void importColumn(Sheet poiSheet, SSheet sheet) {
        CTWorksheet worksheet = ((XSSFSheet)poiSheet).getCTWorksheet();
        if (worksheet.sizeOfColsArray() <= 0) {
            return;
        }
        int defaultWidth = UnitUtil.defaultColumnWidthToPx(poiSheet.getDefaultColumnWidth(), 7);
        CTCols colsArray = worksheet.getColsArray(0);
        for (int i = 0; i < colsArray.sizeOfColArray(); ++i) {
            CellStyle columnStyle;
            CTCol ctCol = colsArray.getColArray(i);
            SColumnArray columnArray = sheet.setupColumnArray((int)ctCol.getMin() - 1, (int)ctCol.getMax() - 1);
            columnArray.setCustomWidth(ctCol.getCustomWidth());
            boolean hidden = ctCol.getHidden();
            int columnIndex = (int)ctCol.getMin() - 1;
            columnArray.setHidden(hidden);
            int width = ImExpUtils.getWidthAny(poiSheet, columnIndex, 7);
            if (!hidden && width != defaultWidth) {
                columnArray.setWidth(width);
            }
            if ((columnStyle = poiSheet.getColumnStyle(columnIndex)) == null) continue;
            columnArray.setCellStyle(this.importCellStyle(columnStyle));
        }
    }

    private void importChart(List<ZssChartX> poiCharts, Sheet poiSheet, SSheet sheet) {
        block15: for (ZssChartX zssChart : poiCharts) {
            XSSFChart xssfChart = (XSSFChart)zssChart.getChart();
            ViewAnchor viewAnchor = this.toViewAnchor(poiSheet, xssfChart.getPreferredSize());
            SChart chart = null;
            XSSFAreaChartData categoryData = null;
            switch (xssfChart.getChartType()) {
                case Area: {
                    chart = sheet.addChart(SChart.ChartType.AREA, viewAnchor);
                    categoryData = new XSSFAreaChartData(xssfChart);
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(categoryData.getGrouping()));
                    break;
                }
                case Area3D: {
                    chart = sheet.addChart(SChart.ChartType.AREA, viewAnchor);
                    categoryData = new XSSFArea3DChartData(xssfChart);
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFArea3DChartData)categoryData).getGrouping()));
                    break;
                }
                case Bar: {
                    chart = sheet.addChart(SChart.ChartType.BAR, viewAnchor);
                    categoryData = new XSSFBarChartData(xssfChart);
                    chart.setBarDirection(PoiEnumConversion.toBarDirection(((XSSFBarChartData)categoryData).getBarDirection()));
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFBarChartData)categoryData).getGrouping()));
                    break;
                }
                case Bar3D: {
                    chart = sheet.addChart(SChart.ChartType.BAR, viewAnchor);
                    categoryData = new XSSFBar3DChartData(xssfChart);
                    chart.setBarDirection(PoiEnumConversion.toBarDirection(((XSSFBar3DChartData)categoryData).getBarDirection()));
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFBar3DChartData)categoryData).getGrouping()));
                    break;
                }
                case Bubble: {
                    chart = sheet.addChart(SChart.ChartType.BUBBLE, viewAnchor);
                    XSSFBubbleChartData xyzData = new XSSFBubbleChartData(xssfChart);
                    this.importXyzSeries(xyzData.getSeries(), (SGeneralChartData)chart.getData());
                    break;
                }
                case Column: {
                    chart = sheet.addChart(SChart.ChartType.COLUMN, viewAnchor);
                    categoryData = new XSSFColumnChartData(xssfChart);
                    chart.setBarDirection(PoiEnumConversion.toBarDirection(((XSSFColumnChartData)categoryData).getBarDirection()));
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFColumnChartData)categoryData).getGrouping()));
                    break;
                }
                case Column3D: {
                    chart = sheet.addChart(SChart.ChartType.COLUMN, viewAnchor);
                    categoryData = new XSSFColumn3DChartData(xssfChart);
                    chart.setBarDirection(PoiEnumConversion.toBarDirection(((XSSFColumn3DChartData)categoryData).getBarDirection()));
                    chart.setGrouping(PoiEnumConversion.toChartGrouping(((XSSFColumn3DChartData)categoryData).getGrouping()));
                    break;
                }
                case Doughnut: {
                    chart = sheet.addChart(SChart.ChartType.DOUGHNUT, viewAnchor);
                    categoryData = new XSSFDoughnutChartData(xssfChart);
                    break;
                }
                case Line: {
                    chart = sheet.addChart(SChart.ChartType.LINE, viewAnchor);
                    categoryData = new XSSFLineChartData(xssfChart);
                    break;
                }
                case Line3D: {
                    chart = sheet.addChart(SChart.ChartType.LINE, viewAnchor);
                    categoryData = new XSSFLine3DChartData(xssfChart);
                    break;
                }
                case Pie: {
                    chart = sheet.addChart(SChart.ChartType.PIE, viewAnchor);
                    categoryData = new XSSFPieChartData(xssfChart);
                    break;
                }
                case Pie3D: {
                    chart = sheet.addChart(SChart.ChartType.PIE, viewAnchor);
                    categoryData = new XSSFPie3DChartData(xssfChart);
                    break;
                }
                case Scatter: {
                    chart = sheet.addChart(SChart.ChartType.SCATTER, viewAnchor);
                    XSSFScatChartData xyData = new XSSFScatChartData(xssfChart);
                    this.importXySeries(xyData.getSeries(), (SGeneralChartData)chart.getData());
                    break;
                }
                default: {
                    continue block15;
                }
            }
            if (xssfChart.getTitle() != null) {
                chart.setTitle(xssfChart.getTitle().getString());
            }
            chart.setThreeD(xssfChart.isSetView3D());
            chart.setLegendPosition(PoiEnumConversion.toLengendPosition(xssfChart.getOrCreateLegend().getPosition()));
            if (categoryData == null) continue;
            this.importSeries(categoryData.getSeries(), (SGeneralChartData)chart.getData());
        }
    }

    private void importSeries(List<? extends CategoryDataSerie> seriesList, SGeneralChartData chartData) {
        CategoryDataSerie firstSeries = null;
        firstSeries = seriesList.get(0);
        if (firstSeries != null) {
            chartData.setCategoriesFormula(this.getValueFormula(firstSeries.getCategories()));
        }
        for (int i = 0; i < seriesList.size(); ++i) {
            CategoryDataSerie sourceSeries = seriesList.get(i);
            String nameExpression = this.getTitleFormula(sourceSeries.getTitle(), i);
            String xValueExpression = this.getValueFormula(sourceSeries.getValues());
            SSeries series = chartData.addSeries();
            series.setFormula(nameExpression, xValueExpression);
        }
    }

    private void importXySeries(List<? extends XYDataSerie> seriesList, SGeneralChartData chartData) {
        for (int i = 0; i < seriesList.size(); ++i) {
            XYDataSerie sourceSeries = seriesList.get(i);
            SSeries series = chartData.addSeries();
            series.setXYFormula(this.getTitleFormula(sourceSeries.getTitle(), i), this.getValueFormula(sourceSeries.getXs()), this.getValueFormula(sourceSeries.getYs()));
        }
    }

    private void importXyzSeries(List<? extends XYZDataSerie> seriesList, SGeneralChartData chartData) {
        for (int i = 0; i < seriesList.size(); ++i) {
            XYZDataSerie sourceSeries = seriesList.get(i);
            String nameExpression = this.getTitleFormula(sourceSeries.getTitle(), i);
            String xValueExpression = this.getValueFormula(sourceSeries.getXs());
            String yValueExpression = this.getValueFormula(sourceSeries.getYs());
            String zValueExpression = this.getValueFormula(sourceSeries.getZs());
            SSeries series = chartData.addSeries();
            series.setXYZFormula(nameExpression, xValueExpression, yValueExpression, zValueExpression);
        }
    }

    private String getTitleFormula(ChartTextSource textSource, int seriesIndex) {
        if (textSource == null) {
            return "\"Series" + seriesIndex + "\"";
        }
        if (textSource.isReference()) {
            return textSource.getFormulaString();
        }
        return "\"" + textSource.getTextString() + "\"";
    }

    private String getValueFormula(ChartDataSource<?> dataSource) {
        if (dataSource.isReference()) {
            return dataSource.getFormulaString();
        }
        int count = dataSource.getPointCount();
        if (count <= 0) {
            return null;
        }
        StringBuilder expression = new StringBuilder("{");
        for (int i = 0; i < count; ++i) {
            Object value = dataSource.getPointAt(i);
            if (value == null) {
                if (dataSource.isNumeric()) {
                    expression.append("0");
                } else {
                    expression.append("\"\"");
                }
            } else if (dataSource.isNumeric()) {
                expression.append(value.toString());
            } else {
                expression.append("\"").append(value).append("\"");
            }
            if (i == count - 1) continue;
            expression.append(",");
        }
        expression.append("}");
        return expression.toString();
    }

    @Override
    protected void importDrawings(Sheet poiSheet, SSheet sheet) {
        LinkedList<ZssChartX> poiCharts = new LinkedList<ZssChartX>();
        LinkedList<Picture> poiPictures = new LinkedList<Picture>();
        XSSFDrawing patriarch = null;
        for (POIXMLDocumentPart dr : ((XSSFSheet)poiSheet).getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            patriarch = (XSSFDrawing)dr;
            break;
        }
        if (patriarch != null) {
            CTDrawing ctdrawing = patriarch.getCTDrawing();
            for (CTTwoCellAnchor anchor : ctdrawing.getTwoCellAnchorArray()) {
                CTPicture ctPicture;
                CTMarker from = anchor.getFrom();
                CTMarker to = anchor.getTo();
                XSSFClientAnchor clientAnchor = null;
                if (from != null && to != null) {
                    clientAnchor = new XSSFClientAnchor((int)from.getColOff(), (int)from.getRowOff(), (int)to.getColOff(), (int)to.getRowOff(), from.getCol(), from.getRow(), to.getCol(), to.getRow());
                }
                if ((ctPicture = anchor.getPic()) == null) {
                    CTGraphicalObjectFrame gfrm = anchor.getGraphicFrame();
                    if (gfrm == null) continue;
                    XSSFChartX chartX = this.createXSSFChartX(patriarch, gfrm, clientAnchor);
                    poiCharts.add((ZssChartX)chartX);
                    continue;
                }
                poiPictures.add((Picture)XSSFPictureHelper.newXSSFPicture(patriarch, clientAnchor, ctPicture));
            }
        }
        this.importChart(poiCharts, poiSheet, sheet);
        this.importPicture(poiPictures, poiSheet, sheet);
    }

    private XSSFChartX createXSSFChartX(XSSFDrawing patriarch, CTGraphicalObjectFrame gfrm, XSSFClientAnchor xanchor) {
        String name = gfrm.getNvGraphicFramePr().getCNvPr().getName();
        CTGraphicalObject gobj = gfrm.getGraphic();
        CTGraphicalObjectData gdata = gobj.getGraphicData();
        String chartId = null;
        for (Node child = gdata.getDomNode().getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!"chart".equals(child.getLocalName())) continue;
            chartId = child.getAttributes().getNamedItemNS("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id").getNodeValue();
            break;
        }
        XSSFChartX chartX = new XSSFChartX(patriarch, xanchor, name, chartId);
        return chartX;
    }

    @Override
    protected int getAnchorWidthInPx(ClientAnchor anchor, Sheet poiSheet) {
        short firstColumn = anchor.getCol1();
        int firstColumnWidth = ImExpUtils.getWidthAny(poiSheet, firstColumn, 7);
        int offsetInFirstColumn = UnitUtil.emuToPx(anchor.getDx1());
        int anchorWidthInFirstColumn = firstColumnWidth - offsetInFirstColumn;
        int anchorWidthInLastColumn = UnitUtil.emuToPx(anchor.getDx2());
        short lastColumn = anchor.getCol2();
        int width = firstColumn == lastColumn ? anchorWidthInLastColumn - offsetInFirstColumn : anchorWidthInFirstColumn + anchorWidthInLastColumn;
        width = Math.abs(width);
        for (int j = firstColumn + 1; j < lastColumn; ++j) {
            width += ImExpUtils.getWidthAny(poiSheet, j, 7);
        }
        return width;
    }

    @Override
    protected int getAnchorHeightInPx(ClientAnchor anchor, Sheet poiSheet) {
        int firstRow = anchor.getRow1();
        int offsetInFirstRow = UnitUtil.emuToPx(anchor.getDy1());
        int firstRowHeight = ImExpUtils.getHeightAny(poiSheet, firstRow);
        int anchorHeightInFirstRow = firstRowHeight - offsetInFirstRow;
        int lastRow = anchor.getRow2();
        int anchorHeightInLastRow = UnitUtil.emuToPx(anchor.getDy2());
        int height = lastRow == firstRow ? anchorHeightInLastRow - offsetInFirstRow : anchorHeightInFirstRow + anchorHeightInLastRow;
        height = Math.abs(height);
        for (int row = firstRow + 1; row < lastRow; ++row) {
            height += ImExpUtils.getHeightAny(poiSheet, row);
        }
        return height;
    }

    @Override
    protected int getXoffsetInPixel(ClientAnchor clientAnchor, Sheet poiSheet) {
        return UnitUtil.emuToPx(clientAnchor.getDx1());
    }

    @Override
    protected int getYoffsetInPixel(ClientAnchor clientAnchor, Sheet poiSheet) {
        return UnitUtil.emuToPx(clientAnchor.getDy1());
    }

    @Override
    protected void importValidation(Sheet poiSheet, SSheet sheet) {
        for (DataValidation poiValidation : poiSheet.getDataValidations()) {
            SDataValidation dataValidation = sheet.addDataValidation(null, null);
            CellRangeAddress[] cellRangeAddresses = poiValidation.getRegions().getCellRangeAddresses();
            DataValidationConstraint poiConstraint = poiValidation.getValidationConstraint();
            ((AbstractDataValidationAdv)dataValidation).setFormulas(poiConstraint.getFormula1(), poiConstraint.getFormula2());
            dataValidation.setOperatorType(PoiEnumConversion.toOperatorType(poiConstraint.getOperator()));
            dataValidation.setValidationType(PoiEnumConversion.toValidationType(poiConstraint.getValidationType()));
            dataValidation.setIgnoreBlank(poiValidation.getEmptyCellAllowed());
            dataValidation.setErrorTitle(poiValidation.getErrorBoxTitle());
            dataValidation.setErrorMessage(poiValidation.getErrorBoxText());
            dataValidation.setAlertStyle(PoiEnumConversion.toErrorStyle(poiValidation.getErrorStyle()));
            dataValidation.setInputTitle(poiValidation.getPromptBoxTitle());
            dataValidation.setInputMessage(poiValidation.getPromptBoxText());
            if (poiConstraint.getValidationType() == 3) {
                dataValidation.setInCellDropdown(poiValidation.getSuppressDropDownArrow());
            }
            dataValidation.setShowError(poiValidation.getShowErrorBox());
            dataValidation.setShowInput(poiValidation.getShowPromptBox());
            HashSet<CellRegion> regions = new HashSet<CellRegion>();
            for (CellRangeAddress cellRangeAddr : cellRangeAddresses) {
                regions.add(new CellRegion(cellRangeAddr.formatAsString()));
            }
            dataValidation.setRegions(regions);
        }
    }

    @Override
    protected boolean skipName(Name definedName) {
        boolean r = super.skipName(definedName);
        if (r) {
            return r;
        }
        return ((XSSFName)definedName).isBuiltInName();
    }

    @Override
    protected void setBookType(SBook book) {
        book.setAttribute(BOOK_TYPE_KEY, "xlsx");
    }

    @Override
    protected void importPassword(Sheet poiSheet, SSheet sheet) {
        short hashpass = ((XSSFSheet)poiSheet).getPasswordHash();
        sheet.setHashedPassword(hashpass);
    }

    @Override
    protected void importSheetProtection(Sheet poiSheet, SSheet sheet) {
        SheetProtection sp = poiSheet.getOrCreateSheetProtection();
        SSheetProtection ssp = sheet.getSheetProtection();
        ssp.setAutoFilter(sp.isAutoFilter());
        ssp.setDeleteColumns(sp.isDeleteColumns());
        ssp.setDeleteRows(sp.isDeleteRows());
        ssp.setFormatCells(sp.isFormatCells());
        ssp.setFormatColumns(sp.isFormatColumns());
        ssp.setFormatRows(sp.isFormatRows());
        ssp.setInsertColumns(sp.isInsertColumns());
        ssp.setInsertHyperlinks(sp.isInsertHyperlinks());
        ssp.setInsertRows(sp.isInsertRows());
        ssp.setPivotTables(sp.isPivotTables());
        ssp.setSort(sp.isSort());
        ssp.setObjects(sp.isObjects());
        ssp.setScenarios(sp.isScenarios());
        ssp.setSelectLockedCells(sp.isSelectLockedCells());
        ssp.setSelectUnlockedCells(sp.isSelectUnlockedCells());
    }
}

