/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.imexp;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.DataValidation;
import org.zkoss.poi.ss.usermodel.DataValidationConstraint;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.usermodel.charts.AxisPosition;
import org.zkoss.poi.ss.usermodel.charts.CategoryAxis;
import org.zkoss.poi.ss.usermodel.charts.CategoryData;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartData;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartLegend;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.ss.usermodel.charts.XYData;
import org.zkoss.poi.ss.usermodel.charts.XYZData;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.poi.ss.util.CellRangeAddressList;
import org.zkoss.poi.xssf.usermodel.XSSFAutoFilter;
import org.zkoss.poi.xssf.usermodel.XSSFClientAnchor;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;
import org.zkoss.poi.xssf.usermodel.charts.XSSFArea3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFAreaChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBar3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBarChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBubbleChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumn3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumnChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFDoughnutChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLine3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLineChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPie3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPieChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFScatChartData;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SPicture;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.chart.SGeneralChartData;
import org.zkoss.zss.model.chart.SSeries;
import org.zkoss.zss.range.impl.imexp.AbstractExcelExporter;
import org.zkoss.zss.range.impl.imexp.PoiEnumConversion;
import org.zkoss.zss.range.impl.imexp.UnitUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelXlsxExporter
extends AbstractExcelExporter {
    @Override
    protected void exportColumnArray(SSheet sheet, Sheet poiSheet, SColumnArray columnArr) {
        XSSFSheet xssfSheet = (XSSFSheet)poiSheet;
        CTWorksheet ctSheet = xssfSheet.getCTWorksheet();
        if (xssfSheet.getCTWorksheet().sizeOfColsArray() == 0) {
            xssfSheet.getCTWorksheet().addNewCols();
        }
        CTCol col = ctSheet.getColsArray(0).addNewCol();
        col.setMin((long)(columnArr.getIndex() + 1));
        col.setMax((long)(columnArr.getLastIndex() + 1));
        col.setStyle((long)this.toPOICellStyle(columnArr.getCellStyle()).getIndex());
        col.setCustomWidth(true);
        col.setWidth(UnitUtil.pxToCTChar(columnArr.getWidth(), 7));
        col.setHidden(columnArr.isHidden());
    }

    @Override
    protected Workbook createPoiBook() {
        return new XSSFWorkbook();
    }

    @Override
    protected void exportChart(SSheet sheet, Sheet poiSheet) {
        for (SChart chart : sheet.getCharts()) {
            ChartData chartData = this.fillPoiChartData(chart);
            if (chartData == null) continue;
            this.plotPoiChart(chart, chartData, sheet, poiSheet);
        }
    }

    @Override
    protected void exportPicture(SSheet sheet, Sheet poiSheet) {
        for (SPicture picture : sheet.getPictures()) {
            int poiPictureIndex = (Integer)this.exportedPicDataMap.get(picture.getPictureData().getIndex());
            poiSheet.createDrawingPatriarch().createPicture(this.toClientAnchor(picture.getAnchor(), sheet), poiPictureIndex);
        }
    }

    private ChartData fillPoiChartData(SChart chart) {
        XSSFDoughnutChartData categoryData = null;
        XSSFBubbleChartData chartData = null;
        switch (chart.getType()) {
            case AREA: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFArea3DChartData();
                    ((XSSFArea3DChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                    break;
                }
                categoryData = new XSSFAreaChartData();
                ((XSSFAreaChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                break;
            }
            case BAR: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFBar3DChartData();
                    ((XSSFBar3DChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                    ((XSSFBar3DChartData)categoryData).setBarDirection(PoiEnumConversion.toPoiBarDirection(chart.getBarDirection()));
                    break;
                }
                categoryData = new XSSFBarChartData();
                ((XSSFBarChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                ((XSSFBarChartData)categoryData).setBarDirection(PoiEnumConversion.toPoiBarDirection(chart.getBarDirection()));
                break;
            }
            case BUBBLE: {
                XSSFBubbleChartData xyzData = new XSSFBubbleChartData();
                this.fillXYZData((SGeneralChartData)chart.getData(), (XYZData)xyzData);
                chartData = xyzData;
                break;
            }
            case COLUMN: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFColumn3DChartData();
                    ((XSSFColumn3DChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                    ((XSSFColumn3DChartData)categoryData).setBarDirection(PoiEnumConversion.toPoiBarDirection(chart.getBarDirection()));
                    break;
                }
                categoryData = new XSSFColumnChartData();
                ((XSSFColumnChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                ((XSSFColumnChartData)categoryData).setBarDirection(PoiEnumConversion.toPoiBarDirection(chart.getBarDirection()));
                break;
            }
            case DOUGHNUT: {
                categoryData = new XSSFDoughnutChartData();
                break;
            }
            case LINE: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFLine3DChartData();
                    break;
                }
                categoryData = new XSSFLineChartData();
                break;
            }
            case PIE: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFPie3DChartData();
                    break;
                }
                categoryData = new XSSFPieChartData();
                break;
            }
            case SCATTER: {
                XSSFScatChartData xyData = new XSSFScatChartData();
                this.fillXYData((SGeneralChartData)chart.getData(), (XYData)xyData);
                chartData = xyData;
                break;
            }
            default: {
                return chartData;
            }
        }
        if (categoryData != null) {
            this.fillCategoryData((SGeneralChartData)chart.getData(), (CategoryData)categoryData);
            chartData = categoryData;
        }
        return chartData;
    }

    private void plotPoiChart(SChart chart, ChartData chartData, SSheet sheet, Sheet poiSheet) {
        Chart poiChart = poiSheet.createDrawingPatriarch().createChart(this.toClientAnchor(chart.getAnchor(), sheet));
        if (chart.isThreeD()) {
            poiChart.getOrCreateView3D();
        }
        if (chart.getLegendPosition() != null) {
            ChartLegend legend = poiChart.getOrCreateLegend();
            legend.setPosition(PoiEnumConversion.toPoiLegendPosition(chart.getLegendPosition()));
        }
        CategoryAxis bottomAxis = null;
        switch (chart.getType()) {
            case AREA: 
            case BAR: 
            case COLUMN: 
            case LINE: {
                bottomAxis = poiChart.getChartAxisFactory().createCategoryAxis(AxisPosition.BOTTOM);
                break;
            }
            case BUBBLE: 
            case SCATTER: {
                bottomAxis = poiChart.getChartAxisFactory().createValueAxis(AxisPosition.BOTTOM);
            }
        }
        if (bottomAxis != null) {
            poiChart.plot(chartData, new ChartAxis[]{bottomAxis, poiChart.getChartAxisFactory().createValueAxis(AxisPosition.LEFT)});
        } else {
            poiChart.plot(chartData, new ChartAxis[0]);
        }
    }

    private ClientAnchor toClientAnchor(ViewAnchor viewAnchor, SSheet sheet) {
        ViewAnchor rightBottomAnchor = viewAnchor.getRightBottomAnchor(sheet);
        XSSFClientAnchor clientAnchor = new XSSFClientAnchor(UnitUtil.pxToEmu(viewAnchor.getXOffset()), UnitUtil.pxToEmu(viewAnchor.getYOffset()), UnitUtil.pxToEmu(rightBottomAnchor.getXOffset()), UnitUtil.pxToEmu(rightBottomAnchor.getYOffset()), viewAnchor.getColumnIndex(), viewAnchor.getRowIndex(), rightBottomAnchor.getColumnIndex(), rightBottomAnchor.getRowIndex());
        return clientAnchor;
    }

    private void fillCategoryData(SGeneralChartData chartData, CategoryData categoryData) {
        ChartDataSource<?> categories = this.createCategoryChartDataSource(chartData);
        for (int i = 0; i < chartData.getNumOfSeries(); ++i) {
            SSeries series = chartData.getSeries(i);
            ChartTextSource title = this.createChartTextSource(series);
            ChartDataSource<Number> values = this.createXValueDataSource(series);
            categoryData.addSerie(title, categories, values);
        }
    }

    private void fillXYData(SGeneralChartData chartData, XYData xyData) {
        for (int i = 0; i < chartData.getNumOfSeries(); ++i) {
            SSeries series = chartData.getSeries(i);
            ChartTextSource title = this.createChartTextSource(series);
            ChartDataSource<Number> xValues = this.createXValueDataSource(series);
            ChartDataSource<Number> yValues = this.createYValueDataSource(series);
            xyData.addSerie(title, xValues, yValues);
        }
    }

    private void fillXYZData(SGeneralChartData chartData, XYZData xyzData) {
        for (int i = 0; i < chartData.getNumOfSeries(); ++i) {
            SSeries series = chartData.getSeries(i);
            ChartTextSource title = this.createChartTextSource(series);
            ChartDataSource<Number> xValues = this.createXValueDataSource(series);
            ChartDataSource<Number> yValues = this.createYValueDataSource(series);
            ChartDataSource<Number> zValues = this.createZValueDataSource(series);
            xyzData.addSerie(title, xValues, yValues, zValues);
        }
    }

    private ChartDataSource<Number> createXValueDataSource(final SSeries series) {
        return new ChartDataSource<Number>(){

            public int getPointCount() {
                return series.getNumOfXValue();
            }

            public Number getPointAt(int index) {
                try {
                    return Double.parseDouble(series.getXValue(index).toString());
                }
                catch (NumberFormatException nfe) {
                    return index;
                }
            }

            public boolean isReference() {
                return true;
            }

            public boolean isNumeric() {
                return true;
            }

            public String getFormulaString() {
                return series.getXValuesFormula();
            }

            public void renameSheet(String oldname, String newname) {
            }
        };
    }

    private ChartDataSource<Number> createYValueDataSource(final SSeries series) {
        return new ChartDataSource<Number>(){

            public int getPointCount() {
                return series.getNumOfYValue();
            }

            public Number getPointAt(int index) {
                try {
                    return Double.parseDouble(series.getYValue(index).toString());
                }
                catch (NumberFormatException nfe) {
                    return index;
                }
            }

            public boolean isReference() {
                return true;
            }

            public boolean isNumeric() {
                return true;
            }

            public String getFormulaString() {
                return series.getYValuesFormula();
            }

            public void renameSheet(String oldname, String newname) {
            }
        };
    }

    private ChartDataSource<Number> createZValueDataSource(final SSeries series) {
        return new ChartDataSource<Number>(){

            public int getPointCount() {
                return series.getNumOfZValue();
            }

            public Number getPointAt(int index) {
                try {
                    return Double.parseDouble(series.getZValue(index).toString());
                }
                catch (NumberFormatException e) {
                    return index;
                }
            }

            public boolean isReference() {
                return true;
            }

            public boolean isNumeric() {
                return true;
            }

            public String getFormulaString() {
                return series.getZValuesFormula();
            }

            public void renameSheet(String oldname, String newname) {
            }
        };
    }

    private ChartTextSource createChartTextSource(final SSeries series) {
        return new ChartTextSource(){

            public void renameSheet(String oldname, String newname) {
            }

            public boolean isReference() {
                return true;
            }

            public String getTextString() {
                return series.getName();
            }

            public String getFormulaString() {
                return series.getNameFormula();
            }
        };
    }

    private ChartDataSource<?> createCategoryChartDataSource(final SGeneralChartData chartData) {
        return new ChartDataSource<String>(){

            public int getPointCount() {
                return chartData.getNumOfCategory();
            }

            public String getPointAt(int index) {
                return chartData.getCategory(index).toString();
            }

            public boolean isReference() {
                return true;
            }

            public boolean isNumeric() {
                return false;
            }

            public String getFormulaString() {
                return chartData.getCategoriesFormula();
            }

            public void renameSheet(String oldname, String newname) {
            }
        };
    }

    @Override
    protected void exportValidation(SSheet sheet, Sheet poiSheet) {
        block9: for (SDataValidation validation : sheet.getDataValidations()) {
            int operatorType = PoiEnumConversion.toPoiOperatorType(validation.getOperatorType());
            String formula1 = validation.getFormula1();
            String formula2 = validation.getFormula2();
            DataValidationConstraint constraint = null;
            switch (validation.getValidationType()) {
                case TIME: {
                    constraint = poiSheet.getDataValidationHelper().createTimeConstraint(operatorType, formula1, formula2);
                    break;
                }
                case TEXT_LENGTH: {
                    constraint = poiSheet.getDataValidationHelper().createTextLengthConstraint(operatorType, formula1, formula2);
                    break;
                }
                case DATE: {
                    constraint = poiSheet.getDataValidationHelper().createDateConstraint(operatorType, formula1, formula2, "");
                    break;
                }
                case LIST: {
                    constraint = poiSheet.getDataValidationHelper().createFormulaListConstraint(formula1);
                    break;
                }
                case INTEGER: {
                    constraint = poiSheet.getDataValidationHelper().createIntegerConstraint(operatorType, formula1, formula2);
                    break;
                }
                case CUSTOM: {
                    constraint = poiSheet.getDataValidationHelper().createCustomConstraint(formula1);
                    break;
                }
                case DECIMAL: {
                    constraint = poiSheet.getDataValidationHelper().createDecimalConstraint(operatorType, formula1, formula2);
                    break;
                }
                default: {
                    continue block9;
                }
            }
            CellRangeAddressList rgnList = new CellRangeAddressList();
            for (CellRegion rgn : validation.getRegions()) {
                rgnList.addCellRangeAddress(rgn.getRow(), rgn.getColumn(), rgn.getLastRow(), rgn.getLastColumn());
            }
            DataValidation poiValidation = poiSheet.getDataValidationHelper().createValidation(constraint, rgnList);
            poiValidation.setEmptyCellAllowed(validation.isIgnoreBlank());
            poiValidation.setSuppressDropDownArrow(validation.isInCellDropdown());
            poiValidation.setErrorStyle(PoiEnumConversion.toPoiErrorStyle(validation.getAlertStyle()));
            poiValidation.createErrorBox(validation.getErrorTitle(), validation.getErrorMessage());
            poiValidation.setShowErrorBox(validation.isShowError());
            poiValidation.createPromptBox(validation.getInputTitle(), validation.getInputMessage());
            poiValidation.setShowPromptBox(validation.isShowInput());
            poiSheet.addValidationData(poiValidation);
        }
    }

    @Override
    protected void exportAutoFilter(SSheet sheet, Sheet poiSheet) {
        SAutoFilter autoFilter = sheet.getAutoFilter();
        if (autoFilter != null) {
            CellRegion region = autoFilter.getRegion();
            XSSFAutoFilter poiAutoFilter = (XSSFAutoFilter)poiSheet.setAutoFilter(new CellRangeAddress(region.getRow(), region.getLastRow(), region.getColumn(), region.getLastColumn()));
            int numberOfColumn = region.getLastColumn() - region.getColumn() + 1;
            for (int i = 0; i < numberOfColumn; ++i) {
                SAutoFilter.NFilterColumn srcFilterColumn = autoFilter.getFilterColumn(i, false);
                if (srcFilterColumn == null) continue;
                XSSFAutoFilter.XSSFFilterColumn destFilterColumn = (XSSFAutoFilter.XSSFFilterColumn)poiAutoFilter.getOrCreateFilterColumn(i);
                String[] criteria1 = null;
                if (srcFilterColumn.getCriteria1() != null) {
                    criteria1 = srcFilterColumn.getCriteria1().toArray(new String[0]);
                }
                String[] criteria2 = null;
                if (srcFilterColumn.getCriteria1() != null) {
                    criteria2 = srcFilterColumn.getCriteria2().toArray(new String[0]);
                }
                destFilterColumn.setProperties((Object)criteria1, PoiEnumConversion.toPoiFilterOperator(srcFilterColumn.getOperator()), (Object)criteria2, Boolean.valueOf(srcFilterColumn.isShowButton()));
            }
        }
    }

    @Override
    protected void exportPassword(SSheet sheet, Sheet poiSheet) {
        short hashpass = sheet.getHashedPassword();
        if (hashpass != 0) {
            ((XSSFSheet)poiSheet).setPasswordHash(hashpass);
        }
    }
}

