/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.imexp;

import org.zkoss.poi.hssf.usermodel.HSSFSheet;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.range.impl.imexp.AbstractExcelExporter;
import org.zkoss.zss.range.impl.imexp.UnitUtil;

public class ExcelXlsExporter
extends AbstractExcelExporter {
    protected void exportColumnArray(SSheet sheet, Sheet poiSheet, SColumnArray columnArr) {
        CellStyle poiCellStyle = this.toPOICellStyle(columnArr.getCellStyle());
        boolean hidden = columnArr.isHidden();
        for (int i = columnArr.getIndex(); i <= columnArr.getLastIndex() && i <= SpreadsheetVersion.EXCEL97.getMaxColumns(); ++i) {
            poiSheet.setColumnWidth(i, UnitUtil.pxToFileChar256(columnArr.getWidth(), 7));
            poiSheet.setColumnHidden(i, hidden);
            poiSheet.setDefaultColumnStyle(i, poiCellStyle);
        }
    }

    protected Workbook createPoiBook() {
        return new HSSFWorkbook();
    }

    protected void exportChart(SSheet sheet, Sheet poiSheet) {
    }

    protected void exportPicture(SSheet sheet, Sheet poiSheet) {
    }

    protected void exportValidation(SSheet sheet, Sheet poiSheet) {
    }

    protected void exportAutoFilter(SSheet sheet, Sheet poiSheet) {
    }

    protected void exportPassword(SSheet sheet, Sheet poiSheet) {
        short hashpass = sheet.getHashedPassword();
        if (hashpass != 0) {
            ((HSSFSheet)poiSheet).setPasswordHash(hashpass);
        }
    }
}

