/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.autofill;

import java.util.Calendar;
import java.util.Date;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.range.impl.autofill.Step;

public class DateTimeStep
implements Step {
    private final Calendar _cal = Calendar.getInstance();
    private long _current;
    private final int _yearStep;
    private final int _monthStep;
    private final int _dayStep;
    private final int _millisecondStep;
    private final int _type;
    private final long _zero;

    public DateTimeStep(Date date, int yearStep, int monthStep, int dayStep, int millisecondStep, int type) {
        this._current = date.getTime();
        this._yearStep = yearStep;
        this._monthStep = monthStep;
        this._dayStep = dayStep;
        this._millisecondStep = millisecondStep;
        this._type = type;
        this._zero = EngineFactory.getInstance().getCalendarUtil().doubleValueToDate(0.0).getTime();
    }

    public Object next(SCell cell) {
        this._cal.clear();
        this._cal.setTimeInMillis(this._current);
        if (this._yearStep != 0) {
            this._cal.add(1, this._yearStep);
        }
        if (this._monthStep != 0) {
            this._cal.add(2, this._monthStep);
        }
        if (this._dayStep != 0) {
            this._cal.add(5, this._dayStep);
        }
        if (this._millisecondStep != 0) {
            this._cal.add(14, this._millisecondStep);
        }
        this._current = this._cal.getTimeInMillis();
        if (this._current < this._zero) {
            this._current += 86400000L;
            this._cal.setTimeInMillis(this._current);
        }
        return this._cal.getTime();
    }

    public int getDataType() {
        return this._type;
    }
}

