/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl.autofill;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.lang.Strings;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.PasteOption;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.format.FormatContext;
import org.zkoss.zss.model.sys.format.FormatEngine;
import org.zkoss.zss.model.sys.format.FormatResult;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.impl.autofill.BlankStep;
import org.zkoss.zss.range.impl.autofill.CopyStep;
import org.zkoss.zss.range.impl.autofill.DateTimeStep;
import org.zkoss.zss.range.impl.autofill.FullMonthData;
import org.zkoss.zss.range.impl.autofill.FullMonthStep;
import org.zkoss.zss.range.impl.autofill.FullWeekData;
import org.zkoss.zss.range.impl.autofill.FullWeekStep;
import org.zkoss.zss.range.impl.autofill.GrowthStep;
import org.zkoss.zss.range.impl.autofill.LinearStep;
import org.zkoss.zss.range.impl.autofill.ShortMonthData;
import org.zkoss.zss.range.impl.autofill.ShortMonthStep;
import org.zkoss.zss.range.impl.autofill.ShortWeekData;
import org.zkoss.zss.range.impl.autofill.ShortWeekStep;
import org.zkoss.zss.range.impl.autofill.Step;

public class AutoFillHelper {
    private static final int FILL_INVALID = 0;
    private static final int FILL_NONE = 1;
    private static final int FILL_UP = 2;
    private static final int FILL_DOWN = 3;
    private static final int FILL_RIGHT = 4;
    private static final int FILL_LEFT = 5;
    private static final Pattern datePattern = Pattern.compile("[yMwWDdFE]+");
    private static final Pattern timePattern = Pattern.compile("[HhKkmsS]+");
    FormatEngine formatEngine;
    private final StepChunk CopyStepChunkInstance = new CopyStepChunk();

    public void fill(SSheet sheet, CellRegion srcRegion, CellRegion dstRegion, SRange.FillType fillType) {
        int fillDir = AutoFillHelper.getFillDirection(srcRegion, dstRegion);
        if (fillDir == 1) {
            return;
        }
        switch (fillDir) {
            case 2: {
                this.fillUp(sheet, srcRegion, dstRegion, fillType);
                return;
            }
            case 3: {
                this.fillDown(sheet, srcRegion, dstRegion, fillType);
                return;
            }
            case 4: {
                this.fillRight(sheet, srcRegion, dstRegion, fillType);
                return;
            }
            case 5: {
                this.fillLeft(sheet, srcRegion, dstRegion, fillType);
                return;
            }
        }
        throw new InvalidModelOpException("Destination range must include source range and can be fill in one direction only");
    }

    private static int getShortWeekIndex(String x, Locale locale) {
        return ShortWeekData.getInstance(0, locale).getIndex(x);
    }

    private static int getFullWeekIndex(String x, Locale locale) {
        return FullWeekData.getInstance(0, locale).getIndex(x);
    }

    private static int getShortMonthIndex(String x, Locale locale) {
        return ShortMonthData.getInstance(0, locale).getIndex(x);
    }

    private static int getFullMonthIndex(String x, Locale locale) {
        return FullMonthData.getInstance(0, locale).getIndex(x);
    }

    private static boolean isShortWeek(String x, Locale locale) {
        return AutoFillHelper.getShortWeekIndex(x, locale) >= 0;
    }

    private static boolean isFullWeek(String x, Locale locale) {
        return AutoFillHelper.getFullWeekIndex(x, locale) >= 0;
    }

    private static boolean isShortMonth(String x, Locale locale) {
        return AutoFillHelper.getShortMonthIndex(x, locale) >= 0;
    }

    private static boolean isFullMonth(String x, Locale locale) {
        return AutoFillHelper.getFullMonthIndex(x, locale) >= 0;
    }

    private static int nextWeekIndex(int current, int step) {
        return AutoFillHelper.nextCircularIndex(current, step, 7);
    }

    private static int nextMonthIndex(int current, int step) {
        return AutoFillHelper.nextCircularIndex(current, step, 12);
    }

    private static int nextCircularIndex(int current, int step, int modulo) {
        if ((current += step) < 0) {
            current += modulo;
        }
        return current % modulo;
    }

    private static int getWeekMonthSubType(String x, Locale locale) {
        if (AutoFillHelper.isShortWeek(x, locale)) {
            return 1;
        }
        if (AutoFillHelper.isShortMonth(x, locale)) {
            return 2;
        }
        if (AutoFillHelper.isFullWeek(x, locale)) {
            return 3;
        }
        if (AutoFillHelper.isFullMonth(x, locale)) {
            return 4;
        }
        if (AutoFillHelper.isShortWeek(x, Locale.US)) {
            return 17;
        }
        if (AutoFillHelper.isShortMonth(x, Locale.US)) {
            return 18;
        }
        if (AutoFillHelper.isFullWeek(x, Locale.US)) {
            return 19;
        }
        if (AutoFillHelper.isFullMonth(x, Locale.US)) {
            return 20;
        }
        if (Strings.isBlank((String)x)) {
            return 8;
        }
        return 0;
    }

    private static boolean isDatePattern(String pattern) {
        Matcher dateM = datePattern.matcher(pattern);
        return dateM.find();
    }

    private static boolean isTimePattern(String pattern) {
        Matcher dateM = timePattern.matcher(pattern);
        return dateM.find();
    }

    private FormatEngine getFormatEngine() {
        if (this.formatEngine == null) {
            this.formatEngine = EngineFactory.getInstance().createFormatEngine();
        }
        return this.formatEngine;
    }

    private int getDateTimeSubType(SCell cell) {
        FormatResult result = this.getFormatEngine().format(cell, new FormatContext(ZssContext.getCurrent().getLocale()));
        Format format = result.getFormater();
        if (result.isDateFormatted() && format instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)format).toPattern();
            return AutoFillHelper.isDatePattern(pattern) ? 6 : 7;
        }
        return 5;
    }

    private int[] getTimeParts(SCell srcCell) {
        String pattern1;
        boolean withtime;
        int[] parts = new int[7];
        int j = 0;
        Date date = srcCell.getDateValue();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        parts[j++] = cal.get(1);
        parts[j++] = cal.get(2);
        parts[j++] = cal.get(5);
        FormatResult result = this.getFormatEngine().format(srcCell, new FormatContext(ZssContext.getCurrent().getLocale()));
        Format format = result.getFormater();
        if (result.isDateFormatted() && format instanceof SimpleDateFormat && (withtime = AutoFillHelper.isTimePattern(pattern1 = ((SimpleDateFormat)format).toPattern()))) {
            parts[j++] = cal.get(11);
            parts[j++] = cal.get(12);
            parts[j++] = cal.get(13);
            parts[j++] = cal.get(14);
            return parts;
        }
        parts[j++] = -1;
        return parts;
    }

    private static Step getTimeStep(SCell[] srcCells, int b, int e, boolean positive, SRange.FillType fillType, int subType) {
        SCell srcCell1 = srcCells[b];
        if (b == e) {
            return new DateTimeStep(srcCell1.getDateValue(), 0, 0, 0, positive ? 3600000 : -3600000, subType);
        }
        Date date1 = srcCell1.getDateValue();
        SCell srcCell2 = srcCells[b + 1];
        Date date2 = srcCell2.getDateValue();
        int step = (int)(date2.getTime() - date1.getTime());
        for (int k = b + 2; k <= e; ++k) {
            srcCell2 = srcCells[k];
            date1 = date2;
            date2 = srcCell2.getDateValue();
            if ((long)step == date2.getTime() - date1.getTime()) continue;
            return CopyStep.instance;
        }
        return new DateTimeStep(date2, 0, 0, 0, step, subType);
    }

    private Step getDateStep(SCell[] srcCells, int b, int e, boolean positive, SRange.FillType fillType, int subType) {
        if (fillType == SRange.FillType.DEFAULT) {
            fillType = SRange.FillType.DAYS;
        }
        return this.myGetDateStep(srcCells, b, e, positive, fillType, subType);
    }

    private Step myGetDateStep(SCell[] srcCells, int b, int e, boolean positive, SRange.FillType fillType, int subType) {
        SCell srcCell1 = srcCells[b];
        int[] time1 = this.getTimeParts(srcCell1);
        int j = 0;
        int y1 = time1[j];
        int m1 = time1[++j];
        int d1 = time1[++j];
        int h1 = time1[++j];
        int min1 = time1[++j];
        int s1 = time1[++j];
        int ms1 = time1[++j];
        int t1 = (h1 < 0 ? 0 : h1 * 60 * 60 * 1000) + min1 * 60 * 1000 + s1 * 1000 + ms1;
        if (b == e) {
            Date date = srcCells[b].getDateValue();
            switch (fillType) {
                case DAYS: {
                    return new DateTimeStep(date, 0, 0, positive ? 1 : -1, 0, subType);
                }
                case HOURS: {
                    return new DateTimeStep(date, 0, 0, 0, positive ? 3600000 : -3600000, subType);
                }
                case MONTHS: {
                    return new DateTimeStep(date, 0, positive ? 1 : -1, 0, 0, subType);
                }
                case YEARS: {
                    return new DateTimeStep(date, positive ? 1 : -1, 0, 0, 0, subType);
                }
                case WEEKDAYS: {
                    return new DateTimeStep(date, 0, 0, positive ? 7 : -7, 0, subType);
                }
            }
            return CopyStep.instance;
        }
        SCell srcCell2 = srcCells[b + 1];
        int[] time2 = this.getTimeParts(srcCell2);
        j = 0;
        int y2 = time2[j];
        int m2 = time2[++j];
        int d2 = time2[++j];
        int h2 = time2[++j];
        int min2 = time2[++j];
        int s2 = time2[++j];
        int ms2 = time2[++j];
        int diffM = m2 - m1 + (y2 - y1) * 12;
        int diffD = d2 - d1;
        if (h1 < 0 && h2 >= 0) {
            h1 = h2;
            min1 = min2;
            s1 = s2;
            ms1 = ms2;
        } else if (h1 >= 0 && h2 < 0) {
            h2 = h1;
            min2 = min1;
            s2 = s1;
            ms2 = ms1;
        }
        int t2 = (h2 < 0 ? 0 : h2 * 60 * 60 * 1000) + min2 * 60 * 1000 + s2 * 1000 + ms2;
        int diffT = t2 - t1;
        for (int k = b + 2; k <= e; ++k) {
            y1 = y2;
            m1 = m2;
            d1 = d2;
            h1 = h2;
            min1 = min2;
            s1 = s2;
            ms1 = ms2;
            t1 = t2;
            SCell srcCell = srcCells[k];
            int[] time = this.getTimeParts(srcCell);
            j = 0;
            y2 = time[j];
            m2 = time[++j];
            d2 = time[++j];
            h2 = time[++j];
            min2 = time[++j];
            s2 = time[++j];
            ms2 = time[++j];
            if (diffM != m2 - m1 + (y2 - y1) * 12 || diffD != d2 - d1) {
                return CopyStep.instance;
            }
            if (h1 < 0 && h2 >= 0) {
                h1 = h2;
                min1 = min2;
                s1 = s2;
                ms1 = ms2;
            } else if (h1 >= 0 && h2 < 0) {
                h2 = h1;
                min2 = min1;
                s2 = s1;
                ms2 = ms1;
            }
            t2 = (h2 < 0 ? 0 : h2 * 60 * 60 * 1000) + min2 * 60 * 1000 + s2 * 1000 + ms2;
            if (diffT == t2 - t1) continue;
            diffT = 0;
        }
        if (h1 < 0) {
            h1 = 0;
        }
        if (h2 < 0) {
            h2 = 0;
        }
        Calendar cal2 = Calendar.getInstance();
        cal2.set(y2, m2, d2, h2, min2, s2);
        cal2.set(14, ms2);
        if (diffD != 0) {
            Calendar cal1 = Calendar.getInstance();
            cal1.set(y1, m1, d1, h1, min1, s1);
            cal1.set(14, ms1);
            int doy1 = cal1.get(6);
            int doy2 = cal2.get(6);
            diffD = (y2 - y1) * 365 + doy2 - doy1;
            return new DateTimeStep(cal2.getTime(), 0, 0, diffD, diffT, -1);
        }
        return new DateTimeStep(cal2.getTime(), 0, diffM, 0, diffT, -1);
    }

    private static Step getGrowthStep(SCell[] srcCells, int b, int e, boolean positive) {
        if (b == e) {
            return CopyStep.instance;
        }
        double prev = srcCells[b].getNumberValue();
        double curv = srcCells[b + 1].getNumberValue();
        double ratio = curv / prev;
        prev = curv;
        for (int k = b + 2; k <= e; ++k) {
            SCell srcCell = srcCells[k];
            curv = srcCell.getNumberValue();
            if (ratio != curv / prev) {
                return CopyStep.instance;
            }
            prev = curv;
        }
        return new GrowthStep(curv, ratio, -1);
    }

    private static Step getLinearStep(SCell[] srcCells, int b, int e, boolean positive) {
        int count = e - b + 1;
        double[] values = new double[count];
        int j = 0;
        for (int k = b; k <= e; ++k) {
            SCell srcCell = srcCells[k];
            values[j++] = srcCell.getNumberValue();
        }
        if (count == 1) {
            double step = positive ? 1.0 : -1.0;
            return new LinearStep(values[count - 1], step, step, 5);
        }
        if (count == 2) {
            double step = values[1] - values[0];
            return new LinearStep(values[count - 1], step, step, -1);
        }
        if (count == 3) {
            double step = values[2] - values[0];
            double initStep = (step + values[1] - values[0]) / 3.0;
            return new LinearStep(values[count - 1], initStep, step /= 2.0, -1);
        }
        if (count == 4) {
            double initStep = (values[2] - values[0]) / 2.0;
            double step = (values[3] - values[0]) * 0.3 + (values[2] - values[1]) * 0.1;
            return new LinearStep(values[count - 1], initStep, step, -1);
        }
        double initStep = -0.4 * values[0] - 0.1 * values[1] + 0.2 * values[2] + 0.5 * values[3] - 0.2 * values[4];
        double step = -0.2 * values[0] - 0.1 * values[1] + 0.1 * values[3] + 0.2 * values[4];
        return new LinearStep(values[count - 1], initStep, step, -1);
    }

    private static int getCaseType(String x) {
        if (Character.isLowerCase(x.charAt(0))) {
            return 1;
        }
        if (Character.isUpperCase(x.charAt(1))) {
            return 2;
        }
        return 0;
    }

    private static Step getShortWeekStep(SCell[] srcCells, int b, int e, boolean positive, Locale locale) {
        int count = e - b + 1;
        String bWeek = null;
        int preIndex = -1;
        int step = 0;
        for (int j = b; j <= e; ++j) {
            SCell srcCell = srcCells[j];
            String x = srcCell.getStringValue();
            int weekIndex = AutoFillHelper.getShortWeekIndex(x, locale);
            if (step == 0) {
                if (preIndex >= 0) {
                    step = weekIndex - preIndex;
                    preIndex = weekIndex;
                    continue;
                }
                bWeek = x;
                preIndex = weekIndex;
                if (count != 1) continue;
                step = positive ? 1 : -1;
                continue;
            }
            if ((preIndex = AutoFillHelper.nextWeekIndex(preIndex, step)) == weekIndex) continue;
            return CopyStep.instance;
        }
        return new ShortWeekStep(preIndex, step, AutoFillHelper.getCaseType(bWeek), b == e ? 1 : -1, locale);
    }

    private static Step getFullWeekStep(SCell[] srcCells, int b, int e, boolean positive, Locale locale) {
        int count = e - b + 1;
        String bWeek = null;
        int preIndex = -1;
        int step = 0;
        for (int j = b; j <= e; ++j) {
            SCell srcCell = srcCells[j];
            String x = srcCell.getStringValue();
            int weekIndex = AutoFillHelper.getFullWeekIndex(x, locale);
            if (step == 0) {
                if (preIndex >= 0) {
                    step = weekIndex - preIndex;
                    preIndex = weekIndex;
                    continue;
                }
                bWeek = x;
                preIndex = weekIndex;
                if (count != 1) continue;
                step = positive ? 1 : -1;
                continue;
            }
            if ((preIndex = AutoFillHelper.nextWeekIndex(preIndex, step)) == weekIndex) continue;
            return CopyStep.instance;
        }
        return new FullWeekStep(preIndex, step, AutoFillHelper.getCaseType(bWeek), b == e ? 3 : -1, locale);
    }

    private static Step getShortMonthStep(SCell[] srcCells, int b, int e, boolean positive, Locale locale) {
        int count = e - b + 1;
        String bMonth = null;
        int preIndex = -1;
        int step = 0;
        for (int j = b; j <= e; ++j) {
            SCell srcCell = srcCells[j];
            String x = srcCell.getStringValue();
            int monthIndex = AutoFillHelper.getShortMonthIndex(x, locale);
            if (step == 0) {
                if (preIndex >= 0) {
                    step = monthIndex - preIndex;
                    preIndex = monthIndex;
                    continue;
                }
                bMonth = x;
                preIndex = monthIndex;
                if (count != 1) continue;
                step = positive ? 1 : -1;
                continue;
            }
            if ((preIndex = AutoFillHelper.nextMonthIndex(preIndex, step)) == monthIndex) continue;
            return CopyStep.instance;
        }
        return new ShortMonthStep(preIndex, step, AutoFillHelper.getCaseType(bMonth), b == e ? 2 : -1, locale);
    }

    private static Step getFullMonthStep(SCell[] srcCells, int b, int e, boolean positive, Locale locale) {
        int count = e - b + 1;
        String bMonth = null;
        int preIndex = -1;
        int step = 0;
        for (int j = b; j <= e; ++j) {
            SCell srcCell = srcCells[j];
            String x = srcCell.getStringValue();
            int monthIndex = AutoFillHelper.getFullMonthIndex(x, locale);
            if (step == 0) {
                if (preIndex >= 0) {
                    step = monthIndex - preIndex;
                    preIndex = monthIndex;
                    continue;
                }
                bMonth = x;
                preIndex = monthIndex;
                if (count != 1) continue;
                step = positive ? 1 : -1;
                continue;
            }
            if ((preIndex = AutoFillHelper.nextMonthIndex(preIndex, step)) == monthIndex) continue;
            return CopyStep.instance;
        }
        return new FullMonthStep(preIndex, step, AutoFillHelper.getCaseType(bMonth), b == e ? 4 : -1, locale);
    }

    private StepChunk getRowStepChunk(SSheet sheet, SRange.FillType fillType, int col, int row1, int row2, boolean pos, int colCount) {
        switch (fillType) {
            case DEFAULT: {
                int diff = row2 - row1;
                SCell[] cells = new SCell[(pos ? diff : -diff) + 1];
                if (pos) {
                    int j = 0;
                    for (int row = row1; row <= row2; ++row) {
                        SCell srcCell = sheet.getCell(row, col);
                        cells[j++] = srcCell;
                    }
                } else {
                    int j = 0;
                    for (int row = row1; row >= row2; --row) {
                        SCell srcCell = sheet.getCell(row, col);
                        cells[j++] = srcCell;
                    }
                }
                return new StepChunk(cells, fillType, pos, colCount);
            }
        }
        return this.CopyStepChunkInstance;
    }

    private StepChunk getColStepChunk(SSheet sheet, SRange.FillType fillType, int row, int col1, int col2, boolean pos, int rowCount) {
        switch (fillType) {
            case DEFAULT: {
                int diff = col2 - col1;
                SCell[] cells = new SCell[(pos ? diff : -diff) + 1];
                if (pos) {
                    int j = 0;
                    for (int col = col1; col <= col2; ++col) {
                        SCell srcCell = sheet.getCell(row, col);
                        cells[j++] = srcCell;
                    }
                } else {
                    int j = 0;
                    for (int col = col1; col >= col2; --col) {
                        SCell srcCell = sheet.getCell(row, col);
                        cells[j++] = srcCell;
                    }
                }
                return new StepChunk(cells, fillType, pos, rowCount);
            }
        }
        return this.CopyStepChunkInstance;
    }

    private static void replaceWithCopyStep(StepChunk[] stepChunks, int index, int b, int e) {
        for (int j = b; j < e; ++j) {
            stepChunks[j].replaceWithCopyStep(index);
        }
    }

    private static void handleSpecialCopyStep(StepChunk[] stepChunks, int srcCount, int siblingCount) {
        for (int index = 0; index < srcCount; ++index) {
            int j;
            int b = 0;
            int preType = -1;
            int count = 0;
            for (j = 0; j < siblingCount; ++j) {
                StepChunk stepChunk = stepChunks[j];
                Step step = stepChunk.getStep(index);
                int stepType = step.getDataType();
                if (preType != stepType) {
                    if (stepType == 8) continue;
                    if (preType >= 0 && count > 0) {
                        AutoFillHelper.replaceWithCopyStep(stepChunks, index, b, j);
                    }
                    count = 0;
                    b = j;
                    preType = stepType;
                    continue;
                }
                if (stepType == 8) continue;
                ++count;
            }
            if (preType < 0 || count <= 0) continue;
            AutoFillHelper.replaceWithCopyStep(stepChunks, index, b, j);
        }
    }

    private PasteOption.PasteType toSupportedFillPasteType(SRange.FillType fillType) {
        switch (fillType) {
            case DEFAULT: 
            case COPY: {
                return PasteOption.PasteType.ALL;
            }
            case FORMATS: {
                return PasteOption.PasteType.FORMATS;
            }
            case VALUES: {
                return PasteOption.PasteType.VALUES;
            }
        }
        return null;
    }

    public void fillDown(SSheet sheet, CellRegion srcRef, CellRegion dstRef, SRange.FillType fillType) {
        PasteOption.PasteType pasteType = this.toSupportedFillPasteType(fillType);
        if (pasteType == null) {
            return;
        }
        PasteOption pasteOption = new PasteOption();
        pasteOption.setPasteType(pasteType);
        int rowCount = srcRef.getRowCount();
        int colCount = srcRef.getColumnCount();
        int srctRow = srcRef.getRow();
        int srcbRow = srcRef.getLastRow();
        int srclCol = srcRef.getColumn();
        int srcrCol = srcRef.getLastColumn();
        int dstbRow = dstRef.getLastRow();
        StepChunk[] stepChunks = new StepChunk[colCount];
        int j = 0;
        for (int c = srclCol; c <= srcrCol; ++c) {
            StepChunk stepChunk = this.getRowStepChunk(sheet, fillType, c, srctRow, srcbRow, true, colCount);
            stepChunks[j++] = stepChunk;
        }
        AutoFillHelper.handleSpecialCopyStep(stepChunks, rowCount, colCount);
        int dstRowDiffCount = dstRef.getRowCount() - rowCount;
        int pastebRow = dstbRow - (dstRowDiffCount <= rowCount ? 0 : dstRowDiffCount % rowCount);
        if (pastebRow >= srcbRow + rowCount) {
            sheet.pasteCell(new SheetRegion(sheet, srctRow, srclCol, srcbRow, srcrCol), new CellRegion(srcbRow + 1, srclCol, pastebRow, srcrCol), pasteOption);
        }
        if (!this.isPasteValue(pasteType)) {
            return;
        }
        int j2 = 0;
        for (int c = srclCol; c <= srcrCol; ++c) {
            StepChunk stepChunk = stepChunks[j2++];
            int srcIndex = 0;
            int r = srcbRow + 1;
            while (r <= dstbRow) {
                int index = srcIndex % rowCount;
                int srcrow = srctRow + index;
                SCell srcCell = sheet.getCell(srcrow, c);
                if (srcCell.isNull()) {
                    sheet.clearCell(new CellRegion(r, c));
                } else {
                    Object value = stepChunk.getStep(index).next(srcCell);
                    this.applyStepValue(srcCell, sheet.getCell(r, c), value);
                }
                ++r;
                ++srcIndex;
            }
        }
    }

    public void applyStepValue(SCell srcCell, SCell dstCell, Object value) {
        SCell.CellType type = srcCell.getType();
        if (type == SCell.CellType.FORMULA) {
            return;
        }
        dstCell.setValue(value);
    }

    public void fillUp(SSheet sheet, CellRegion srcRef, CellRegion dstRef, SRange.FillType fillType) {
        PasteOption.PasteType pasteType = this.toSupportedFillPasteType(fillType);
        if (pasteType == null) {
            return;
        }
        PasteOption pasteOption = new PasteOption();
        pasteOption.setPasteType(pasteType);
        int rowCount = srcRef.getRowCount();
        int colCount = srcRef.getColumnCount();
        int srctRow = srcRef.getRow();
        int srcbRow = srcRef.getLastRow();
        int srclCol = srcRef.getColumn();
        int srcrCol = srcRef.getLastColumn();
        int dsttRow = dstRef.getRow();
        StepChunk[] stepChunks = new StepChunk[colCount];
        int j = 0;
        for (int c = srclCol; c <= srcrCol; ++c) {
            StepChunk stepChunk = this.getRowStepChunk(sheet, fillType, c, srcbRow, srctRow, false, colCount);
            stepChunks[j++] = stepChunk;
        }
        AutoFillHelper.handleSpecialCopyStep(stepChunks, rowCount, colCount);
        int dstRowDiffCount = dstRef.getRowCount() - rowCount;
        int pastetRow = dsttRow + (dstRowDiffCount <= rowCount ? 0 : dstRowDiffCount % rowCount);
        if (pastetRow <= srctRow - rowCount) {
            sheet.pasteCell(new SheetRegion(sheet, srctRow, srclCol, srcbRow, srcrCol), new CellRegion(pastetRow, srclCol, srctRow - 1, srcrCol), pasteOption);
        }
        if (!this.isPasteValue(pasteType)) {
            return;
        }
        int j2 = 0;
        for (int c = srclCol; c <= srcrCol; ++c) {
            StepChunk stepChunk = stepChunks[j2++];
            int srcIndex = 0;
            int r = srctRow - 1;
            while (r >= dsttRow) {
                int index = srcIndex % rowCount;
                int srcrow = srcbRow - index;
                SCell srcCell = sheet.getCell(srcrow, c);
                if (srcCell.isNull()) {
                    sheet.clearCell(new CellRegion(r, c));
                } else {
                    Object value = stepChunk.getStep(index).next(srcCell);
                    this.applyStepValue(srcCell, sheet.getCell(r, c), value);
                }
                --r;
                ++srcIndex;
            }
        }
    }

    public void fillRight(SSheet sheet, CellRegion srcRef, CellRegion dstRef, SRange.FillType fillType) {
        PasteOption.PasteType pasteType = this.toSupportedFillPasteType(fillType);
        if (pasteType == null) {
            return;
        }
        PasteOption pasteOption = new PasteOption();
        pasteOption.setPasteType(pasteType);
        int rowCount = srcRef.getRowCount();
        int colCount = srcRef.getColumnCount();
        int srclCol = srcRef.getColumn();
        int srcrCol = srcRef.getLastColumn();
        int srctRow = srcRef.getRow();
        int srcbRow = srcRef.getLastRow();
        int dstrCol = dstRef.getLastColumn();
        StepChunk[] stepChunks = new StepChunk[rowCount];
        int j = 0;
        for (int r = srctRow; r <= srcbRow; ++r) {
            StepChunk stepChunk = this.getColStepChunk(sheet, fillType, r, srclCol, srcrCol, true, rowCount);
            stepChunks[j++] = stepChunk;
        }
        AutoFillHelper.handleSpecialCopyStep(stepChunks, colCount, rowCount);
        int dstColDiffCount = dstRef.getColumnCount() - colCount;
        int pasterCol = dstrCol - (dstColDiffCount <= colCount ? 0 : dstColDiffCount % colCount);
        if (pasterCol >= srcrCol + colCount) {
            sheet.pasteCell(new SheetRegion(sheet, srctRow, srclCol, srcbRow, srcrCol), new CellRegion(srctRow, srcrCol + 1, srcbRow, pasterCol), pasteOption);
        }
        if (!this.isPasteValue(pasteType)) {
            return;
        }
        int j2 = 0;
        for (int r = srctRow; r <= srcbRow; ++r) {
            StepChunk stepChunk = stepChunks[j2++];
            int srcIndex = 0;
            int c = srcrCol + 1;
            while (c <= dstrCol) {
                int index = srcIndex % colCount;
                int srccol = srclCol + index;
                SCell srcCell = sheet.getCell(r, srccol);
                if (srcCell.isNull()) {
                    sheet.clearCell(new CellRegion(r, c));
                } else {
                    Object value = stepChunk.getStep(index).next(srcCell);
                    this.applyStepValue(srcCell, sheet.getCell(r, c), value);
                }
                ++c;
                ++srcIndex;
            }
        }
    }

    public void fillLeft(SSheet sheet, CellRegion srcRef, CellRegion dstRef, SRange.FillType fillType) {
        PasteOption.PasteType pasteType = this.toSupportedFillPasteType(fillType);
        if (pasteType == null) {
            return;
        }
        PasteOption pasteOption = new PasteOption();
        pasteOption.setPasteType(pasteType);
        int rowCount = srcRef.getRowCount();
        int colCount = srcRef.getColumnCount();
        int srclCol = srcRef.getColumn();
        int srcrCol = srcRef.getLastColumn();
        int srctRow = srcRef.getRow();
        int srcbRow = srcRef.getLastRow();
        int dstlCol = dstRef.getColumn();
        StepChunk[] stepChunks = new StepChunk[rowCount];
        int j = 0;
        for (int r = srctRow; r <= srcbRow; ++r) {
            StepChunk stepChunk = this.getColStepChunk(sheet, fillType, r, srcrCol, srclCol, false, rowCount);
            stepChunks[j++] = stepChunk;
        }
        AutoFillHelper.handleSpecialCopyStep(stepChunks, colCount, rowCount);
        int dstColDiffCount = dstRef.getColumnCount() - colCount;
        int pastelCol = dstlCol + (dstColDiffCount <= colCount ? 0 : dstColDiffCount % colCount);
        if (pastelCol <= srclCol - colCount) {
            sheet.pasteCell(new SheetRegion(sheet, srctRow, srclCol, srcbRow, srcrCol), new CellRegion(srctRow, pastelCol, srcbRow, srclCol - 1), pasteOption);
        }
        if (!this.isPasteValue(pasteType)) {
            return;
        }
        int j2 = 0;
        for (int r = srctRow; r <= srcbRow; ++r) {
            StepChunk stepChunk = stepChunks[j2++];
            int srcIndex = 0;
            int c = srclCol - 1;
            while (c >= dstlCol) {
                int index = srcIndex % colCount;
                int srccol = srcrCol - index;
                SCell srcCell = sheet.getCell(r, srccol);
                if (srcCell.isNull()) {
                    sheet.clearCell(new CellRegion(r, c));
                } else {
                    Object value = stepChunk.getStep(index).next(srcCell);
                    this.applyStepValue(srcCell, sheet.getCell(r, c), value);
                }
                --c;
                ++srcIndex;
            }
        }
    }

    private boolean isPasteValue(PasteOption.PasteType pasteType) {
        switch (pasteType) {
            case ALL: 
            case ALL_EXCEPT_BORDERS: 
            case VALUES: 
            case VALUES_AND_NUMBER_FORMATS: {
                return true;
            }
        }
        return false;
    }

    private static int getFillDirection(CellRegion srcRef, CellRegion dstRef) {
        int dsttRow = dstRef.getRow();
        int dstbRow = dstRef.getLastRow();
        int dstlCol = dstRef.getColumn();
        int dstrCol = dstRef.getLastColumn();
        int srctRow = srcRef.getRow();
        int srcbRow = srcRef.getLastRow();
        int srclCol = srcRef.getColumn();
        int srcrCol = srcRef.getLastColumn();
        if (srclCol == dstlCol && srcrCol == dstrCol) {
            if (dsttRow == srctRow) {
                if (dstbRow > srcbRow) {
                    return 3;
                }
                if (dstbRow == srcbRow) {
                    return 1;
                }
            }
            if (dstbRow == srcbRow && dsttRow < srctRow) {
                return 2;
            }
        } else if (srctRow == dsttRow && srcbRow == dstbRow) {
            if (dstlCol == srclCol && dstrCol > srcrCol) {
                return 4;
            }
            if (dstrCol == srcrCol && dstlCol < srclCol) {
                return 5;
            }
        }
        return 0;
    }

    private class CopyStepChunk
    extends StepChunk {
        private CopyStepChunk() {
        }

        public Step getStep(int index) {
            return CopyStep.instance;
        }
    }

    private class StepChunk {
        private Step[] _steps;

        protected StepChunk() {
        }

        public StepChunk(SCell[] srcCells, SRange.FillType fillType, boolean positive, int siblingCount) {
            this._steps = new Step[srcCells.length];
            int b = 0;
            int e = 0;
            SCell.CellType prevtype = null;
            int subType = -1;
            Locale locale = ZssContext.getCurrent().getLocale();
            for (int j = 0; j < srcCells.length; ++j) {
                SCell.CellType type;
                SCell cell = srcCells[j];
                SCell.CellType cellType = type = cell.isNull() ? SCell.CellType.BLANK : cell.getType();
                if (type != prevtype) {
                    if (prevtype != null) {
                        this.prepareSteps(srcCells, b, e, positive, fillType, subType, siblingCount);
                    }
                    b = e = j;
                    prevtype = type;
                    if (type == SCell.CellType.STRING) {
                        String x = cell.getStringValue();
                        subType = AutoFillHelper.getWeekMonthSubType(x, locale);
                        continue;
                    }
                    if (type != SCell.CellType.NUMBER) continue;
                    subType = AutoFillHelper.this.getDateTimeSubType(cell);
                    continue;
                }
                if (type == SCell.CellType.STRING) {
                    String x = cell.getStringValue();
                    int curSubType = AutoFillHelper.getWeekMonthSubType(x, locale);
                    if (curSubType == subType) {
                        e = j;
                        continue;
                    }
                    this.prepareSteps(srcCells, b, e, positive, fillType, subType, siblingCount);
                    b = e = j;
                    subType = curSubType;
                } else if (type == SCell.CellType.NUMBER) {
                    int curSubType = AutoFillHelper.this.getDateTimeSubType(cell);
                    if (subType == curSubType) {
                        e = j;
                        continue;
                    }
                    this.prepareSteps(srcCells, b, e, positive, fillType, subType, siblingCount);
                    b = e = j;
                    subType = curSubType;
                }
                e = j;
            }
            this.prepareSteps(srcCells, b, e, positive, fillType, subType, siblingCount);
        }

        public Step getStep(int srcIndex) {
            return this._steps[srcIndex];
        }

        private void replaceWithCopyStep(int index) {
            this._steps[index] = CopyStep.instance;
        }

        private void prepareSteps(SCell[] srcCells, int b, int e, boolean positive, SRange.FillType fillType, int subType, int siblingCount) {
            Step step;
            SCell srcCell = srcCells[b];
            SCell.CellType type = srcCell.isNull() ? SCell.CellType.BLANK : srcCell.getType();
            block0 : switch (type) {
                default: {
                    step = CopyStep.instance;
                    break;
                }
                case BLANK: {
                    step = BlankStep.instance;
                    break;
                }
                case NUMBER: {
                    switch (subType) {
                        default: {
                            step = srcCells.length == 1 && siblingCount == 1 ? CopyStep.instance : (fillType == SRange.FillType.GROWTH_TREND ? AutoFillHelper.getGrowthStep(srcCells, b, e, positive) : AutoFillHelper.getLinearStep(srcCells, b, e, positive));
                            break block0;
                        }
                        case 6: {
                            step = AutoFillHelper.this.getDateStep(srcCells, b, e, positive, fillType, subType);
                            break block0;
                        }
                        case 7: 
                    }
                    step = AutoFillHelper.getTimeStep(srcCells, b, e, positive, fillType, subType);
                    break;
                }
                case STRING: {
                    Locale locale = ZssContext.getCurrent().getLocale();
                    switch (subType) {
                        default: {
                            step = BlankStep.instance;
                            break block0;
                        }
                        case 0: {
                            step = CopyStep.instance;
                            break block0;
                        }
                        case 1: {
                            step = AutoFillHelper.getShortWeekStep(srcCells, b, e, positive, locale);
                            break block0;
                        }
                        case 2: {
                            step = AutoFillHelper.getShortMonthStep(srcCells, b, e, positive, locale);
                            break block0;
                        }
                        case 3: {
                            step = AutoFillHelper.getFullWeekStep(srcCells, b, e, positive, locale);
                            break block0;
                        }
                        case 4: {
                            step = AutoFillHelper.getFullMonthStep(srcCells, b, e, positive, locale);
                            break block0;
                        }
                        case 17: {
                            step = AutoFillHelper.getShortWeekStep(srcCells, b, e, positive, Locale.US);
                            break block0;
                        }
                        case 18: {
                            step = AutoFillHelper.getShortMonthStep(srcCells, b, e, positive, Locale.US);
                            break block0;
                        }
                        case 19: {
                            step = AutoFillHelper.getFullWeekStep(srcCells, b, e, positive, Locale.US);
                            break block0;
                        }
                        case 20: 
                    }
                    step = AutoFillHelper.getFullMonthStep(srcCells, b, e, positive, Locale.US);
                }
            }
            for (int k = b; k <= e; ++k) {
                this._steps[k] = step;
            }
        }
    }
}

