/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import org.zkoss.zss.model.CellStyleHolder;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SRichText;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.RichTextImpl;
import org.zkoss.zss.model.util.CellStyleMatcher;
import org.zkoss.zss.model.util.FontMatcher;

public class StyleUtil {
    public static final short BORDER_EDGE_BOTTOM = 1;
    public static final short BORDER_EDGE_RIGHT = 2;
    public static final short BORDER_EDGE_TOP = 4;
    public static final short BORDER_EDGE_LEFT = 8;
    public static final short BORDER_EDGE_ALL = 15;

    public static SCellStyle cloneCellStyle(SCell cell) {
        SCellStyle destination = cell.getSheet().getBook().createCellStyle(cell.getCellStyle(), true);
        return destination;
    }

    public static SCellStyle cloneCellStyle(SBook book, SCellStyle style) {
        SCellStyle destination = book.createCellStyle(style, true);
        return destination;
    }

    public static void setFontColor(SBook book, CellStyleHolder holder, String color) {
        SColor newColor;
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SColor orgColor = orgFont.getColor();
        if (orgColor == (newColor = book.createColor(color)) || orgColor != null && orgColor.equals(newColor)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setColor(color);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setColor(newColor);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        holder.setCellStyle(style);
    }

    public static void setFillColor(SBook book, CellStyleHolder holder, String htmlColor) {
        SColor newColor;
        SCellStyle orgStyle = holder.getCellStyle();
        SColor orgColor = orgStyle.getFillColor();
        if (orgColor == (newColor = book.createColor(htmlColor)) || orgColor != null && orgColor.equals(newColor)) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setFillColor(htmlColor);
        matcher.setFillPattern(SCellStyle.FillPattern.SOLID_FOREGROUND);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFillColor(newColor);
            style.setFillPattern(SCellStyle.FillPattern.SOLID_FOREGROUND);
        }
        holder.setCellStyle(style);
    }

    public static void setTextWrap(SBook book, CellStyleHolder holder, boolean wrap) {
        SCellStyle orgStyle = holder.getCellStyle();
        boolean textWrap = orgStyle.isWrapText();
        if (wrap == textWrap) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setWrapText(wrap);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setWrapText(wrap);
        }
        holder.setCellStyle(style);
    }

    public static void setFontHeightPoints(SBook book, CellStyleHolder holder, int fontHeightPoints) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        int orgSize = orgFont.getHeightPoints();
        if (orgSize == fontHeightPoints) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setHeightPoints(fontHeightPoints);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setHeightPoints(fontHeightPoints);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        holder.setCellStyle(style);
    }

    public static void setFontStrikethrough(SBook book, CellStyleHolder holder, boolean strikeout) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        boolean orgStrikeout = orgFont.isStrikeout();
        if (orgStrikeout == strikeout) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setStrikeout(strikeout);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setStrikeout(strikeout);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        holder.setCellStyle(style);
    }

    public static void setFontName(SBook book, CellStyleHolder holder, String name) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        String orgName = orgFont.getName();
        if (orgName.equals(name)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setName(name);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setName(name);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        holder.setCellStyle(style);
    }

    public static void setBorder(SBook book, CellStyleHolder holder, String color, SCellStyle.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)15);
    }

    public static void setBorderTop(SBook book, CellStyleHolder holder, String color, SCellStyle.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)4);
    }

    public static void setBorderLeft(SBook book, CellStyleHolder holder, String color, SCellStyle.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)8);
    }

    public static void setBorderBottom(SBook book, CellStyleHolder holder, String color, SCellStyle.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)1);
    }

    public static void setBorderRight(SBook book, CellStyleHolder holder, String color, SCellStyle.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)2);
    }

    public static void setBorder(SBook book, CellStyleHolder holder, String htmlColor, SCellStyle.BorderType lineStyle, short at) {
        boolean hasBorder;
        SCellStyle orgStyle = holder.getCellStyle();
        SCellStyle style = null;
        SColor color = book.createColor(htmlColor);
        boolean bl = hasBorder = lineStyle != SCellStyle.BorderType.NONE;
        if (htmlColor != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            if ((at & 8) != 0) {
                if (hasBorder) {
                    matcher.setBorderLeftColor(htmlColor);
                } else {
                    matcher.removeBorderLeftColor();
                }
                matcher.setBorderLeft(lineStyle);
            }
            if ((at & 4) != 0) {
                if (hasBorder) {
                    matcher.setBorderTopColor(htmlColor);
                } else {
                    matcher.removeBorderTopColor();
                }
                matcher.setBorderTop(lineStyle);
            }
            if ((at & 2) != 0) {
                if (hasBorder) {
                    matcher.setBorderRightColor(htmlColor);
                } else {
                    matcher.removeBorderRightColor();
                }
                matcher.setBorderRight(lineStyle);
            }
            if ((at & 1) != 0) {
                if (hasBorder) {
                    matcher.setBorderBottomColor(htmlColor);
                } else {
                    matcher.removeBorderBottomColor();
                }
                matcher.setBorderBottom(lineStyle);
            }
            style = book.searchCellStyle(matcher);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            if ((at & 8) != 0) {
                if (hasBorder) {
                    style.setBorderLeftColor(color);
                }
                style.setBorderLeft(lineStyle);
            }
            if ((at & 4) != 0) {
                if (hasBorder) {
                    style.setBorderTopColor(color);
                }
                style.setBorderTop(lineStyle);
            }
            if ((at & 2) != 0) {
                if (hasBorder) {
                    style.setBorderRightColor(color);
                }
                style.setBorderRight(lineStyle);
            }
            if ((at & 1) != 0) {
                if (hasBorder) {
                    style.setBorderBottomColor(color);
                }
                style.setBorderBottom(lineStyle);
            }
        }
        holder.setCellStyle(style);
    }

    public static void setFontBoldWeight(SBook book, CellStyleHolder holder, SFont.Boldweight boldWeight) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SFont.Boldweight orgBoldWeight = orgFont.getBoldweight();
        if (orgBoldWeight.equals((Object)boldWeight)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setBoldweight(boldWeight);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setBoldweight(boldWeight);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        holder.setCellStyle(style);
    }

    public static void setFontItalic(SBook book, CellStyleHolder holder, boolean italic) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        boolean orgItalic = orgFont.isItalic();
        if (orgItalic == italic) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setItalic(italic);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setItalic(italic);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        holder.setCellStyle(style);
    }

    public static void setFontUnderline(SBook book, CellStyleHolder holder, SFont.Underline underline) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SFont.Underline orgUnderline = orgFont.getUnderline();
        if (orgUnderline.equals((Object)underline)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setUnderline(underline);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setUnderline(underline);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        holder.setCellStyle(style);
    }

    public static void setTextHAlign(SBook book, CellStyleHolder holder, SCellStyle.Alignment align) {
        SCellStyle orgStyle = holder.getCellStyle();
        SCellStyle.Alignment orgAlign = orgStyle.getAlignment();
        if (align.equals((Object)orgAlign)) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setAlignment(align);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setAlignment(align);
        }
        holder.setCellStyle(style);
    }

    public static void setTextVAlign(SBook book, CellStyleHolder holder, SCellStyle.VerticalAlignment valign) {
        SCellStyle orgStyle = holder.getCellStyle();
        SCellStyle.VerticalAlignment orgValign = orgStyle.getVerticalAlignment();
        if (valign.equals((Object)orgValign)) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setVerticalAlignment(valign);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setVerticalAlignment(valign);
        }
        holder.setCellStyle(style);
    }

    public static void setDataFormat(SBook book, CellStyleHolder holder, String format) {
        SCellStyle orgStyle = holder.getCellStyle();
        String orgFormat = orgStyle.getDataFormat();
        if (format == orgFormat || format != null && format.equals(orgFormat)) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setDataFormat(format);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setDataFormat(format);
        }
        holder.setCellStyle(style);
    }

    public static void setFontTypeOffset(SBook book, CellStyleHolder holder, SFont.TypeOffset offset) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SFont.TypeOffset orgOffset = orgFont.getTypeOffset();
        if (orgOffset.equals((Object)offset)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setTypeOffset(offset);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setTypeOffset(offset);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        holder.setCellStyle(style);
    }

    public static boolean setRichTextFontTypeOffset(SBook book, SCell cell, SFont.TypeOffset offset) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font = seg.getFont();
            SFont.TypeOffset orgOffset = font.getTypeOffset();
            if (!orgOffset.equals((Object)offset)) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setTypeOffset(offset);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setTypeOffset(offset);
                }
                modified = true;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontBoldweight(SBook book, SCell cell, SFont.Boldweight bold) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font = seg.getFont();
            SFont.Boldweight orgBold = font.getBoldweight();
            if (!orgBold.equals((Object)bold)) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setBoldweight(bold);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setBoldweight(bold);
                }
                modified = true;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontItalic(SBook book, SCell cell, boolean italic) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font = seg.getFont();
            boolean orgItalic = font.isItalic();
            if (orgItalic != italic) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setItalic(italic);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setItalic(italic);
                }
                modified = true;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontUnderline(SBook book, SCell cell, SFont.Underline underline) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font = seg.getFont();
            SFont.Underline orgUnderline = font.getUnderline();
            if (!orgUnderline.equals((Object)underline)) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setUnderline(underline);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setUnderline(underline);
                }
                modified = true;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontName(SBook book, SCell cell, String name) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font = seg.getFont();
            String orgName = font.getName();
            if (!orgName.equals(name)) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setName(name);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setName(name);
                }
                modified = true;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontHeightPoints(SBook book, SCell cell, int heightPoints) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font = seg.getFont();
            int orgHeightPoints = font.getHeightPoints();
            if (orgHeightPoints != heightPoints) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setHeightPoints(heightPoints);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setHeightPoints(heightPoints);
                }
                modified = true;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontStrikeout(SBook book, SCell cell, boolean strike) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font = seg.getFont();
            boolean orgStrike = font.isStrikeout();
            if (orgStrike != strike) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setStrikeout(strike);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setStrikeout(strike);
                }
                modified = true;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontColor(SBook book, SCell cell, String htmlColor) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SColor newColor = book.createColor(htmlColor);
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font = seg.getFont();
            SColor orgColor = font.getColor();
            if (!(orgColor == newColor || orgColor != null && orgColor.equals(newColor))) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setColor(htmlColor);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setColor(newColor);
                }
                modified = true;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }
}

