/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.HashSet;
import java.util.Iterator;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColumn;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.impl.RangeHelperBase;

public class SetCellStyleHelper
extends RangeHelperBase {
    SCellStyle _defaultStyle;

    public SetCellStyleHelper(SRange range) {
        super(range);
        this._defaultStyle = range.getSheet().getBook().getDefaultCellStyle();
    }

    public void setCellStyle(SCellStyle style) {
        if (this.isWholeSheet()) {
            throw new InvalidModelOpException("don't allow to set style to whole sheet, please consider to set as whole column style");
        }
        if (this.isWholeRow()) {
            this.setWholeRowCellStyle(style);
        } else if (this.isWholeColumn()) {
            this.setWholeColumnCellStyle(style);
        } else {
            for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
                for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                    SCell cell = this.sheet.getCell(r, c);
                    cell.setCellStyle(style);
                }
            }
        }
    }

    public void setWholeRowCellStyle(SCellStyle style) {
        for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
            SRow row = this.sheet.getRow(r);
            row.setCellStyle(style);
            HashSet<Integer> cellProcessed = new HashSet<Integer>();
            Iterator<SCell> cells = this.sheet.getCellIterator(r);
            while (cells.hasNext()) {
                SCell cell = cells.next();
                if (cell.getCellStyle(true) != null || this.sheet.getColumn(cell.getColumnIndex()).getCellStyle(true) != null) {
                    cell.setCellStyle(style);
                }
                cellProcessed.add(cell.getColumnIndex());
            }
            Iterator<SColumn> columns = this.sheet.getColumnIterator();
            while (columns.hasNext()) {
                SColumn column = columns.next();
                if (cellProcessed.contains(column.getIndex()) || column.getCellStyle(true) == null) continue;
                this.sheet.getCell(r, column.getIndex()).setCellStyle(style);
            }
        }
    }

    public void setWholeColumnCellStyle(SCellStyle style) {
        for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
            SColumn column = this.sheet.getColumn(c);
            column.setCellStyle(style);
        }
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                SCell cell = this.sheet.getCell(row.getIndex(), c);
                if (cell.getCellStyle(true) == null && row.getCellStyle(true) == null) continue;
                cell.setCellStyle(style);
            }
        }
    }
}

