/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.LinkedHashMap;
import java.util.Set;
import org.zkoss.util.logging.Log;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.sys.dependency.ObjectRef;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.range.impl.NotifyChangeHelper;
import org.zkoss.zss.range.impl.RefHelperBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RefNotifyContentChangeHelper
extends RefHelperBase {
    private static final Log _logger = Log.lookup(RefNotifyContentChangeHelper.class);
    private NotifyChangeHelper _notifyHelper = new NotifyChangeHelper();

    public RefNotifyContentChangeHelper(SBookSeries bookSeries) {
        super(bookSeries);
    }

    public void notifyContentChange(Ref notify) {
        if (notify.getType() == Ref.RefType.CELL || notify.getType() == Ref.RefType.AREA) {
            this.handleAreaRef(notify);
        } else if (notify.getType() == Ref.RefType.OBJECT) {
            if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.CHART) {
                this.handleChartRef((ObjectRef)notify);
            } else if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.DATA_VALIDATION) {
                this.handleDataValidationRef((ObjectRef)notify);
            } else if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.AUTO_FILTER) {
                this.handleAutoFilterRef((ObjectRef)notify);
            }
        }
    }

    public void notifyContentChange(Set<Ref> notifySet) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        for (Ref notify : notifySet) {
            if (_logger.debugable()) {
                _logger.debug("Notify Dependent Change : " + notify);
            }
            if (notify.getType() == Ref.RefType.CELL || notify.getType() == Ref.RefType.AREA) {
                this.handleAreaRef(notify);
                continue;
            }
            if (notify.getType() != Ref.RefType.OBJECT) continue;
            if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.CHART) {
                chartDependents.put(((ObjectRef)notify).getObjectIdPath()[0], notify);
                continue;
            }
            if (((ObjectRef)notify).getObjectType() == ObjectRef.ObjectType.DATA_VALIDATION) {
                validationDependents.put(((ObjectRef)notify).getObjectIdPath()[0], notify);
                continue;
            }
            if (((ObjectRef)notify).getObjectType() != ObjectRef.ObjectType.AUTO_FILTER) continue;
            this.handleAutoFilterRef((ObjectRef)notify);
        }
        for (Ref notify : chartDependents.values()) {
            this.handleChartRef((ObjectRef)notify);
        }
        for (Ref notify : validationDependents.values()) {
            this.handleDataValidationRef((ObjectRef)notify);
        }
    }

    private void handleChartRef(ObjectRef notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = notify.getObjectIdPath();
        this._notifyHelper.notifyChartChange(sheet, ids[0]);
    }

    private void handleDataValidationRef(ObjectRef notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = notify.getObjectIdPath();
        this._notifyHelper.notifyDataValidationChange(sheet, ids[0]);
    }

    private void handleAutoFilterRef(ObjectRef notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        this._notifyHelper.notifySheetAutoFilterChange(sheet);
    }

    private void handleAreaRef(Ref notify) {
        SBook book = this.bookSeries.getBook(notify.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(notify.getSheetName());
        if (sheet == null) {
            return;
        }
        this._notifyHelper.notifyCellChange(new SheetRegion(sheet, notify.getRow(), notify.getColumn(), notify.getLastRow(), notify.getLastColumn()));
    }
}

