/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.zkoss.lang.Strings;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.ss.util.WorkbookUtil;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.PasteOption;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SColumn;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SHyperlink;
import org.zkoss.zss.model.SName;
import org.zkoss.zss.model.SPicture;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SSheetProtection;
import org.zkoss.zss.model.SSheetViewInfo;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractDataValidationAdv;
import org.zkoss.zss.model.impl.AbstractNameAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.ColorImpl;
import org.zkoss.zss.model.impl.FormulaCacheCleaner;
import org.zkoss.zss.model.impl.NameRefImpl;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.NameRef;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.format.FormatContext;
import org.zkoss.zss.model.sys.format.FormatEngine;
import org.zkoss.zss.model.sys.input.InputEngine;
import org.zkoss.zss.model.sys.input.InputParseContext;
import org.zkoss.zss.model.sys.input.InputResult;
import org.zkoss.zss.model.util.FontMatcher;
import org.zkoss.zss.model.util.ReadWriteTask;
import org.zkoss.zss.model.util.RichTextHelper;
import org.zkoss.zss.model.util.Validations;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.SRanges;
import org.zkoss.zss.range.impl.AutoFilterHelper;
import org.zkoss.zss.range.impl.BorderHelper;
import org.zkoss.zss.range.impl.ChartDataHelper;
import org.zkoss.zss.range.impl.ClearCellHelper;
import org.zkoss.zss.range.impl.DataRegionHelper;
import org.zkoss.zss.range.impl.DataValidationHelper;
import org.zkoss.zss.range.impl.EmptyNRange;
import org.zkoss.zss.range.impl.InsertDeleteHelper;
import org.zkoss.zss.range.impl.InsertDeleteUpdate;
import org.zkoss.zss.range.impl.MergeHelper;
import org.zkoss.zss.range.impl.MergeUpdate;
import org.zkoss.zss.range.impl.ModelUpdate;
import org.zkoss.zss.range.impl.ModelUpdateCollector;
import org.zkoss.zss.range.impl.NotifyChangeHelper;
import org.zkoss.zss.range.impl.RefNotifyContentChangeHelper;
import org.zkoss.zss.range.impl.SetCellStyleHelper;
import org.zkoss.zss.range.impl.SortHelper;
import org.zkoss.zss.range.impl.StyleUtil;
import org.zkoss.zss.range.impl.autofill.AutoFillHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeImpl
implements SRange {
    private SBook _book;
    private final List<EffectedRegion> _rangeRefs = new ArrayList<EffectedRegion>(1);
    private int _column = Integer.MAX_VALUE;
    private int _row = Integer.MAX_VALUE;
    private int _lastColumn = Integer.MIN_VALUE;
    private int _lastRow = Integer.MIN_VALUE;
    private boolean _autoRefresh = true;
    private static final SRange EMPTY_RANGE = new EmptyNRange();

    public RangeImpl(SBook book) {
        this._book = book;
    }

    public RangeImpl(SSheet sheet) {
        this.addRangeRef(sheet, 0, 0, sheet.getBook().getMaxRowIndex(), sheet.getBook().getMaxColumnIndex());
    }

    public RangeImpl(SSheet sheet, int row, int col) {
        this.addRangeRef(sheet, row, col, row, col);
    }

    public RangeImpl(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        this.addRangeRef(sheet, tRow, lCol, bRow, rCol);
    }

    public RangeImpl(SSheet sheet, CellRegion region) {
        this.addRangeRef(sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
    }

    private RangeImpl(Collection<SheetRegion> regions) {
        for (SheetRegion region : regions) {
            this.addRangeRef(region.getSheet(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
        }
    }

    private void addRangeRef(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        Validations.argNotNull(sheet);
        this._rangeRefs.add(new EffectedRegion(sheet, tRow, lCol, bRow, rCol));
        this._column = Math.min(this._column, lCol);
        this._row = Math.min(this._row, tRow);
        this._lastColumn = Math.max(this._lastColumn, rCol);
        this._lastRow = Math.max(this._lastRow, bRow);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.getBookSeries().getLock();
    }

    SBookSeries getBookSeries() {
        return this.getBook().getBookSeries();
    }

    SBook getBook() {
        if (this._book == null) {
            this._book = this.getSheet().getBook();
        }
        return this._book;
    }

    @Override
    public SSheet getSheet() {
        if (this._rangeRefs.size() <= 0) {
            throw new IllegalStateException("can't find any effected sheet or range");
        }
        return this._rangeRefs.get(0).sheet;
    }

    @Override
    public int getRow() {
        return this._row;
    }

    @Override
    public int getColumn() {
        return this._column;
    }

    @Override
    public int getLastRow() {
        return this._lastRow;
    }

    @Override
    public int getLastColumn() {
        return this._lastColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void travelCells(CellVisitor visitor) {
        ModelUpdateWrapper updateWrap = new ModelUpdateWrapper(this.getBookSeries(), false);
        try {
            block3: for (EffectedRegion r : this._rangeRefs) {
                CellRegion region = r.region;
                for (int i = region.row; i <= region.lastRow; ++i) {
                    for (int j = region.column; j <= region.lastColumn; ++j) {
                        SCell cell = r.sheet.getCell(i, j);
                        boolean conti = visitor.visit(cell);
                        if (!conti) continue block3;
                    }
                }
            }
        }
        finally {
            updateWrap.doFinially();
        }
        visitor.afterVisitAll();
    }

    private void handleRefNotifyContentChange(SBookSeries bookSeries, Set<Ref> notifySet) {
        new RefNotifyContentChangeHelper(bookSeries).notifyContentChange(notifySet);
    }

    private void handleRefNotifyContentChange(SBookSeries bookSeries, Ref notify) {
        new RefNotifyContentChangeHelper(bookSeries).notifyContentChange(notify);
    }

    private boolean equalObjects(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }

    @Override
    public void setRichText(String html) {
        this.setValue(new RichTextHelper().parse(this, html));
    }

    @Override
    public String getRichText() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            public boolean visit(SCell cell) {
                if (cell.isRichTextValue()) {
                    String html = RichTextHelper.getCellRichTextHtml(cell);
                    r.set(html);
                } else {
                    r.set(null);
                }
                return false;
            }
        }).doInReadLock(this.getLock());
        return (String)r.get();
    }

    @Override
    public void setValue(final Object value) {
        new CellVisitorTask(new CellVisitorForUpdate(){

            public boolean visit(SCell cell) {
                Object cellval = cell.getValue();
                if (!RangeImpl.this.equalObjects(cellval, value)) {
                    cell.setValue(value);
                }
                return true;
            }
        }).doInWriteLock(this.getLock());
    }

    @Override
    public void clearContents() {
        new ModelManipulationTask(){

            protected boolean isCollectModelUpdate() {
                return false;
            }

            protected Object doInvoke() {
                SBookSeries bookSeries = RangeImpl.this.getSheet().getBook().getBookSeries();
                DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
                for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                    SBook book = r.sheet.getBook();
                    CellRegion region = r.region;
                    new ClearCellHelper(new RangeImpl(r.sheet, r.region)).clearCellContent();
                    RangeImpl.this.handleCellNotifyContentChange(new SheetRegion(r.sheet, r.region));
                    boolean wholeSheet = region.row == 0 && region.lastRow >= book.getMaxRowIndex() && region.column == 0 && region.lastColumn >= book.getMaxColumnIndex();
                    if (wholeSheet) continue;
                    RangeImpl.this.handleRefNotifyContentChange(bookSeries, table.getEvaluatedDependents(new RefImpl(r.sheet.getBook().getBookName(), r.sheet.getSheetName(), region.row, region.column, region.lastRow, region.lastColumn)));
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void clearCellStyles() {
        new ModelManipulationTask(){

            protected boolean isCollectModelUpdate() {
                return false;
            }

            protected Object doInvoke() {
                for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                    new ClearCellHelper(new RangeImpl(r.sheet, r.region)).clearCellStyle();
                    RangeImpl.this.handleCellNotifyContentChange(new SheetRegion(r.sheet, r.region));
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void clearAll() {
        new ModelManipulationTask(){

            protected boolean isCollectModelUpdate() {
                return false;
            }

            protected Object doInvoke() {
                SBookSeries bookSeries = RangeImpl.this.getSheet().getBook().getBookSeries();
                DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
                for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                    CellRegion region = r.region;
                    r.sheet.clearCell(region);
                    new ClearCellHelper(new RangeImpl(r.sheet, r.region)).clearCellStyle();
                    RangeImpl.this.handleCellNotifyContentChange(new SheetRegion(r.sheet, r.region));
                    RangeImpl.this.handleRefNotifyContentChange(bookSeries, table.getEvaluatedDependents(new RefImpl(r.sheet.getBook().getBookName(), r.sheet.getSheetName(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn())));
                }
                return null;
            }

            protected void doAfterNotify() {
                RangeImpl.this.unmerge();
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setEditText(final String editText) {
        final InputEngine ie = EngineFactory.getInstance().createInputEngine();
        final ResultWrap input = new ResultWrap();
        final ResultWrap hyperlinkType = new ResultWrap();
        new CellVisitorTask(new CellVisitorForUpdate(){

            public boolean visit(SCell cell) {
                Object cellval;
                FormatEngine fe;
                String oldEditText;
                Locale locale = ZssContext.getCurrent().getLocale();
                InputResult result = (InputResult)input.get();
                if (result == null) {
                    result = ie.parseInput(editText == null ? "" : editText, cell.getCellStyle().getDataFormat(), new InputParseContext(locale));
                    input.set(result);
                    if (result.getType() == SCell.CellType.STRING) {
                        hyperlinkType.set(RangeImpl.this.getHyperlinkType((String)result.getValue()));
                    }
                }
                Object resultVal = result.getValue();
                if (cell.getType() == result.getType() && (result.getType() == SCell.CellType.FORMULA ? editText.equals(oldEditText = (fe = EngineFactory.getInstance().createFormatEngine()).getEditText(cell, new FormatContext(locale))) : RangeImpl.this.equalObjects(cellval = cell.getValue(), resultVal))) {
                    return true;
                }
                String format = result.getFormat();
                switch (result.getType()) {
                    case BLANK: {
                        cell.clearValue();
                        break;
                    }
                    case BOOLEAN: {
                        cell.setBooleanValue((Boolean)resultVal);
                        break;
                    }
                    case FORMULA: {
                        ((AbstractCellAdv)cell).setFormulaValue((String)resultVal, locale);
                        break;
                    }
                    case NUMBER: {
                        if (resultVal instanceof Date) {
                            cell.setDateValue((Date)resultVal);
                            break;
                        }
                        cell.setNumberValue((Double)resultVal);
                        break;
                    }
                    case STRING: {
                        cell.setStringValue((String)resultVal);
                        if (hyperlinkType.get() == null) break;
                        cell.setupHyperlink((SHyperlink.HyperlinkType)((Object)hyperlinkType.get()), (String)resultVal, (String)resultVal);
                        break;
                    }
                    case ERROR: {
                        cell.setErrorValue(ErrorValue.valueOf((Byte)resultVal));
                        break;
                    }
                    default: {
                        cell.setValue(resultVal);
                    }
                }
                String oldFormat = cell.getCellStyle().getDataFormat();
                if (format != null && "General".equals(oldFormat)) {
                    StyleUtil.setDataFormat(cell.getSheet().getBook(), cell, format);
                }
                return true;
            }
        }).doInWriteLock(this.getLock());
    }

    private SHyperlink.HyperlinkType getHyperlinkType(String address) {
        if (address != null) {
            String addr = address.toLowerCase();
            if (addr.startsWith("http://") || addr.startsWith("https://")) {
                return SHyperlink.HyperlinkType.URL;
            }
            if (addr.startsWith("mailto:")) {
                return SHyperlink.HyperlinkType.EMAIL;
            }
        }
        return null;
    }

    @Override
    public String getEditText() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            public boolean visit(SCell cell) {
                FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
                r.set(fe.getEditText(cell, new FormatContext(ZssContext.getCurrent().getLocale())));
                return false;
            }
        }).doInReadLock(this.getLock());
        return (String)r.get();
    }

    @Override
    public void notifyChange() {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.notifyChangeInLock(true);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void notifyChangeInLock(boolean notifyDependent) {
        SBookSeries bookSeries = this.getBookSeries();
        DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
        LinkedHashSet<Ref> notifySet = new LinkedHashSet<Ref>();
        FormulaCacheCleaner cacheCleaner = new FormulaCacheCleaner(bookSeries);
        for (EffectedRegion r : this._rangeRefs) {
            boolean wholeSheet;
            SBook book = r.sheet.getBook();
            String bookName = book.getBookName();
            String sheetName = r.sheet.getSheetName();
            CellRegion region = r.region;
            RefImpl pre = new RefImpl(bookName, sheetName, region.row, region.column, region.lastRow, region.lastColumn);
            cacheCleaner.clearByPrecedent(pre);
            notifySet.add(pre);
            boolean bl = wholeSheet = region.row == 0 && region.lastRow >= book.getMaxRowIndex() && region.column == 0 && region.lastColumn >= book.getMaxColumnIndex();
            if (!notifyDependent || wholeSheet) continue;
            notifySet.addAll(table.getEvaluatedDependents(pre));
        }
        this.handleRefNotifyContentChange(bookSeries, notifySet);
    }

    @Override
    public void notifyChange(final String[] variables) {
        SBookSeries bookSeries = this.getBookSeries();
        DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
        LinkedHashSet notifySet = new LinkedHashSet();
        FormulaCacheCleaner cacheCleaner = new FormulaCacheCleaner(bookSeries);
        new ReadWriteTask(){

            public Object invoke() {
                SBookSeries bookSeries = RangeImpl.this.getBookSeries();
                DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
                LinkedHashSet<Ref> notifySet = new LinkedHashSet<Ref>();
                FormulaCacheCleaner cacheCleaner = new FormulaCacheCleaner(bookSeries);
                for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                    final String bookName = r.sheet.getBook().getBookName();
                    String sheetName = r.sheet.getSheetName();
                    for (final String var : variables) {
                        Set<Ref> precedents = table.searchPrecedents(new DependencyTable.RefFilter(){

                            public boolean accept(Ref ref) {
                                String refNameName;
                                return ref.getBookName().equals(bookName) && ref.getType() == Ref.RefType.NAME && ((refNameName = ((NameRef)ref).getNameName()).equals(var) || refNameName.startsWith(var + "."));
                            }
                        });
                        for (Ref pre : precedents) {
                            cacheCleaner.clearByPrecedent(pre);
                            notifySet.add(pre);
                            notifySet.addAll(table.getEvaluatedDependents(pre));
                        }
                    }
                }
                RangeImpl.this.handleRefNotifyContentChange(bookSeries, notifySet);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public boolean isWholeSheet() {
        return this.isWholeRow() && this.isWholeColumn();
    }

    @Override
    public boolean isWholeRow() {
        return this._column <= 0 && this._lastColumn >= this.getBook().getMaxColumnIndex();
    }

    @Override
    public SRange getRows() {
        return new RangeImpl(this.getSheet(), this._row, 0, this._lastRow, this.getBook().getMaxColumnIndex());
    }

    @Override
    public void setRowHeight(int heightPx) {
        this.setRowHeight(heightPx, true);
    }

    @Override
    public void setRowHeight(final int heightPx, final boolean custom) {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.setRowHeightInLock(heightPx, null, custom);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void setRowHeightInLock(Integer heightPx, Boolean hidden, Boolean custom) {
        LinkedHashSet<SheetRegion> notifySet = new LinkedHashSet<SheetRegion>();
        for (EffectedRegion r : this._rangeRefs) {
            int maxcol = r.sheet.getBook().getMaxColumnIndex();
            CellRegion region = r.region;
            for (int i = region.row; i <= region.lastRow; ++i) {
                SRow row = r.sheet.getRow(i);
                if (heightPx != null) {
                    row.setHeight(heightPx);
                }
                if (hidden != null) {
                    row.setHidden(hidden);
                }
                if (custom != null) {
                    row.setCustomHeight(custom);
                }
                notifySet.add(new SheetRegion(r.sheet, i, 0, i, maxcol));
            }
        }
        new NotifyChangeHelper().notifyRowColumnSizeChange(notifySet);
    }

    @Override
    public boolean isWholeColumn() {
        return this._row <= 0 && this._lastRow >= this.getBook().getMaxRowIndex();
    }

    @Override
    public SRange getColumns() {
        return new RangeImpl(this.getSheet(), 0, this._column, this.getBook().getMaxRowIndex(), this._lastColumn);
    }

    @Override
    public void setColumnWidth(int widthPx) {
        this.setColumnWidth(widthPx, true);
    }

    @Override
    public void setColumnWidth(final int widthPx, final boolean custom) {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.setColumnWidthInLock(widthPx, null, custom);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void setColumnWidthInLock(Integer widthPx, Boolean hidden, Boolean custom) {
        LinkedHashSet<SheetRegion> notifySet = new LinkedHashSet<SheetRegion>();
        for (EffectedRegion r : this._rangeRefs) {
            int maxrow = r.sheet.getBook().getMaxRowIndex();
            CellRegion region = r.region;
            for (int i = region.column; i <= region.lastColumn; ++i) {
                SColumn column = r.sheet.getColumn(i);
                if (widthPx != null) {
                    column.setWidth(widthPx);
                }
                if (hidden != null) {
                    column.setHidden(hidden);
                }
                if (custom != null) {
                    column.setCustomWidth(true);
                }
                notifySet.add(new SheetRegion(r.sheet, 0, i, maxrow, i));
            }
        }
        new NotifyChangeHelper().notifyRowColumnSizeChange(notifySet);
        new NotifyChangeHelper().notifyCellChange(notifySet);
    }

    @Override
    public SHyperlink getHyperlink() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            public boolean visit(SCell cell) {
                r.set(cell.getHyperlink());
                return false;
            }
        }).doInReadLock(this.getLock());
        return (SHyperlink)r.get();
    }

    @Override
    public SRange copy(SRange dstRange, boolean cut) {
        PasteOption option = new PasteOption();
        option.setCut(cut);
        return this.pasteSpecial0(dstRange, option);
    }

    @Override
    public SRange copy(SRange dstRange) {
        return this.copy(dstRange, false);
    }

    @Override
    public SRange pasteSpecial(SRange dstRange, SRange.PasteType pasteType, SRange.PasteOperation pasteOp, boolean skipBlanks, boolean transpose) {
        PasteOption option = new PasteOption();
        option.setSkipBlank(skipBlanks);
        option.setTranspose(transpose);
        option.setPasteType(this.toModelPasteType(pasteType));
        option.setPasteOperation(this.toModelPasteOperation(pasteOp));
        return this.pasteSpecial0(dstRange, option);
    }

    private PasteOption.PasteOperation toModelPasteOperation(SRange.PasteOperation pasteOp) {
        switch (pasteOp) {
            case ADD: {
                return PasteOption.PasteOperation.ADD;
            }
            case DIV: {
                return PasteOption.PasteOperation.DIV;
            }
            case MUL: {
                return PasteOption.PasteOperation.MUL;
            }
            case NONE: {
                return PasteOption.PasteOperation.NONE;
            }
            case SUB: {
                return PasteOption.PasteOperation.SUB;
            }
        }
        throw new IllegalStateException("unknow operation " + (Object)((Object)pasteOp));
    }

    private PasteOption.PasteType toModelPasteType(SRange.PasteType pasteType) {
        switch (pasteType) {
            case ALL: {
                return PasteOption.PasteType.ALL;
            }
            case ALL_EXCEPT_BORDERS: {
                return PasteOption.PasteType.ALL_EXCEPT_BORDERS;
            }
            case COLUMN_WIDTHS: {
                return PasteOption.PasteType.COLUMN_WIDTHS;
            }
            case COMMENTS: {
                return PasteOption.PasteType.COMMENTS;
            }
            case FORMATS: {
                return PasteOption.PasteType.FORMATS;
            }
            case FORMULAS: {
                return PasteOption.PasteType.FORMULAS;
            }
            case FORMULAS_AND_NUMBER_FORMATS: {
                return PasteOption.PasteType.FORMULAS_AND_NUMBER_FORMATS;
            }
            case VALIDATAION: {
                return PasteOption.PasteType.VALIDATAION;
            }
            case VALUES: {
                return PasteOption.PasteType.VALUES;
            }
            case VALUES_AND_NUMBER_FORMATS: {
                return PasteOption.PasteType.VALUES_AND_NUMBER_FORMATS;
            }
        }
        throw new IllegalStateException("unknow type " + (Object)((Object)pasteType));
    }

    public SRange pasteSpecial0(final SRange dstRange, final PasteOption option) {
        final ResultWrap effectedRegion = new ResultWrap();
        return (SRange)new ModelManipulationTask(){

            protected Object doInvoke() {
                CellRegion effected = dstRange.getSheet().pasteCell(new SheetRegion(RangeImpl.this.getSheet(), RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), new CellRegion(dstRange.getRow(), dstRange.getColumn(), dstRange.getLastRow(), dstRange.getLastColumn()), option);
                effectedRegion.set(effected);
                return new RangeImpl(RangeImpl.this.getSheet(), effected.getRow(), effected.getColumn(), effected.getLastRow(), effected.getLastColumn());
            }

            protected void doBeforeNotify() {
                if (option.getPasteType() == PasteOption.PasteType.COLUMN_WIDTHS) {
                    CellRegion effected = (CellRegion)effectedRegion.get();
                    new NotifyChangeHelper().notifyRowColumnSizeChange(new SheetRegion(dstRange.getSheet(), effected));
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void insert(final SRange.InsertShift shift, final SRange.InsertCopyOrigin copyOrigin) {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                new InsertDeleteHelper(RangeImpl.this).insert(shift, copyOrigin);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void delete(final SRange.DeleteShift shift) {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                new InsertDeleteHelper(RangeImpl.this).delete(shift);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void merge(final boolean across) {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                new MergeHelper(RangeImpl.this).merge(across);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void unmerge() {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                new MergeHelper(RangeImpl.this).unmerge(true);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setBorders(final SRange.ApplyBorderType borderType, final SCellStyle.BorderType lineStyle, final String color) {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                new BorderHelper(RangeImpl.this).applyBorder(borderType, lineStyle, color);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void move(final int nRow, final int nCol) {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                SSheet sheet = RangeImpl.this.getSheet();
                sheet.moveCell(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn(), nRow, nCol);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setCellStyle(final SCellStyle style) {
        new ReadWriteTask(){

            public Object invoke() {
                for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                    new SetCellStyleHelper(new RangeImpl(r.sheet, r.region)).setCellStyle(style);
                }
                RangeImpl.this.notifyChangeInLock(false);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SCellStyle getCellStyle() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            public boolean visit(SCell cell) {
                r.set(cell.getCellStyle());
                return false;
            }
        }).doInReadLock(this.getLock());
        return (SCellStyle)r.get();
    }

    @Override
    public void fill(final SRange dstRange, final SRange.FillType fillType) {
        SSheet sheet = this.getSheet();
        if (!dstRange.getSheet().equals(sheet)) {
            throw new InvalidModelOpException("the source sheet and destination sheet aren't the same");
        }
        new ModelManipulationTask(){

            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), new CellRegion(dstRange.getRow(), dstRange.getColumn(), dstRange.getLastRow(), dstRange.getLastColumn()), fillType);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void autoFillInLock(CellRegion src, CellRegion dest, SRange.FillType fillType) {
        SSheet sheet = this.getSheet();
        new AutoFillHelper().fill(sheet, src, dest, fillType);
    }

    @Override
    public void fillDown() {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getRow(), RangeImpl.this.getLastColumn()), new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), SRange.FillType.COPY);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void fillLeft() {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getLastColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), SRange.FillType.COPY);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void fillRight() {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getColumn()), new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), SRange.FillType.COPY);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void fillUp() {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                RangeImpl.this.autoFillInLock(new CellRegion(RangeImpl.this.getLastRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()), SRange.FillType.COPY);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setHidden(final boolean hidden) {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.setHiddenInLock(hidden);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private boolean isWholeRow(SBook book, CellRegion region) {
        return region.column <= 0 && region.lastColumn >= book.getMaxColumnIndex();
    }

    private boolean isWholeColumn(SBook book, CellRegion region) {
        return region.row <= 0 && region.lastRow >= book.getMaxRowIndex();
    }

    protected void setHiddenInLock(boolean hidden) {
        LinkedHashSet<SheetRegion> notifySet = new LinkedHashSet<SheetRegion>();
        for (EffectedRegion r : this._rangeRefs) {
            int i;
            SBook book = r.sheet.getBook();
            int maxcol = r.sheet.getBook().getMaxColumnIndex();
            int maxrow = r.sheet.getBook().getMaxRowIndex();
            CellRegion region = r.region;
            if (this.isWholeRow(book, region)) {
                for (i = region.getRow(); i <= region.getLastRow(); ++i) {
                    SRow row = r.sheet.getRow(i);
                    if (row.isHidden() == hidden) continue;
                    row.setHidden(hidden);
                    notifySet.add(new SheetRegion(r.sheet, i, 0, i, maxcol));
                }
                continue;
            }
            if (!this.isWholeColumn(book, region)) continue;
            for (i = region.getColumn(); i <= region.getLastColumn(); ++i) {
                SColumn col = r.sheet.getColumn(i);
                if (col.isHidden() == hidden) continue;
                col.setHidden(hidden);
                notifySet.add(new SheetRegion(r.sheet, 0, i, maxrow, i));
            }
        }
        new NotifyChangeHelper().notifyRowColumnSizeChange(notifySet);
    }

    @Override
    public void setDisplayGridlines(final boolean show) {
        new ReadWriteTask(){

            public Object invoke() {
                for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                    SSheet sheet = r.sheet;
                    if (sheet.getViewInfo().isDisplayGridlines() == show) continue;
                    sheet.getViewInfo().setDisplayGridlines(show);
                    new NotifyChangeHelper().notifyDisplayGridlines(sheet, show);
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    @Deprecated
    public void protectSheet(final String password) {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.setPasswordInLock(RangeImpl.this.getSheet(), password);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setHyperlink(final SHyperlink.HyperlinkType linkType, final String address, final String display) {
        new CellVisitorTask(new CellVisitorForUpdate(){

            public boolean visit(SCell cell) {
                SHyperlink link = cell.setupHyperlink(linkType, address, display);
                String text = display;
                while (text.startsWith("=")) {
                    text = text.substring(1);
                }
                cell.setStringValue(text);
                return true;
            }
        }).doInWriteLock(this.getLock());
    }

    @Override
    public Object getValue() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            public boolean visit(SCell cell) {
                Object val = cell.getValue();
                r.set(val);
                return false;
            }
        }).doInReadLock(this.getLock());
        return r.get();
    }

    @Override
    public SRange getOffset(int rowOffset, int colOffset) {
        if (rowOffset == 0 && colOffset == 0) {
            return this;
        }
        if (this._rangeRefs != null && !this._rangeRefs.isEmpty()) {
            SBook book = this.getBook();
            int maxCol = book.getMaxColumnIndex();
            int maxRow = book.getMaxRowIndex();
            LinkedHashSet<SheetRegion> nrefs = new LinkedHashSet<SheetRegion>(this._rangeRefs.size());
            for (EffectedRegion ref : this._rangeRefs) {
                SheetRegion refAddr;
                int nbottom;
                int left = ref.region.getColumn() + colOffset;
                int top = ref.region.getRow() + rowOffset;
                int right = ref.region.getLastColumn() + colOffset;
                int bottom = ref.region.getLastRow() + rowOffset;
                SSheet refSheet = ref.sheet;
                int nleft = colOffset < 0 ? Math.max(0, left) : left;
                int ntop = rowOffset < 0 ? Math.max(0, top) : top;
                int nright = colOffset > 0 ? Math.min(maxCol, right) : right;
                int n = nbottom = rowOffset > 0 ? Math.min(maxRow, bottom) : bottom;
                if (nleft > nright || ntop > nbottom || nrefs.contains(refAddr = new SheetRegion(refSheet, ntop, nleft, nbottom, nright))) continue;
                nrefs.add(refAddr);
            }
            if (nrefs.isEmpty()) {
                return EMPTY_RANGE;
            }
            return new RangeImpl(nrefs);
        }
        return EMPTY_RANGE;
    }

    @Override
    public boolean isAnyCellProtected() {
        return (Boolean)new ReadWriteTask(){

            public Object invoke() {
                for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                    SSheet sheet = r.sheet;
                    if (!sheet.isProtected()) continue;
                    CellRegion region = r.region;
                    for (int i = region.row; i <= region.lastRow; ++i) {
                        for (int j = region.column; j <= region.lastColumn; ++j) {
                            SCellStyle style = r.sheet.getCell(i, j).getCellStyle();
                            if (!style.isLocked()) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public void deleteSheet() {
        final ResultWrap toDeleteSheet = new ResultWrap();
        final ResultWrap toDeleteIndex = new ResultWrap();
        new ModelManipulationTask(){

            protected Object doInvoke() {
                SBook book = RangeImpl.this.getBook();
                int sheetCount = book.getNumOfSheet();
                if (sheetCount <= 1) {
                    throw new InvalidModelOpException("can't delete last sheet ");
                }
                SSheet toDelete = RangeImpl.this.getSheet();
                int index = book.getSheetIndex(toDelete);
                toDeleteSheet.set(toDelete);
                toDeleteIndex.set(index);
                book.deleteSheet(toDelete);
                return null;
            }

            protected void doBeforeNotify() {
                if (toDeleteSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetDelete(RangeImpl.this.getBook(), (SSheet)toDeleteSheet.get(), (Integer)toDeleteIndex.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SSheet createSheet(final String name) {
        final ResultWrap resultSheet = new ResultWrap();
        return (SSheet)new ModelManipulationTask(){

            protected Object doInvoke() {
                SBook book = RangeImpl.this.getBook();
                SSheet sheet = Strings.isBlank((String)name) ? book.createSheet(RangeImpl.this.nextSheetName()) : book.createSheet(name);
                resultSheet.set(sheet);
                return sheet;
            }

            protected void doBeforeNotify() {
                if (resultSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetCreate((SSheet)resultSheet.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SSheet cloneSheet(final String name) {
        final ResultWrap resultSheet = new ResultWrap();
        return (SSheet)new ModelManipulationTask(){

            protected Object doInvoke() {
                SBook book = RangeImpl.this.getBook();
                SSheet srcsheet = RangeImpl.this.getSheet();
                SSheet sheet = Strings.isBlank((String)name) ? book.createSheet(RangeImpl.this.nextSheetName(), srcsheet) : book.createSheet(name, srcsheet);
                resultSheet.set(sheet);
                return sheet;
            }

            protected void doBeforeNotify() {
                if (resultSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetCreate((SSheet)resultSheet.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    private String nextSheetName() {
        SBook book = this.getBook();
        Integer idx = (Integer)book.getAttribute("zss.nextSheetCount");
        int i = idx == null ? 1 : idx;
        HashSet<String> names = new HashSet<String>();
        for (SSheet sheet : this.getBook().getSheets()) {
            names.add(sheet.getSheetName());
        }
        String base = "Sheet";
        String name = base + i;
        while (names.contains(name)) {
            name = base + ++i;
        }
        book.setAttribute("zss.nextSheetCount", i + 1);
        return name;
    }

    @Override
    public void setSheetName(final String newname) {
        final ResultWrap resultSheet = new ResultWrap();
        final ResultWrap oldName = new ResultWrap();
        new ModelManipulationTask(){

            protected Object doInvoke() {
                SBook book = RangeImpl.this.getBook();
                SSheet sheet = RangeImpl.this.getSheet();
                String old = sheet.getSheetName();
                if (old.equals(newname)) {
                    return null;
                }
                book.setSheetName(sheet, newname);
                resultSheet.set(sheet);
                oldName.set(old);
                return null;
            }

            protected void doBeforeNotify() {
                if (resultSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetNameChange((SSheet)resultSheet.get(), (String)oldName.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setSheetOrder(final int pos) {
        final ResultWrap resultSheet = new ResultWrap();
        final ResultWrap oldIdx = new ResultWrap();
        new ModelManipulationTask(){

            protected Object doInvoke() {
                SSheet sheet;
                SBook book = RangeImpl.this.getBook();
                int old = book.getSheetIndex(sheet = RangeImpl.this.getSheet());
                if (old == pos) {
                    return null;
                }
                book.moveSheetTo(sheet, pos);
                resultSheet.set(sheet);
                oldIdx.set(old);
                return null;
            }

            protected void doBeforeNotify() {
                if (resultSheet.get() != null) {
                    new NotifyChangeHelper().notifySheetReorder((SSheet)resultSheet.get(), (Integer)oldIdx.get());
                }
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void setFreezePanel(final int numOfRow, final int numOfColumn) {
        new ReadWriteTask(){

            public Object invoke() {
                SSheetViewInfo viewInfo = RangeImpl.this.getSheet().getViewInfo();
                viewInfo.setNumOfRowFreeze(numOfRow);
                viewInfo.setNumOfColumnFreeze(numOfColumn);
                RangeImpl.this.notifySheetFreezeChange();
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void notifySheetFreezeChange() {
        new NotifyChangeHelper().notifySheetFreezeChange(this.getSheet());
    }

    @Override
    public String getCellFormatText() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            public boolean visit(SCell cell) {
                FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
                r.set(fe.format(cell, new FormatContext(ZssContext.getCurrent().getLocale())).getText());
                return false;
            }
        }).doInReadLock(this.getLock());
        return (String)r.get();
    }

    @Override
    public String getCellDataFormat() {
        final ResultWrap r = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            public boolean visit(SCell cell) {
                FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
                r.set(fe.getFormat(cell, new FormatContext(ZssContext.getCurrent().getLocale())));
                return false;
            }
        }).doInReadLock(this.getLock());
        return (String)r.get();
    }

    @Override
    public boolean isSheetProtected() {
        return (Boolean)new ReadWriteTask(){

            public Object invoke() {
                return RangeImpl.this.getSheet().isProtected();
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public SDataValidation validate(final String editText) {
        final ResultWrap retrunVal = new ResultWrap();
        new CellVisitorTask(new CellVisitor(){

            boolean visit(SCell cell) {
                SDataValidation validation = RangeImpl.this.getSheet().getDataValidation(cell.getRowIndex(), cell.getColumnIndex());
                if (validation != null && !new DataValidationHelper(validation).validate(editText, cell.getCellStyle().getDataFormat())) {
                    retrunVal.set(validation);
                    return false;
                }
                return true;
            }
        }).doInReadLock(this.getLock());
        return (SDataValidation)retrunVal.get();
    }

    @Override
    public SRange findAutoFilterRange() {
        return (SRange)new ReadWriteTask(){

            public Object invoke() {
                CellRegion region = new DataRegionHelper(RangeImpl.this).findAutoFilterDataRegion();
                if (region != null) {
                    return SRanges.range(RangeImpl.this.getSheet(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
                }
                return null;
            }
        }.doInReadLock(this.getLock());
    }

    Ref getSheetRef() {
        return new RefImpl((AbstractSheetAdv)this.getSheet());
    }

    Ref getBookRef() {
        return new RefImpl((AbstractSheetAdv)((Object)this.getBook()));
    }

    private Set<Ref> toSet(Ref ref) {
        HashSet<Ref> refs = new HashSet<Ref>(1);
        refs.add(ref);
        return refs;
    }

    @Override
    public SAutoFilter enableAutoFilter(final boolean enable) {
        return (SAutoFilter)new ReadWriteTask(){

            public Object invoke() {
                SSheet sheet = RangeImpl.this.getSheet();
                SAutoFilter filter = sheet.getAutoFilter();
                if (filter == null && !enable || filter != null && enable) {
                    return filter;
                }
                filter = new AutoFilterHelper(RangeImpl.this).enableAutoFilter(enable);
                RangeImpl.this.notifySheetAutoFilterChange();
                return filter;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SAutoFilter enableAutoFilter(final int field, final SAutoFilter.FilterOp filterOp, final Object criteria1, final Object criteria2, final Boolean visibleDropDown) {
        return (SAutoFilter)new ReadWriteTask(){

            public Object invoke() {
                SAutoFilter filter = new AutoFilterHelper(RangeImpl.this).enableAutoFilter(field, filterOp, criteria1, criteria2, visibleDropDown);
                RangeImpl.this.notifySheetAutoFilterChange();
                return filter;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void resetAutoFilter() {
        new ReadWriteTask(){

            public Object invoke() {
                new AutoFilterHelper(RangeImpl.this).resetAutoFilter();
                RangeImpl.this.notifySheetAutoFilterChange();
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void applyAutoFilter() {
        new ReadWriteTask(){

            public Object invoke() {
                new AutoFilterHelper(RangeImpl.this).applyAutoFilter();
                RangeImpl.this.notifySheetAutoFilterChange();
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void notifySheetAutoFilterChange() {
        new NotifyChangeHelper().notifySheetAutoFilterChange(this.getSheet());
    }

    @Override
    public void notifyCustomEvent(final String customEventName, final Object data, boolean writelock) {
        ReadWriteTask task = new ReadWriteTask(){

            public Object invoke() {
                NotifyChangeHelper notifyHelper = new NotifyChangeHelper();
                for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                    SBook book = r.sheet.getBook();
                    notifyHelper.notifyCustomEvent(customEventName, r.sheet, data);
                }
                return null;
            }
        };
        if (writelock) {
            task.doInWriteLock(this.getLock());
        } else {
            task.doInReadLock(this.getLock());
        }
    }

    @Override
    public SPicture addPicture(final ViewAnchor anchor, final byte[] image, final SPicture.Format format) {
        return (SPicture)new ReadWriteTask(){

            public Object invoke() {
                SPicture picture = RangeImpl.this.getSheet().addPicture(format, image, anchor);
                new NotifyChangeHelper().notifySheetPictureAdd(RangeImpl.this.getSheet(), picture.getId());
                return picture;
            }
        }.doInWriteLock(this.getLock());
    }

    private void handleMergeRemoveNotifyChange(SheetRegion mergeNotify) {
        new NotifyChangeHelper().notifyMergeRemove(mergeNotify);
    }

    private void handleMergeRemoveNotifyChange(Set<SheetRegion> mergeNotifySet) {
        new NotifyChangeHelper().notifyMergeRemove(mergeNotifySet);
    }

    private void handleMergeAddNotifyChange(SheetRegion mergeNotify) {
        new NotifyChangeHelper().notifyMergeAdd(mergeNotify);
    }

    private void handleMergeAddNotifyChange(Set<SheetRegion> mergeNotifySet) {
        new NotifyChangeHelper().notifyMergeAdd(mergeNotifySet);
    }

    private void handleCellNotifyContentChange(SheetRegion cellNotify) {
        new NotifyChangeHelper().notifyCellChange(cellNotify);
    }

    private void handleCellNotifyContentChange(Set<SheetRegion> cellNotifySet) {
        new NotifyChangeHelper().notifyCellChange(cellNotifySet);
    }

    private void handleInsertDeleteNotifyChange(InsertDeleteUpdate insertDeleteNofity) {
        new NotifyChangeHelper().notifyInsertDelete(insertDeleteNofity);
    }

    private void handleInsertDeleteNotifyChange(List<InsertDeleteUpdate> insertDeleteNofitySet) {
        new NotifyChangeHelper().notifyInsertDelete(insertDeleteNofitySet);
    }

    @Override
    public void deletePicture(final SPicture picture) {
        new ReadWriteTask(){

            public Object invoke() {
                String pid = picture.getId();
                RangeImpl.this.getSheet().deletePicture(picture);
                new NotifyChangeHelper().notifySheetPictureDelete(RangeImpl.this.getSheet(), pid);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void movePicture(final SPicture picture, final ViewAnchor anchor) {
        new ReadWriteTask(){

            public Object invoke() {
                picture.setAnchor(anchor);
                new NotifyChangeHelper().notifySheetPictureMove(RangeImpl.this.getSheet(), picture.getId());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SChart addChart(final ViewAnchor anchor, final SChart.ChartType type, final SChart.ChartGrouping grouping, final SChart.ChartLegendPosition pos, final boolean isThreeD) {
        return (SChart)new ReadWriteTask(){

            public Object invoke() {
                SChart chart = RangeImpl.this.getSheet().addChart(type, anchor);
                chart.setThreeD(isThreeD);
                new ChartDataHelper(RangeImpl.this).fillChartData(chart);
                chart.setGrouping(grouping);
                chart.setLegendPosition(pos);
                new NotifyChangeHelper().notifySheetChartAdd(RangeImpl.this.getSheet(), chart.getId());
                return chart;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void deleteChart(final SChart chart) {
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.getSheet().deleteChart(chart);
                new NotifyChangeHelper().notifySheetChartDelete(RangeImpl.this.getSheet(), chart.getId());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void moveChart(final SChart chart, final ViewAnchor anchor) {
        new ReadWriteTask(){

            public Object invoke() {
                chart.setAnchor(anchor);
                new NotifyChangeHelper().notifySheetChartUpdate(RangeImpl.this.getSheet(), chart.getId());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void updateChart(final SChart chart) {
        new ReadWriteTask(){

            public Object invoke() {
                new NotifyChangeHelper().notifySheetChartUpdate(RangeImpl.this.getSheet(), chart.getId());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void sort(final SRange key1, final boolean descending1, final SRange.SortDataOption dataOption1, final SRange key2, final boolean descending2, final SRange.SortDataOption dataOption2, final SRange key3, final boolean descending3, final SRange.SortDataOption dataOption3, final int hasHeader, final boolean matchCase, final boolean sortByRows) {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                new SortHelper(RangeImpl.this).sort(key1, descending1, dataOption1, key2, descending2, dataOption2, key3, descending3, dataOption3, hasHeader, matchCase, sortByRows);
                return null;
            }

            protected void doBeforeNotify() {
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void createName(final String nameName) {
        new ModelManipulationTask(){

            protected Object doInvoke() {
                RangeImpl.this.createNameInLock(nameName);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private void createNameInLock(String nameName) {
        SSheet sht = this.getSheet();
        String sn = sht.getSheetName();
        int c1 = this.getColumn();
        int c2 = this.getLastColumn();
        int r1 = this.getRow();
        int r2 = this.getLastRow();
        String refers = null;
        if (c1 == c2 && r1 == r2) {
            CellReference cf = new CellReference(sn, r1, c1, true, true);
            refers = cf.formatAsString();
        } else {
            AreaReference af = new AreaReference(new CellReference(sn, this.getRow(), c1, true, true), new CellReference(sn, this.getLastRow(), this.getLastColumn(), true, true));
            refers = af.formatAsString();
        }
        SName name = this.getBook().createName(nameName);
        name.setRefersToFormula(refers);
        AbstractBookSeriesAdv series = (AbstractBookSeriesAdv)this.getBookSeries();
        DependencyTable table = series.getDependencyTable();
        this.handleRefNotifyContentChange((SBookSeries)series, table.getEvaluatedDependents(new NameRefImpl((AbstractNameAdv)name)));
    }

    @Override
    public boolean isProtected() {
        return (Boolean)new ReadWriteTask(){

            public Object invoke() {
                SSheet sheet;
                EffectedRegion r;
                EffectedRegion effectedRegion = r = RangeImpl.this._rangeRefs.isEmpty() ? null : (EffectedRegion)RangeImpl.this._rangeRefs.get(0);
                if (r != null && (sheet = r.sheet).isProtected()) {
                    CellRegion region = r.region;
                    for (int i = region.row; i <= region.lastRow; ++i) {
                        for (int j = region.column; j <= region.lastColumn; ++j) {
                            SCellStyle style = r.sheet.getCell(i, j).getCellStyle();
                            if (!style.isLocked()) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public void protectSheet(String password, final boolean allowSelectingLockedCells, final boolean allowSelectingUnlockedCells, final boolean allowFormattingCells, final boolean allowFormattingColumns, final boolean allowFormattingRows, final boolean allowInsertColumns, final boolean allowInsertRows, final boolean allowInsertingHyperlinks, final boolean allowDeletingColumns, final boolean allowDeletingRows, final boolean allowSorting, final boolean allowFiltering, final boolean allowUsingPivotTables, final boolean drawingObjects, final boolean scenarios) {
        final String pass0 = password == null ? "" : password;
        new ReadWriteTask(){

            public Object invoke() {
                RangeImpl.this.protectSheetInLock(RangeImpl.this.getSheet(), pass0, allowSelectingLockedCells, allowSelectingUnlockedCells, allowFormattingCells, allowFormattingColumns, allowFormattingRows, allowInsertColumns, allowInsertRows, allowInsertingHyperlinks, allowDeletingColumns, allowDeletingRows, allowSorting, allowFiltering, allowUsingPivotTables, drawingObjects, scenarios);
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public boolean unprotectSheet(final String password) {
        if (!this.getSheet().isProtected()) {
            return true;
        }
        return (Boolean)new ReadWriteTask(){

            public Object invoke() {
                return RangeImpl.this.unprotectSheetInLock(RangeImpl.this.getSheet(), password);
            }
        }.doInWriteLock(this.getLock());
    }

    private void protectSheetInLock(SSheet sht, String password, boolean allowSelectingLockedCells, boolean allowSelectingUnlockedCells, boolean allowFormattingCells, boolean allowFormattingColumns, boolean allowFormattingRows, boolean allowInsertColumns, boolean allowInsertRows, boolean allowInsertingHyperlinks, boolean allowDeletingColumns, boolean allowDeletingRows, boolean allowSorting, boolean allowFiltering, boolean allowUsingPivotTables, boolean drawingObjects, boolean scenarios) {
        if (sht.isProtected()) {
            short hashpass = sht.getHashedPassword();
            short inputpass = WorkbookUtil.hashPassword((String)password);
            if (inputpass != hashpass) {
                return;
            }
        }
        SSheetProtection sp = sht.getSheetProtection();
        sp.setSelectLockedCells(allowSelectingLockedCells);
        sp.setSelectUnlockedCells(allowSelectingUnlockedCells);
        sp.setFormatCells(allowFormattingCells);
        sp.setFormatColumns(allowFormattingColumns);
        sp.setFormatRows(allowFormattingRows);
        sp.setInsertColumns(allowInsertColumns);
        sp.setInsertRows(allowInsertRows);
        sp.setInsertHyperlinks(allowInsertingHyperlinks);
        sp.setDeleteColumns(allowDeletingColumns);
        sp.setDeleteRows(allowDeletingRows);
        sp.setSort(allowSorting);
        sp.setAutoFilter(allowFiltering);
        sp.setPivotTables(allowUsingPivotTables);
        sp.setObjects(drawingObjects);
        sp.setScenarios(scenarios);
        this.setPasswordInLock(sht, password);
    }

    private boolean unprotectSheetInLock(SSheet sht, String password) {
        short hashpass = sht.getHashedPassword();
        if (hashpass != 0 && (password == null || password.isEmpty() || WorkbookUtil.hashPassword((String)password) != hashpass)) {
            return false;
        }
        this.setPasswordInLock(sht, null);
        SSheetProtection sp = sht.getSheetProtection();
        sp.setObjects(false);
        sp.setScenarios(false);
        return true;
    }

    private void setPasswordInLock(SSheet sheet, String password) {
        if (sheet.isProtected() && password == null) {
            sheet.setPassword(null);
            new NotifyChangeHelper().notifyProtectSheet(sheet, false);
        } else if (!sheet.isProtected() && password != null) {
            sheet.setPassword(password);
            new NotifyChangeHelper().notifyProtectSheet(sheet, true);
        }
    }

    @Override
    public SSheetProtection getSheetProtection() {
        return this.getSheet().getSheetProtection();
    }

    @Override
    public void setValidation(final SDataValidation.ValidationType validationType, final boolean ignoreBlank, final SDataValidation.OperatorType operatorType, final boolean inCellDropDown, final String formula1, final String formula2, final boolean showInput, final String inputTitle, final String inputMessage, final boolean showError, final SDataValidation.AlertStyle alertStyle, final String errorTitle, final String errorMessage) {
        if (validationType == SDataValidation.ValidationType.ANY && inputTitle == null && inputMessage == null && errorTitle == null && errorMessage == null) {
            return;
        }
        new ReadWriteTask(){

            public Object invoke() {
                SDataValidation dv = RangeImpl.this.setValidaitonInLock(validationType, ignoreBlank, operatorType, inCellDropDown, formula1, formula2, showInput, inputTitle, inputMessage, showError, alertStyle, errorTitle, errorMessage);
                new NotifyChangeHelper().notifyDataValidationChange(RangeImpl.this.getSheet(), (String)dv.getId());
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    private SDataValidation setValidaitonInLock(SDataValidation.ValidationType validationType, boolean ignoreBlank, SDataValidation.OperatorType operatorType, boolean inCellDropDown, String formula1, String formula2, boolean showInput, String inputTitle, String inputMessage, boolean showError, SDataValidation.AlertStyle alertStyle, String errorTitle, String errorMessage) {
        SDataValidation dv = this.getSheet().getDataValidation(this.getRow(), this.getColumn());
        if (dv == null) {
            dv = this.getSheet().addDataValidation(new CellRegion(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn()));
        }
        dv.setValidationType(validationType);
        dv.setIgnoreBlank(ignoreBlank);
        dv.setOperatorType(operatorType);
        dv.setInCellDropdown(inCellDropDown);
        ((AbstractDataValidationAdv)dv).setFormulas(formula1, formula2);
        dv.setShowInput(showInput);
        dv.setInputTitle(inputTitle);
        dv.setInputMessage(inputMessage);
        dv.setShowError(showError);
        dv.setAlertStyle(alertStyle);
        dv.setErrorTitle(errorTitle);
        dv.setErrorMessage(errorMessage);
        return dv;
    }

    @Override
    public List<SDataValidation> getValidations() {
        return (List)new ReadWriteTask(){

            public Object invoke() {
                CellRegion region = new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn());
                ArrayList<SDataValidation> results = new ArrayList<SDataValidation>();
                for (SDataValidation dv : RangeImpl.this.getSheet().getDataValidations()) {
                    for (CellRegion rgn : dv.getRegions()) {
                        if (!rgn.overlaps(region)) continue;
                        results.add(dv);
                        break;
                    }
                    if (results.size() <= 1) continue;
                    break;
                }
                return results;
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public void deleteValidation() {
        new ReadWriteTask(){

            public Object invoke() {
                List<SDataValidation> dvs = RangeImpl.this.getSheet().deleteDataValidationRegion(new CellRegion(RangeImpl.this.getRow(), RangeImpl.this.getColumn(), RangeImpl.this.getLastRow(), RangeImpl.this.getLastColumn()));
                for (SDataValidation dv : dvs) {
                    new NotifyChangeHelper().notifyDataValidationChange(RangeImpl.this.getSheet(), (String)dv.getId());
                }
                return null;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public SFont getOrCreateFont(final SFont.Boldweight boldweight, final String htmlColor, final int fontHeight, final String fontName, final boolean italic, final boolean strikeout, final SFont.TypeOffset typeOffset, final SFont.Underline underline) {
        final SBook book = this.getBook();
        return (SFont)new ReadWriteTask(){

            public Object invoke() {
                FontMatcher fm = new FontMatcher();
                fm.setBoldweight(boldweight);
                fm.setColor(htmlColor);
                fm.setHeightPoints(fontHeight);
                fm.setName(fontName);
                fm.setItalic(italic);
                fm.setStrikeout(strikeout);
                fm.setTypeOffset(typeOffset);
                fm.setUnderline(underline);
                SFont font = book.searchFont(fm);
                if (font == null) {
                    font = book.createFont(true);
                    font.setBoldweight(boldweight);
                    font.setColor(new ColorImpl(htmlColor));
                    font.setHeightPoints(fontHeight);
                    font.setName(fontName);
                    font.setItalic(italic);
                    font.setStrikeout(strikeout);
                    font.setTypeOffset(typeOffset);
                    font.setUnderline(underline);
                }
                return font;
            }
        }.doInWriteLock(this.getLock());
    }

    @Override
    public void refresh(final boolean includeDependants) {
        new ReadWriteTask(){

            public Object invoke() {
                SBookSeries bookSeries = null;
                DependencyTable table = null;
                if (includeDependants) {
                    bookSeries = RangeImpl.this.getSheet().getBook().getBookSeries();
                    table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
                }
                for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                    CellRegion region = r.region;
                    RangeImpl.this.handleCellNotifyContentChange(new SheetRegion(r.sheet, region));
                    if (!includeDependants) continue;
                    RangeImpl.this.handleRefNotifyContentChange(bookSeries, table.getEvaluatedDependents(new RefImpl(r.sheet.getBook().getBookName(), r.sheet.getSheetName(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn())));
                }
                return null;
            }
        }.doInReadLock(this.getLock());
    }

    @Override
    public boolean setAutoRefresh(boolean auto) {
        boolean previous = this._autoRefresh;
        this._autoRefresh = auto;
        return previous;
    }

    private class ModelUpdateWrapper {
        SBookSeries bookSeries;
        List<ModelUpdate> modelUpdates;
        ModelUpdateCollector modelUpdateCollector;
        ModelUpdateCollector oldCollector;
        FormulaCacheCleaner oldClearer;

        public ModelUpdateWrapper(SBookSeries bookSeries, boolean collectUpdate) {
            this.bookSeries = bookSeries;
            this.oldCollector = ModelUpdateCollector.setCurrent(collectUpdate ? (this.modelUpdateCollector = new ModelUpdateCollector()) : null);
            this.oldClearer = FormulaCacheCleaner.setCurrent(new FormulaCacheCleaner(bookSeries));
        }

        public void doFinially() {
            if (this.modelUpdateCollector != null) {
                this.modelUpdates = this.modelUpdateCollector.getModelUpdates();
            }
            ModelUpdateCollector.setCurrent(this.oldCollector);
            FormulaCacheCleaner.setCurrent(this.oldClearer);
        }

        public void doNotify() {
            if (this.modelUpdates == null) {
                return;
            }
            for (ModelUpdate update : this.modelUpdates) {
                switch (update.getType()) {
                    case CELL: {
                        RangeImpl.this.handleCellNotifyContentChange((SheetRegion)update.getData());
                        break;
                    }
                    case CELLS: {
                        RangeImpl.this.handleCellNotifyContentChange((Set)update.getData());
                        break;
                    }
                    case REF: {
                        RangeImpl.this.handleRefNotifyContentChange(this.bookSeries, (Ref)update.getData());
                        break;
                    }
                    case REFS: {
                        RangeImpl.this.handleRefNotifyContentChange(this.bookSeries, (Set)update.getData());
                        break;
                    }
                    case MERGE: {
                        MergeUpdate mu = (MergeUpdate)update.getData();
                        if (mu.getOrigMerge() != null) {
                            RangeImpl.this.handleMergeRemoveNotifyChange(new SheetRegion(mu.getSheet(), mu.getOrigMerge()));
                        }
                        if (mu.getMerge() == null) break;
                        RangeImpl.this.handleMergeAddNotifyChange(new SheetRegion(mu.getSheet(), mu.getMerge()));
                        break;
                    }
                    case INSERT_DELETE: {
                        RangeImpl.this.handleInsertDeleteNotifyChange((InsertDeleteUpdate)update.getData());
                    }
                }
            }
        }
    }

    private abstract class ModelManipulationTask
    extends ReadWriteTask {
        private ModelManipulationTask() {
        }

        protected abstract Object doInvoke();

        protected void doBeforeNotify() {
        }

        protected void doAfterNotify() {
        }

        protected boolean isCollectModelUpdate() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke() {
            ModelUpdateWrapper updateWrap = new ModelUpdateWrapper(RangeImpl.this.getBookSeries(), this.isCollectModelUpdate());
            Object result = null;
            try {
                result = this.doInvoke();
            }
            finally {
                updateWrap.doFinially();
            }
            this.doBeforeNotify();
            updateWrap.doNotify();
            this.doAfterNotify();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResultWrap<T> {
        T obj;

        public ResultWrap() {
        }

        public ResultWrap(T obj) {
            this.obj = obj;
        }

        public T get() {
            return this.obj;
        }

        public void set(T obj) {
            this.obj = obj;
        }
    }

    private abstract class CellVisitorForUpdate
    extends CellVisitor {
        private CellVisitorForUpdate() {
        }

        public void afterVisitAll() {
            if (!RangeImpl.this._autoRefresh) {
                return;
            }
            SBookSeries bookSeries = RangeImpl.this.getSheet().getBook().getBookSeries();
            DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
            for (EffectedRegion r : RangeImpl.this._rangeRefs) {
                CellRegion region = r.region;
                RangeImpl.this.handleCellNotifyContentChange(new SheetRegion(r.sheet, r.region));
                RangeImpl.this.handleRefNotifyContentChange(bookSeries, table.getEvaluatedDependents(new RefImpl(r.sheet.getBook().getBookName(), r.sheet.getSheetName(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn())));
            }
        }
    }

    private abstract class CellVisitor {
        private CellVisitor() {
        }

        abstract boolean visit(SCell var1);

        public void afterVisitAll() {
        }
    }

    private class EffectedRegion {
        private final SSheet sheet;
        private final CellRegion region;

        public EffectedRegion(SSheet sheet, int row, int column, int lastRow, int lastColumn) {
            this.sheet = sheet;
            this.region = new CellRegion(row, column, lastRow, lastColumn);
        }
    }

    private class CellVisitorTask
    extends ReadWriteTask {
        private CellVisitor visitor;
        private boolean stop = false;

        private CellVisitorTask(CellVisitor visitor) {
            this.visitor = visitor;
        }

        public Object invoke() {
            RangeImpl.this.travelCells(this.visitor);
            return null;
        }
    }
}

