/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.zkoss.util.logging.Log;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.ModelEvent;
import org.zkoss.zss.model.ModelEvents;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.range.impl.InsertDeleteUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NotifyChangeHelper {
    private static final Log _logger = Log.lookup((String)NotifyChangeHelper.class.getName());

    NotifyChangeHelper() {
    }

    public void notifyRowColumnSizeChange(HashSet<SheetRegion> notifySet) {
        for (SheetRegion notify : notifySet) {
            this.notifyRowColumnSizeChange(notify);
        }
    }

    public void notifyRowColumnSizeChange(SheetRegion notify) {
        ((AbstractBookAdv)notify.getSheet().getBook()).sendModelEvent(ModelEvents.createModelEvent("onRowColumnSizeChange", notify.getSheet(), new CellRegion(notify.getRow(), notify.getColumn(), notify.getLastRow(), notify.getLastColumn())));
    }

    public void notifySheetAutoFilterChange(SSheet sheet) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onAutoFilterChange", sheet));
    }

    public void notifySheetFreezeChange(SSheet sheet) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onFreezeChange", sheet));
    }

    public void notifySheetPictureAdd(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onPictureAdd", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetPictureDelete(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onPictureDelete", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetPictureMove(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onPictureUpdate", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetChartAdd(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onChartAdd", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetChartDelete(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onChartDelete", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetChartUpdate(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onChartUpdate", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifyMergeRemove(Set<SheetRegion> toRemove) {
        for (SheetRegion notify : toRemove) {
            this.notifyMergeRemove(notify);
        }
    }

    public void notifyMergeRemove(SheetRegion notify) {
        SBook book = notify.getSheet().getBook();
        if (_logger.debugable()) {
            _logger.debug("Notify remove merge " + notify.getReferenceString());
        }
        ((AbstractBookAdv)book).sendModelEvent(ModelEvents.createModelEvent("onMergeDelete", notify.getSheet(), notify.getRegion()));
    }

    public void notifyMergeAdd(Set<SheetRegion> toAdd) {
        for (SheetRegion notify : toAdd) {
            this.notifyMergeAdd(notify);
        }
    }

    public void notifyMergeAdd(SheetRegion notify) {
        SBook book = notify.getSheet().getBook();
        if (_logger.debugable()) {
            _logger.debug("Notify add merge " + notify.getReferenceString());
        }
        ((AbstractBookAdv)book).sendModelEvent(ModelEvents.createModelEvent("onMergeAdd", notify.getSheet(), notify.getRegion()));
    }

    public void notifyCellChange(Set<SheetRegion> cellNotifySet) {
        for (SheetRegion notify : cellNotifySet) {
            this.notifyCellChange(notify);
        }
    }

    public void notifyCellChange(SheetRegion notify) {
        SBook book = notify.getSheet().getBook();
        if (_logger.debugable()) {
            _logger.debug("Notify cell change " + notify.getReferenceString());
        }
        ((AbstractBookAdv)book).sendModelEvent(ModelEvents.createModelEvent("onCellChange", notify.getSheet(), notify.getRegion()));
    }

    public void notifySheetDelete(SBook book, SSheet deletedSheet, int deletedIndex) {
        if (_logger.debugable()) {
            _logger.debug("Notify sheet delete " + deletedSheet.getSheetName() + ":" + deletedIndex);
        }
        ((AbstractBookAdv)book).sendModelEvent(ModelEvents.createModelEvent("onSheetDelete", book, ModelEvents.createDataMap("sheet", deletedSheet, "index", deletedIndex)));
    }

    public void notifySheetCreate(SSheet sheet) {
        if (_logger.debugable()) {
            _logger.debug("Notify sheet create " + sheet.getSheetName());
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onSheetCreate", sheet));
    }

    public void notifySheetNameChange(SSheet sheet, String oldName) {
        if (_logger.debugable()) {
            _logger.debug("Notify sheet name change " + oldName + " to " + sheet.getSheetName());
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onSheetNameChange", sheet, ModelEvents.createDataMap("oldName", oldName)));
    }

    public void notifySheetReorder(SSheet sheet, int oldIdx) {
        if (_logger.debugable()) {
            _logger.debug("Notify sheet reorder " + oldIdx + " to " + sheet.getBook().getSheetIndex(sheet));
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onSheetOrderChange", sheet, ModelEvents.createDataMap("oldIndex", oldIdx)));
    }

    public void notifyDataValidationChange(SSheet sheet, String validationId) {
        if (_logger.debugable()) {
            _logger.debug("Notify data validation change" + validationId);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onDataValidationContentChange", sheet, ModelEvents.createDataMap("objid", validationId)));
    }

    public void notifyChartChange(SSheet sheet, String chartId) {
        if (_logger.debugable()) {
            _logger.debug("Notify chart change " + chartId);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onChartContentChange", sheet, ModelEvents.createDataMap("objid", chartId)));
    }

    public void notifyCustomEvent(String customEventName, SSheet sheet, Object data) {
        if (_logger.debugable()) {
            _logger.debug("Notify custom event " + customEventName + ":" + data);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent(customEventName, sheet, ModelEvents.createDataMap("customData", data)));
    }

    public void notifyDisplayGridlines(SSheet sheet, boolean show) {
        if (_logger.debugable()) {
            _logger.debug("Notify display gridlines " + show);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onDisplayGridlinesChange", sheet, ModelEvents.createDataMap("enabled", show)));
    }

    public void notifyProtectSheet(SSheet sheet, boolean protect) {
        if (_logger.debugable()) {
            _logger.debug("Notify protect sheet " + sheet.getSheetName() + ":" + protect);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onProtectSheetChange", sheet, ModelEvents.createDataMap("enabled", protect)));
    }

    public void notifyInsertDelete(List<InsertDeleteUpdate> insertDeleteNofitySet) {
        for (InsertDeleteUpdate update : insertDeleteNofitySet) {
            this.notifyInsertDelete(update);
        }
    }

    public void notifyInsertDelete(InsertDeleteUpdate update) {
        CellRegion region;
        String eventName;
        if (update.isRow()) {
            eventName = update.isInserted() ? "onRowInsert" : "onRowDelete";
            region = new CellRegion(update.getIndex(), 0, update.getLastIndex(), 0);
        } else {
            eventName = update.isInserted() ? "onColumnInsert" : "onColumnDelete";
            region = new CellRegion(0, update.getIndex(), 0, update.getLastIndex());
        }
        if (_logger.debugable()) {
            _logger.debug("Notify InsertDelete " + eventName + ":" + region.getReferenceString());
        }
        SSheet sheet = update.getSheet();
        ModelEvent event = ModelEvents.createModelEvent(eventName, sheet, region);
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(event);
    }
}

