/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.range.impl.InsertDeleteUpdate;
import org.zkoss.zss.range.impl.MergeUpdate;
import org.zkoss.zss.range.impl.ModelUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUpdateCollector {
    static ThreadLocal<ModelUpdateCollector> _current = new ThreadLocal();
    private List<ModelUpdate> _updates;

    public static ModelUpdateCollector setCurrent(ModelUpdateCollector ctx) {
        ModelUpdateCollector old = _current.get();
        _current.set(ctx);
        return old;
    }

    public static ModelUpdateCollector getCurrent() {
        return _current.get();
    }

    public void addModelUpdate(ModelUpdate mu) {
        if (this._updates == null) {
            this._updates = new LinkedList<ModelUpdate>();
        }
        this._updates.add(mu);
    }

    public List<ModelUpdate> getModelUpdates() {
        if (this._updates == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this._updates);
    }

    private ModelUpdate getLast() {
        return this._updates == null || this._updates.size() == 0 ? null : this._updates.get(this._updates.size() - 1);
    }

    private void removeLast() {
        if (this._updates != null && this._updates.size() > 0) {
            this._updates.remove(this._updates.size() - 1);
        }
    }

    public void addRefs(Set<Ref> dependents) {
        ModelUpdate last = this.getLast();
        if (last != null) {
            if (last.getType() == ModelUpdate.UpdateType.REFS) {
                ((Set)last.getData()).addAll(dependents);
                return;
            }
            if (last.getType() == ModelUpdate.UpdateType.REF) {
                LinkedHashSet<Ref> data = new LinkedHashSet<Ref>();
                data.add((Ref)last.getData());
                data.addAll(dependents);
                this.removeLast();
                this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.REFS, data));
                return;
            }
        }
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.REFS, new LinkedHashSet<Ref>(dependents)));
    }

    public void addRef(Ref ref) {
        ModelUpdate last = this.getLast();
        if (last != null) {
            if (last.getType() == ModelUpdate.UpdateType.REFS) {
                ((Set)last.getData()).add(ref);
                return;
            }
            if (last.getType() == ModelUpdate.UpdateType.REF) {
                LinkedHashSet<Ref> data = new LinkedHashSet<Ref>();
                data.add((Ref)last.getData());
                data.add(ref);
                this.removeLast();
                this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.REFS, data));
                return;
            }
        }
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.REF, ref));
    }

    public void addCellUpdate(SSheet sheet, int row, int column, int lastRow, int lastColumn) {
        ModelUpdate last = this.getLast();
        if (last != null) {
            if (last.getType() == ModelUpdate.UpdateType.REFS) {
                String bookName = sheet.getBook().getBookName();
                String sheetName = sheet.getSheetName();
                if (((Set)last.getData()).contains(new RefImpl(bookName, sheetName, row, column, lastRow, lastColumn))) {
                    return;
                }
            } else if (last.getType() == ModelUpdate.UpdateType.REF) {
                String bookName = sheet.getBook().getBookName();
                String sheetName = sheet.getSheetName();
                if (((Ref)last.getData()).equals(new RefImpl(bookName, sheetName, row, column, lastRow, lastColumn))) {
                    return;
                }
            } else {
                if (last.getType() == ModelUpdate.UpdateType.CELLS) {
                    SheetRegion data = new SheetRegion(sheet, row, column, lastRow, lastColumn);
                    ((Set)last.getData()).add(data);
                    return;
                }
                if (last.getType() == ModelUpdate.UpdateType.CELL) {
                    LinkedHashSet<SheetRegion> data = new LinkedHashSet<SheetRegion>();
                    data.add((SheetRegion)last.getData());
                    data.add(new SheetRegion(sheet, row, column, lastRow, lastColumn));
                    this.removeLast();
                    this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.CELLS, data));
                }
            }
        }
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.CELL, new SheetRegion(sheet, row, column, lastRow, lastColumn)));
    }

    public void addMergeChange(SSheet sheet, CellRegion original, CellRegion changeTo) {
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.MERGE, new MergeUpdate(sheet, original, changeTo)));
    }

    public void addInsertDeleteUpdate(SSheet sheet, boolean inserted, boolean isRow, int index, int lastIndex) {
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.INSERT_DELETE, new InsertDeleteUpdate(sheet, inserted, isRow, index, lastIndex)));
    }
}

