/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.List;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.impl.RangeHelperBase;

public class MergeHelper
extends RangeHelperBase {
    public MergeHelper(SRange range) {
        super(range);
    }

    public void unmerge(boolean overlapped) {
        int tRow = this.getRow();
        int lCol = this.getColumn();
        int bRow = this.getLastRow();
        int rCol = this.getLastColumn();
        this.sheet.removeMergedRegion(new CellRegion(tRow, lCol, bRow, rCol), overlapped);
    }

    public void merge(boolean across) {
        int rCol;
        int bRow;
        int lCol;
        int tRow = this.range.getRow();
        List<CellRegion> overlaps = this.sheet.getOverlapsMergedRegions(new CellRegion(tRow, lCol = this.range.getColumn(), bRow = this.range.getLastRow(), rCol = this.range.getLastColumn()), false);
        if (overlaps.size() > 0) {
            this.unmerge(true);
        }
        if (across) {
            for (int r = tRow; r <= bRow; ++r) {
                this.merge0(this.sheet, r, lCol, r, rCol);
            }
        } else {
            this.merge0(this.sheet, tRow, lCol, bRow, rCol);
        }
    }

    private void merge0(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        if (tRow == bRow && lCol == rCol) {
            return;
        }
        SCell target = null;
        block0: for (int r = tRow; target == null && r <= bRow; ++r) {
            for (int c = lCol; c <= rCol; ++c) {
                SCell cell = sheet.getCell(r, c);
                if (MergeHelper.isBlank(cell)) continue;
                target = cell;
                continue block0;
            }
        }
        SCellStyle style = null;
        if (target != null) {
            SCellStyle source;
            int tgtRow = target.getRowIndex();
            int tgtCol = target.getColumnIndex();
            int nRow = tRow - tgtRow;
            int nCol = lCol - tgtCol;
            if (nRow != 0 || nCol != 0) {
                sheet.moveCell(tgtRow, tgtCol, tgtRow, tgtCol, nRow, nCol);
            }
            SCellStyle sCellStyle = style = (source = target.getCellStyle()).equals(sheet.getBook().getDefaultCellStyle()) ? null : sheet.getBook().createCellStyle(source, true);
            if (style != null) {
                style.setBorderLeft(SCellStyle.BorderType.NONE);
                style.setBorderTop(SCellStyle.BorderType.NONE);
                style.setBorderRight(SCellStyle.BorderType.NONE);
                style.setBorderBottom(SCellStyle.BorderType.NONE);
                target.setCellStyle(style);
            }
            for (int c = lCol + 1; c <= rCol; ++c) {
                SCell cell = sheet.getCell(tRow, c);
                cell.setCellStyle(style);
                cell.setValue(null);
            }
            for (int r = tRow + 1; r <= bRow; ++r) {
                for (int c = lCol; c <= rCol; ++c) {
                    SCell cell = sheet.getCell(r, c);
                    cell.setCellStyle(style);
                    cell.setValue(null);
                }
            }
        }
        CellRegion mergeArea = new CellRegion(tRow, lCol, bRow, rCol);
        sheet.addMergedRegion(mergeArea);
    }
}

