/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.Iterator;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SColumn;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheetViewInfo;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractColumnArrayAdv;
import org.zkoss.zss.model.impl.AbstractRowAdv;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.impl.NotifyChangeHelper;
import org.zkoss.zss.range.impl.RangeHelperBase;

public class InsertDeleteHelper
extends RangeHelperBase {
    public InsertDeleteHelper(SRange range) {
        super(range);
    }

    public void delete(SRange.DeleteShift shift) {
        if (this.isWholeRow()) {
            if (this.checkInCornerFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support deleting rows/columns operation when current range covers the corner frozen panes");
            }
            if (this.checkCrossTopFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support deleting rows when current range cross the freeze panes line");
            }
            this.shrinkChartHeight();
            this.sheet.deleteRow(this.getRow(), this.getLastRow());
        } else if (this.isWholeColumn()) {
            if (this.checkInCornerFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support deleting rows/columns operation when current range covers the corner frozen panes");
            }
            if (this.checkCrossLeftFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support deleting columns when current range cross the freeze panes line");
            }
            this.shrinkChartWidth();
            this.sheet.deleteColumn(this.getColumn(), this.getLastColumn());
        } else if (shift != SRange.DeleteShift.DEFAULT) {
            this.sheet.deleteCell(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn(), shift == SRange.DeleteShift.LEFT);
        }
    }

    public void insert(SRange.InsertShift shift, SRange.InsertCopyOrigin copyOrigin) {
        if (this.isWholeRow()) {
            if (this.checkInCornerFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support inserting rows/columns when current range covers the corner frozen panes");
            }
            if (this.checkCrossTopFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support inserting rows when current range cross the freeze panes line");
            }
            this.sheet.insertRow(this.getRow(), this.getLastRow());
            if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE) {
                if (this.getRow() - 1 >= 0) {
                    this.copyRowStyle(this.getRow() - 1, this.getRow(), this.getLastRow());
                }
            } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW && this.getLastRow() + 1 <= this.sheet.getBook().getMaxRowIndex()) {
                this.copyRowStyle(this.getLastRow() + 1, this.getRow(), this.getLastRow());
            }
            this.extendChartHeight();
        } else if (this.isWholeColumn()) {
            if (this.checkInCornerFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support inserting rows/columns when current range covers the corner frozen panes");
            }
            if (this.checkCrossLeftFreezePanel()) {
                throw new InvalidModelOpException("Doesn't support inserting columns when current range cross the freeze panes line");
            }
            this.sheet.insertColumn(this.getColumn(), this.getLastColumn());
            if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE) {
                if (this.getColumn() - 1 >= 0) {
                    this.copyColumnStyle(this.getColumn() - 1, this.getColumn(), this.getLastColumn());
                }
            } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW && this.getLastColumn() + 1 <= this.sheet.getBook().getMaxColumnIndex()) {
                this.copyColumnStyle(this.getLastColumn() + 1, this.getColumn(), this.getLastColumn());
            }
            this.extendChartWidth();
        } else if (shift != SRange.InsertShift.DEFAULT) {
            this.sheet.insertCell(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn(), shift == SRange.InsertShift.RIGHT);
            if (shift == SRange.InsertShift.RIGHT) {
                if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE) {
                    if (this.getColumn() - 1 >= 0) {
                        this.copyCellStyleFromColumn(this.getColumn() - 1);
                    }
                } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW && this.getLastColumn() + 1 <= this.sheet.getBook().getMaxColumnIndex()) {
                    this.copyCellStyleFromColumn(this.getLastColumn() + 1);
                }
            } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_LEFT_ABOVE) {
                if (this.getRow() - 1 >= 0) {
                    this.copyCellStyleFromRow(this.getRow() - 1);
                }
            } else if (copyOrigin == SRange.InsertCopyOrigin.FORMAT_RIGHT_BELOW && this.getLastRow() + 1 <= this.sheet.getBook().getMaxRowIndex()) {
                this.copyCellStyleFromRow(this.getLastRow() + 1);
            }
        }
    }

    private void copyRowStyle(int srcRowIdx, int rowIdx, int lastRowIdx) {
        SRow srcRow = this.sheet.getRow(srcRowIdx);
        if (!srcRow.isNull()) {
            for (int r = rowIdx; r <= lastRowIdx; ++r) {
                SRow row = this.sheet.getRow(r);
                SCellStyle style = ((AbstractRowAdv)srcRow).getCellStyle(true);
                if (style != null) {
                    row.setCellStyle(style);
                }
                if (!srcRow.isCustomHeight()) continue;
                row.setHeight(srcRow.getHeight());
                row.setCustomHeight(true);
            }
        }
        Iterator<SCell> cellsInRow = this.sheet.getCellIterator(srcRowIdx);
        while (cellsInRow.hasNext()) {
            SCell srcCell = cellsInRow.next();
            SCellStyle cellStyle = ((AbstractCellAdv)srcCell).getCellStyle(true);
            if (cellStyle == null) continue;
            for (int r = rowIdx; r <= lastRowIdx; ++r) {
                this.sheet.getCell(r, srcCell.getColumnIndex()).setCellStyle(cellStyle);
            }
        }
    }

    private void copyColumnStyle(int srcColumnIdx, int columnIdx, int lastColumnIdx) {
        SColumnArray srcColumnArray = this.sheet.getColumnArray(srcColumnIdx);
        if (srcColumnArray != null) {
            for (int c = columnIdx; c <= lastColumnIdx; ++c) {
                SColumn row = this.sheet.getColumn(c);
                SCellStyle style = ((AbstractColumnArrayAdv)srcColumnArray).getCellStyle(true);
                if (style != null) {
                    row.setCellStyle(style);
                }
                if (!srcColumnArray.isCustomWidth()) continue;
                row.setWidth(srcColumnArray.getWidth());
                row.setCustomWidth(true);
            }
        }
        Iterator<SRow> srcRows = this.sheet.getRowIterator();
        while (srcRows.hasNext()) {
            SCellStyle cellStyle;
            int r = srcRows.next().getIndex();
            SCell srcCell = this.sheet.getCell(r, srcColumnIdx);
            if (srcCell.isNull() || (cellStyle = ((AbstractCellAdv)srcCell).getCellStyle(true)) == null) continue;
            for (int c = columnIdx; c <= lastColumnIdx; ++c) {
                this.sheet.getCell(r, c).setCellStyle(cellStyle);
            }
        }
    }

    private void copyCellStyleFromRow(int rowIndex) {
        Iterator<SCell> cellsInRow = this.sheet.getCellIterator(rowIndex);
        while (cellsInRow.hasNext()) {
            SCell srcCell = cellsInRow.next();
            int c = srcCell.getColumnIndex();
            if (c < this.getColumn()) continue;
            if (c > this.getLastColumn()) break;
            SCellStyle cellStyle = ((AbstractCellAdv)srcCell).getCellStyle(true);
            if (cellStyle == null) continue;
            for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
                this.sheet.getCell(r, c).setCellStyle(cellStyle);
            }
        }
    }

    private void copyCellStyleFromColumn(int srcColumnIdx) {
        Iterator<SRow> srcRows = this.sheet.getRowIterator();
        while (srcRows.hasNext()) {
            SCellStyle cellStyle;
            int r = srcRows.next().getIndex();
            if (r < this.getRow()) continue;
            if (r > this.getLastRow()) break;
            SCell srcCell = this.sheet.getCell(r, srcColumnIdx);
            if (srcCell.isNull() || (cellStyle = ((AbstractCellAdv)srcCell).getCellStyle(true)) == null) continue;
            for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                this.sheet.getCell(r, c).setCellStyle(cellStyle);
            }
        }
    }

    private void shrinkChartWidth() {
        for (SChart chart : this.sheet.getCharts()) {
            int c;
            ViewAnchor anchor = chart.getAnchor();
            int col = anchor.getColumnIndex();
            ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(this.sheet);
            int lastCol = rightBottomAnchor.getColumnIndex();
            if ((col > this.getColumn() || this.getColumn() > lastCol) && (col > this.getLastColumn() || this.getLastColumn() > lastCol)) continue;
            int shrunkWidth = 0;
            int n = c = this.getColumn() > col ? this.getColumn() : col;
            while (c <= this.getLastColumn() && c <= lastCol) {
                shrunkWidth = c != lastCol ? (shrunkWidth += this.sheet.getColumn(c).getWidth()) : (shrunkWidth += rightBottomAnchor.getXOffset());
                ++c;
            }
            if (anchor.getWidth() <= shrunkWidth) continue;
            anchor.setWidth(anchor.getWidth() - shrunkWidth);
            new NotifyChangeHelper().notifySheetChartUpdate(this.sheet, chart.getId());
        }
    }

    private void shrinkChartHeight() {
        for (SChart chart : this.sheet.getCharts()) {
            int r;
            ViewAnchor anchor = chart.getAnchor();
            int row = anchor.getRowIndex();
            ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(this.sheet);
            int lastRow = rightBottomAnchor.getRowIndex();
            if ((row > this.getRow() || this.getRow() > lastRow) && (row > this.getLastRow() || this.getLastRow() > lastRow)) continue;
            int shrunkHeight = 0;
            int n = r = this.getRow() > row ? this.getRow() : row;
            while (r <= this.getLastRow() && r <= lastRow) {
                shrunkHeight = r != lastRow ? (shrunkHeight += this.sheet.getRow(r).getHeight()) : (shrunkHeight += rightBottomAnchor.getYOffset());
                ++r;
            }
            if (anchor.getHeight() <= shrunkHeight) continue;
            anchor.setHeight(anchor.getHeight() - shrunkHeight);
            new NotifyChangeHelper().notifySheetChartUpdate(this.sheet, chart.getId());
        }
    }

    private void extendChartWidth() {
        int size = 0;
        for (int r = this.getColumn(); r <= this.getLastColumn(); ++r) {
            size += this.sheet.getColumn(r).getWidth();
        }
        for (SChart chart : this.sheet.getCharts()) {
            ViewAnchor anchor = chart.getAnchor();
            int col = anchor.getColumnIndex();
            int lastCol = anchor.getRightBottomAnchor(this.sheet).getColumnIndex();
            if (col > this.getColumn() || this.getColumn() > lastCol) continue;
            anchor.setWidth(anchor.getWidth() + size);
            new NotifyChangeHelper().notifySheetChartUpdate(this.sheet, chart.getId());
        }
    }

    private void extendChartHeight() {
        int size = 0;
        for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
            size += this.sheet.getRow(r).getHeight();
        }
        for (SChart chart : this.sheet.getCharts()) {
            ViewAnchor anchor = chart.getAnchor();
            int row = anchor.getRowIndex();
            int lastRow = anchor.getRightBottomAnchor(this.sheet).getRowIndex();
            if (row > this.getRow() || this.getRow() > lastRow) continue;
            anchor.setHeight(anchor.getHeight() + size);
            new NotifyChangeHelper().notifySheetChartUpdate(this.sheet, chart.getId());
        }
    }

    private boolean checkInCornerFreezePanel() {
        SSheetViewInfo viewInfo = this.sheet.getViewInfo();
        int fzr = viewInfo.getNumOfRowFreeze();
        int fzc = viewInfo.getNumOfColumnFreeze();
        return fzr > 0 && fzc > 0 && this.getRow() < fzr && this.getColumn() < fzc;
    }

    private boolean checkCrossTopFreezePanel() {
        SSheetViewInfo viewInfo = this.sheet.getViewInfo();
        int fzr = viewInfo.getNumOfRowFreeze();
        return fzr > 0 && this.getRow() < fzr && this.getLastRow() >= fzr;
    }

    private boolean checkCrossLeftFreezePanel() {
        SSheetViewInfo viewInfo = this.sheet.getViewInfo();
        int fzc = viewInfo.getNumOfColumnFreeze();
        return fzc > 0 && this.getColumn() < fzc && this.getLastColumn() >= fzc;
    }
}

