/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.Date;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.FormulaResultCellValue;
import org.zkoss.zss.model.sys.CalendarUtil;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaEvaluationContext;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;
import org.zkoss.zss.model.sys.input.InputEngine;
import org.zkoss.zss.model.sys.input.InputParseContext;
import org.zkoss.zss.model.sys.input.InputResult;

public class DataValidationHelper {
    private final SDataValidation _validation;
    private final SSheet _sheet;

    public DataValidationHelper(SDataValidation validation) {
        this._validation = validation;
        this._sheet = validation.getSheet();
    }

    public boolean validate(String editText, String dataformat) {
        InputEngine ie = EngineFactory.getInstance().createInputEngine();
        InputResult result = ie.parseInput(editText == null ? "" : editText, dataformat, new InputParseContext(ZssContext.getCurrent().getLocale()));
        return this.validate(result.getType(), result.getValue());
    }

    public boolean validate(SCell.CellType cellType, Object value) {
        SDataValidation.ValidationType vtype = this._validation.getValidationType();
        if (vtype == SDataValidation.ValidationType.ANY) {
            return true;
        }
        if (vtype != SDataValidation.ValidationType.TEXT_LENGTH && (value == null || value instanceof String && ((String)value).length() == 0) && this._validation.isIgnoreBlank()) {
            return true;
        }
        if (cellType == SCell.CellType.FORMULA) {
            FormulaEngine engine = EngineFactory.getInstance().createFormulaEngine();
            FormulaExpression expr = engine.parse((String)value, new FormulaParseContext(this._sheet, null));
            if (expr.hasError()) {
                return false;
            }
            FormulaResultCellValue result = new FormulaResultCellValue(engine.evaluate(expr, new FormulaEvaluationContext(this._sheet, null)));
            value = result.getValue();
            cellType = result.getCellType();
        }
        CalendarUtil cal = EngineFactory.getInstance().getCalendarUtil();
        boolean success = true;
        switch (vtype) {
            case INTEGER: {
                if (DataValidationHelper.isInteger(value) && this.validateOperation((Number)value)) break;
                success = false;
                break;
            }
            case DECIMAL: {
                if (DataValidationHelper.isDecimal(value) && this.validateOperation((Number)value)) break;
                success = false;
                break;
            }
            case DATE: 
            case TIME: {
                success = value instanceof Date && this.validateOperation(cal.dateToDoubleValue((Date)value));
                break;
            }
            case LIST: {
                if (this.validateListOperation(value instanceof Date ? Double.valueOf(cal.dateToDoubleValue((Date)value)) : value)) break;
                success = false;
                break;
            }
            case TEXT_LENGTH: {
                if ((value == null || DataValidationHelper.isString(value)) && this.validateOperation(value == null ? 0 : ((String)value).length())) break;
                success = false;
                break;
            }
            case CUSTOM: {
                success = false;
            }
        }
        return success;
    }

    private static boolean isInteger(Object value) {
        if (value instanceof Number) {
            return (double)((Number)value).intValue() == ((Number)value).doubleValue();
        }
        return false;
    }

    private static boolean isDecimal(Object value) {
        return value instanceof Number;
    }

    private static boolean isString(Object value) {
        return value instanceof String;
    }

    private boolean validateOperation(Number value) {
        if (value == null) {
            return false;
        }
        Object value1 = this._validation.getValue1(0);
        if (!(value1 instanceof Number)) {
            return false;
        }
        Object value2 = this._validation.getValue2(0);
        double v1 = ((Number)value1).doubleValue();
        double v = value.doubleValue();
        switch (this._validation.getOperatorType()) {
            case BETWEEN: {
                if (!(value2 instanceof Number)) {
                    return false;
                }
                double v2 = ((Number)value2).doubleValue();
                return v >= v1 && v <= v2;
            }
            case NOT_BETWEEN: {
                if (!(value2 instanceof Number)) {
                    return false;
                }
                double v2 = ((Number)value2).doubleValue();
                return v < v1 || v > v2;
            }
            case EQUAL: {
                return v == v1;
            }
            case NOT_EQUAL: {
                return v != v1;
            }
            case GREATER_THAN: {
                return v > v1;
            }
            case LESS_THAN: {
                return v < v1;
            }
            case GREATER_OR_EQUAL: {
                return v >= v1;
            }
            case LESS_OR_EQUAL: {
                return v <= v1;
            }
        }
        return true;
    }

    private boolean validateListOperation(Object value) {
        if (value == null) {
            return false;
        }
        if (this._validation.hasReferToCellList()) {
            for (SCell cell : this._validation.getReferToCellList()) {
                Object val = cell.getValue();
                if (!value.equals(val)) continue;
                return true;
            }
        } else {
            int size = this._validation.getNumOfValue1();
            for (int i = 0; i < size; ++i) {
                Object val = this._validation.getValue1(i);
                if (!value.equals(val)) continue;
                return true;
            }
        }
        return false;
    }
}

