/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.HashSet;
import java.util.Iterator;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColumn;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.impl.RangeHelperBase;

public class ClearCellHelper
extends RangeHelperBase {
    SCellStyle _defaultStyle;

    public ClearCellHelper(SRange range) {
        super(range);
        this._defaultStyle = range.getSheet().getBook().getDefaultCellStyle();
    }

    public void clearCellStyle() {
        if (this.isWholeSheet()) {
            this.clearWholeSheetStyle();
        } else if (this.isWholeRow()) {
            this.clearWholeRowCellStyle();
        } else if (this.isWholeColumn()) {
            this.clearWholeColumnCellStyle();
        } else {
            for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
                SRow row = this.sheet.getRow(r);
                for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                    SColumn column = this.sheet.getColumn(c);
                    SCell cell = this.sheet.getCell(r, c);
                    if (row.getCellStyle(true) != null || column.getCellStyle(true) != null) {
                        cell.setCellStyle(this._defaultStyle);
                        continue;
                    }
                    if (cell.getCellStyle(true) == null) continue;
                    cell.setCellStyle(null);
                }
            }
        }
    }

    private void clearWholeSheetStyle() {
        Iterator<SColumnArray> columns = this.sheet.getColumnArrayIterator();
        while (columns.hasNext()) {
            SColumnArray column = columns.next();
            if (column.getCellStyle(true) == null) continue;
            column.setCellStyle(null);
        }
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            if (row.getCellStyle(true) != null) {
                row.setCellStyle(null);
            }
            Iterator<SCell> cells = this.sheet.getCellIterator(row.getIndex());
            while (cells.hasNext()) {
                SCell cell = cells.next();
                if (cell.getCellStyle(true) == null) continue;
                cell.setCellStyle(null);
            }
        }
    }

    private void clearWholeColumnCellStyle() {
        for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
            SColumn column = this.sheet.getColumn(c);
            if (column.isNull()) continue;
            column.setCellStyle(null);
        }
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            boolean rowHasStyle = row.getCellStyle(true) != null;
            for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                SCell cell = this.sheet.getCell(row.getIndex(), c);
                if (rowHasStyle) {
                    cell.setCellStyle(this._defaultStyle);
                    continue;
                }
                if (cell.getCellStyle(true) == null) continue;
                cell.setCellStyle(null);
            }
        }
    }

    private void clearWholeRowCellStyle() {
        HashSet<Integer> columnHasStyle = new HashSet<Integer>();
        Iterator<SColumn> columns = this.sheet.getColumnIterator();
        while (columns.hasNext()) {
            SColumn column = columns.next();
            if (column.getCellStyle(true) == null) continue;
            columnHasStyle.add(column.getIndex());
        }
        for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
            HashSet rowColumnHasStyle = new HashSet(columnHasStyle);
            SRow row = this.sheet.getRow(r);
            if (!row.isNull()) {
                row.setCellStyle(null);
            }
            Iterator<SCell> cells = this.sheet.getCellIterator(r);
            while (cells.hasNext()) {
                SCell cell = cells.next();
                if (columnHasStyle.contains(cell.getColumnIndex())) {
                    cell.setCellStyle(this._defaultStyle);
                    rowColumnHasStyle.remove(cell.getColumnIndex());
                    continue;
                }
                if (cell.getCellStyle(true) == null) continue;
                cell.setCellStyle(null);
            }
            for (Integer c : rowColumnHasStyle) {
                this.sheet.getCell(row.getIndex(), c).setCellStyle(this._defaultStyle);
            }
        }
    }

    public void clearCellContent() {
        if (this.isWholeSheet()) {
            this.clearWholeSheetContent();
        } else if (this.isWholeRow()) {
            this.clearWholeRowContent();
        } else if (this.isWholeColumn()) {
            this.clearWholeColumnContent();
        } else {
            for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
                for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                    SCell cell = this.sheet.getCell(r, c);
                    this.clearCellContent(cell);
                }
            }
        }
    }

    private void clearWholeSheetContent() {
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            Iterator<SCell> cells = this.sheet.getCellIterator(row.getIndex());
            while (cells.hasNext()) {
                SCell cell = cells.next();
                this.clearCellContent(cell);
            }
        }
    }

    private void clearWholeColumnContent() {
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                SCell cell = this.sheet.getCell(row.getIndex(), c);
                this.clearCellContent(cell);
            }
        }
    }

    private void clearWholeRowContent() {
        for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
            Iterator<SCell> cells = this.sheet.getCellIterator(r);
            while (cells.hasNext()) {
                SCell cell = cells.next();
                this.clearCellContent(cell);
            }
        }
    }

    private void clearCellContent(SCell cell) {
        if (!cell.isNull()) {
            cell.setHyperlink(null);
            cell.clearValue();
        }
    }
}

