/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.impl.RangeHelperBase;
import org.zkoss.zss.range.impl.StyleUtil;

public class BorderHelper
extends RangeHelperBase {
    static final short TOP = 1;
    static final short BOTTOM = 2;
    static final short LEFT = 4;
    static final short RIGHT = 8;
    private final int _maxRowIndex;
    private final int _maxColumnIndex;
    private final SBook _book;
    static final String BLACK = "#000000";

    public BorderHelper(SRange range) {
        super(range);
        this._book = range.getSheet().getBook();
        this._maxRowIndex = this._book.getMaxRowIndex();
        this._maxColumnIndex = this._book.getMaxColumnIndex();
    }

    public void applyBorder(SRange.ApplyBorderType borderType, SCellStyle.BorderType lineStyle, String borderColor) {
        if (borderType == SRange.ApplyBorderType.DIAGONAL || borderType == SRange.ApplyBorderType.DIAGONAL_DOWN || borderType == SRange.ApplyBorderType.DIAGONAL_UP) {
            // empty if block
        }
        SSheet sheet = this.range.getSheet();
        int row = this.getRow();
        int column = this.getColumn();
        int lastRow = this.getLastRow();
        int lastColumn = this.getLastColumn();
        for (int r = row; r <= lastRow; ++r) {
            for (int c = column; c <= lastColumn; ++c) {
                short location = 0;
                if (r == row) {
                    location = (short)(location | 1);
                }
                if (r == lastRow) {
                    location = (short)(location | 2);
                }
                if (c == column) {
                    location = (short)(location | 4);
                }
                if (c == lastColumn) {
                    location = (short)(location | 8);
                }
                this.handleCellBorder(sheet, r, c, borderType, lineStyle, borderColor, location);
            }
        }
    }

    private void handleCellBorder(SSheet sheet, int r, int c, SRange.ApplyBorderType borderType, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        switch (borderType) {
            case FULL: {
                this.handleFull(sheet, r, c, lineStyle, borderColor, location);
                break;
            }
            case EDGE_BOTTOM: {
                this.handleEdgeBottom(sheet, r, c, lineStyle, borderColor, location);
                break;
            }
            case EDGE_RIGHT: {
                this.handleEdgeRight(sheet, r, c, lineStyle, borderColor, location);
                break;
            }
            case EDGE_TOP: {
                this.handleEdgeTop(sheet, r, c, lineStyle, borderColor, location);
                break;
            }
            case EDGE_LEFT: {
                this.handleEdgeLeft(sheet, r, c, lineStyle, borderColor, location);
                break;
            }
            case OUTLINE: {
                this.handleOutline(sheet, r, c, lineStyle, borderColor, location);
                break;
            }
            case INSIDE: {
                this.handleInside(sheet, r, c, lineStyle, borderColor, location);
                break;
            }
            case INSIDE_HORIZONTAL: {
                this.handleInsideHorizontal(sheet, r, c, lineStyle, borderColor, location);
                break;
            }
            case INSIDE_VERTICAL: {
                this.handleInsideVertical(sheet, r, c, lineStyle, borderColor, location);
            }
        }
    }

    private void handleInside(SSheet sheet, int r, int c, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        short at = 15;
        if ((location & 1) != 0) {
            this.resetBorderBottom(sheet, r - 1, c, lineStyle, borderColor);
            at = (short)(at - 4);
        }
        if ((location & 4) != 0) {
            this.resetBorderRight(sheet, r, c - 1, lineStyle, borderColor);
            at = (short)(at - 8);
        }
        if ((location & 2) != 0) {
            this.resetBorderTop(sheet, r + 1, c, lineStyle, borderColor);
            at = (short)(at - 1);
        }
        if ((location & 8) != 0) {
            this.resetBorderLeft(sheet, r, c + 1, lineStyle, borderColor);
            at = (short)(at - 2);
        }
        StyleUtil.setBorder(this._book, sheet.getCell(r, c), borderColor, lineStyle, at);
    }

    private void handleInsideVertical(SSheet sheet, int r, int c, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        short at = 10;
        if ((location & 4) != 0) {
            at = (short)(at - 8);
        }
        if ((location & 8) != 0) {
            at = (short)(at - 2);
        }
        StyleUtil.setBorder(this._book, sheet.getCell(r, c), borderColor, lineStyle, at);
    }

    private void handleInsideHorizontal(SSheet sheet, int r, int c, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        short at = 5;
        if ((location & 2) != 0) {
            at = (short)(at - 1);
        }
        if ((location & 1) != 0) {
            at = (short)(at - 4);
        }
        StyleUtil.setBorder(this._book, sheet.getCell(r, c), borderColor, lineStyle, at);
    }

    private void handleOutline(SSheet sheet, int r, int c, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        short at = 0;
        if ((location & 1) != 0) {
            this.resetBorderBottom(sheet, r - 1, c, lineStyle, borderColor);
            at = (short)(at | 4);
        }
        if ((location & 4) != 0) {
            this.resetBorderRight(sheet, r, c - 1, lineStyle, borderColor);
            at = (short)(at | 8);
        }
        if ((location & 2) != 0) {
            this.resetBorderTop(sheet, r + 1, c, lineStyle, borderColor);
            at = (short)(at | 1);
        }
        if ((location & 8) != 0) {
            this.resetBorderLeft(sheet, r, c + 1, lineStyle, borderColor);
            at = (short)(at | 2);
        }
        StyleUtil.setBorder(this._book, sheet.getCell(r, c), borderColor, lineStyle, at);
    }

    private void handleEdgeLeft(SSheet sheet, int r, int c, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        if ((location & 4) != 0) {
            this.resetBorderRight(sheet, r, c - 1, lineStyle, borderColor);
            StyleUtil.setBorder(this._book, sheet.getCell(r, c), borderColor, lineStyle, (short)8);
        }
    }

    private void handleEdgeTop(SSheet sheet, int r, int c, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        if ((location & 1) != 0) {
            this.resetBorderBottom(sheet, r - 1, c, lineStyle, borderColor);
            StyleUtil.setBorder(this._book, sheet.getCell(r, c), borderColor, lineStyle, (short)4);
        }
    }

    private void handleEdgeRight(SSheet sheet, int r, int c, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        if ((location & 8) != 0) {
            this.resetBorderLeft(sheet, r, c + 1, lineStyle, borderColor);
            StyleUtil.setBorder(this._book, sheet.getCell(r, c), borderColor, lineStyle, (short)2);
        }
    }

    private void handleEdgeBottom(SSheet sheet, int r, int c, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        if ((location & 2) != 0) {
            this.resetBorderTop(sheet, r + 1, c, lineStyle, borderColor);
            StyleUtil.setBorder(this._book, sheet.getCell(r, c), borderColor, lineStyle, (short)1);
        }
    }

    private void handleFull(SSheet sheet, int r, int c, SCellStyle.BorderType lineStyle, String borderColor, short location) {
        short at = 0;
        if ((location & 1) != 0) {
            this.resetBorderBottom(sheet, r - 1, c, lineStyle, borderColor);
        }
        if ((location & 4) != 0) {
            this.resetBorderRight(sheet, r, c - 1, lineStyle, borderColor);
        }
        if ((location & 2) != 0) {
            this.resetBorderTop(sheet, r + 1, c, lineStyle, borderColor);
        }
        if ((location & 8) != 0) {
            this.resetBorderLeft(sheet, r, c + 1, lineStyle, borderColor);
        }
        at = (short)(at | 8);
        at = (short)(at | 4);
        at = (short)(at | 2);
        at = (short)(at | 1);
        StyleUtil.setBorder(this._book, sheet.getCell(r, c), borderColor, lineStyle, at);
    }

    private boolean isOutOfBoundCell(SSheet sheet, int r, int c) {
        return r < 0 || c < 0 || r > this._maxRowIndex || c > this._maxColumnIndex;
    }

    private boolean resetBorderTop(SSheet sheet, int r, int c, SCellStyle.BorderType borderType, String borderColor) {
        if (this.isOutOfBoundCell(sheet, r, c)) {
            return false;
        }
        SCell cell = sheet.getCell(r, c);
        if (cell.isNull()) {
            return false;
        }
        SCellStyle style = cell.getCellStyle();
        SCellStyle.BorderType bType = style.getBorderTop();
        String bColor = style.getBorderTopColor().getHtmlColor();
        if (SCellStyle.BorderType.NONE.equals((Object)bType)) {
            return false;
        }
        if (borderType.equals((Object)bType) && borderColor.equals(bColor)) {
            return false;
        }
        StyleUtil.setBorder(this._book, sheet.getCell(r, c), BLACK, SCellStyle.BorderType.NONE, (short)4);
        return true;
    }

    private boolean resetBorderBottom(SSheet sheet, int r, int c, SCellStyle.BorderType borderType, String borderColor) {
        if (this.isOutOfBoundCell(sheet, r, c)) {
            return false;
        }
        SCell cell = sheet.getCell(r, c);
        if (cell.isNull()) {
            return false;
        }
        SCellStyle style = cell.getCellStyle();
        SCellStyle.BorderType bType = style.getBorderBottom();
        String bColor = style.getBorderBottomColor().getHtmlColor();
        if (SCellStyle.BorderType.NONE.equals((Object)bType)) {
            return false;
        }
        if (borderType.equals((Object)bType) && borderColor.equals(bColor)) {
            return false;
        }
        StyleUtil.setBorder(this._book, sheet.getCell(r, c), BLACK, SCellStyle.BorderType.NONE, (short)1);
        return true;
    }

    private boolean resetBorderLeft(SSheet sheet, int r, int c, SCellStyle.BorderType borderType, String borderColor) {
        if (this.isOutOfBoundCell(sheet, r, c)) {
            return false;
        }
        SCell cell = sheet.getCell(r, c);
        if (cell.isNull()) {
            return false;
        }
        SCellStyle style = cell.getCellStyle();
        SCellStyle.BorderType bType = style.getBorderLeft();
        String bColor = style.getBorderLeftColor().getHtmlColor();
        if (SCellStyle.BorderType.NONE.equals((Object)bType)) {
            return false;
        }
        if (borderType.equals((Object)bType) && borderColor.equals(bColor)) {
            return false;
        }
        StyleUtil.setBorder(this._book, sheet.getCell(r, c), BLACK, SCellStyle.BorderType.NONE, (short)8);
        return true;
    }

    private boolean resetBorderRight(SSheet sheet, int r, int c, SCellStyle.BorderType borderType, String borderColor) {
        if (this.isOutOfBoundCell(sheet, r, c)) {
            return false;
        }
        SCell cell = sheet.getCell(r, c);
        if (cell.isNull()) {
            return false;
        }
        SCellStyle style = cell.getCellStyle();
        SCellStyle.BorderType bType = style.getBorderRight();
        String bColor = style.getBorderRightColor().getHtmlColor();
        if (SCellStyle.BorderType.NONE.equals((Object)bType)) {
            return false;
        }
        if (borderType.equals((Object)bType) && borderColor.equals(bColor)) {
            return false;
        }
        StyleUtil.setBorder(this._book, sheet.getCell(r, c), BLACK, SCellStyle.BorderType.NONE, (short)2);
        return true;
    }
}

