/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.SRanges;
import org.zkoss.zss.range.impl.DataRegionHelper;
import org.zkoss.zss.range.impl.RangeHelperBase;

class AutoFilterHelper
extends RangeHelperBase {
    public AutoFilterHelper(SRange range) {
        super(range);
    }

    public CellRegion findAutoFilterRegion() {
        return new DataRegionHelper(this.range).findAutoFilterDataRegion();
    }

    public SAutoFilter enableAutoFilter(boolean enable) {
        SAutoFilter filter = this.sheet.getAutoFilter();
        boolean update = false;
        if (filter != null && !enable) {
            CellRegion region = filter.getRegion();
            SRange toUnhide = SRanges.range(this.sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn()).getRows();
            toUnhide.setHidden(false);
            this.sheet.deleteAutoFilter();
            filter = null;
            update = true;
        } else if (filter == null && enable) {
            CellRegion region = this.findAutoFilterRegion();
            if (region != null) {
                filter = this.sheet.createAutoFilter(region);
                update = true;
            } else {
                throw new InvalidModelOpException("can't find any data in range");
            }
        }
        return filter;
    }

    public SAutoFilter enableAutoFilter(int field, SAutoFilter.FilterOp filterOp, Object criteria1, Object criteria2, Boolean showButton) {
        SAutoFilter filter = this.sheet.getAutoFilter();
        if (filter == null) {
            CellRegion region = new DataRegionHelper(this.range).findAutoFilterDataRegion();
            if (region != null) {
                filter = this.sheet.createAutoFilter(region);
            } else {
                throw new InvalidModelOpException("can't find any data in range");
            }
        }
        SAutoFilter.NFilterColumn fc = filter.getFilterColumn(field - 1, true);
        fc.setProperties(filterOp, criteria1, criteria2, showButton);
        CellRegion affectedArea = filter.getRegion();
        int row1 = affectedArea.getRow();
        int col1 = affectedArea.getColumn();
        int col = col1 + field - 1;
        int row = row1 + 1;
        int row2 = affectedArea.getLastRow();
        Set cr1 = fc.getCriteria1();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj;
            String val;
            SCell cell = this.sheet.getCell(r, col);
            String string = val = AutoFilterHelper.isBlank(cell) ? "=" : this.getFormattedText(cell);
            if (cr1 != null && !cr1.isEmpty() && !cr1.contains(val)) {
                rowobj = this.sheet.getRow(r);
                if (rowobj.isHidden()) continue;
                SRanges.range(this.sheet, r, 0).getRows().setHidden(true);
                continue;
            }
            rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden() || !this.canUnhide(filter, fc, r, col1)) continue;
            SRange rng = SRanges.range(this.sheet, r, 0, r, 0);
            rng.getRows().setHidden(false);
        }
        return filter;
    }

    private boolean canUnhide(SAutoFilter af, SAutoFilter.NFilterColumn fc, int row, int col) {
        Collection<SAutoFilter.NFilterColumn> fltcs = af.getFilterColumns();
        for (SAutoFilter.NFilterColumn fltc : fltcs) {
            if (fc.equals(fltc) || !this.shallHide(fltc, row, col)) continue;
            return false;
        }
        return true;
    }

    private boolean shallHide(SAutoFilter.NFilterColumn fc, int row, int col) {
        SCell cell = this.sheet.getCell(row, col + fc.getIndex());
        boolean blank = AutoFilterHelper.isBlank(cell);
        String val = blank ? "=" : this.getFormattedText(cell);
        Set critera1 = fc.getCriteria1();
        return critera1 != null && !critera1.isEmpty() && !critera1.contains(val);
    }

    public void resetAutoFilter() {
        SAutoFilter af = this.sheet.getAutoFilter();
        if (af == null) {
            return;
        }
        CellRegion afrng = af.getRegion();
        Collection<SAutoFilter.NFilterColumn> fcs = af.getFilterColumns();
        if (fcs == null) {
            return;
        }
        for (SAutoFilter.NFilterColumn fc : fcs) {
            fc.setProperties(SAutoFilter.FilterOp.VALUES, null, null, null);
        }
        int row1 = afrng.getRow();
        int row = row1 + 1;
        int row2 = afrng.getLastRow();
        int col1 = afrng.getColumn();
        int col2 = afrng.getLastColumn();
        for (int r = row; r <= row2; ++r) {
            SRow rowobj = this.sheet.getRow(r);
            if (!rowobj.isHidden()) continue;
            SRange rng = SRanges.range(this.sheet, r, 0, r, 0);
            rng.getRows().setHidden(false);
        }
    }

    public void applyAutoFilter() {
        SAutoFilter oldFilter = this.sheet.getAutoFilter();
        if (oldFilter == null) {
            return;
        }
        CellRegion region = oldFilter.getRegion();
        int firstRow = region.getRow();
        int firstColumn = region.getColumn();
        ArrayList<Object[]> originalFilteringColumns = new ArrayList<Object[]>();
        if (oldFilter.getFilterColumns() != null) {
            for (SAutoFilter.NFilterColumn filterColumn : oldFilter.getFilterColumns()) {
                Object[] filterColumnData = new Object[]{filterColumn.getIndex() + 1, filterColumn.getCriteria1().toArray(new String[0]), filterColumn.getOperator(), filterColumn.getCriteria2(), filterColumn.isShowButton()};
                originalFilteringColumns.add(filterColumnData);
            }
        }
        this.enableAutoFilter(false);
        CellRegion filteringRange = DataRegionHelper.findCurrentRegion(this.sheet, firstRow, firstColumn);
        if (filteringRange == null) {
            return;
        }
        this.sheet.createAutoFilter(filteringRange);
        for (int nCol = 0; nCol < originalFilteringColumns.size(); ++nCol) {
            Object[] oldFilterColumn = (Object[])originalFilteringColumns.get(nCol);
            int field = (Integer)oldFilterColumn[0];
            Object c1 = oldFilterColumn[1];
            SAutoFilter.FilterOp op = (SAutoFilter.FilterOp)((Object)oldFilterColumn[2]);
            Object c2 = oldFilterColumn[3];
            boolean showBtn = (Boolean)oldFilterColumn[4];
            this.enableAutoFilter(field, op, c1, c2, showBtn);
        }
    }
}

