/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.range;

import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SName;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.range.SRange;
import org.zkoss.zss.range.impl.RangeImpl;

public class SRanges {
    public static SRange range(SSheet sheet) {
        return new RangeImpl(sheet);
    }

    public static SRange range(SSheet sheet, String areaReference) {
        SheetRegion region = new SheetRegion(sheet, areaReference);
        return new RangeImpl(sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
    }

    public static SRange range(SSheet sheet, CellRegion region) {
        return new RangeImpl(sheet, region);
    }

    public static SRange rangeByName(SSheet sheet, String name) {
        SBook book = sheet.getBook();
        SName n = book.getNameByName(name);
        if (n == null) {
            throw new InvalidModelOpException("can't find name " + name);
        }
        sheet = book.getSheetByName(n.getRefersToSheetName());
        CellRegion region = n.getRefersToCellRegion();
        if (sheet == null || region == null) {
            throw new InvalidModelOpException("bad name " + name + " : " + n.getRefersToFormula());
        }
        return new RangeImpl(sheet, region.row, region.column, region.lastRow, region.lastColumn);
    }

    public static SRange range(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        return new RangeImpl(sheet, tRow, lCol, bRow, rCol);
    }

    public static SRange range(SSheet sheet, int row, int col) {
        return new RangeImpl(sheet, row, col);
    }
}

