/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.zss.model.SFont;

public class FontMatcher {
    Map<Property, Object> _criteria = new LinkedHashMap<Property, Object>();

    public FontMatcher() {
    }

    public FontMatcher(SFont criteria) {
        this.setColor(criteria.getColor().getHtmlColor());
        this.setName(criteria.getName());
        this.setBoldweight(criteria.getBoldweight());
        this.setHeightPoints(criteria.getHeightPoints());
        this.setItalic(criteria.isItalic());
        this.setStrikeout(criteria.isStrikeout());
        this.setTypeOffset(criteria.getTypeOffset());
        this.setUnderline(criteria.getUnderline());
    }

    public void setColor(String color) {
        this._criteria.put(Property.Color, color);
    }

    public void setName(String name) {
        this._criteria.put(Property.Name, name);
    }

    public void setBoldweight(SFont.Boldweight boldweight) {
        this._criteria.put(Property.Boldweight, (Object)boldweight);
    }

    public void setHeightPoints(int height) {
        this._criteria.put(Property.HeightPoints, height);
    }

    public void setItalic(boolean italic) {
        this._criteria.put(Property.Italic, italic);
    }

    public void setStrikeout(boolean strikeout) {
        this._criteria.put(Property.Strikeout, strikeout);
    }

    public void setTypeOffset(SFont.TypeOffset typeOffset) {
        this._criteria.put(Property.TypeOffset, (Object)typeOffset);
    }

    public void setUnderline(SFont.Underline underline) {
        this._criteria.put(Property.Underline, (Object)underline);
    }

    public void removeColor() {
        this._criteria.remove((Object)Property.Color);
    }

    public void removeName() {
        this._criteria.remove((Object)Property.Name);
    }

    public void removeBoldweight() {
        this._criteria.remove((Object)Property.Boldweight);
    }

    public void removeHeightPoints() {
        this._criteria.remove((Object)Property.HeightPoints);
    }

    public void removeItalic() {
        this._criteria.remove((Object)Property.Italic);
    }

    public void removeStrikeout() {
        this._criteria.remove((Object)Property.Strikeout);
    }

    public void removeTypeOffset() {
        this._criteria.remove((Object)Property.TypeOffset);
    }

    public void removeUnderline() {
        this._criteria.remove((Object)Property.Underline);
    }

    public boolean match(SFont style) {
        for (Map.Entry<Property, Object> e : this._criteria.entrySet()) {
            switch (e.getKey()) {
                case Color: {
                    if (this.htmlColorEuqlas(e.getValue(), style.getColor().getHtmlColor())) break;
                    return false;
                }
                case Name: {
                    if (this.equals(e.getValue(), style.getName())) break;
                    return false;
                }
                case Boldweight: {
                    if (this.equals(e.getValue(), (Object)style.getBoldweight())) break;
                    return false;
                }
                case HeightPoints: {
                    if (this.equals(e.getValue(), style.getHeightPoints())) break;
                    return false;
                }
                case Italic: {
                    if (this.equals(e.getValue(), style.isItalic())) break;
                    return false;
                }
                case Strikeout: {
                    if (this.equals(e.getValue(), style.isStrikeout())) break;
                    return false;
                }
                case TypeOffset: {
                    if (this.equals(e.getValue(), (Object)style.getTypeOffset())) break;
                    return false;
                }
                case Underline: {
                    if (this.equals(e.getValue(), (Object)style.getUnderline())) break;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean htmlColorEuqlas(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)o1).equalsIgnoreCase((String)o2);
        }
        return false;
    }

    public boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 != null ? o1.equals(o2) : false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Property {
        Name,
        Color,
        Boldweight,
        HeightPoints,
        Italic,
        Strikeout,
        TypeOffset,
        Underline;

    }
}

