/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.sys.formula;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.EvaluationName;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.FormulaParser;
import org.zkoss.poi.ss.formula.FormulaParsingWorkbook;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.ptg.NamePtg;
import org.zkoss.poi.ss.formula.ptg.NameXPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.TableNamePtg;
import org.zkoss.util.logging.Log;
import org.zkoss.zss.model.SBook;

public class ParsingBook
implements FormulaParsingWorkbook,
FormulaRenderingWorkbook {
    private static final Log logger = Log.lookup((String)ParsingBook.class.getName());
    private SBook book;
    private SheetIndexes _indexes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsingBook(SBook book) {
        this.book = book;
        SBook sBook = book;
        synchronized (sBook) {
            this._indexes = (SheetIndexes)book.getAttribute("$ZSS_SHEET_INDEXES$");
            if (this._indexes == null) {
                this._indexes = new SheetIndexes();
                book.setAttribute("$ZSS_SHEET_INDEXES$", this._indexes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameName(int sheetIndex, String oldName, String newName) {
        String sidx = String.valueOf(sheetIndex);
        String oldkey = this.toKey(sidx, oldName);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.name2index.remove(oldkey);
            if (index != null) {
                String key = this.toKey(sidx, newName);
                this._indexes.name2index.put(key, index);
                this._indexes.index2name.set(index, new Object[]{sheetIndex, newName});
            }
        }
    }

    public EvaluationName getName(String name, int sheetIndex) {
        return this.getOrCreateName(name, sheetIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameXPtg getNameXPtg(String name) {
        String key = this.toKey("", name);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.name2index.get(key);
            if (index == null) {
                index = this._indexes.index2name.size();
                this._indexes.index2name.add(new Object[]{-1, name});
                this._indexes.name2index.put(key, index);
            }
            return new NameXPtg(0, index.intValue());
        }
    }

    public int getExternalSheetIndex(String sheetName) {
        return this.getExternalSheetIndex(null, sheetName);
    }

    private String[] splitSheetName(String sheetName) {
        String[] stringArray;
        String lastName;
        int p = sheetName.indexOf(58);
        String name = p < 0 ? sheetName : sheetName.substring(0, p);
        String string = lastName = p < 0 ? sheetName : sheetName.substring(p + 1);
        if (name.equalsIgnoreCase(lastName)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = name;
            stringArray = stringArray3;
            stringArray3[1] = lastName;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExternalSheetIndex(String workbookName, String sheetName) {
        String name;
        String lastName;
        String[] names = this.splitSheetName(sheetName);
        if (names.length == 1) {
            name = lastName = names[0];
            sheetName = lastName;
        } else {
            name = names[0];
            lastName = names[1];
        }
        String key = this.toKey(workbookName, sheetName);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.sheetName2index.get(key);
            if (index == null) {
                index = this._indexes.index2sheet.size();
                this._indexes.index2sheet.add(new EvaluationWorkbook.ExternalSheet(workbookName, name, lastName));
                this._indexes.sheetName2index.put(key, index);
            }
            return index;
        }
    }

    public int findExternalSheetIndex(String sheetName) {
        return this.findExternalSheetIndex(null, sheetName);
    }

    private String normalizeSheetName(String sheetName) {
        String[] names = this.splitSheetName(sheetName);
        return names.length == 1 ? names[0] : sheetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findExternalSheetIndex(String workbookName, String sheetName) {
        sheetName = this.normalizeSheetName(sheetName);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.sheetName2index.get(this.toKey(workbookName, sheetName));
            return index != null ? index : -1;
        }
    }

    private String toKey(String ... strings) {
        return Arrays.toString(strings);
    }

    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL2007;
    }

    public String getBookNameFromExternalLinkIndex(String externalLinkIndex) {
        try {
            int index = Integer.parseInt(externalLinkIndex) - 1;
            List names = (List)this.book.getAttribute("$ZSS_EXTERNAL_BOOK_NAMES$");
            if (names != null) {
                return names.get(index).toString();
            }
        }
        catch (NumberFormatException e) {
        }
        catch (IndexOutOfBoundsException e) {
            logger.warning(e.getMessage(), (Throwable)e);
        }
        return externalLinkIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationName getOrCreateName(String name, int sheetIndex) {
        String key = this.toKey(String.valueOf(sheetIndex), name);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.name2index.get(key);
            if (index == null) {
                index = this._indexes.index2name.size();
                this._indexes.index2name.add(new Object[]{sheetIndex, name});
                this._indexes.name2index.put(key, index);
            }
            SimpleName n = new SimpleName(name, index, sheetIndex);
            return n;
        }
    }

    public String getNameText(NamePtg namePtg) {
        return (String)this.getNameInfo(namePtg)[1];
    }

    public String getFullNameText(NamePtg namePtg) {
        Object[] info = this.getNameInfo(namePtg);
        String nameName = (String)info[1];
        int sheetIndex = (Integer)info[0];
        return sheetIndex < 0 ? nameName : this.book.getSheet(sheetIndex).getSheetName() + '!' + nameName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getNameInfo(NamePtg namePtg) {
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            return (Object[])this._indexes.index2name.get(namePtg.getIndex());
        }
    }

    public String resolveNameXText(NameXPtg nameXPtg) {
        return (String)this.resolveNameXInfo(nameXPtg)[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] resolveNameXInfo(NameXPtg nameXPtg) {
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            return (Object[])this._indexes.index2name.get(nameXPtg.getNameIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationWorkbook.ExternalSheet getAnyExternalSheet(int externSheetIndex) {
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            return (EvaluationWorkbook.ExternalSheet)this._indexes.index2sheet.get(externSheetIndex);
        }
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(int externSheetIndex) {
        EvaluationWorkbook.ExternalSheet externalSheet = this.getAnyExternalSheet(externSheetIndex);
        return externalSheet.getWorkbookName() != null ? externalSheet : null;
    }

    public String getSheetNameByExternSheet(int externSheetIndex) {
        String lastName;
        EvaluationWorkbook.ExternalSheet sheet = this.getAnyExternalSheet(externSheetIndex);
        String name = sheet.getSheetName();
        return name.equals(lastName = sheet.getLastSheetName()) ? name : name + ":" + lastName;
    }

    public String getExternalLinkIndexFromBookName(String bookname) {
        return bookname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSheet(String bookName, String oldName, String newName) {
        if (this.book.getBookName().equals(bookName)) {
            bookName = null;
        }
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Map sheetName2index = this._indexes.sheetName2index;
            List index2sheet = this._indexes.index2sheet;
            ArrayList<EvaluationWorkbook.ExternalSheet> temp = new ArrayList<EvaluationWorkbook.ExternalSheet>(index2sheet.size());
            for (EvaluationWorkbook.ExternalSheet extSheet : index2sheet) {
                if (bookName == null && extSheet.getWorkbookName() == null || bookName != null && bookName.equals(extSheet.getWorkbookName())) {
                    String sheet1 = oldName.equals(extSheet.getSheetName()) ? newName : extSheet.getSheetName();
                    String sheet2 = oldName.equals(extSheet.getLastSheetName()) ? newName : extSheet.getLastSheetName();
                    temp.add(new EvaluationWorkbook.ExternalSheet(extSheet.getWorkbookName(), sheet1, sheet2));
                    continue;
                }
                temp.add(extSheet);
            }
            this._indexes.index2sheet = temp;
            sheetName2index.clear();
            int len = temp.size();
            for (int i = 0; i < len; ++i) {
                EvaluationWorkbook.ExternalSheet esheet = (EvaluationWorkbook.ExternalSheet)temp.get(i);
                String book = esheet.getWorkbookName();
                String sheet1 = esheet.getSheetName();
                String sheet2 = esheet.getLastSheetName();
                String key = this.toKey(book, !sheet1.equalsIgnoreCase(sheet2) ? sheet1 + ":" + sheet2 : sheet1);
                sheetName2index.put(key, i);
            }
        }
    }

    public boolean isAllowedDeferredNamePtg() {
        return true;
    }

    public EvaluationName getName(String name, String sheetName) {
        int sheetIndex = this.book.getSheetIndex(sheetName);
        return this.getName(name, sheetIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationName getTableName(String tableName, String columnName, int sheetIndex, int rowIdx, int colIdx) {
        String tableName0 = tableName == null ? "" : tableName;
        String key = this.toKey(String.valueOf(-1), tableName0);
        SheetIndexes sheetIndexes = this._indexes;
        synchronized (sheetIndexes) {
            Integer index = (Integer)this._indexes.name2index.get(key);
            if (index == null) {
                index = this._indexes.index2name.size();
                this._indexes.index2name.add(new Object[]{-1, tableName0});
                this._indexes.name2index.put(key, index);
            }
            TableName n = new TableName(tableName0, index, columnName, tableName == null);
            return n;
        }
    }

    private static class SheetIndexes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Object[]> index2name = new ArrayList<Object[]>();
        private Map<String, Integer> name2index = new HashMap<String, Integer>();
        private List<EvaluationWorkbook.ExternalSheet> index2sheet = new ArrayList<EvaluationWorkbook.ExternalSheet>();
        private Map<String, Integer> sheetName2index = new HashMap<String, Integer>();

        private SheetIndexes() {
        }
    }

    private class TableName
    implements EvaluationName {
        private final String tableName;
        private final String columnName;
        private final int nameIndex;
        private final boolean inTable;

        public TableName(String tableName, int nameIndex, String columnName, boolean inTable) {
            this.tableName = tableName;
            this.nameIndex = nameIndex;
            this.columnName = columnName;
            this.inTable = inTable;
        }

        public Ptg[] getNameDefinition() {
            return FormulaParser.parse((String)this.tableName, (FormulaParsingWorkbook)ParsingBook.this, (int)4, (int)-1);
        }

        public String getNameText() {
            return this.tableName;
        }

        public boolean hasFormula() {
            return false;
        }

        public boolean isFunctionName() {
            return true;
        }

        public boolean isRange() {
            return true;
        }

        public TableNamePtg createPtg() {
            return new TableNamePtg(this.nameIndex, this.tableName, this.columnName, this.inTable);
        }
    }

    private class SimpleName
    implements EvaluationName {
        private final String name;
        private final int nameIndex;
        private int sheetIndex;

        public SimpleName(String name, int nameIndex, int sheetIndex) {
            this.name = name;
            this.nameIndex = nameIndex;
            this.sheetIndex = sheetIndex;
        }

        public Ptg[] getNameDefinition() {
            return FormulaParser.parse((String)this.name, (FormulaParsingWorkbook)ParsingBook.this, (int)4, (int)this.sheetIndex);
        }

        public String getNameText() {
            return this.name;
        }

        public boolean hasFormula() {
            return false;
        }

        public boolean isFunctionName() {
            return false;
        }

        public boolean isRange() {
            return false;
        }

        public NamePtg createPtg() {
            return new NamePtg(this.nameIndex);
        }
    }
}

