/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.sys.formula;

import org.zkoss.poi.ss.formula.EvaluationCell;
import org.zkoss.poi.ss.formula.EvaluationSheet;
import org.zkoss.poi.ss.usermodel.FormulaError;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.CellImpl;
import org.zkoss.zss.model.sys.formula.FormulaExpression;

public class EvalSheet
implements EvaluationSheet {
    private SSheet _sheet;

    public EvalSheet(SSheet sheet) {
        this._sheet = sheet;
    }

    public SSheet getNSheet() {
        return this._sheet;
    }

    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        SCell cell = this._sheet.getCell(rowIndex, columnIndex);
        return cell != null ? new EvalCell(cell) : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._sheet == null ? 0 : this._sheet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvalSheet other = (EvalSheet)obj;
        return this._sheet == other._sheet;
    }

    private static class Key {
        public int sheet;
        public int row;
        public int column;

        public Key(int sheet, int row, int column) {
            this.sheet = sheet;
            this.row = row;
            this.column = column;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.column;
            result = 31 * result + this.row;
            result = 31 * result + this.sheet;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.column != other.column) {
                return false;
            }
            if (this.row != other.row) {
                return false;
            }
            return this.sheet == other.sheet;
        }
    }

    class EvalCell
    implements EvaluationCell {
        private SCell cell;
        private Key key;

        public EvalCell(SCell cell) {
            this.cell = cell;
            SSheet sheet = cell.getSheet();
            SBook book = sheet.getBook();
            int sheetIndex = book.getSheetIndex(sheet);
            this.key = new Key(sheetIndex, cell.getRowIndex(), cell.getColumnIndex());
        }

        public Object getIdentityKey() {
            return this.key;
        }

        public EvaluationSheet getSheet() {
            return EvalSheet.this;
        }

        public int getRowIndex() {
            return this.cell.getRowIndex();
        }

        public int getColumnIndex() {
            return this.cell.getColumnIndex();
        }

        public int getCellType() {
            switch (this.cell.getType()) {
                case BLANK: {
                    return 3;
                }
                case BOOLEAN: {
                    return 4;
                }
                case ERROR: {
                    return 5;
                }
                case FORMULA: {
                    return 2;
                }
                case NUMBER: {
                    return 0;
                }
                case STRING: {
                    return 1;
                }
            }
            return -1;
        }

        public double getNumericCellValue() {
            return this.cell.getNumberValue();
        }

        public String getStringCellValue() {
            if (this.cell.getType() == SCell.CellType.FORMULA) {
                return this.cell.getFormulaValue();
            }
            if (this.cell.getType() == SCell.CellType.STRING) {
                return this.cell.getStringValue();
            }
            return null;
        }

        public boolean getBooleanCellValue() {
            return this.cell.getBooleanValue();
        }

        public int getErrorCellValue() {
            ErrorValue errorValue = this.cell.getErrorValue();
            switch (errorValue.getCode()) {
                case 127: {
                    return FormulaError.NA.getCode();
                }
            }
            return errorValue.getCode();
        }

        public int getCachedFormulaResultType() {
            return this.getCellType();
        }

        public String toString() {
            return this.getRowIndex() + ":" + this.getColumnIndex() + " " + this.getStringCellValue();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EvaluationCell)) {
                return false;
            }
            return this.key.equals(((EvaluationCell)obj).getIdentityKey());
        }

        public FormulaExpression getFormulaExpression() {
            return this.cell.getType() == SCell.CellType.FORMULA ? (FormulaExpression)((CellImpl)this.cell).getValue(false) : null;
        }
    }
}

