/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.sys;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.zkoss.util.logging.Log;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.impl.sys.DependencyTableAdv;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.Ref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTableImpl
extends DependencyTableAdv {
    private static final long serialVersionUID = 1L;
    private static final Log _logger = Log.lookup((String)DependencyTableImpl.class.getName());
    private static final EnumSet<Ref.RefType> _regionTypes = EnumSet.of(Ref.RefType.BOOK, Ref.RefType.SHEET, Ref.RefType.AREA, Ref.RefType.CELL);
    private Map<Ref, Set<Ref>> _map = new LinkedHashMap<Ref, Set<Ref>>();
    private Map<Ref, Set<Ref>> _evaledMap = new LinkedHashMap<Ref, Set<Ref>>();
    private SBookSeries _books;

    @Override
    public void setBookSeries(SBookSeries series) {
        this._books = series;
    }

    @Override
    public void add(Ref dependant, Ref precedent) {
        Set<Ref> precedents = this._map.get(dependant);
        if (precedents == null) {
            precedents = new LinkedHashSet<Ref>();
            this._map.put(dependant, precedents);
        }
        precedents.add(precedent);
    }

    public void clear() {
        this._map.clear();
        this._evaledMap.clear();
    }

    @Override
    public void clearDependents(Ref dependant) {
        this._map.remove(dependant);
        this._evaledMap.remove(dependant);
    }

    @Override
    public Set<Ref> getDependents(Ref precedent) {
        return this.getDependents(precedent, this._map);
    }

    @Override
    public Set<Ref> getEvaluatedDependents(Ref precedent) {
        return this.getDependents(precedent, this._evaledMap);
    }

    @Override
    public void setEvaluated(Ref dependent) {
        Set<Ref> precedents = this._map.get(dependent);
        if (precedents != null) {
            this._evaledMap.put(dependent, precedents);
        }
    }

    private Set<Ref> getDependents(Ref precedent, Map<Ref, Set<Ref>> base) {
        LinkedHashSet<Ref> result = new LinkedHashSet<Ref>();
        LinkedList<Ref> queue = new LinkedList<Ref>();
        queue.add(precedent);
        Ref.RefType precedentType = precedent.getType();
        while (!queue.isEmpty()) {
            Ref p = (Ref)queue.remove();
            block1: for (Map.Entry<Ref, Set<Ref>> entry : base.entrySet()) {
                Ref target = entry.getKey();
                if (result.contains(target)) continue;
                if ((precedentType == Ref.RefType.BOOK || precedentType == Ref.RefType.SHEET) && this.isMatched(target, precedent)) {
                    result.add(target);
                    queue.add(target);
                    continue;
                }
                for (Ref pre : entry.getValue()) {
                    if (!this.isMatched(pre, p)) continue;
                    result.add(target);
                    queue.add(target);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public Set<Ref> getDirectDependents(Ref precedent) {
        LinkedHashSet<Ref> result = new LinkedHashSet<Ref>();
        Ref.RefType precedentType = precedent.getType();
        block0: for (Map.Entry<Ref, Set<Ref>> entry : this._map.entrySet()) {
            Ref target = entry.getKey();
            if (result.contains(target)) continue;
            if ((precedentType == Ref.RefType.BOOK || precedentType == Ref.RefType.SHEET) && this.isMatched(target, precedent)) {
                result.add(target);
                continue;
            }
            for (Ref pre : entry.getValue()) {
                if (!this.isMatched(pre, precedent)) continue;
                result.add(target);
                continue block0;
            }
        }
        return result;
    }

    private boolean isMatched(Ref a, Ref b) {
        if (_regionTypes.contains((Object)a.getType()) && _regionTypes.contains((Object)b.getType())) {
            return this.isIntersected(a, b);
        }
        return a.equals(b);
    }

    private boolean isIntersected(Ref a, Ref b) {
        if (!a.getBookName().equals(b.getBookName())) {
            return false;
        }
        if (a.getType() == Ref.RefType.BOOK || b.getType() == Ref.RefType.BOOK) {
            return this.isBookIntersected(a, b);
        }
        SBook book = this._books.getBook(a.getBookName());
        int[] aSheetIndexes = this.getSheetIndex(book, a);
        int[] bSheetIndexes = this.getSheetIndex(book, b);
        if (!(a.getSheetName().equals(b.getSheetName()) || !this.isBothNotExist(aSheetIndexes, bSheetIndexes) && this.isIntersected(aSheetIndexes[0], aSheetIndexes[1], bSheetIndexes[0], bSheetIndexes[1]))) {
            return false;
        }
        if (a.getType() == Ref.RefType.SHEET || b.getType() == Ref.RefType.SHEET) {
            return this.isSheetIntersected(a, b);
        }
        return this.isIntersected(a.getColumn(), a.getRow(), a.getLastColumn(), a.getLastRow(), b.getColumn(), b.getRow(), b.getLastColumn(), b.getLastRow());
    }

    private boolean isSheetIntersected(Ref a, Ref b) {
        if (a.getType() == Ref.RefType.SHEET) {
            return a.getSheetName().equals(b.getSheetName());
        }
        if (b.getType() == Ref.RefType.SHEET) {
            return b.getSheetName().equals(a.getSheetName());
        }
        return false;
    }

    private boolean isBookIntersected(Ref a, Ref b) {
        if (a.getType() == Ref.RefType.BOOK) {
            return a.getBookName().equals(b.getBookName());
        }
        if (b.getType() == Ref.RefType.BOOK) {
            return b.getBookName().equals(a.getBookName());
        }
        return false;
    }

    private boolean isBothNotExist(int[] aSheetIndexes, int[] bSheetIndexes) {
        for (int i : aSheetIndexes) {
            if (i >= 0) continue;
            return true;
        }
        for (int i : bSheetIndexes) {
            if (i >= 0) continue;
            return true;
        }
        return false;
    }

    private int[] getSheetIndex(SBook book, Ref ref) {
        String sn = ref.getSheetName();
        String lsn = ref.getLastSheetName();
        int a = book.getSheetIndex(sn);
        int b = lsn == null || lsn.equals(sn) ? a : book.getSheetIndex(lsn);
        return new int[]{a, b};
    }

    private final boolean isIntersected(int a1, int a2, int b) {
        return a1 <= b && b <= a2;
    }

    private final boolean isIntersected(int a1, int a2, int b1, int b2) {
        return this.isIntersected(a1, a2, b1) || this.isIntersected(a1, a2, b2) || this.isIntersected(b1, b2, a1) || this.isIntersected(b1, b2, a2);
    }

    private final boolean isIntersected(int ax1, int ay1, int ax2, int ay2, int bx1, int by1, int bx2, int by2) {
        return this.isIntersected(ax1, ax2, bx1, bx2) && this.isIntersected(ay1, ay2, by1, by2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Ref, Set<Ref>> entry : this._map.entrySet()) {
            Ref target = entry.getKey();
            sb.append(target).append('\n');
            for (Ref pre : entry.getValue()) {
                sb.append('\t').append(pre).append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public void merge(DependencyTableAdv dependencyTable) {
        if (!(dependencyTable instanceof DependencyTableImpl)) {
            _logger.error("can't merge different type of dependency table: " + dependencyTable.getClass().getName());
            return;
        }
        DependencyTableImpl another = (DependencyTableImpl)dependencyTable;
        this._map.putAll(another._map);
        this._evaledMap.putAll(another._evaledMap);
    }

    @Override
    public Set<Ref> searchPrecedents(DependencyTable.RefFilter filter) {
        LinkedHashSet<Ref> precedents = new LinkedHashSet<Ref>();
        for (Map.Entry<Ref, Set<Ref>> entry : this._map.entrySet()) {
            for (Ref pre : entry.getValue()) {
                if (!filter.accept(pre)) continue;
                precedents.add(pre);
            }
        }
        return precedents;
    }

    public void dump() {
        for (Map.Entry<Ref, Set<Ref>> entry : this._map.entrySet()) {
            System.out.println("[" + entry.getKey() + "] depends on");
            for (Ref ref : entry.getValue()) {
                System.out.println("\t+[" + ref + "]");
            }
        }
    }

    @Override
    public Set<Ref> getDirectPrecedents(Ref dependent) {
        return this._map.get(dependent);
    }
}

