/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.sys;

import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.util.CacheMap;
import org.zkoss.zss.model.impl.sys.FullMonthData;

public class DateInputMask {
    private static final String SPACES = "[ \\t]*";
    private static final String SPACE1 = "[ \\t]+";
    private static final String START_ANCHOR = "^[ \\t]*";
    private static final String END_ANCHOR = "[ \\t]*$";
    private static final String AMPM = "[AP]M?";
    private static final String AMPM1_G = "([AP]M?)";
    private static final String COMMA = "[ \\t]*[,][ \\t]+";
    private static final String DASH_SLASH_SPACE = "(?:[ \\t]*[-/]?|[-/]?)[ \\t]*";
    private static final String DOT_DASH_SLASH_SPACE = "(?:[ \\t]*[-/.]?|[-/.]?)[ \\t]*";
    private static final String DOT_SPACE = "(?:[ \\t]*[.]?|[.]?)[ \\t]*";
    private static final String COLON_SPACE = "(?:[ \\t]*[:]?|[:]?)[ \\t]*";
    private static final String DOT_DASH_SLASH = "[ \\t]*[-/.][ \\t]*";
    private static final String DASH_SLASH = "[ \\t]*[/-][ \\t]*";
    private static final String COLON_AMPM = "(?:[ \\t]*[:]|[ \\t]+([AP]M?))[ \\t]*";
    private static final String NAME_MONTH_G = "([A-Z\\p{InLatin-1Supplement}]{3,9})";
    private static final String NUM_MONTH_G = "([0]?[1-9]|1[012])";
    private static final String DAY_G = "([0]?[1-9]|[12][0-9]|3[01])";
    private static final String YEAR_G = "(19\\d\\d|[2-9]\\d\\d\\d|\\d\\d|\\d)";
    private static final String HOUR_G = "(\\d{1,4})";
    private static final String MINUTE_G = "(\\d{1,4})";
    private static final String SECOND_G = "(\\d{0,4})";
    private static final String MSECOND_G = "(\\d{0,4})";
    private static final String AMPM2_G = "([ \\t]+[AP]M?|[AP]M?)?";
    private static final String TIME = "(\\d{1,4})(?:[ \\t]*[:]|[ \\t]+([AP]M?))[ \\t]*(?:(\\d{1,4})(?:[ \\t]*[:]?|[:]?)[ \\t]*|[ \\t]*)(\\d{0,4})(?:[ \\t]*[.]?|[.]?)[ \\t]*(\\d{0,4})([ \\t]+[AP]M?|[AP]M?)?";
    private static final String TIME_PAT = "^[ \\t]*(\\d{1,4})(?:[ \\t]*[:]|[ \\t]+([AP]M?))[ \\t]*(?:(\\d{1,4})(?:[ \\t]*[:]?|[:]?)[ \\t]*|[ \\t]*)(\\d{0,4})(?:[ \\t]*[.]?|[.]?)[ \\t]*(\\d{0,4})([ \\t]+[AP]M?|[AP]M?)?[ \\t]*$";
    private static final int flags = 2;
    private static final CacheMap _formatInfosMap = new CacheMap(4);

    private String[] getDate11(Locale locale, boolean withTime) {
        String[] stringArray;
        DateFormat format = DateFormat.getDateInstance(2, locale);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(65, 6, 18, 0, 0, 0);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        boolean alreadyDate = false;
        boolean alreadyMonth = false;
        boolean alreadyYear = false;
        int leadingSpace = -2;
        int leadingComma = -2;
        int j = 0;
        sb.append(START_ANCHOR);
        char c = iter.first();
        while (c != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                switch (c) {
                    case ',': {
                        leadingComma = j;
                        break;
                    }
                    case ' ': {
                        if (leadingComma == j - 1) {
                            sb.append(COMMA);
                        } else if (leadingSpace != j - 1) {
                            sb.append(DASH_SLASH_SPACE);
                        }
                        leadingSpace = j;
                        break;
                    }
                    case '-': 
                    case '.': 
                    case '/': {
                        if (leadingSpace != j - 1) {
                            sb.append(DOT_DASH_SLASH_SPACE);
                        }
                        leadingSpace = j;
                    }
                }
                sb1.append(c);
            } else {
                for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            if (alreadyDate) break;
                            alreadyDate = true;
                            sb.append(DAY_G);
                            sb1.append("18");
                            break;
                        }
                        case 2: {
                            if (alreadyMonth) break;
                            alreadyMonth = true;
                            sb.append(NAME_MONTH_G);
                            sb1.append("JUL");
                            break;
                        }
                        case 1: {
                            if (alreadyYear) break;
                            alreadyYear = true;
                            sb.append(YEAR_G);
                            sb1.append("65");
                        }
                    }
                }
            }
            ++j;
            c = iter.next();
        }
        StringBuilder sb2 = new StringBuilder();
        if (withTime) {
            sb.append(SPACE1).append(TIME);
            sb2.append((CharSequence)sb1).append(" 2 P");
            sb1.append(" 2:3:5.100 A");
        }
        sb.append(END_ANCHOR);
        if (withTime) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = sb.toString();
            stringArray2[1] = sb1.toString();
            stringArray = stringArray2;
            stringArray2[2] = sb2.toString();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = sb.toString();
            stringArray = stringArray3;
            stringArray3[1] = sb1.toString();
        }
        return stringArray;
    }

    private void enforceDMY(StringBuilder sb, StringBuilder sb1, int attrCount) {
        switch (attrCount) {
            case 0: {
                sb.append(DAY_G);
                sb1.append("18");
                break;
            }
            case 1: {
                sb.append(NAME_MONTH_G);
                sb1.append("JUL");
                break;
            }
            case 2: {
                sb.append(YEAR_G);
                sb1.append("65");
            }
        }
    }

    private String[] getDate12(Locale locale, boolean withTime) {
        String[] stringArray;
        DateFormat format = DateFormat.getDateInstance(3, locale);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(65, 6, 18, 0, 0, 0);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        boolean alreadyDate = false;
        boolean alreadyMonth = false;
        boolean alreadyYear = false;
        int leadingSpace = -2;
        int attrCount = 0;
        int j = 0;
        sb.append(START_ANCHOR);
        char c = iter.first();
        while (c != '\uffff' && attrCount < 3) {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                if (leadingSpace != j - 1) {
                    if (c == '.') {
                        sb.append(DOT_DASH_SLASH_SPACE);
                    } else {
                        sb.append(DASH_SLASH_SPACE);
                    }
                    sb1.append(' ');
                }
                leadingSpace = j;
            } else {
                for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            if (alreadyDate) break;
                            alreadyDate = true;
                            this.enforceDMY(sb, sb1, attrCount);
                            ++attrCount;
                            break;
                        }
                        case 2: {
                            if (alreadyMonth) break;
                            alreadyMonth = true;
                            this.enforceDMY(sb, sb1, attrCount);
                            ++attrCount;
                            break;
                        }
                        case 1: {
                            if (alreadyYear) break;
                            alreadyYear = true;
                            this.enforceDMY(sb, sb1, attrCount);
                            ++attrCount;
                        }
                    }
                }
            }
            ++j;
            c = iter.next();
        }
        StringBuilder sb2 = new StringBuilder();
        if (withTime) {
            sb.append(SPACE1).append(TIME);
            sb2.append((CharSequence)sb1).append(" 2 P");
            sb1.append(" 2:3:5.100 A");
        }
        sb.append(END_ANCHOR);
        if (withTime) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = sb.toString();
            stringArray2[1] = sb1.toString();
            stringArray = stringArray2;
            stringArray2[2] = sb2.toString();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = sb.toString();
            stringArray = stringArray3;
            stringArray3[1] = sb1.toString();
        }
        return stringArray;
    }

    private String[] getDate21(Locale locale, boolean withTime) {
        String[] stringArray;
        DateFormat format = DateFormat.getDateInstance(3, locale);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(65, 6, 18, 0, 0, 0);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        boolean alreadyDate = false;
        boolean alreadyMonth = false;
        boolean alreadyYear = false;
        int attrCount = 0;
        int leadingSpace = -2;
        int j = 0;
        sb.append(START_ANCHOR);
        char c = iter.first();
        while (c != '\uffff' && attrCount < 2) {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                if (leadingSpace != j - 1) {
                    if (c == '.') {
                        sb.append(DOT_DASH_SLASH_SPACE);
                    } else {
                        sb.append(DASH_SLASH_SPACE);
                    }
                    sb1.append(' ');
                }
                leadingSpace = j;
            } else {
                for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            if (alreadyDate) break;
                            alreadyDate = true;
                            sb.append(DAY_G);
                            sb1.append("18");
                            ++attrCount;
                            break;
                        }
                        case 2: {
                            if (alreadyMonth) break;
                            alreadyMonth = true;
                            sb.append(NAME_MONTH_G);
                            sb1.append("JUL");
                            ++attrCount;
                            break;
                        }
                        case 1: {
                            if (alreadyYear) break;
                            alreadyYear = true;
                            sb.append(YEAR_G);
                            sb1.append("65");
                            ++attrCount;
                        }
                    }
                }
            }
            ++j;
            c = iter.next();
        }
        StringBuilder sb2 = new StringBuilder();
        if (withTime) {
            sb.append(SPACE1).append(TIME);
            sb2.append((CharSequence)sb1).append(" 2 P");
            sb1.append(" 2:3:5.100 A");
        }
        sb.append(END_ANCHOR);
        if (withTime) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = sb.toString();
            stringArray2[1] = sb1.toString();
            stringArray = stringArray2;
            stringArray2[2] = sb2.toString();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = sb.toString();
            stringArray = stringArray3;
            stringArray3[1] = sb1.toString();
        }
        return stringArray;
    }

    private String[] getDate22(Locale locale, boolean withTime) {
        String[] stringArray;
        DateFormat format = DateFormat.getDateInstance(3, locale);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(65, 6, 18, 0, 0, 0);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        boolean alreadyDate = false;
        boolean alreadyMonth = false;
        boolean alreadyYear = false;
        int leadingSpace = -2;
        int j = 0;
        int attrCount = 0;
        sb.append(START_ANCHOR);
        char c = iter.first();
        while (c != '\uffff' && attrCount < 2) {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                if (leadingSpace != j - 1) {
                    if ('.' == c) {
                        sb.append(DOT_DASH_SLASH);
                    } else {
                        sb.append(DASH_SLASH);
                    }
                    sb1.append('-');
                }
                leadingSpace = j;
            } else {
                for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            if (alreadyDate) break;
                            alreadyDate = true;
                            sb.append(DAY_G);
                            sb1.append("18");
                            ++attrCount;
                            break;
                        }
                        case 2: {
                            if (alreadyMonth) break;
                            alreadyMonth = true;
                            sb.append(NUM_MONTH_G);
                            sb1.append("7");
                            ++attrCount;
                            break;
                        }
                        case 1: {
                            if (alreadyYear) break;
                            alreadyYear = true;
                            sb.append(YEAR_G);
                            sb1.append("65");
                            ++attrCount;
                        }
                    }
                }
            }
            ++j;
            c = iter.next();
        }
        StringBuilder sb2 = new StringBuilder();
        if (withTime) {
            sb.append(SPACE1).append(TIME);
            sb2.append((CharSequence)sb1).append(" 2 P");
            sb1.append(" 2:3:5.100 A");
        }
        sb.append(END_ANCHOR);
        if (withTime) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = sb.toString();
            stringArray2[1] = sb1.toString();
            stringArray = stringArray2;
            stringArray2[2] = sb2.toString();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = sb.toString();
            stringArray = stringArray3;
            stringArray3[1] = sb1.toString();
        }
        return stringArray;
    }

    private String[] getDate31(Locale locale, boolean withTime) {
        String[] stringArray;
        DateFormat format = DateFormat.getDateInstance(3, locale);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(65, 6, 18, 0, 0, 0);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        boolean alreadyDate = false;
        boolean alreadyMonth = false;
        boolean alreadyYear = false;
        int attrCount = 0;
        int leadingSpace = -2;
        int j = 0;
        sb.append(START_ANCHOR);
        char c = iter.first();
        while (c != '\uffff' && attrCount < 2) {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                if (leadingSpace != j - 1 && alreadyMonth) {
                    if (c == '.') {
                        sb.append(DOT_DASH_SLASH_SPACE);
                    } else {
                        sb.append(DASH_SLASH_SPACE);
                    }
                    sb1.append(' ');
                }
                leadingSpace = j;
            } else {
                for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            if (alreadyDate || !alreadyMonth) break;
                            alreadyDate = true;
                            sb.append(YEAR_G);
                            sb1.append("65");
                            ++attrCount;
                            break;
                        }
                        case 2: {
                            if (alreadyMonth) break;
                            alreadyMonth = true;
                            sb.append(NAME_MONTH_G);
                            sb1.append("JUL");
                            ++attrCount;
                            break;
                        }
                        case 1: {
                            if (alreadyYear || !alreadyMonth) break;
                            alreadyYear = true;
                            sb.append(YEAR_G);
                            sb1.append("65");
                            ++attrCount;
                        }
                    }
                }
            }
            ++j;
            c = iter.next();
        }
        StringBuilder sb2 = new StringBuilder();
        if (withTime) {
            sb.append(SPACE1).append(TIME);
            sb2.append((CharSequence)sb1).append(" 2 P");
            sb1.append(" 2:3:5.100 A");
        }
        sb.append(END_ANCHOR);
        if (withTime) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = sb.toString();
            stringArray2[1] = sb1.toString();
            stringArray = stringArray2;
            stringArray2[2] = sb2.toString();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = sb.toString();
            stringArray = stringArray3;
            stringArray3[1] = sb1.toString();
        }
        return stringArray;
    }

    private String[] getDate32(Locale locale, boolean withTime) {
        String[] stringArray;
        DateFormat format = DateFormat.getDateInstance(3, locale);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(65, 6, 18, 0, 0, 0);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        boolean alreadyDate = false;
        boolean alreadyMonth = false;
        boolean alreadyYear = false;
        int leadingSpace = -2;
        int j = 0;
        int attrCount = 0;
        sb.append(START_ANCHOR);
        char c = iter.first();
        while (c != '\uffff' && attrCount < 2) {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                if (leadingSpace != j - 1 && attrCount < 2 && alreadyMonth) {
                    if ('.' == c) {
                        sb.append(DOT_DASH_SLASH);
                    } else {
                        sb.append(DASH_SLASH);
                    }
                    sb1.append('-');
                }
                leadingSpace = j;
            } else {
                for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            if (alreadyDate || !alreadyMonth) break;
                            alreadyDate = true;
                            sb.append(YEAR_G);
                            sb1.append("65");
                            ++attrCount;
                            break;
                        }
                        case 2: {
                            if (alreadyMonth) break;
                            alreadyMonth = true;
                            sb.append(NUM_MONTH_G);
                            sb1.append("7");
                            ++attrCount;
                            break;
                        }
                        case 1: {
                            if (alreadyYear || !alreadyMonth) break;
                            alreadyYear = true;
                            sb.append(YEAR_G);
                            sb1.append("65");
                            ++attrCount;
                        }
                    }
                }
            }
            ++j;
            c = iter.next();
        }
        StringBuilder sb2 = new StringBuilder();
        if (withTime) {
            sb.append(SPACE1).append(TIME);
            sb2.append((CharSequence)sb1).append(" 2 P");
            sb1.append(" 2:3:5.100 A");
        }
        sb.append(END_ANCHOR);
        if (withTime) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = sb.toString();
            stringArray2[1] = sb1.toString();
            stringArray = stringArray2;
            stringArray2[2] = sb2.toString();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = sb.toString();
            stringArray = stringArray3;
            stringArray3[1] = sb1.toString();
        }
        return stringArray;
    }

    private String[] getDate4(Locale locale, boolean withTime) {
        String[] stringArray;
        DateFormat format = DateFormat.getDateInstance(3, locale);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(65, 6, 18, 0, 0, 0);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        boolean alreadyDate = false;
        boolean alreadyMonth = false;
        boolean alreadyYear = false;
        int leadingSpace = -2;
        int j = 0;
        sb.append(START_ANCHOR);
        char c = iter.first();
        while (c != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                if (leadingSpace != j - 1) {
                    if (c == '.') {
                        sb.append(DOT_DASH_SLASH);
                    } else {
                        sb.append(DASH_SLASH);
                    }
                    sb1.append('-');
                }
                leadingSpace = j;
            } else {
                for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            if (alreadyDate) break;
                            alreadyDate = true;
                            sb.append(DAY_G);
                            sb1.append("18");
                            break;
                        }
                        case 2: {
                            if (alreadyMonth) break;
                            alreadyMonth = true;
                            sb.append(NUM_MONTH_G);
                            sb1.append("7");
                            break;
                        }
                        case 1: {
                            if (alreadyYear) break;
                            alreadyYear = true;
                            sb.append(YEAR_G);
                            sb1.append("65");
                        }
                    }
                }
            }
            ++j;
            c = iter.next();
        }
        StringBuilder sb2 = new StringBuilder();
        if (withTime) {
            sb.append(SPACE1).append(TIME);
            sb2.append((CharSequence)sb1).append(" 2 P");
            sb1.append(" 2:3:5.100 A");
        }
        sb.append(END_ANCHOR);
        if (withTime) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = sb.toString();
            stringArray2[1] = sb1.toString();
            stringArray = stringArray2;
            stringArray2[2] = sb2.toString();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = sb.toString();
            stringArray = stringArray3;
            stringArray3[1] = sb1.toString();
        }
        return stringArray;
    }

    private FormatInfo[] getFormatInfos(Locale locale) {
        FormatInfo[] formatInfos = (FormatInfo[])_formatInfosMap.get((Object)locale);
        if (formatInfos != null) {
            return formatInfos;
        }
        formatInfos = new FormatInfo[15];
        int j = 0;
        String[] date11 = this.getDate11(locale, false);
        formatInfos[j++] = new FormatInfo(Pattern.compile(date11[0], 2), "d-mmm-yy", date11[1], null, locale);
        String[] date12 = this.getDate12(locale, false);
        formatInfos[j++] = new FormatInfo(Pattern.compile(date12[0], 2), "d-mmm-yy", date12[1], null, locale);
        String[] date21 = this.getDate21(locale, false);
        formatInfos[j++] = new FormatInfo(Pattern.compile(date21[0], 2), "d-mmm", date21[1], null, locale);
        String[] date22 = this.getDate22(locale, false);
        formatInfos[j++] = new FormatInfo(Pattern.compile(date22[0], 2), "d-mmm", date22[1], null, locale);
        String[] date31 = this.getDate31(locale, false);
        formatInfos[j++] = new FormatInfo(Pattern.compile(date31[0], 2), "mmm-yy", date31[1], null, locale);
        String[] date32 = this.getDate32(locale, false);
        formatInfos[j++] = new FormatInfo(Pattern.compile(date32[0], 2), "mmm-yy", date32[1], null, locale);
        String[] date4 = this.getDate4(locale, false);
        formatInfos[j++] = new FormatInfo(Pattern.compile(date4[0], 2), "m/d/yyyy", date4[1], null, locale);
        formatInfos[j++] = new FormatInfo(Pattern.compile(TIME_PAT, 2), null, "2:3:5.100 A", "2 P", locale);
        String[] datetime11 = this.getDate11(locale, true);
        formatInfos[j++] = new FormatInfo(Pattern.compile(datetime11[0], 2), "m/d/yyyy h:mm", datetime11[1], datetime11[2], locale);
        String[] datetime12 = this.getDate12(locale, true);
        formatInfos[j++] = new FormatInfo(Pattern.compile(datetime12[0], 2), "m/d/yyyy h:mm", datetime12[1], datetime12[2], locale);
        String[] datetime21 = this.getDate21(locale, true);
        formatInfos[j++] = new FormatInfo(Pattern.compile(datetime21[0], 2), "m/d/yyyy h:mm", datetime21[1], datetime21[2], locale);
        String[] datetime22 = this.getDate22(locale, true);
        formatInfos[j++] = new FormatInfo(Pattern.compile(datetime22[0], 2), "m/d/yyyy h:mm", datetime22[1], datetime22[2], locale);
        String[] datetime31 = this.getDate31(locale, true);
        formatInfos[j++] = new FormatInfo(Pattern.compile(datetime31[0], 2), "m/d/yyyy h:mm", datetime31[1], datetime31[2], locale);
        String[] datetime32 = this.getDate32(locale, true);
        formatInfos[j++] = new FormatInfo(Pattern.compile(datetime32[0], 2), "m/d/yyyy h:mm", datetime32[1], datetime32[2], locale);
        String[] datetime4 = this.getDate4(locale, true);
        formatInfos[j++] = new FormatInfo(Pattern.compile(datetime4[0], 2), "m/d/yyyy h:mm", datetime4[1], datetime4[2], locale);
        _formatInfosMap.put((Object)locale, (Object)formatInfos);
        return formatInfos;
    }

    public Object[] parseDateInput(String txt, Locale locale) {
        int twoDigitYearUpperBound = -1;
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        String[] ampm = symbols.getAmPmStrings();
        String am = ampm[0];
        String pm = ampm[1];
        String txt1 = txt;
        txt1 = txt1.replaceFirst(am, "AM");
        txt1 = txt1.replaceFirst(pm, "PM");
        FormatInfo[] formatInfos = this.getFormatInfos(locale);
        for (int j = 0; j < formatInfos.length; ++j) {
            FormatInfo info = formatInfos[j];
            Matcher m = info.getMaskPattern().matcher(txt1);
            if (!m.matches()) continue;
            return info.parseInput(txt1, m, -1);
        }
        return new Object[]{txt, null};
    }

    static {
        _formatInfosMap.setLifetime(86400000);
    }

    private static class FormatInfo {
        private final Pattern _mask;
        private final String _format;
        private int _year;
        private int _month;
        private int _day;
        private int _hour;
        private int _minute;
        private int _second;
        private int _msecond;
        private int _ampm1;
        private int _ampm2;
        private Locale _locale;
        private static final int[] MAXDAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

        public FormatInfo(Pattern mask, String format, String groupMatchText, String ampm1MatchText, Locale locale) {
            String grptxt;
            int j;
            this._locale = locale;
            this._mask = mask;
            this._format = format;
            Matcher m = this._mask.matcher(groupMatchText);
            if (!m.matches()) {
                throw new RuntimeException("Wrong groupMatchText: " + groupMatchText + ", regex mask: " + this._mask);
            }
            int len = m.groupCount() + 1;
            for (j = 1; j < len; ++j) {
                grptxt = m.group(j);
                if ("65".equals(grptxt)) {
                    this._year = j;
                    continue;
                }
                if ("7".equals(grptxt)) {
                    this._month = j;
                    continue;
                }
                if ("JUL".equals(grptxt)) {
                    this._month = j;
                    continue;
                }
                if ("18".equals(grptxt)) {
                    this._day = j;
                    continue;
                }
                if (" A".equals(grptxt)) {
                    this._ampm2 = j;
                    continue;
                }
                if ("2".equals(grptxt)) {
                    this._hour = j;
                    continue;
                }
                if ("3".equals(grptxt)) {
                    this._minute = j;
                    continue;
                }
                if ("5".equals(grptxt)) {
                    this._second = j;
                    continue;
                }
                if (!"100".equals(grptxt)) continue;
                this._msecond = j;
            }
            if (ampm1MatchText != null) {
                m = this._mask.matcher(ampm1MatchText);
                if (!m.matches()) {
                    throw new RuntimeException("Wrong ampm1MatchText: " + ampm1MatchText + ", regex mask: " + this._mask);
                }
                len = m.groupCount();
                for (j = 1; j < len; ++j) {
                    grptxt = m.group(j);
                    if (!"P".equals(grptxt)) continue;
                    this._ampm1 = j;
                    break;
                }
            }
        }

        public Pattern getMaskPattern() {
            return this._mask;
        }

        public String getFormat() {
            return this._format;
        }

        private int getMonthIndex(String month) {
            month = month.toUpperCase();
            FullMonthData fmd = FullMonthData.getInstance(2, this._locale);
            return fmd.getIndexByStartsWith(month);
        }

        private int parseMonth(Matcher m) {
            if (this._month > 0) {
                String month = m.group(this._month);
                if (month.length() >= 3) {
                    return this.getMonthIndex(month);
                }
                return Integer.parseInt(month) - 1;
            }
            return -1;
        }

        private int parseDay(Matcher m) {
            if (this._day > 0) {
                String day = m.group(this._day);
                return Integer.parseInt(day);
            }
            if (this._day == 0) {
                return 1;
            }
            return -1;
        }

        private int parseYear(Matcher m, int twoDigitYearUpperBound) {
            if (this._year > 0) {
                String year = m.group(this._year);
                int y = Integer.parseInt(year);
                return y < 100 ? this.twoDigitYearTo4DigitYear(y, twoDigitYearUpperBound) : y;
            }
            return -1;
        }

        private int twoDigitYearTo4DigitYear(int y, int twoDigitYearUpperBound) {
            int upperLowDigit;
            if (twoDigitYearUpperBound < 1999) {
                twoDigitYearUpperBound = this.getCalendar().get(1) / 10 * 10 + 20 - 1;
            }
            if (y <= (upperLowDigit = twoDigitYearUpperBound % 100)) {
                return twoDigitYearUpperBound - upperLowDigit + y;
            }
            return twoDigitYearUpperBound - upperLowDigit - 100 + y;
        }

        private int getMaxday(int month, int year) {
            int maxday = MAXDAYS[month];
            if (month == 1 && this.isLeapYear(year)) {
                return maxday + 1;
            }
            return maxday;
        }

        private boolean isLeapYear(int year) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }

        private int parseHour(Matcher m) {
            return this.parseTime(m, this._hour);
        }

        private int parseMinute(Matcher m) {
            return this.parseTime(m, this._minute);
        }

        private int parseSecond(Matcher m) {
            return this.parseTime(m, this._second);
        }

        private int parseMillisecond(Matcher m) {
            return this.parseTime(m, this._msecond);
        }

        private int parseTime(Matcher m, int groupIndex) {
            String value;
            if (groupIndex > 0 && (value = m.group(groupIndex)) != null && value.length() > 0) {
                return Integer.parseInt(value);
            }
            return -1;
        }

        private String parseAmpm(Matcher m) {
            String result = null;
            if (this._ampm2 > 0) {
                result = m.group(this._ampm2);
            }
            if (result == null && this._ampm1 > 0) {
                result = m.group(this._ampm1);
            }
            return result;
        }

        private Calendar getCalendar() {
            return Calendar.getInstance();
        }

        public Object[] parseInput(String txt, Matcher m, int twoDigitYearUpperBound) {
            int maxday;
            int month = this.parseMonth(m);
            if (month < 0 && this._month > 0) {
                return new Object[]{txt, null};
            }
            int day = this.parseDay(m);
            if (day < 0 && this._day > 0) {
                return new Object[]{txt, null};
            }
            Calendar cal = this.getCalendar();
            int year = this.parseYear(m, twoDigitYearUpperBound);
            if (year < 0 && this._format != null) {
                year = cal.get(1);
            }
            String format = this._format;
            if (this._month > 0 && (maxday = this.getMaxday(month, year)) < day) {
                if (this._year > 0) {
                    return new Object[]{txt, null};
                }
                if (this._hour <= 0) {
                    format = "mmm-yy";
                }
                year = day + 1900;
                day = 1;
            }
            int hour = this.parseHour(m);
            int minute = this.parseMinute(m);
            int second = this.parseSecond(m);
            int msecond = this.parseMillisecond(m);
            String ampm = this.parseAmpm(m);
            if (ampm != null) {
                if (hour > 12 || minute >= 60 || second >= 60) {
                    return new Object[]{txt, null};
                }
                ampm = ampm.toUpperCase();
                if (hour < 12) {
                    if (ampm.startsWith("P")) {
                        hour += 12;
                    }
                } else if (ampm.startsWith("A")) {
                    hour = 0;
                }
            }
            if (hour > 23 && minute >= 60 || minute >= 60 && second >= 60 || hour > 23 && second >= 60) {
                return new Object[]{txt, null};
            }
            if (format == null) {
                year = 1900;
                month = 0;
                day = 0;
                if (msecond >= 0) {
                    format = "mm:ss.0";
                } else if (ampm != null) {
                    format = second >= 0 ? "h:mm:ss AM/PM" : "h:mm AM/PM";
                } else if (hour < 24) {
                    if (minute < 60 && second < 60) {
                        format = second > 0 ? "h:mm:ss" : "h:mm";
                    }
                } else if (minute < 60 && second < 60) {
                    format = "[h]:mm:ss";
                }
            } else if (msecond >= 0) {
                format = "mm:ss.0";
            } else if (hour > 23 || minute >= 60 || second >= 60) {
                format = null;
            }
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, day);
            if (hour < 0) {
                hour = 0;
            }
            if (minute < 0) {
                minute = 0;
            }
            if (second < 0) {
                second = 0;
            }
            if (msecond < 0) {
                msecond = 0;
            }
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, msecond);
            return new Object[]{cal.getTime(), format};
        }
    }
}

