/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl.chart;

import java.io.Serializable;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.chart.SSeries;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractChartAdv;
import org.zkoss.zss.model.impl.AbstractSeriesAdv;
import org.zkoss.zss.model.impl.EvaluationUtil;
import org.zkoss.zss.model.impl.LinkedModelObject;
import org.zkoss.zss.model.impl.ObjectRefImpl;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.EvaluationResult;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaEvaluationContext;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;

public class SeriesImpl
extends AbstractSeriesAdv
implements SSeries,
Serializable,
LinkedModelObject {
    private static final long serialVersionUID = 1L;
    private FormulaExpression _nameExpr;
    private FormulaExpression _valueExpr;
    private FormulaExpression _yValueExpr;
    private FormulaExpression _zValueExpr;
    private AbstractChartAdv _chart;
    private final String _id;
    private Object _evalNameResult;
    private Object _evalValuesResult;
    private Object _evalYValuesResult;
    private Object _evalZValuesResult;
    private boolean _evaluated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalFormula() {
        if (this._evaluated) {
            return;
        }
        SeriesImpl seriesImpl = this;
        synchronized (seriesImpl) {
            if (!this._evaluated) {
                Object val;
                EvaluationResult result;
                FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
                SSheet sheet = this._chart.getSheet();
                Ref ref = this.getRef();
                if (this._nameExpr != null) {
                    result = fe.evaluate(this._nameExpr, new FormulaEvaluationContext(sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalNameResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        Object object = this._evalNameResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                if (this._valueExpr != null) {
                    result = fe.evaluate(this._valueExpr, new FormulaEvaluationContext(sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalValuesResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        Object object = this._evalValuesResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                if (this._yValueExpr != null) {
                    result = fe.evaluate(this._yValueExpr, new FormulaEvaluationContext(sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalYValuesResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        Object object = this._evalYValuesResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                if (this._zValueExpr != null) {
                    result = fe.evaluate(this._zValueExpr, new FormulaEvaluationContext(sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalZValuesResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        this._evalZValuesResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                this._evaluated = true;
            }
        }
    }

    public SeriesImpl(AbstractChartAdv chart, String id) {
        this._chart = chart;
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        this.evalFormula();
        return this._evalNameResult == null ? null : (this._evalNameResult instanceof ErrorValue ? ((ErrorValue)this._evalNameResult).getErrorString() : this._evalNameResult.toString());
    }

    public int getNumOfValue() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalValuesResult);
    }

    public Object getValue(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalValuesResult)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalValuesResult, index);
    }

    public int getNumOfYValue() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalYValuesResult);
    }

    public Object getYValue(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalYValuesResult)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalYValuesResult, index);
    }

    public int getNumOfZValue() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalZValuesResult);
    }

    public Object getZValue(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalZValuesResult)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalZValuesResult, index);
    }

    public void setFormula(String nameExpression, String valueExpression) {
        this.setXYZFormula(nameExpression, valueExpression, null, null);
    }

    public void setXYFormula(String nameExpression, String xValueExpression, String yValueExpression) {
        this.setXYZFormula(nameExpression, xValueExpression, yValueExpression, null);
    }

    public void setXYZFormula(String nameExpression, String xValueExpression, String yValueExpression, String zValueExpression) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency();
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        SSheet sheet = this._chart.getSheet();
        Ref ref = this.getRef();
        this._nameExpr = nameExpression != null ? fe.parse(nameExpression, new FormulaParseContext(sheet, ref)) : null;
        this._valueExpr = xValueExpression != null ? fe.parse(xValueExpression, new FormulaParseContext(sheet, ref)) : null;
        this._yValueExpr = yValueExpression != null ? fe.parse(yValueExpression, new FormulaParseContext(sheet, ref)) : null;
        this._zValueExpr = zValueExpression != null ? fe.parse(zValueExpression, new FormulaParseContext(sheet, ref)) : null;
    }

    public boolean isFormulaParsingError() {
        boolean r = false;
        if (this._nameExpr != null) {
            r |= this._nameExpr.hasError();
        }
        if (!r && this._valueExpr != null) {
            r |= this._valueExpr.hasError();
        }
        if (!r && this._yValueExpr != null) {
            r |= this._yValueExpr.hasError();
        }
        if (!r && this._zValueExpr != null) {
            r |= this._zValueExpr.hasError();
        }
        return r;
    }

    public String getNameFormula() {
        return this._nameExpr == null ? null : this._nameExpr.getFormulaString();
    }

    public String getValuesFormula() {
        return this._valueExpr == null ? null : this._valueExpr.getFormulaString();
    }

    public String getYValuesFormula() {
        return this._yValueExpr == null ? null : this._yValueExpr.getFormulaString();
    }

    public String getZValuesFormula() {
        return this._zValueExpr == null ? null : this._zValueExpr.getFormulaString();
    }

    public void clearFormulaResultCache() {
        this._evaluated = false;
        this._evalZValuesResult = null;
        this._evalYValuesResult = null;
        this._evalValuesResult = null;
        this._evalNameResult = null;
    }

    private void clearFormulaDependency() {
        if (this._nameExpr != null || this._valueExpr != null || this._yValueExpr != null || this._zValueExpr != null) {
            ((AbstractBookSeriesAdv)this._chart.getSheet().getBook().getBookSeries()).getDependencyTable().clearDependents(this.getRef());
        }
    }

    private Ref getRef() {
        return new ObjectRefImpl(this._chart, new String[]{this._chart.getId(), this._id});
    }

    public void destroy() {
        this.checkOrphan();
        this.clearFormulaDependency();
        this.clearFormulaResultCache();
        this._chart = null;
    }

    public void checkOrphan() {
        if (this._chart == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    public int getNumOfXValue() {
        return this.getNumOfValue();
    }

    public Object getXValue(int index) {
        return this.getValue(index);
    }

    public String getXValuesFormula() {
        return this.getValuesFormula();
    }

    public SeriesImpl cloneSeriesImpl(AbstractChartAdv chart) {
        SeriesImpl tgt = new SeriesImpl(chart, this._id);
        String nexpr = this.getNameFormula();
        String vexpr = this.getValuesFormula();
        String yexpr = this.getYValuesFormula();
        String zexpr = this.getZValuesFormula();
        tgt.setXYZFormula(nexpr, vexpr, yexpr, zexpr);
        return tgt;
    }

    public FormulaExpression getNameFormulaExpression() {
        return this._nameExpr;
    }

    public FormulaExpression getValuesFormulaExpression() {
        return this._valueExpr;
    }

    public FormulaExpression getXValuesFormulaExpression() {
        return this.getValuesFormulaExpression();
    }

    public FormulaExpression getYValuesFormulaExpression() {
        return this._yValueExpr;
    }

    public FormulaExpression getZValuesFormulaExpression() {
        return this._zValueExpr;
    }

    public void setXYZFormula(FormulaExpression nameExpr, FormulaExpression xValueExpr, FormulaExpression yValueExpr, FormulaExpression zValueExpr) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency();
        this._nameExpr = nameExpr;
        this._valueExpr = xValueExpr;
        this._yValueExpr = yValueExpr;
        this._zValueExpr = zValueExpr;
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        SSheet sheet = this._chart.getSheet();
        Ref ref = this.getRef();
        FormulaParseContext context = new FormulaParseContext(sheet, ref);
        if (nameExpr != null) {
            fe.updateDependencyTable(nameExpr, context);
        }
        if (xValueExpr != null) {
            fe.updateDependencyTable(xValueExpr, context);
        }
        if (yValueExpr != null) {
            fe.updateDependencyTable(yValueExpr, context);
        }
        if (zValueExpr != null) {
            fe.updateDependencyTable(zValueExpr, context);
        }
    }
}

