/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SRichText;
import org.zkoss.zss.model.impl.AbstractRichTextAdv;
import org.zkoss.zss.model.impl.SegmentImpl;
import org.zkoss.zss.model.util.Validations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextImpl
extends AbstractRichTextAdv {
    private static final long serialVersionUID = 1L;
    List<SegmentImpl> _segments = new LinkedList<SegmentImpl>();

    @Override
    public String getText() {
        if (this._segments.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (SegmentImpl s : this._segments) {
            sb.append(s.getText());
        }
        return sb.toString();
    }

    @Override
    public List<SRichText.Segment> getSegments() {
        return Collections.unmodifiableList(this._segments);
    }

    @Override
    public void addSegment(String text, SFont font) {
        Validations.argNotNull(text, font);
        if ("".equals(text)) {
            return;
        }
        this._segments.add(new SegmentImpl(text, font));
    }

    @Override
    public void clearSegments() {
        this._segments.clear();
    }

    @Override
    public SFont getFont() {
        if (this._segments.size() == 0) {
            return null;
        }
        return this._segments.get(0).getFont();
    }

    @Override
    public AbstractRichTextAdv clone() {
        RichTextImpl richText = new RichTextImpl();
        for (SegmentImpl s : this._segments) {
            richText.addSegment(s.getText(), s.getFont());
        }
        return richText;
    }
}

