/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.sys.dependency.Ref;

public class RefImpl
implements Ref,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Ref.RefType _type;
    protected final String bookName;
    protected final String sheetName;
    protected final String lastSheetName;
    private final int _row;
    private final int _column;
    private final int _lastRow;
    private final int _lastColumn;

    public RefImpl(String bookName, String sheetName, int row, int column, int lastRow, int lastColumn) {
        this(row == lastRow && column == lastColumn ? Ref.RefType.CELL : Ref.RefType.AREA, bookName, sheetName, null, row, column, lastRow, lastColumn);
    }

    public RefImpl(String bookName, String sheetName, int row, int column) {
        this(Ref.RefType.CELL, bookName, sheetName, null, row, column, row, column);
    }

    public RefImpl(String bookName, String sheetName, String lastSheetName, int row, int column, int lastRow, int lastColumn) {
        this(row == lastRow && column == lastColumn ? Ref.RefType.CELL : Ref.RefType.AREA, bookName, sheetName, lastSheetName, row, column, lastRow, lastColumn);
    }

    public RefImpl(String bookName, String sheetName, String lastSheetName, int row, int column) {
        this(Ref.RefType.CELL, bookName, sheetName, lastSheetName, row, column, row, column);
    }

    public RefImpl(String bookName, String sheetName) {
        this(Ref.RefType.SHEET, bookName, sheetName, null, -1, -1, -1, -1);
    }

    public RefImpl(String bookName) {
        this(Ref.RefType.BOOK, bookName, null, null, -1, -1, -1, -1);
    }

    public RefImpl(AbstractCellAdv cell) {
        this(Ref.RefType.CELL, cell.getSheet().getBook().getBookName(), cell.getSheet().getSheetName(), null, cell.getRowIndex(), cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex());
    }

    public RefImpl(AbstractSheetAdv sheet) {
        this(Ref.RefType.SHEET, ((AbstractBookAdv)sheet.getBook()).getBookName(), sheet.getSheetName(), null, -1, -1, -1, -1);
    }

    public RefImpl(AbstractBookAdv book) {
        this(Ref.RefType.BOOK, book.getBookName(), null, null, -1, -1, -1, -1);
    }

    protected RefImpl(Ref.RefType type, String bookName, String sheetName, String lastSheetName, int row, int column, int lastRow, int lastColumn) {
        this._type = type;
        this.bookName = bookName;
        this.sheetName = sheetName;
        this.lastSheetName = lastSheetName;
        this._row = row;
        this._column = column;
        this._lastRow = lastRow;
        this._lastColumn = lastColumn;
    }

    public Ref.RefType getType() {
        return this._type;
    }

    public String getBookName() {
        return this.bookName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getLastSheetName() {
        return this.lastSheetName;
    }

    public int getRow() {
        return this._row;
    }

    public int getColumn() {
        return this._column;
    }

    public int getLastRow() {
        return this._lastRow;
    }

    public int getLastColumn() {
        return this._lastColumn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bookName == null ? 0 : this.bookName.hashCode());
        result = 31 * result + this._column;
        result = 31 * result + this._lastColumn;
        result = 31 * result + this._lastRow;
        result = 31 * result + this._row;
        result = 31 * result + (this.sheetName == null ? 0 : this.sheetName.hashCode());
        result = 31 * result + (this.lastSheetName == null ? 0 : this.lastSheetName.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefImpl other = (RefImpl)obj;
        if (this.bookName == null ? other.bookName != null : !this.bookName.equals(other.bookName)) {
            return false;
        }
        if (this._column != other._column) {
            return false;
        }
        if (this._lastColumn != other._lastColumn) {
            return false;
        }
        if (this._lastRow != other._lastRow) {
            return false;
        }
        if (this._row != other._row) {
            return false;
        }
        if (this.sheetName == null ? other.sheetName != null : !this.sheetName.equals(other.sheetName)) {
            return false;
        }
        if (this.lastSheetName == null ? other.lastSheetName != null : !this.lastSheetName.equals(other.lastSheetName)) {
            return false;
        }
        return this._type == other._type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this._type) {
            case AREA: {
                sb.insert(0, ":" + new CellRegion(this._lastRow, this._lastColumn).getReferenceString());
            }
            case CELL: {
                sb.insert(0, new CellRegion(this._row, this._column).getReferenceString());
            }
            case SHEET: {
                if (this.lastSheetName != null) {
                    sb.insert(0, this.sheetName + ":" + this.lastSheetName + "!");
                    break;
                }
                sb.insert(0, this.sheetName + "!");
                break;
            }
            case OBJECT: {
                if (this.lastSheetName != null) {
                    sb.insert(0, this.sheetName + ":" + this.lastSheetName + "!");
                    break;
                }
                if (this.sheetName == null) break;
                sb.insert(0, this.sheetName + "!");
            }
        }
        sb.insert(0, this.bookName + ":");
        return sb.toString();
    }
}

