/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.SAutoFilter;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SName;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.SheetRegion;
import org.zkoss.zss.model.chart.SChartData;
import org.zkoss.zss.model.chart.SGeneralChartData;
import org.zkoss.zss.model.chart.SSeries;
import org.zkoss.zss.model.impl.AbstractAutoFilterAdv;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractDataValidationAdv;
import org.zkoss.zss.model.impl.AbstractNameAdv;
import org.zkoss.zss.model.impl.AbstractSeriesAdv;
import org.zkoss.zss.model.impl.ModelUpdateUtil;
import org.zkoss.zss.model.impl.chart.AbstractGeneralChartDataAdv;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.NameRef;
import org.zkoss.zss.model.sys.dependency.ObjectRef;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FormulaTunerHelper {
    private final SBookSeries _bookSeries;
    private FormulaEngine engine;

    public FormulaTunerHelper(SBookSeries bookSeries) {
        this._bookSeries = bookSeries;
    }

    public void move(SheetRegion sheetRegion, Set<Ref> dependents, int rowOffset, int columnOffset) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> cellDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<String, Ref> nameDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> filterDependents = new LinkedHashSet<Ref>();
        this.splitDependents(dependents, cellDependents, chartDependents, validationDependents, nameDependents, filterDependents);
        for (Ref dependent : cellDependents) {
            this.moveCellRef(sheetRegion, dependent, rowOffset, columnOffset);
        }
        for (Ref dependent : chartDependents.values()) {
            this.moveChartRef(sheetRegion, (ObjectRef)dependent, rowOffset, columnOffset);
        }
        for (Ref dependent : validationDependents.values()) {
            this.moveDataValidationRef(sheetRegion, (ObjectRef)dependent, rowOffset, columnOffset);
        }
        for (Ref dependent : nameDependents.values()) {
            this.moveNameRef(sheetRegion, (NameRef)dependent, rowOffset, columnOffset);
        }
        for (Ref dependent : filterDependents) {
            this.moveFilterRef(sheetRegion, (ObjectRef)dependent, rowOffset, columnOffset);
        }
    }

    private void moveChartRef(SheetRegion sheetRegion, ObjectRef dependent, int rowOffset, int columnOffset) {
        FormulaExpression exprAfter;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        SGeneralChartData data = (SGeneralChartData)d;
        FormulaExpression catExpr = ((AbstractGeneralChartDataAdv)((Object)data)).getCategoriesFormulaExpression();
        if (catExpr != null) {
            exprAfter = engine.movePtgs(catExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null));
            if (!exprAfter.hasError() && !catExpr.getFormulaString().equals(exprAfter.getFormulaString())) {
                ((AbstractGeneralChartDataAdv)((Object)data)).setCategoriesFormula(exprAfter);
            } else {
                data.clearFormulaResultCache();
            }
        }
        for (int i = 0; i < data.getNumOfSeries(); ++i) {
            SSeries series = data.getSeries(i);
            FormulaExpression nameExpr = ((AbstractSeriesAdv)series).getNameFormulaExpression();
            FormulaExpression xvalExpr = ((AbstractSeriesAdv)series).getXValuesFormulaExpression();
            FormulaExpression yvalExpr = ((AbstractSeriesAdv)series).getYValuesFormulaExpression();
            FormulaExpression zvalExpr = ((AbstractSeriesAdv)series).getZValuesFormulaExpression();
            boolean dirty = false;
            if (nameExpr != null && !(exprAfter = engine.movePtgs(nameExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError()) {
                dirty |= !nameExpr.getFormulaString().equals(exprAfter.getFormulaString());
                nameExpr = exprAfter;
            }
            if (xvalExpr != null && !(exprAfter = engine.movePtgs(xvalExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError()) {
                dirty |= !xvalExpr.getFormulaString().equals(exprAfter.getFormulaString());
                xvalExpr = exprAfter;
            }
            if (yvalExpr != null && !(exprAfter = engine.movePtgs(yvalExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError()) {
                dirty |= !yvalExpr.getFormulaString().equals(exprAfter.getFormulaString());
                yvalExpr = exprAfter;
            }
            if (zvalExpr != null && !(exprAfter = engine.movePtgs(zvalExpr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError()) {
                dirty |= !zvalExpr.getFormulaString().equals(exprAfter.getFormulaString());
                zvalExpr = exprAfter;
            }
            if (dirty) {
                ((AbstractSeriesAdv)series).setXYZFormula(nameExpr, xvalExpr, yvalExpr, zvalExpr);
                continue;
            }
            series.clearFormulaResultCache();
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void moveFilterRef(SheetRegion sheetRegion, ObjectRef dependent, int rowOffset, int columnOffset) {
        FormulaParseContext context;
        CellRegion region;
        String area;
        FormulaExpression fexpr;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SAutoFilter filter = sheet.getAutoFilter();
        if (filter == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression expr2 = engine.movePtgs(fexpr = engine.parse(area = (region = filter.getRegion()).getReferenceString(), context = new FormulaParseContext(sheet, null)), sheetRegion, rowOffset, columnOffset, context);
        if (!expr2.hasError() && !area.equals(expr2.getFormulaString())) {
            sheet.deleteAutoFilter();
            if (!"#REF!".equals(expr2.getFormulaString())) {
                CellRegion region2 = new CellRegion(expr2.getFormulaString());
                sheet.createAutoFilter(region2);
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void moveDataValidationRef(SheetRegion sheetRegion, ObjectRef dependent, int rowOffset, int columnOffset) {
        FormulaExpression exprf2;
        FormulaExpression exprf1;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression f1 = ((AbstractDataValidationAdv)validation).getFormulaExpression1();
        FormulaExpression f2 = ((AbstractDataValidationAdv)validation).getFormulaExpression2();
        boolean changed = false;
        if (f1 != null && !(exprf1 = engine.movePtgs(f1, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
            f1 = exprf1;
            changed = true;
        }
        if (f2 != null && !(exprf2 = engine.movePtgs(f2, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
            f2 = exprf2;
            changed = true;
        }
        if (changed) {
            ((AbstractDataValidationAdv)validation).setFormulas(f1, f2);
        } else {
            validation.clearFormulaResultCache();
        }
        for (CellRegion region : validation.getRegions()) {
            FormulaParseContext context;
            String sqref = region.getReferenceString();
            FormulaExpression fexpr = engine.parse(sqref, context = new FormulaParseContext(sheet, null));
            FormulaExpression expr2 = engine.movePtgs(fexpr, sheetRegion, rowOffset, columnOffset, context);
            if (expr2.hasError() || sqref.equals(expr2.getFormulaString())) continue;
            if ("#REF!".equals(expr2.getFormulaString())) {
                ((AbstractDataValidationAdv)validation).removeRegion(region);
                if (validation.getRegions() != null) continue;
                sheet.deleteDataValidation(validation);
                continue;
            }
            region = new CellRegion(expr2.getFormulaString());
            ((AbstractDataValidationAdv)validation).addRegion(region);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void moveCellRef(SheetRegion sheetRegion, Ref dependent, int rowOffset, int columnOffset) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression expr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.movePtgs(expr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(cell, null));
        if (!expr.getFormulaString().equals(exprAfter.getFormulaString())) {
            cell.setValue(exprAfter);
        } else {
            cell.clearFormulaResultCache();
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    private void moveNameRef(SheetRegion sheetRegion, NameRef dependent, int rowOffset, int columnOffset) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SName name = book.getNameByName(dependent.getNameName());
        if (name == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(name.getRefersToSheetName());
        if (sheet == null) {
            return;
        }
        FormulaExpression expr = ((AbstractNameAdv)name).getRefersToFormulaExpression();
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.movePtgs(expr, sheetRegion, rowOffset, columnOffset, new FormulaParseContext(sheet, null));
        if (!expr.getFormulaString().equals(exprAfter.getFormulaString())) {
            ((AbstractNameAdv)name).setRefersToFormula(exprAfter);
        } else {
            this.clearFormulaCache(dependent);
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    private FormulaEngine getFormulaEngine() {
        if (this.engine == null) {
            this.engine = EngineFactory.getInstance().createFormulaEngine();
        }
        return this.engine;
    }

    public void extend(SheetRegion sheetRegion, Set<Ref> dependents, boolean horizontal) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> cellDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<String, Ref> nameDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> filterDependents = new LinkedHashSet<Ref>();
        this.splitDependents(dependents, cellDependents, chartDependents, validationDependents, nameDependents, filterDependents);
        for (Ref dependent : cellDependents) {
            this.extendCellRef(sheetRegion, dependent, horizontal);
        }
        for (Ref dependent : chartDependents.values()) {
            this.extendChartRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : validationDependents.values()) {
            this.extendDataValidationRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : nameDependents.values()) {
            this.extendNameRef(sheetRegion, (NameRef)dependent, horizontal);
        }
        for (Ref dependent : filterDependents) {
            this.extendFilterRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
    }

    private void extendChartRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        SGeneralChartData data = (SGeneralChartData)d;
        FormulaEngine engine = this.getFormulaEngine();
        for (int i = 0; i < data.getNumOfSeries(); ++i) {
            FormulaExpression expr2;
            SSeries series = data.getSeries(i);
            if (series == null) continue;
            boolean changed = false;
            series.clearFormulaResultCache();
            FormulaExpression nf = ((AbstractSeriesAdv)series).getNameFormulaExpression();
            FormulaExpression xf = ((AbstractSeriesAdv)series).getXValuesFormulaExpression();
            FormulaExpression yf = ((AbstractSeriesAdv)series).getYValuesFormulaExpression();
            FormulaExpression zf = ((AbstractSeriesAdv)series).getZValuesFormulaExpression();
            if (nf != null && !(expr2 = engine.extendPtgs(nf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !nf.getFormulaString().equals(expr2.getFormulaString())) {
                nf = expr2;
                changed = true;
            }
            if (xf != null && !(expr2 = engine.extendPtgs(xf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !xf.getFormulaString().equals(expr2.getFormulaString())) {
                xf = expr2;
                changed = true;
            }
            if (yf != null && !(expr2 = engine.extendPtgs(yf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !yf.getFormulaString().equals(expr2.getFormulaString())) {
                yf = expr2;
                changed = true;
            }
            if (zf != null && !(expr2 = engine.extendPtgs(zf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !zf.getFormulaString().equals(expr2.getFormulaString())) {
                zf = expr2;
                changed = true;
            }
            if (changed) {
                ((AbstractSeriesAdv)series).setXYZFormula(nf, xf, yf, zf);
                continue;
            }
            series.clearFormulaResultCache();
        }
        FormulaExpression expr = ((AbstractGeneralChartDataAdv)((Object)data)).getCategoriesFormulaExpression();
        if (expr != null) {
            FormulaExpression exprAfter = engine.extendPtgs(expr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
            if (!exprAfter.hasError() && !expr.getFormulaString().equals(exprAfter.getFormulaString())) {
                ((AbstractGeneralChartDataAdv)((Object)data)).setCategoriesFormula(exprAfter);
            } else {
                data.clearFormulaResultCache();
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void extendDataValidationRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        FormulaExpression exprf2;
        FormulaExpression exprf1;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression f1 = ((AbstractDataValidationAdv)validation).getFormulaExpression1();
        FormulaExpression f2 = ((AbstractDataValidationAdv)validation).getFormulaExpression2();
        boolean changed = false;
        if (f1 != null && !(exprf1 = engine.extendPtgs(f1, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
            f1 = exprf1;
            changed = true;
        }
        if (f2 != null && !(exprf2 = engine.extendPtgs(f2, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
            f2 = exprf2;
            changed = true;
        }
        if (changed) {
            ((AbstractDataValidationAdv)validation).setFormulas(f1, f2);
        } else {
            validation.clearFormulaResultCache();
        }
        FormulaParseContext context = new FormulaParseContext(sheet, null);
        for (CellRegion region : validation.getRegions()) {
            String sqref = region.getReferenceString();
            FormulaExpression fexpr = engine.parse(sqref, context);
            FormulaExpression expr2 = engine.extendPtgs(fexpr, sheetRegion, horizontal, context);
            if (expr2.hasError() || sqref.equals(expr2.getFormulaString())) continue;
            if ("#REF!".equals(expr2.getFormulaString())) {
                ((AbstractDataValidationAdv)validation).removeRegion(region);
                if (validation.getRegions() != null) continue;
                sheet.deleteDataValidation(validation);
                continue;
            }
            region = new CellRegion(expr2.getFormulaString());
            ((AbstractDataValidationAdv)validation).addRegion(region);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void extendFilterRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        FormulaParseContext context;
        CellRegion region;
        String area;
        FormulaExpression fexpr;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SAutoFilter filter = sheet.getAutoFilter();
        if (filter == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression expr2 = engine.extendPtgs(fexpr = engine.parse(area = (region = filter.getRegion()).getReferenceString(), context = new FormulaParseContext(sheet, null)), sheetRegion, horizontal, context);
        if (!expr2.hasError() && !area.equals(expr2.getFormulaString())) {
            sheet.deleteAutoFilter();
            if (!"#REF!".equals(expr2.getFormulaString())) {
                CellRegion region2 = new CellRegion(expr2.getFormulaString());
                sheet.createAutoFilter(region2);
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void extendCellRef(SheetRegion sheetRegion, Ref dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression fexpr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.extendPtgs(fexpr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
        if (!fexpr.getFormulaString().equals(exprAfter.getFormulaString())) {
            cell.setValue(exprAfter);
        } else {
            cell.clearFormulaResultCache();
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    private void extendNameRef(SheetRegion sheetRegion, NameRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SName name = book.getNameByName(dependent.getNameName());
        if (name == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(name.getRefersToSheetName());
        if (sheet == null) {
            return;
        }
        FormulaExpression expr = ((AbstractNameAdv)name).getRefersToFormulaExpression();
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.extendPtgs(expr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
        if (!expr.getFormulaString().equals(exprAfter.getFormulaString())) {
            ((AbstractNameAdv)name).setRefersToFormula(exprAfter);
        } else {
            this.clearFormulaCache(dependent);
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    public void shrink(SheetRegion sheetRegion, Set<Ref> dependents, boolean horizontal) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> cellDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<String, Ref> nameDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> filterDependents = new LinkedHashSet<Ref>();
        this.splitDependents(dependents, cellDependents, chartDependents, validationDependents, nameDependents, filterDependents);
        for (Ref dependent : cellDependents) {
            this.shrinkCellRef(sheetRegion, dependent, horizontal);
        }
        for (Ref dependent : chartDependents.values()) {
            this.shrinkChartRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : validationDependents.values()) {
            this.shrinkDataValidationRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
        for (Ref dependent : nameDependents.values()) {
            this.shrinkNameRef(sheetRegion, (NameRef)dependent, horizontal);
        }
        for (Ref dependent : filterDependents) {
            this.shrinkFilterRef(sheetRegion, (ObjectRef)dependent, horizontal);
        }
    }

    private void shrinkChartRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        SGeneralChartData data = (SGeneralChartData)d;
        FormulaEngine engine = this.getFormulaEngine();
        for (int i = 0; i < data.getNumOfSeries(); ++i) {
            FormulaExpression expr2;
            SSeries series = data.getSeries(i);
            if (series == null) continue;
            boolean changed = false;
            series.clearFormulaResultCache();
            FormulaExpression nf = ((AbstractSeriesAdv)series).getNameFormulaExpression();
            FormulaExpression xf = ((AbstractSeriesAdv)series).getXValuesFormulaExpression();
            FormulaExpression yf = ((AbstractSeriesAdv)series).getYValuesFormulaExpression();
            FormulaExpression zf = ((AbstractSeriesAdv)series).getZValuesFormulaExpression();
            if (nf != null && !(expr2 = engine.shrinkPtgs(nf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !nf.getFormulaString().equals(expr2.getFormulaString())) {
                nf = expr2;
                changed = true;
            }
            if (xf != null && !(expr2 = engine.shrinkPtgs(xf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !xf.getFormulaString().equals(expr2.getFormulaString())) {
                xf = expr2;
                changed = true;
            }
            if (yf != null && !(expr2 = engine.shrinkPtgs(yf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !yf.getFormulaString().equals(expr2.getFormulaString())) {
                yf = expr2;
                changed = true;
            }
            if (zf != null && !(expr2 = engine.shrinkPtgs(zf, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !zf.getFormulaString().equals(expr2.getFormulaString())) {
                zf = expr2;
                changed = true;
            }
            if (changed) {
                ((AbstractSeriesAdv)series).setXYZFormula(nf, xf, yf, zf);
                continue;
            }
            series.clearFormulaResultCache();
        }
        FormulaExpression expr = ((AbstractGeneralChartDataAdv)((Object)data)).getCategoriesFormulaExpression();
        if (expr != null) {
            FormulaExpression exprAfter = engine.shrinkPtgs(expr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
            if (!exprAfter.hasError() && !expr.getFormulaString().equals(exprAfter.getFormulaString())) {
                ((AbstractGeneralChartDataAdv)((Object)data)).setCategoriesFormula(exprAfter);
            } else {
                data.clearFormulaResultCache();
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void shrinkDataValidationRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        FormulaExpression exprf2;
        FormulaExpression exprf1;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression f1 = ((AbstractDataValidationAdv)validation).getFormulaExpression1();
        FormulaExpression f2 = ((AbstractDataValidationAdv)validation).getFormulaExpression2();
        boolean changed = false;
        if (f1 != null && !(exprf1 = engine.shrinkPtgs(f1, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
            f1 = exprf1;
            changed = true;
        }
        if (f2 != null && !(exprf2 = engine.shrinkPtgs(f2, sheetRegion, horizontal, new FormulaParseContext(sheet, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
            f2 = exprf2;
            changed = true;
        }
        if (changed) {
            ((AbstractDataValidationAdv)validation).setFormulas(f1, f2);
        } else {
            validation.clearFormulaResultCache();
        }
        for (CellRegion region : validation.getRegions()) {
            FormulaParseContext context;
            String sqref = region.getReferenceString();
            FormulaExpression fexpr = engine.parse(sqref, context = new FormulaParseContext(sheet, null));
            FormulaExpression expr2 = engine.shrinkPtgs(fexpr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
            if (expr2.hasError() || sqref.equals(expr2.getFormulaString())) continue;
            if ("#REF!".equals(expr2.getFormulaString())) {
                ((AbstractDataValidationAdv)validation).removeRegion(region);
                if (validation.getRegions() != null) continue;
                sheet.deleteDataValidation(validation);
                continue;
            }
            region = new CellRegion(expr2.getFormulaString());
            ((AbstractDataValidationAdv)validation).addRegion(region);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void shrinkFilterRef(SheetRegion sheetRegion, ObjectRef dependent, boolean horizontal) {
        FormulaParseContext context;
        CellRegion region;
        String area;
        FormulaExpression fexpr;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SAutoFilter filter = sheet.getAutoFilter();
        if (filter == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression expr2 = engine.shrinkPtgs(fexpr = engine.parse(area = (region = filter.getRegion()).getReferenceString(), context = new FormulaParseContext(sheet, null)), sheetRegion, horizontal, context);
        if (!expr2.hasError() && !area.equals(expr2.getFormulaString())) {
            sheet.deleteAutoFilter();
            if (!"#REF!".equals(expr2.getFormulaString())) {
                CellRegion region2 = new CellRegion(expr2.getFormulaString());
                sheet.createAutoFilter(region2);
            }
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void shrinkCellRef(SheetRegion sheetRegion, Ref dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression fexpr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.shrinkPtgs(fexpr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
        if (!fexpr.getFormulaString().equals(exprAfter.getFormulaString())) {
            cell.setValue(exprAfter);
        } else {
            cell.clearFormulaResultCache();
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    private void shrinkNameRef(SheetRegion sheetRegion, NameRef dependent, boolean horizontal) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SName name = book.getNameByName(dependent.getNameName());
        if (name == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(name.getRefersToSheetName());
        if (sheet == null) {
            return;
        }
        FormulaExpression expr = ((AbstractNameAdv)name).getRefersToFormulaExpression();
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.shrinkPtgs(expr, sheetRegion, horizontal, new FormulaParseContext(sheet, null));
        if (!expr.getFormulaString().equals(exprAfter.getFormulaString())) {
            ((AbstractNameAdv)name).setRefersToFormula(exprAfter);
        } else {
            this.clearFormulaCache(dependent);
            ModelUpdateUtil.addRefUpdate(dependent);
        }
    }

    public void renameSheet(SBook book, String oldName, String newName, Set<Ref> dependents) {
        LinkedHashMap<String, Ref> chartDependents = new LinkedHashMap<String, Ref>();
        LinkedHashMap<String, Ref> validationDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> cellDependents = new LinkedHashSet<Ref>();
        LinkedHashMap<String, Ref> nameDependents = new LinkedHashMap<String, Ref>();
        LinkedHashSet<Ref> filterDependents = new LinkedHashSet<Ref>();
        this.splitDependents(dependents, cellDependents, chartDependents, validationDependents, nameDependents, filterDependents);
        for (Ref dependent : cellDependents) {
            this.renameSheetCellRef(book, oldName, newName, dependent);
        }
        for (Ref dependent : chartDependents.values()) {
            this.renameSheetChartRef(book, oldName, newName, (ObjectRef)dependent);
        }
        for (Ref dependent : validationDependents.values()) {
            this.renameSheetDataValidationRef(book, oldName, newName, (ObjectRef)dependent);
        }
        for (Ref dependent : nameDependents.values()) {
            this.renameSheetNameRef(book, oldName, newName, (NameRef)dependent);
        }
        for (Ref dependent : filterDependents) {
            this.renameSheetFilterRef(book, oldName, newName, (ObjectRef)dependent);
        }
    }

    private void renameSheetChartRef(SBook bookOfSheet, String oldName, String newName, ObjectRef dependent) {
        FormulaExpression exprAfter;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        String sheetName = null;
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            if (oldName.equals(dependent.getSheetName())) {
                sheet = book.getSheetByName(newName);
                sheetName = oldName;
            }
        } else {
            sheetName = sheet.getSheetName();
        }
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        SGeneralChartData data = (SGeneralChartData)d;
        FormulaExpression catExpr = ((AbstractGeneralChartDataAdv)((Object)data)).getCategoriesFormulaExpression();
        if (catExpr != null && !(exprAfter = engine.renameSheetPtgs(catExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
            ((AbstractGeneralChartDataAdv)((Object)data)).setCategoriesFormula(exprAfter);
        }
        for (int i = 0; i < data.getNumOfSeries(); ++i) {
            SSeries series = data.getSeries(i);
            FormulaExpression nameExpr = ((AbstractSeriesAdv)series).getNameFormulaExpression();
            FormulaExpression xvalExpr = ((AbstractSeriesAdv)series).getXValuesFormulaExpression();
            FormulaExpression yvalExpr = ((AbstractSeriesAdv)series).getYValuesFormulaExpression();
            FormulaExpression zvalExpr = ((AbstractSeriesAdv)series).getZValuesFormulaExpression();
            if (nameExpr != null && !(exprAfter = engine.renameSheetPtgs(nameExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                nameExpr = exprAfter;
            }
            if (xvalExpr != null && !(exprAfter = engine.renameSheetPtgs(xvalExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                xvalExpr = exprAfter;
            }
            if (yvalExpr != null && !(exprAfter = engine.renameSheetPtgs(yvalExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                yvalExpr = exprAfter;
            }
            if (zvalExpr != null && !(exprAfter = engine.renameSheetPtgs(zvalExpr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError()) {
                zvalExpr = exprAfter;
            }
            ((AbstractSeriesAdv)series).setXYZFormula(nameExpr, xvalExpr, yvalExpr, zvalExpr);
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void renameSheetDataValidationRef(SBook bookOfSheet, String oldName, String newName, ObjectRef dependent) {
        FormulaExpression exprf2;
        FormulaExpression exprf1;
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        String sheetName = null;
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            if (oldName.equals(dependent.getSheetName())) {
                sheet = book.getSheetByName(newName);
                sheetName = oldName;
            }
        } else {
            sheetName = sheet.getSheetName();
        }
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression f1 = ((AbstractDataValidationAdv)validation).getFormulaExpression1();
        FormulaExpression f2 = ((AbstractDataValidationAdv)validation).getFormulaExpression2();
        boolean changed = false;
        if (f1 != null && !(exprf1 = engine.renameSheetPtgs(f1, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() && !f1.getFormulaString().equals(exprf1.getFormulaString())) {
            f1 = exprf1;
            changed = true;
        }
        if (f2 != null && !(exprf2 = engine.renameSheetPtgs(f2, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null))).hasError() && !f2.getFormulaString().equals(exprf2.getFormulaString())) {
            f2 = exprf2;
            changed = true;
        }
        if (changed) {
            ((AbstractDataValidationAdv)validation).setFormulas(f1, f2);
        } else {
            validation.clearFormulaResultCache();
        }
        ((AbstractDataValidationAdv)validation).renameSheet(oldName, newName);
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void renameSheetFilterRef(SBook bookOfSheet, String oldName, String newName, ObjectRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null && oldName.equals(dependent.getSheetName())) {
            sheet = book.getSheetByName(newName);
        }
        if (sheet == null) {
            return;
        }
        SAutoFilter filter = sheet.getAutoFilter();
        if (filter == null) {
            return;
        }
        ((AbstractAutoFilterAdv)filter).renameSheet(book, oldName, newName);
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void renameSheetCellRef(SBook bookOfSheet, String oldName, String newName, Ref dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        String sheetName = null;
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            if (oldName.equals(dependent.getSheetName())) {
                sheet = book.getSheetByName(newName);
                sheetName = oldName;
            }
        } else {
            sheetName = sheet.getSheetName();
        }
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression expr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.renameSheetPtgs(expr, bookOfSheet, oldName, newName, new FormulaParseContext(cell, sheetName, null));
        cell.setValue(exprAfter);
    }

    private void renameSheetNameRef(SBook bookOfSheet, String oldName, String newName, NameRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SName name = book.getNameByName(dependent.getNameName());
        if (name == null) {
            return;
        }
        String sheetName = null;
        SSheet sheet = book.getSheetByName(name.getRefersToSheetName());
        if (sheet == null) {
            if (oldName.equals(name.getRefersToSheetName())) {
                sheet = book.getSheetByName(newName);
                sheetName = oldName;
            }
        } else {
            sheetName = sheet.getSheetName();
        }
        if (sheet == null) {
            return;
        }
        FormulaExpression expr = ((AbstractNameAdv)name).getRefersToFormulaExpression();
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.renameSheetPtgs(expr, bookOfSheet, oldName, newName, new FormulaParseContext(sheet, sheetName, null));
        ((AbstractNameAdv)name).setRefersToFormula(exprAfter);
    }

    public void renameName(SBook book, String oldName, String newName, Set<Ref> dependents, int sheetIndex) {
        for (Ref dependent : dependents) {
            if (dependent.getType() != Ref.RefType.CELL) continue;
            this.renameNameCellRef(book, oldName, newName, dependent, sheetIndex);
        }
    }

    private void renameNameCellRef(SBook bookOfSheet, String oldName, String newName, Ref dependent, int sheetIndex) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        FormulaExpression expr = (FormulaExpression)((AbstractCellAdv)cell).getValue(false);
        FormulaEngine engine = this.getFormulaEngine();
        FormulaExpression exprAfter = engine.renameNamePtgs(expr, bookOfSheet, sheetIndex, oldName, newName, new FormulaParseContext(cell, null));
        cell.setValue(exprAfter);
    }

    private void splitDependents(Set<Ref> dependents, Set<Ref> cellDependents, Map<String, Ref> chartDependents, Map<String, Ref> validationDependents, Map<String, Ref> nameDependents, Set<Ref> filterDependents) {
        for (Ref dependent : dependents) {
            Ref.RefType type = dependent.getType();
            if (type == Ref.RefType.CELL) {
                cellDependents.add(dependent);
                continue;
            }
            if (type == Ref.RefType.OBJECT) {
                if (((ObjectRef)dependent).getObjectType() == ObjectRef.ObjectType.CHART) {
                    chartDependents.put(((ObjectRef)dependent).getObjectIdPath()[0], dependent);
                    continue;
                }
                if (((ObjectRef)dependent).getObjectType() == ObjectRef.ObjectType.DATA_VALIDATION) {
                    validationDependents.put(((ObjectRef)dependent).getObjectIdPath()[0], dependent);
                    continue;
                }
                if (((ObjectRef)dependent).getObjectType() != ObjectRef.ObjectType.AUTO_FILTER) continue;
                filterDependents.add(dependent);
                continue;
            }
            if (type != Ref.RefType.NAME) continue;
            nameDependents.put(((NameRef)dependent).toString(), dependent);
        }
    }

    private void clearFormulaCache(NameRef precedent) {
        HashMap<String, Ref> chartDependents = new HashMap<String, Ref>();
        HashMap<String, Ref> validationDependents = new HashMap<String, Ref>();
        HashSet<Ref> nameDependents = new HashSet<Ref>();
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this._bookSeries;
        DependencyTable dt = bs.getDependencyTable();
        this.clearFormulaCache(precedent, dt, chartDependents, validationDependents, nameDependents);
        for (Ref dependent : chartDependents.values()) {
            this.clearFormulaCacheChartRef((ObjectRef)dependent);
        }
        for (Ref dependent : validationDependents.values()) {
            this.clearFormulaCacheDataValidationRef((ObjectRef)dependent);
        }
    }

    private void clearFormulaCache(NameRef precedent, DependencyTable dt, Map<String, Ref> chartDependents, Map<String, Ref> validationDependents, Set<Ref> nameDependents) {
        Set<Ref> dependents = dt.getDependents(precedent);
        for (Ref dependent : dependents) {
            Ref.RefType type = dependent.getType();
            if (type == Ref.RefType.CELL) {
                this.clearFormulaCacheCellRef(dependent);
                continue;
            }
            if (type == Ref.RefType.OBJECT) {
                if (((ObjectRef)dependent).getObjectType() == ObjectRef.ObjectType.CHART) {
                    chartDependents.put(((ObjectRef)dependent).getObjectIdPath()[0], dependent);
                    continue;
                }
                if (((ObjectRef)dependent).getObjectType() != ObjectRef.ObjectType.DATA_VALIDATION) continue;
                validationDependents.put(((ObjectRef)dependent).getObjectIdPath()[0], dependent);
                continue;
            }
            if (type != Ref.RefType.NAME || nameDependents.contains(dependent)) continue;
            nameDependents.add(dependent);
            this.clearFormulaCache((NameRef)dependent, dt, chartDependents, validationDependents, nameDependents);
        }
    }

    private void clearFormulaCacheDataValidationRef(ObjectRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SDataValidation validation = sheet.getDataValidation(dependent.getObjectIdPath()[0]);
        if (validation == null) {
            return;
        }
        validation.clearFormulaResultCache();
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void clearFormulaCacheChartRef(ObjectRef dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SChart chart = sheet.getChart(dependent.getObjectIdPath()[0]);
        if (chart == null) {
            return;
        }
        SChartData d = chart.getData();
        if (!(d instanceof SGeneralChartData)) {
            return;
        }
        SGeneralChartData data = (SGeneralChartData)d;
        data.clearFormulaResultCache();
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void clearFormulaCacheCellRef(Ref dependent) {
        SBook book = this._bookSeries.getBook(dependent.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(dependent.getSheetName());
        if (sheet == null) {
            return;
        }
        SCell cell = sheet.getCell(dependent.getRow(), dependent.getColumn());
        if (cell.getType() != SCell.CellType.FORMULA) {
            return;
        }
        cell.clearFormulaResultCache();
        ModelUpdateUtil.addRefUpdate(dependent);
    }
}

