/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.SBook;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SDataValidation;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractDataValidationAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.EvaluationUtil;
import org.zkoss.zss.model.impl.ModelUpdateUtil;
import org.zkoss.zss.model.impl.ObjectRefImpl;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.impl.sys.DependencyTableAdv;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.ObjectRef;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.EvaluationResult;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaEvaluationContext;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;
import org.zkoss.zss.model.util.Validations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataValidationImpl
extends AbstractDataValidationAdv {
    private static final long serialVersionUID = 1L;
    private AbstractSheetAdv _sheet;
    private final String _id;
    private SDataValidation.AlertStyle _alertStyle = SDataValidation.AlertStyle.STOP;
    private boolean _ignoreBlank = true;
    private boolean _showInCellDropdown;
    private boolean _showInput;
    private boolean _showError;
    private String _inputTitle;
    private String _inputMessage;
    private String _errorTitle;
    private String _errorMessage;
    private Set<CellRegion> _regions;
    private SDataValidation.ValidationType _validationType = SDataValidation.ValidationType.ANY;
    private SDataValidation.OperatorType _operatorType = SDataValidation.OperatorType.BETWEEN;
    private FormulaExpression _formula1Expr;
    private FormulaExpression _formula2Expr;
    private Object _evalValue1Result;
    private Object _evalValue2Result;
    private boolean _evaluated = false;

    public DataValidationImpl(AbstractSheetAdv sheet, String id) {
        this._sheet = sheet;
        this._id = id;
    }

    public boolean isEmpty() {
        return this._validationType == SDataValidation.ValidationType.ANY && this._inputTitle == null && this._inputMessage == null && this._errorTitle == null && this._errorMessage == null;
    }

    public DataValidationImpl(AbstractSheetAdv sheet, AbstractDataValidationAdv copyFrom) {
        this(sheet, (String)null);
        if (copyFrom != null) {
            this.copyFrom(copyFrom);
        }
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public SSheet getSheet() {
        return this._sheet;
    }

    @Override
    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        this.clearFormulaDependency(true);
        this.clearFormulaResultCache();
        this._sheet = null;
    }

    @Override
    public SDataValidation.AlertStyle getAlertStyle() {
        return this._alertStyle;
    }

    @Override
    public void setAlertStyle(SDataValidation.AlertStyle alertStyle) {
        Validations.argNotNull(new Object[]{alertStyle});
        this._alertStyle = alertStyle;
    }

    @Override
    public void setIgnoreBlank(boolean allowed) {
        this._ignoreBlank = allowed;
    }

    @Override
    public boolean isIgnoreBlank() {
        return this._ignoreBlank;
    }

    @Override
    public void setInCellDropdown(boolean show) {
        this._showInCellDropdown = show;
    }

    @Override
    public boolean isInCellDropdown() {
        return this._showInCellDropdown;
    }

    @Override
    public void setShowInput(boolean show) {
        this._showInput = show;
    }

    @Override
    public boolean isShowInput() {
        return this._showInput;
    }

    @Override
    public void setShowError(boolean show) {
        this._showError = show;
    }

    @Override
    public boolean isShowError() {
        return this._showError;
    }

    @Override
    public void setInputTitle(String title) {
        this._inputTitle = title;
    }

    @Override
    public void setInputMessage(String message) {
        this._inputMessage = message;
    }

    @Override
    public String getInputTitle() {
        return this._inputTitle;
    }

    @Override
    public String getInputMessage() {
        return this._inputMessage;
    }

    @Override
    public void setErrorTitle(String title) {
        this._errorTitle = title;
    }

    @Override
    public void setErrorMessage(String text) {
        this._errorMessage = text;
    }

    @Override
    public String getErrorTitle() {
        return this._errorTitle;
    }

    @Override
    public String getErrorMessage() {
        return this._errorMessage;
    }

    @Override
    public Set<CellRegion> getRegions() {
        return this._regions;
    }

    @Override
    public void addRegion(CellRegion region) {
        Validations.argNotNull(region);
        if (this._regions == null) {
            this._regions = new HashSet<CellRegion>(2);
        }
        for (CellRegion regn : this._regions) {
            if (!regn.contains(region)) continue;
            return;
        }
        this._regions.add(region);
        Ref dependent = this.getRef();
        SBook book = this._sheet.getBook();
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        dt.add(dependent, this.newDummyRef(region));
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    @Override
    public void removeRegion(CellRegion region) {
        Validations.argNotNull(region);
        if (this._regions == null || this._regions.isEmpty()) {
            return;
        }
        ArrayList<CellRegion> newRegions = new ArrayList<CellRegion>();
        ArrayList<CellRegion> delRegions = new ArrayList<CellRegion>();
        for (CellRegion regn : this._regions) {
            if (!regn.overlaps(region)) continue;
            newRegions.addAll(regn.diff(region));
            delRegions.add(regn);
        }
        if (newRegions.isEmpty() && delRegions.isEmpty()) {
            return;
        }
        Ref dependent = this.getRef();
        SBook book = this._sheet.getBook();
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        Set<Ref> precedents = ((DependencyTableAdv)dt).getDirectPrecedents(dependent);
        dt.clearDependents(dependent);
        for (CellRegion regn : delRegions) {
            this._regions.remove(regn);
            precedents.remove(this.newDummyRef(regn));
        }
        if (precedents != null) {
            for (Ref precedent : precedents) {
                dt.add(dependent, precedent);
            }
        }
        for (CellRegion regn : newRegions) {
            this._regions.add(regn);
            dt.add(dependent, this.newDummyRef(regn));
        }
        if (this._regions.isEmpty()) {
            this._regions = null;
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    @Override
    public void setRegions(Set<CellRegion> regions) {
        this._regions = new HashSet<CellRegion>(regions.size() * 4 / 3 + 1);
        for (CellRegion rgn : regions) {
            this.addRegion(rgn);
        }
    }

    @Override
    public SDataValidation.ValidationType getValidationType() {
        return this._validationType;
    }

    @Override
    public void setValidationType(SDataValidation.ValidationType type) {
        Validations.argNotNull(new Object[]{type});
        this._validationType = type;
    }

    @Override
    public SDataValidation.OperatorType getOperatorType() {
        return this._operatorType;
    }

    @Override
    public void setOperatorType(SDataValidation.OperatorType type) {
        Validations.argNotNull(new Object[]{type});
        this._operatorType = type;
    }

    @Override
    public boolean isFormulaParsingError() {
        boolean r = false;
        if (this._formula1Expr != null) {
            r |= this._formula1Expr.hasError();
        }
        if (!r && this._formula2Expr != null) {
            r |= this._formula2Expr.hasError();
        }
        return r;
    }

    @Override
    public int getNumOfValue() {
        return this.getNumOfValue1();
    }

    @Override
    public Object getValue(int index) {
        return this.getValue1(index);
    }

    @Override
    public int getNumOfValue1() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalValue1Result);
    }

    @Override
    public Object getValue1(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalValue1Result)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalValue1Result, index);
    }

    @Override
    public int getNumOfValue2() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalValue2Result);
    }

    @Override
    public Object getValue2(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalValue2Result)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalValue2Result, index);
    }

    @Override
    public String getFormula1() {
        return this._formula1Expr == null ? null : this._formula1Expr.getFormulaString();
    }

    @Override
    public String getFormula2() {
        return this._formula2Expr == null ? null : this._formula2Expr.getFormulaString();
    }

    private void clearFormulaDependency(boolean all) {
        if (this._formula1Expr != null || this._formula2Expr != null) {
            Ref dependent = this.getRef();
            DependencyTable dt = ((AbstractBookSeriesAdv)this._sheet.getBook().getBookSeries()).getDependencyTable();
            dt.clearDependents(dependent);
            if (!all && this._regions != null) {
                for (CellRegion regn : this._regions) {
                    dt.add(dependent, this.newDummyRef(regn));
                }
            }
        }
    }

    private Ref getRef() {
        return new ObjectRefImpl(this, this._id);
    }

    private Ref getRef(String sheetName) {
        return new ObjectRefImpl(this._sheet.getBook().getBookName(), sheetName, this._id, ObjectRef.ObjectType.DATA_VALIDATION);
    }

    private Ref newDummyRef(CellRegion regn) {
        return new RefImpl(this._sheet.getBook().getBookName(), this._sheet.getSheetName(), regn.row, regn.column, regn.lastRow, regn.lastColumn);
    }

    private Ref newDummyRef(String sheetName, CellRegion regn) {
        return new RefImpl(this._sheet.getBook().getBookName(), sheetName, regn.row, regn.column, regn.lastRow, regn.lastColumn);
    }

    @Override
    public void setFormula1(String formula1) {
        this.setFormulas(formula1, this._formula2Expr == null ? null : this._formula2Expr.getFormulaString());
    }

    @Override
    public void setFormula2(String formula2) {
        this.setFormulas(this._formula1Expr == null ? null : this._formula1Expr.getFormulaString(), formula2);
    }

    @Override
    public void setFormulas(String formula1, String formula2) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency(false);
        this.clearFormulaResultCache();
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        Ref ref = this.getRef();
        this._formula1Expr = formula1 != null ? fe.parse(formula1, new FormulaParseContext(this._sheet, ref)) : null;
        this._formula2Expr = formula2 != null ? fe.parse(formula2, new FormulaParseContext(this._sheet, ref)) : null;
    }

    @Override
    public void clearFormulaResultCache() {
        this._evaluated = false;
        this._evalValue2Result = null;
        this._evalValue1Result = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalFormula() {
        if (this._evaluated) {
            return;
        }
        DataValidationImpl dataValidationImpl = this;
        synchronized (dataValidationImpl) {
            if (!this._evaluated) {
                Object val;
                EvaluationResult result;
                Ref ref = this.getRef();
                FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
                if (this._formula1Expr != null) {
                    result = fe.evaluate(this._formula1Expr, new FormulaEvaluationContext(this._sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalValue1Result = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        Object object = this._evalValue1Result = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                if (this._formula2Expr != null) {
                    result = fe.evaluate(this._formula2Expr, new FormulaEvaluationContext(this._sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalValue2Result = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        this._evalValue2Result = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                this._evaluated = true;
            }
        }
    }

    @Override
    public List<SCell> getReferToCellList() {
        if (this._formula1Expr != null && this._formula1Expr.isAreaRefs()) {
            LinkedList<SCell> list = new LinkedList<SCell>();
            SBookSeries bookSeries = this._sheet.getBook().getBookSeries();
            Ref areaRef = this._formula1Expr.getAreaRefs()[0];
            String bookName = areaRef.getBookName();
            String sheetName = areaRef.getSheetName();
            CellRegion region = new CellRegion(areaRef.getRow(), areaRef.getColumn(), areaRef.getLastRow(), areaRef.getLastColumn());
            SBook book = bookSeries.getBook(bookName);
            if (book == null) {
                return list;
            }
            SSheet sheet = book.getSheetByName(sheetName);
            if (sheet == null) {
                return list;
            }
            for (int i = region.getRow(); i <= region.getLastRow(); ++i) {
                for (int j = region.getColumn(); j <= region.getLastColumn(); ++j) {
                    list.add(sheet.getCell(i, j));
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasReferToCellList() {
        return this._formula1Expr != null && this._formula1Expr.isAreaRefs();
    }

    @Override
    void copyFrom(AbstractDataValidationAdv src) {
        Validations.argInstance(src, DataValidationImpl.class);
        DataValidationImpl srcImpl = (DataValidationImpl)src;
        this._alertStyle = srcImpl._alertStyle;
        this._ignoreBlank = srcImpl._ignoreBlank;
        this._showInCellDropdown = srcImpl._showInCellDropdown;
        this._showInput = srcImpl._showInput;
        this._showError = srcImpl._showError;
        this._inputTitle = srcImpl._inputTitle;
        this._inputMessage = srcImpl._inputMessage;
        this._errorTitle = srcImpl._errorTitle;
        this._errorMessage = srcImpl._errorMessage;
        this._validationType = srcImpl._validationType;
        this._operatorType = srcImpl._operatorType;
        if (srcImpl._formula1Expr != null) {
            this.setFormulas(srcImpl._formula1Expr == null ? null : srcImpl._formula1Expr.getFormulaString(), srcImpl._formula2Expr == null ? null : srcImpl._formula2Expr.getFormulaString());
        }
    }

    @Override
    void renameSheet(String oldName, String newName) {
        Validations.argNotNull(oldName);
        Validations.argNotNull(newName);
        if (oldName.equals(newName)) {
            return;
        }
        Ref dependent = this.getRef(oldName);
        SBook book = this._sheet.getBook();
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        Set<Ref> precedents = ((DependencyTableAdv)dt).getDirectPrecedents(dependent);
        if (precedents != null && this._regions != null) {
            for (CellRegion regn : this._regions) {
                precedents.remove(this.newDummyRef(oldName, regn));
            }
        }
        dt.clearDependents(dependent);
        dependent = this.getRef(newName);
        if (this._regions != null) {
            for (CellRegion regn : this._regions) {
                dt.add(dependent, this.newDummyRef(newName, regn));
            }
        }
        if (precedents != null) {
            for (Ref precedent : precedents) {
                dt.add(dependent, precedent);
            }
        }
    }

    DataValidationImpl cloneDataValidationImpl(AbstractSheetAdv sheet) {
        String f1;
        DataValidationImpl tgt = new DataValidationImpl(sheet, this._id);
        tgt._alertStyle = this._alertStyle;
        tgt._ignoreBlank = this._ignoreBlank;
        tgt._showInCellDropdown = this._showInCellDropdown;
        tgt._showInput = this._showInput;
        tgt._showError = this._showError;
        tgt._inputTitle = this._inputTitle;
        tgt._inputMessage = this._inputMessage;
        tgt._errorTitle = this._errorTitle;
        tgt._errorMessage = this._errorMessage;
        tgt._validationType = this._validationType;
        tgt._operatorType = this._operatorType;
        if (this._regions != null) {
            tgt._regions = new HashSet<CellRegion>(this._regions.size() * 4 / 3);
            for (CellRegion rgn : this._regions) {
                tgt._regions.add(new CellRegion(rgn.row, rgn.column, rgn.lastRow, rgn.lastColumn));
            }
        }
        if ((f1 = this.getFormula1()) != null) {
            String f2 = this.getFormula2();
            this.setFormulas(f1, f2);
        }
        return tgt;
    }

    @Override
    public void setFormulas(FormulaExpression fe1, FormulaExpression fe2) {
        this.checkOrphan();
        this._evaluated = false;
        this.clearFormulaDependency(false);
        this.clearFormulaResultCache();
        this._formula1Expr = fe1;
        this._formula2Expr = fe2;
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        Ref ref = this.getRef();
        FormulaParseContext context = new FormulaParseContext(this._sheet, ref);
        if (fe1 != null) {
            fe.updateDependencyTable(fe1, context);
        }
        if (fe2 != null) {
            fe.updateDependencyTable(fe2, context);
        }
    }

    @Override
    public FormulaExpression getFormulaExpression1() {
        return this._formula1Expr;
    }

    @Override
    public FormulaExpression getFormulaExpression2() {
        return this._formula2Expr;
    }

    @Override
    public void setFormula1(FormulaExpression formula1) {
        this.setFormulas(formula1, this._formula2Expr);
    }

    @Override
    public void setFormula2(FormulaExpression formula2) {
        this.setFormulas(this._formula1Expr, formula2);
    }
}

