/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.AbstractCellStyleAdv;
import org.zkoss.zss.model.impl.AbstractColumnArrayAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.util.Validations;

public class ColumnArrayImpl
extends AbstractColumnArrayAdv {
    private static final long serialVersionUID = 1L;
    private AbstractSheetAdv _sheet;
    private AbstractCellStyleAdv _cellStyle;
    private Integer _width;
    private boolean _hidden = false;
    private boolean _customWidth = false;
    int _index;
    int _lastIndex;

    public ColumnArrayImpl(AbstractSheetAdv sheet, int index, int lastIndex) {
        this._sheet = sheet;
        this._index = index;
        this._lastIndex = lastIndex;
    }

    public int getIndex() {
        this.checkOrphan();
        return this._index;
    }

    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    public void destroy() {
        this.checkOrphan();
        this._sheet = null;
    }

    public SSheet getSheet() {
        this.checkOrphan();
        return this._sheet;
    }

    public SCellStyle getCellStyle() {
        return this.getCellStyle(false);
    }

    public SCellStyle getCellStyle(boolean local) {
        if (local || this._cellStyle != null) {
            return this._cellStyle;
        }
        this.checkOrphan();
        return this._sheet.getBook().getDefaultCellStyle();
    }

    public void setCellStyle(SCellStyle cellStyle) {
        Validations.argInstance(cellStyle, AbstractCellStyleAdv.class);
        this._cellStyle = (AbstractCellStyleAdv)cellStyle;
    }

    public int getWidth() {
        if (this._width != null) {
            return this._width;
        }
        this.checkOrphan();
        return this.getSheet().getDefaultColumnWidth();
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public int getLastIndex() {
        return this._lastIndex;
    }

    void setIndex(int index) {
        this._index = index;
    }

    void setLastIndex(int lastIndex) {
        this._lastIndex = lastIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("[").append(this.getIndex()).append("-").append(this.getLastIndex()).append("]");
        return sb.toString();
    }

    public boolean isCustomWidth() {
        return this._customWidth;
    }

    public void setCustomWidth(boolean custom) {
        this._customWidth = custom;
    }

    ColumnArrayImpl cloneColumnArrayImpl(AbstractSheetAdv sheet) {
        ColumnArrayImpl tgt = new ColumnArrayImpl(sheet, this._index, this._lastIndex);
        tgt._width = this._width;
        tgt._hidden = this._hidden;
        tgt._customWidth = this._customWidth;
        tgt._cellStyle = this._cellStyle;
        return tgt;
    }
}

