/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import org.zkoss.zss.model.SChart;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.ViewAnchor;
import org.zkoss.zss.model.chart.SChartData;
import org.zkoss.zss.model.impl.AbstractChartAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.chart.ChartDataAdv;
import org.zkoss.zss.model.impl.chart.GeneralChartDataImpl;
import org.zkoss.zss.model.impl.chart.UnsupportedChartDataImpl;
import org.zkoss.zss.model.util.Validations;

public class ChartImpl
extends AbstractChartAdv {
    private static final long serialVersionUID = 1L;
    private String _id;
    private SChart.ChartType _type;
    private ViewAnchor _anchor;
    private ChartDataAdv _data;
    private String _title;
    private String _xAxisTitle;
    private String _yAxisTitle;
    private AbstractSheetAdv _sheet;
    private SChart.ChartLegendPosition _legendPosition;
    private SChart.ChartGrouping _grouping;
    private SChart.BarDirection _direction;
    private boolean _threeD;

    public ChartImpl(AbstractSheetAdv sheet, String id, SChart.ChartType type, ViewAnchor anchor) {
        this._sheet = sheet;
        this._id = id;
        this._type = type;
        this._anchor = anchor;
        this._data = this.createChartData(type);
        Validations.argNotNull(anchor);
        switch (type) {
            case BAR: {
                this._direction = SChart.BarDirection.HORIZONTAL;
                break;
            }
            case COLUMN: {
                this._direction = SChart.BarDirection.VERTICAL;
            }
        }
    }

    public SSheet getSheet() {
        this.checkOrphan();
        return this._sheet;
    }

    public String getId() {
        return this._id;
    }

    public ViewAnchor getAnchor() {
        return this._anchor;
    }

    public void setAnchor(ViewAnchor anchor) {
        Validations.argNotNull(anchor);
        this._anchor = anchor;
    }

    public SChart.ChartType getType() {
        return this._type;
    }

    public SChartData getData() {
        return this._data;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getXAxisTitle() {
        return this._xAxisTitle;
    }

    public void setXAxisTitle(String xAxisTitle) {
        this._xAxisTitle = xAxisTitle;
    }

    public String getYAxisTitle() {
        return this._yAxisTitle;
    }

    public void setYAxisTitle(String yAxisTitle) {
        this._yAxisTitle = yAxisTitle;
    }

    private ChartDataAdv createChartData(SChart.ChartType type) {
        switch (type) {
            case BAR: 
            case COLUMN: 
            case AREA: 
            case LINE: 
            case DOUGHNUT: 
            case PIE: 
            case SCATTER: 
            case BUBBLE: 
            case STOCK: {
                return new GeneralChartDataImpl(this, this._id + "-data");
            }
            case OF_PIE: 
            case RADAR: 
            case SURFACE: {
                return new UnsupportedChartDataImpl(this);
            }
        }
        throw new UnsupportedOperationException("unsupported chart type " + (Object)((Object)type));
    }

    public void destroy() {
        this.checkOrphan();
        ((ChartDataAdv)this.getData()).destroy();
        this._sheet = null;
    }

    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    public void setLegendPosition(SChart.ChartLegendPosition pos) {
        this._legendPosition = pos;
    }

    public SChart.ChartLegendPosition getLegendPosition() {
        return this._legendPosition;
    }

    public void setGrouping(SChart.ChartGrouping grouping) {
        this._grouping = grouping;
    }

    public SChart.ChartGrouping getGrouping() {
        return this._grouping;
    }

    public SChart.BarDirection getBarDirection() {
        return this._direction;
    }

    public void setBarDirection(SChart.BarDirection direction) {
        this._direction = direction;
    }

    public boolean isThreeD() {
        return this._threeD;
    }

    public void setThreeD(boolean threeD) {
        this._threeD = threeD;
    }

    ChartImpl cloneChartImpl(AbstractSheetAdv sheet) {
        ChartImpl tgt = new ChartImpl(sheet, this._id, this._type, this._anchor.cloneViewAnchor());
        if (tgt._data instanceof GeneralChartDataImpl) {
            ((GeneralChartDataImpl)tgt._data).copyFrom((GeneralChartDataImpl)this._data);
        }
        tgt._title = this._title;
        tgt._xAxisTitle = this._xAxisTitle;
        tgt._yAxisTitle = this._yAxisTitle;
        tgt._legendPosition = this._legendPosition;
        tgt._grouping = this._grouping;
        tgt._direction = this._direction;
        tgt._threeD = this._threeD;
        return tgt;
    }
}

