/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.impl.AbstractCellStyleAdv;
import org.zkoss.zss.model.impl.AbstractFontAdv;
import org.zkoss.zss.model.impl.ColorImpl;
import org.zkoss.zss.model.util.Validations;

public class CellStyleImpl
extends AbstractCellStyleAdv {
    private static final long serialVersionUID = 1L;
    private AbstractFontAdv _font;
    private SColor _fillColor = ColorImpl.WHITE;
    private SColor _backColor = ColorImpl.WHITE;
    private SCellStyle.FillPattern _fillPattern = SCellStyle.FillPattern.NO_FILL;
    private SCellStyle.Alignment _alignment = SCellStyle.Alignment.GENERAL;
    private SCellStyle.VerticalAlignment _verticalAlignment = SCellStyle.VerticalAlignment.BOTTOM;
    private boolean _wrapText = false;
    private SCellStyle.BorderType _borderLeft = SCellStyle.BorderType.NONE;
    private SCellStyle.BorderType _borderTop = SCellStyle.BorderType.NONE;
    private SCellStyle.BorderType _borderRight = SCellStyle.BorderType.NONE;
    private SCellStyle.BorderType _borderBottom = SCellStyle.BorderType.NONE;
    private SColor _borderTopColor = ColorImpl.BLACK;
    private SColor _borderLeftColor = ColorImpl.BLACK;
    private SColor _borderBottomColor = ColorImpl.BLACK;
    private SColor _borderRightColor = ColorImpl.BLACK;
    private String _dataFormat = "General";
    private boolean _directFormat = false;
    private boolean _locked = true;
    private boolean _hidden = false;

    public CellStyleImpl(AbstractFontAdv font) {
        this._font = font;
    }

    public SFont getFont() {
        return this._font;
    }

    public void setFont(SFont font) {
        Validations.argInstance(font, AbstractFontAdv.class);
        this._font = (AbstractFontAdv)font;
    }

    public SColor getFillColor() {
        return this._fillColor;
    }

    public void setFillColor(SColor fillColor) {
        Validations.argNotNull(fillColor);
        this._fillColor = fillColor;
    }

    public SCellStyle.FillPattern getFillPattern() {
        return this._fillPattern;
    }

    public void setFillPattern(SCellStyle.FillPattern fillPattern) {
        Validations.argNotNull(new Object[]{fillPattern});
        this._fillPattern = fillPattern;
    }

    public SCellStyle.Alignment getAlignment() {
        return this._alignment;
    }

    public void setAlignment(SCellStyle.Alignment alignment) {
        Validations.argNotNull(new Object[]{alignment});
        this._alignment = alignment;
    }

    public SCellStyle.VerticalAlignment getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public void setVerticalAlignment(SCellStyle.VerticalAlignment verticalAlignment) {
        Validations.argNotNull(new Object[]{verticalAlignment});
        this._verticalAlignment = verticalAlignment;
    }

    public boolean isWrapText() {
        return this._wrapText;
    }

    public void setWrapText(boolean wrapText) {
        this._wrapText = wrapText;
    }

    public SCellStyle.BorderType getBorderLeft() {
        return this._borderLeft;
    }

    public void setBorderLeft(SCellStyle.BorderType borderLeft) {
        Validations.argNotNull(new Object[]{borderLeft});
        this._borderLeft = borderLeft;
    }

    public SCellStyle.BorderType getBorderTop() {
        return this._borderTop;
    }

    public void setBorderTop(SCellStyle.BorderType borderTop) {
        Validations.argNotNull(new Object[]{borderTop});
        this._borderTop = borderTop;
    }

    public SCellStyle.BorderType getBorderRight() {
        return this._borderRight;
    }

    public void setBorderRight(SCellStyle.BorderType borderRight) {
        Validations.argNotNull(new Object[]{borderRight});
        this._borderRight = borderRight;
    }

    public SCellStyle.BorderType getBorderBottom() {
        return this._borderBottom;
    }

    public void setBorderBottom(SCellStyle.BorderType borderBottom) {
        Validations.argNotNull(new Object[]{borderBottom});
        this._borderBottom = borderBottom;
    }

    public SColor getBorderTopColor() {
        return this._borderTopColor;
    }

    public void setBorderTopColor(SColor borderTopColor) {
        Validations.argNotNull(borderTopColor);
        this._borderTopColor = borderTopColor;
    }

    public SColor getBorderLeftColor() {
        return this._borderLeftColor;
    }

    public void setBorderLeftColor(SColor borderLeftColor) {
        Validations.argNotNull(borderLeftColor);
        this._borderLeftColor = borderLeftColor;
    }

    public SColor getBorderBottomColor() {
        return this._borderBottomColor;
    }

    public void setBorderBottomColor(SColor borderBottomColor) {
        Validations.argNotNull(borderBottomColor);
        this._borderBottomColor = borderBottomColor;
    }

    public SColor getBorderRightColor() {
        return this._borderRightColor;
    }

    public void setBorderRightColor(SColor borderRightColor) {
        Validations.argNotNull(borderRightColor);
        this._borderRightColor = borderRightColor;
    }

    public String getDataFormat() {
        return this._dataFormat;
    }

    public boolean isDirectDataFormat() {
        return this._directFormat;
    }

    public void setDataFormat(String dataFormat) {
        if (dataFormat == null || "".equals(dataFormat.trim())) {
            dataFormat = "General";
        }
        this._dataFormat = dataFormat;
        this._directFormat = false;
    }

    public void setDirectDataFormat(String dataFormat) {
        this.setDataFormat(dataFormat);
        this._directFormat = true;
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void setLocked(boolean locked) {
        this._locked = locked;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public void copyFrom(SCellStyle src) {
        if (src == this) {
            return;
        }
        Validations.argInstance(src, CellStyleImpl.class);
        this.setFont(src.getFont());
        this.setFillColor(src.getFillColor());
        this.setFillPattern(src.getFillPattern());
        this.setAlignment(src.getAlignment());
        this.setVerticalAlignment(src.getVerticalAlignment());
        this.setWrapText(src.isWrapText());
        this.setBorderLeft(src.getBorderLeft());
        this.setBorderTop(src.getBorderTop());
        this.setBorderRight(src.getBorderRight());
        this.setBorderBottom(src.getBorderBottom());
        this.setBorderTopColor(src.getBorderTopColor());
        this.setBorderLeftColor(src.getBorderLeftColor());
        this.setBorderBottomColor(src.getBorderBottomColor());
        this.setBorderRightColor(src.getBorderRightColor());
        this.setDataFormat(src.getDataFormat());
        this.setLocked(src.isLocked());
        this.setHidden(src.isHidden());
    }

    String getStyleKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._font.getStyleKey()).append(".").append(this._fillPattern.ordinal()).append(".").append(this._fillColor.getHtmlColor()).append(".").append(this._alignment.ordinal()).append(".").append(this._verticalAlignment.ordinal()).append(".").append(this._wrapText ? "T" : "F").append(".").append(this._borderLeft.ordinal()).append(".").append(this._borderLeftColor.getHtmlColor()).append(".").append(this._borderRight.ordinal()).append(".").append(this._borderRightColor.getHtmlColor()).append(".").append(this._borderTop.ordinal()).append(".").append(this._borderTopColor.getHtmlColor()).append(".").append(this._borderBottom.ordinal()).append(".").append(this._borderBottomColor.getHtmlColor()).append(".").append(this._dataFormat).append(".").append(this._locked ? "T" : "F").append(".").append(this._hidden ? "T" : "F");
        return sb.toString();
    }

    public void setBorderLeft(SCellStyle.BorderType borderLeft, SColor color) {
        this.setBorderLeft(borderLeft);
        this.setBorderLeftColor(color);
    }

    public void setBorderTop(SCellStyle.BorderType borderTop, SColor color) {
        this.setBorderTop(borderTop);
        this.setBorderTopColor(color);
    }

    public void setBorderRight(SCellStyle.BorderType borderRight, SColor color) {
        this.setBorderRight(borderRight);
        this.setBorderRightColor(color);
    }

    public void setBorderBottom(SCellStyle.BorderType borderBottom, SColor color) {
        this.setBorderBottom(borderBottom);
        this.setBorderBottomColor(color);
    }

    public SColor getBackColor() {
        return this._backColor;
    }

    public void setBackgroundColor(SColor backColor) {
        Validations.argNotNull(backColor);
        this._backColor = backColor;
    }
}

