/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import org.zkoss.zss.model.CellRegion;
import org.zkoss.zss.model.ErrorValue;
import org.zkoss.zss.model.InvalidFormulaException;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SComment;
import org.zkoss.zss.model.SHyperlink;
import org.zkoss.zss.model.SRichText;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractCellAdv;
import org.zkoss.zss.model.impl.AbstractCellStyleAdv;
import org.zkoss.zss.model.impl.AbstractColumnArrayAdv;
import org.zkoss.zss.model.impl.AbstractCommentAdv;
import org.zkoss.zss.model.impl.AbstractHyperlinkAdv;
import org.zkoss.zss.model.impl.AbstractRichTextAdv;
import org.zkoss.zss.model.impl.AbstractRowAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.BookImpl;
import org.zkoss.zss.model.impl.CellValue;
import org.zkoss.zss.model.impl.FormulaResultCellValue;
import org.zkoss.zss.model.impl.ModelUpdateUtil;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.FormulaClearContext;
import org.zkoss.zss.model.sys.formula.FormulaEngine;
import org.zkoss.zss.model.sys.formula.FormulaEvaluationContext;
import org.zkoss.zss.model.sys.formula.FormulaExpression;
import org.zkoss.zss.model.sys.formula.FormulaParseContext;
import org.zkoss.zss.model.util.Validations;

public class CellImpl
extends AbstractCellAdv {
    private static final long serialVersionUID = 1L;
    private AbstractRowAdv _row;
    private int _index;
    private CellValue _localValue = null;
    private AbstractCellStyleAdv _cellStyle;
    private transient FormulaResultCellValue _formulaResultValue;
    private OptFields _opts;

    private OptFields getOpts(boolean create) {
        if (this._opts == null && create) {
            this._opts = new OptFields();
        }
        return this._opts;
    }

    public CellImpl(AbstractRowAdv row, int index) {
        this._row = row;
        this._index = index;
    }

    public SCell.CellType getType() {
        CellValue val = this.getCellValue();
        return val == null ? SCell.CellType.BLANK : val.getType();
    }

    public boolean isNull() {
        return false;
    }

    public int getRowIndex() {
        this.checkOrphan();
        return this._row.getIndex();
    }

    public int getColumnIndex() {
        this.checkOrphan();
        return this._index;
    }

    public String getReferenceString() {
        return new CellRegion(this.getRowIndex(), this.getColumnIndex()).getReferenceString();
    }

    public void checkOrphan() {
        if (this._row == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    public SSheet getSheet() {
        this.checkOrphan();
        return this._row.getSheet();
    }

    public void destroy() {
        this.checkOrphan();
        this.clearValue();
        this._row = null;
    }

    public SCellStyle getCellStyle() {
        return this.getCellStyle(false);
    }

    public SCellStyle getCellStyle(boolean local) {
        SColumnArray array;
        if (local || this._cellStyle != null) {
            return this._cellStyle;
        }
        this.checkOrphan();
        this._cellStyle = (AbstractCellStyleAdv)this._row.getCellStyle(true);
        AbstractSheetAdv sheet = (AbstractSheetAdv)this._row.getSheet();
        if (this._cellStyle == null && (array = sheet.getColumnArray(this.getColumnIndex())) != null) {
            this._cellStyle = (AbstractCellStyleAdv)((AbstractColumnArrayAdv)array).getCellStyle(true);
        }
        if (this._cellStyle == null) {
            this._cellStyle = (AbstractCellStyleAdv)sheet.getBook().getDefaultCellStyle();
        }
        return this._cellStyle;
    }

    public void setCellStyle(SCellStyle cellStyle) {
        if (cellStyle != null) {
            Validations.argInstance(cellStyle, AbstractCellStyleAdv.class);
        }
        this._cellStyle = (AbstractCellStyleAdv)cellStyle;
        this.addCellUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evalFormula() {
        if (this._formulaResultValue != null) {
            return;
        }
        CellImpl cellImpl = this;
        synchronized (cellImpl) {
            CellValue val;
            if (this._formulaResultValue == null && (val = this.getCellValue()) != null && val.getType() == SCell.CellType.FORMULA) {
                FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
                this._formulaResultValue = new FormulaResultCellValue(fe.evaluate((FormulaExpression)val.getValue(), new FormulaEvaluationContext(this, this.getRef())));
            }
        }
    }

    public SCell.CellType getFormulaResultType() {
        this.checkType(SCell.CellType.FORMULA);
        this.evalFormula();
        return this._formulaResultValue.getCellType();
    }

    public void clearValue() {
        this.checkOrphan();
        this.clearFormulaDependency();
        this.clearFormulaResultCache();
        this.setCellValue(null);
        OptFields opts = this.getOpts(false);
        if (opts != null) {
            // empty if block
        }
        if (BookImpl.destroyingSheet.get() != this.getSheet()) {
            this.addCellUpdate();
        }
    }

    private void addCellUpdate() {
        ModelUpdateUtil.addCellUpdate(this.getSheet(), this.getRowIndex(), this.getColumnIndex());
    }

    public void setFormulaValue(String formula) {
        this.setFormulaValue(formula, Locale.US);
    }

    public void setFormulaValue(String formula, Locale locale) {
        this.checkOrphan();
        Validations.argNotNull(formula);
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        FormulaParseContext formulaCtx = new FormulaParseContext(this.getSheet().getBook(), this.getSheet(), this, this.getSheet().getSheetName(), null, locale);
        FormulaExpression expr = fe.parse(formula, formulaCtx);
        if (expr.hasError()) {
            String msg = expr.getErrorMessage();
            throw new InvalidFormulaException(msg == null ? "The formula =" + formula + " contains error" : msg);
        }
        this.setValue(expr);
    }

    private void clearValueForSet(boolean clearDependency) {
        if (clearDependency) {
            this.clearFormulaDependency();
        }
        this.clearFormulaResultCache();
        OptFields opts = this.getOpts(false);
        if (opts != null) {
            // empty if block
        }
    }

    public void clearFormulaResultCache() {
        if (this._formulaResultValue != null) {
            EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        }
        this._formulaResultValue = null;
    }

    public boolean isFormulaParsingError() {
        if (this.getType() == SCell.CellType.FORMULA) {
            return ((FormulaExpression)this.getValue(false)).hasError();
        }
        return false;
    }

    private void clearFormulaDependency() {
        if (this.getType() == SCell.CellType.FORMULA) {
            ((AbstractBookSeriesAdv)this.getSheet().getBook().getBookSeries()).getDependencyTable().clearDependents(this.getRef());
        }
    }

    public Object getValue(boolean evaluatedVal) {
        CellValue val = this.getCellValue();
        if (evaluatedVal && val != null && val.getType() == SCell.CellType.FORMULA) {
            this.evalFormula();
            return this._formulaResultValue.getValue();
        }
        return val == null ? null : val.getValue();
    }

    private boolean isFormula(String string) {
        return string != null && string.startsWith("=") && string.length() > 1;
    }

    private CellValue getCellValue() {
        this.checkOrphan();
        return this._localValue;
    }

    private void setCellValue(CellValue value) {
        this.checkOrphan();
        this._localValue = value != null && value.getType() == SCell.CellType.BLANK ? null : value;
        SBookSeries bookSeries = this.getSheet().getBook().getBookSeries();
        ModelUpdateUtil.handlePrecedentUpdate(bookSeries, this.getRef());
    }

    private static boolean valueEuqals(Object val1, Object val2) {
        return val1 == val2 || val1 != null && val1.equals(val2);
    }

    public void setValue(Object newVal) {
        SCell.CellType newType;
        CellValue oldVal = this.getCellValue();
        if (oldVal == null && newVal == null || oldVal != null && CellImpl.valueEuqals(oldVal.getValue(), newVal)) {
            return;
        }
        if (newVal == null) {
            newType = SCell.CellType.BLANK;
        } else if (newVal instanceof String) {
            if (this.isFormula((String)newVal)) {
                this.setFormulaValue(((String)newVal).substring(1));
                return;
            }
            newType = SCell.CellType.STRING;
        } else if (newVal instanceof SRichText) {
            newType = SCell.CellType.STRING;
        } else if (newVal instanceof FormulaExpression) {
            newType = SCell.CellType.FORMULA;
        } else if (newVal instanceof Date) {
            newType = SCell.CellType.NUMBER;
            newVal = EngineFactory.getInstance().getCalendarUtil().dateToDoubleValue((Date)newVal);
        } else if (newVal instanceof Boolean) {
            newType = SCell.CellType.BOOLEAN;
        } else if (newVal instanceof Double) {
            newType = SCell.CellType.NUMBER;
        } else if (newVal instanceof Number) {
            newType = SCell.CellType.NUMBER;
            newVal = ((Number)newVal).doubleValue();
        } else if (newVal instanceof ErrorValue) {
            newType = SCell.CellType.ERROR;
        } else {
            throw new IllegalArgumentException("unsupported type " + newVal + ", supports NULL, String, Date, Number and Byte(as Error Code)");
        }
        InnerCellValue newCellVal = new InnerCellValue(newType, newVal);
        this.clearValueForSet(oldVal != null && oldVal.getType() == SCell.CellType.FORMULA);
        if (newType == SCell.CellType.FORMULA) {
            FormulaParseContext context = new FormulaParseContext(this, this.getRef());
            EngineFactory.getInstance().createFormulaEngine().updateDependencyTable((FormulaExpression)newVal, context);
        }
        this.setCellValue(newCellVal);
    }

    public SHyperlink getHyperlink() {
        OptFields opts = this.getOpts(false);
        return opts == null ? null : opts._hyperlink;
    }

    public void setHyperlink(SHyperlink hyperlink) {
        Validations.argInstance(hyperlink, AbstractHyperlinkAdv.class);
        this.getOpts(true)._hyperlink = (AbstractHyperlinkAdv)hyperlink;
        this.addCellUpdate();
    }

    public SComment getComment() {
        OptFields opts = this.getOpts(false);
        return opts == null ? null : opts._comment;
    }

    public void setComment(SComment comment) {
        Validations.argInstance(comment, AbstractCommentAdv.class);
        this.getOpts(true)._comment = (AbstractCommentAdv)comment;
        this.addCellUpdate();
    }

    void setIndex(int newidx) {
        if (this._index == newidx) {
            return;
        }
        SCell.CellType type = this.getType();
        String formula = null;
        DependencyTable table = null;
        if (type == SCell.CellType.FORMULA) {
            formula = this.getFormulaValue();
            Ref oldRef = this.getRef();
            table = ((AbstractBookSeriesAdv)this.getSheet().getBook().getBookSeries()).getDependencyTable();
            table.clearDependents(oldRef);
        }
        this._index = newidx;
        if (formula != null) {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            Ref ref = this.getRef();
            fe.parse(formula, new FormulaParseContext(this, ref));
            if (this._formulaResultValue != null) {
                table.setEvaluated(ref);
            }
        }
    }

    void setRow(int oldRowIdx, AbstractRowAdv row) {
        if (oldRowIdx == row.getIndex() && this._row == row) {
            return;
        }
        SCell.CellType type = this.getType();
        String formula = null;
        DependencyTable table = null;
        if (type == SCell.CellType.FORMULA) {
            formula = this.getFormulaValue();
            SSheet sheet = this.getSheet();
            RefImpl oldRef = new RefImpl(sheet.getBook().getBookName(), sheet.getSheetName(), oldRowIdx, this.getColumnIndex());
            table = ((AbstractBookSeriesAdv)this.getSheet().getBook().getBookSeries()).getDependencyTable();
            table.clearDependents(oldRef);
        }
        this._row = row;
        if (formula != null) {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            Ref ref = this.getRef();
            fe.parse(formula, new FormulaParseContext(this, ref));
            if (this._formulaResultValue != null) {
                table.setEvaluated(ref);
            }
        }
    }

    protected Ref getRef() {
        return new RefImpl(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cell:" + this.getReferenceString() + "[").append(this.getRowIndex()).append(",").append(this.getColumnIndex()).append("]");
        return sb.toString();
    }

    AbstractCellAdv cloneCell(AbstractRowAdv row) {
        CellImpl tgt = new CellImpl(row, this._index);
        if (this._localValue != null) {
            Object newVal = this._localValue.getValue();
            if (newVal instanceof SRichText) {
                newVal = ((AbstractRichTextAdv)newVal).clone();
            } else if (newVal instanceof FormulaExpression) {
                newVal = "=" + ((FormulaExpression)newVal).getFormulaString();
            }
            tgt.setValue(newVal);
        }
        tgt._cellStyle = this._cellStyle;
        if (this._opts != null) {
            OptFields opts = tgt.getOpts(true);
            if (this._opts._comment != null) {
                opts._comment = this._opts._comment.clone();
            }
            if (this._opts._hyperlink != null) {
                opts._hyperlink = this._opts._hyperlink.clone();
            }
        }
        return tgt;
    }

    private static class InnerCellValue
    extends CellValue {
        private static final long serialVersionUID = 1L;

        private InnerCellValue(SCell.CellType type, Object value) {
            super(type, value);
        }
    }

    private static class OptFields
    implements Serializable {
        private AbstractHyperlinkAdv _hyperlink;
        private AbstractCommentAdv _comment;

        private OptFields() {
        }
    }
}

