/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.zkoss.lang.Objects;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.util.logging.Log;
import org.zkoss.zss.model.EventQueueModelEventListener;
import org.zkoss.zss.model.InvalidModelOpException;
import org.zkoss.zss.model.ModelEvent;
import org.zkoss.zss.model.ModelEventListener;
import org.zkoss.zss.model.SBookSeries;
import org.zkoss.zss.model.SCell;
import org.zkoss.zss.model.SCellStyle;
import org.zkoss.zss.model.SColor;
import org.zkoss.zss.model.SColumnArray;
import org.zkoss.zss.model.SFont;
import org.zkoss.zss.model.SName;
import org.zkoss.zss.model.SPicture;
import org.zkoss.zss.model.SPictureData;
import org.zkoss.zss.model.SRow;
import org.zkoss.zss.model.SSheet;
import org.zkoss.zss.model.impl.AbstractBookAdv;
import org.zkoss.zss.model.impl.AbstractBookSeriesAdv;
import org.zkoss.zss.model.impl.AbstractCellStyleAdv;
import org.zkoss.zss.model.impl.AbstractColorAdv;
import org.zkoss.zss.model.impl.AbstractFontAdv;
import org.zkoss.zss.model.impl.AbstractNameAdv;
import org.zkoss.zss.model.impl.AbstractSheetAdv;
import org.zkoss.zss.model.impl.CellStyleImpl;
import org.zkoss.zss.model.impl.ColorImpl;
import org.zkoss.zss.model.impl.DirectEventListenerAdaptor;
import org.zkoss.zss.model.impl.EventListenerAdaptor;
import org.zkoss.zss.model.impl.EventQueueListenerAdaptor;
import org.zkoss.zss.model.impl.FontImpl;
import org.zkoss.zss.model.impl.FormulaTunerHelper;
import org.zkoss.zss.model.impl.ModelUpdateUtil;
import org.zkoss.zss.model.impl.NameImpl;
import org.zkoss.zss.model.impl.NameRefImpl;
import org.zkoss.zss.model.impl.PictureDataImpl;
import org.zkoss.zss.model.impl.RefImpl;
import org.zkoss.zss.model.impl.SheetImpl;
import org.zkoss.zss.model.impl.SimpleBookSeriesImpl;
import org.zkoss.zss.model.sys.EngineFactory;
import org.zkoss.zss.model.sys.dependency.DependencyTable;
import org.zkoss.zss.model.sys.dependency.Ref;
import org.zkoss.zss.model.sys.formula.EvaluationContributor;
import org.zkoss.zss.model.sys.formula.FormulaClearContext;
import org.zkoss.zss.model.util.CellStyleMatcher;
import org.zkoss.zss.model.util.FontMatcher;
import org.zkoss.zss.model.util.Strings;
import org.zkoss.zss.model.util.Validations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookImpl
extends AbstractBookAdv {
    private static final long serialVersionUID = 1L;
    private static final Log _logger = Log.lookup(BookImpl.class);
    private final String _bookName;
    private String _shareScope;
    private SBookSeries _bookSeries;
    private final List<AbstractSheetAdv> _sheets = new LinkedList<AbstractSheetAdv>();
    private List<AbstractNameAdv> _names;
    private final List<AbstractCellStyleAdv> _cellStyles = new LinkedList<AbstractCellStyleAdv>();
    private AbstractCellStyleAdv _defaultCellStyle;
    private final List<AbstractFontAdv> _fonts = new LinkedList<AbstractFontAdv>();
    private final AbstractFontAdv _defaultFont;
    private final HashMap<AbstractColorAdv, AbstractColorAdv> _colors = new LinkedHashMap<AbstractColorAdv, AbstractColorAdv>();
    private static final Random _random = new Random(System.currentTimeMillis());
    private static final AtomicInteger _bookCount = new AtomicInteger();
    private final String _bookId;
    private final HashMap<String, AtomicInteger> _objIdCounter = new HashMap();
    private final int _maxRowSize = SpreadsheetVersion.EXCEL2007.getMaxRows();
    private final int _maxColumnSize = SpreadsheetVersion.EXCEL2007.getMaxColumns();
    private EventListenerAdaptor _listeners;
    private EventListenerAdaptor _queueListeners;
    private HashMap<String, Object> _attributes;
    private EvaluationContributor _evalContributor;
    private ArrayList<SPictureData> _picDatas;
    static final ThreadLocal<SSheet> destroyingSheet = new ThreadLocal();

    public BookImpl(String bookName) {
        Validations.argNotNull(bookName);
        this._bookName = bookName;
        this._bookSeries = new SimpleBookSeriesImpl(this);
        this._defaultFont = new FontImpl();
        this._fonts.add(this._defaultFont);
        this._defaultCellStyle = new CellStyleImpl(this._defaultFont);
        this._cellStyles.add(this._defaultCellStyle);
        this._colors.put(ColorImpl.WHITE, ColorImpl.WHITE);
        this._colors.put(ColorImpl.BLACK, ColorImpl.BLACK);
        this._colors.put(ColorImpl.RED, ColorImpl.RED);
        this._colors.put(ColorImpl.GREEN, ColorImpl.GREEN);
        this._colors.put(ColorImpl.BLUE, ColorImpl.BLUE);
        this._bookId = (char)(97 + _random.nextInt(26)) + Long.toString(_bookCount.getAndIncrement(), 36);
    }

    @Override
    public SBookSeries getBookSeries() {
        return this._bookSeries;
    }

    @Override
    public String getBookName() {
        return this._bookName;
    }

    @Override
    public SSheet getSheet(int i) {
        return this._sheets.get(i);
    }

    @Override
    public int getNumOfSheet() {
        return this._sheets.size();
    }

    @Override
    public SSheet getSheetByName(String name) {
        for (AbstractSheetAdv sheet : this._sheets) {
            if (!sheet.getSheetName().equalsIgnoreCase(name)) continue;
            return sheet;
        }
        return null;
    }

    @Override
    public SSheet getSheetById(String id) {
        for (AbstractSheetAdv sheet : this._sheets) {
            if (!sheet.getId().equals(id)) continue;
            return sheet;
        }
        return null;
    }

    protected void checkOwnership(SSheet sheet) {
        if (!this._sheets.contains(sheet)) {
            throw new IllegalStateException("doesn't has ownership " + sheet);
        }
    }

    protected void checkOwnership(SName name) {
        if (this._names == null || !this._names.contains(name)) {
            throw new IllegalStateException("doesn't has ownership " + name);
        }
    }

    @Override
    public void sendModelEvent(ModelEvent event) {
        if (this._listeners != null) {
            this._listeners.sendModelEvent(event);
        }
        if (this._queueListeners != null) {
            this._queueListeners.sendModelEvent(event);
        }
    }

    @Override
    public SSheet createSheet(String name) {
        return this.createSheet(name, null);
    }

    @Override
    String nextObjId(String type) {
        StringBuilder sb = new StringBuilder(this._bookId);
        sb.append("_").append(type).append("_");
        AtomicInteger i = this._objIdCounter.get(type);
        if (i == null) {
            i = new AtomicInteger(0);
            this._objIdCounter.put(type, i);
        }
        sb.append(i.getAndIncrement());
        return sb.toString();
    }

    @Override
    public SSheet createSheet(String name, SSheet src) {
        this.checkLegalSheetName(name);
        if (src != null) {
            this.checkOwnership(src);
        }
        SheetImpl sheet = new SheetImpl(this, this.nextObjId("sheet"));
        ((AbstractSheetAdv)sheet).setSheetName(name);
        this._sheets.add(sheet);
        if (src instanceof AbstractSheetAdv) {
            ((AbstractSheetAdv)src).copyTo(sheet);
        }
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(sheet));
        return sheet;
    }

    protected Ref getRef() {
        return new RefImpl(this);
    }

    @Override
    public void setSheetName(SSheet sheet, String newname) {
        this.checkLegalSheetName(newname);
        this.checkOwnership(sheet);
        String oldname = sheet.getSheetName();
        ((AbstractSheetAdv)sheet).setSheetName(newname);
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(this.getBookName(), newname));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(this.getBookName(), oldname));
        this.renameSheetFormula(oldname, newname);
    }

    private void renameSheetFormula(String oldName, String newName) {
        RefImpl ref;
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this.getBookSeries();
        DependencyTable dt = bs.getDependencyTable();
        Set<Ref> dependents = dt.getDirectDependents(ref = new RefImpl(this.getBookName(), oldName));
        if (dependents.size() > 0) {
            for (Ref dependent : dependents) {
                dt.clearDependents(dependent);
            }
            FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
            tuner.renameSheet(this, oldName, newName, dependents);
        }
    }

    private void checkLegalSheetName(String name) {
        if (Strings.isBlank(name)) {
            throw new InvalidModelOpException("sheet name '" + name + "' is not legal");
        }
        if (this.getSheetByName(name) != null) {
            throw new InvalidModelOpException("sheet name '" + name + "' is duplicated");
        }
    }

    private void checkLegalNameName(String name, String sheetName) {
        int colIndex;
        if (Strings.isBlank(name)) {
            throw new InvalidModelOpException("name '" + name + "' is not legal");
        }
        if (this.getNameByName(name, sheetName) != null) {
            throw new InvalidModelOpException("name '" + name + "' " + (sheetName == null ? "" : " in '" + sheetName + "'") + " is duplicated");
        }
        if (sheetName != null && this.getSheetByName(sheetName) == null) {
            throw new InvalidModelOpException("no such sheet " + sheetName);
        }
        if (name.length() > 255) {
            throw new InvalidModelOpException("name '" + name + "' is not legal: cannot exceed 255 characters");
        }
        char c1 = name.charAt(0);
        if (!Character.isLetter(c1) && c1 != '_' && c1 != '\\') {
            throw new InvalidModelOpException("name '" + name + "' is not legal: first character must be a letter, an underscore, or a backslash");
        }
        boolean invalid = c1 == '_' || c1 == '\\' || c1 == '?' || c1 == '.';
        int n = colIndex = invalid ? -2 : Character.getNumericValue(c1) - 9;
        if (!invalid) {
            invalid = colIndex < 0;
        }
        int rowIndex = -1;
        int len = name.length();
        for (int j = 1; j < len; ++j) {
            char ch = name.charAt(j);
            if (Character.isLetter(ch)) {
                if (invalid) continue;
                if (rowIndex >= 0) {
                    invalid = true;
                    continue;
                }
                int c = Character.getNumericValue(ch) - 9;
                if (c < 0) {
                    invalid = true;
                    continue;
                }
                colIndex = colIndex * 26 + c;
                continue;
            }
            if (Character.isDigit(ch)) {
                if (invalid) continue;
                if (rowIndex < 0) {
                    rowIndex = Character.getNumericValue(ch);
                    continue;
                }
                rowIndex = rowIndex * 10 + Character.getNumericValue(ch);
                continue;
            }
            if (ch != '.' && ch != '_' && ch != '?' && ch != '\\') {
                throw new InvalidModelOpException("name '" + name + "' is not legal: the character '" + ch + "' at index " + j + " must be a letter, a digit, an underscore, a period, a question mark, or a backslash");
            }
            invalid = true;
        }
        if (!invalid && colIndex >= 0 && colIndex <= this.getMaxColumnSize() && rowIndex >= 0 && rowIndex < this.getMaxRowSize()) {
            throw new InvalidModelOpException("name '" + name + "' is not legal: cannot be a cell reference");
        }
        if (name.equalsIgnoreCase("C") || name.equalsIgnoreCase("R")) {
            throw new InvalidModelOpException("name '" + name + "' is not legal: cannot be 'C', 'c', 'R', or 'r'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSheet(SSheet sheet) {
        this.checkOwnership(sheet);
        destroyingSheet.set(sheet);
        try {
            ((AbstractSheetAdv)sheet).destroy();
        }
        finally {
            destroyingSheet.set(null);
        }
        String oldName = sheet.getSheetName();
        int index = this._sheets.indexOf(sheet);
        this._sheets.remove(index);
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new RefImpl(this.getBookName(), sheet.getSheetName()));
        this.renameSheetFormula(oldName, null);
    }

    @Override
    public void moveSheetTo(SSheet sheet, int index) {
        this.checkOwnership(sheet);
        if (index < 0 || index >= this._sheets.size()) {
            throw new InvalidModelOpException("new position out of bound " + this._sheets.size() + "<>" + index);
        }
        int oldindex = this._sheets.indexOf(sheet);
        if (oldindex == index) {
            return;
        }
        this._sheets.remove(oldindex);
        this._sheets.add(index, (AbstractSheetAdv)sheet);
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
    }

    public void dump(StringBuilder builder) {
        for (AbstractSheetAdv sheet : this._sheets) {
            if (sheet instanceof SheetImpl) {
                ((SheetImpl)sheet).dump(builder);
                continue;
            }
            builder.append("\n").append(sheet);
        }
    }

    @Override
    public SCellStyle getDefaultCellStyle() {
        return this._defaultCellStyle;
    }

    @Override
    public void setDefaultCellStyle(SCellStyle cellStyle) {
        if (cellStyle == null) {
            return;
        }
        this._defaultCellStyle = (AbstractCellStyleAdv)cellStyle;
        this._cellStyles.set(0, this._defaultCellStyle);
    }

    @Override
    public SCellStyle createCellStyle(boolean inStyleTable) {
        return this.createCellStyle(null, inStyleTable);
    }

    @Override
    public SCellStyle createCellStyle(SCellStyle src, boolean inStyleTable) {
        if (src != null) {
            Validations.argInstance(src, AbstractCellStyleAdv.class);
        }
        CellStyleImpl style = new CellStyleImpl(this._defaultFont);
        if (src != null) {
            style.copyFrom(src);
        }
        if (inStyleTable) {
            this._cellStyles.add(style);
        }
        return style;
    }

    @Override
    public SCellStyle searchCellStyle(CellStyleMatcher matcher) {
        for (AbstractCellStyleAdv style : this._cellStyles) {
            if (!matcher.match(style)) continue;
            return style;
        }
        return null;
    }

    @Override
    public SFont getDefaultFont() {
        return this._defaultFont;
    }

    @Override
    public SFont createFont(boolean inFontTable) {
        return this.createFont(null, inFontTable);
    }

    @Override
    public SFont createFont(SFont src, boolean inFontTable) {
        if (src != null) {
            Validations.argInstance(src, AbstractFontAdv.class);
        }
        FontImpl font = new FontImpl();
        if (src != null) {
            font.copyFrom(src);
        }
        if (inFontTable) {
            this._fonts.add(font);
        }
        return font;
    }

    @Override
    public SFont searchFont(FontMatcher matcher) {
        for (AbstractFontAdv font : this._fonts) {
            if (!matcher.match(font)) continue;
            return font;
        }
        return null;
    }

    @Override
    public int getMaxRowSize() {
        return this._maxRowSize;
    }

    @Override
    public int getMaxColumnSize() {
        return this._maxColumnSize;
    }

    @Override
    public void optimizeCellStyle() {
        LinkedHashMap<String, SCellStyle> stylePool = new LinkedHashMap<String, SCellStyle>();
        this._cellStyles.clear();
        this._fonts.clear();
        SCellStyle defaultStyle = this.getDefaultCellStyle();
        SFont defaultFont = this.getDefaultFont();
        stylePool.put(((AbstractCellStyleAdv)defaultStyle).getStyleKey(), defaultStyle);
        for (AbstractSheetAdv sheet : this._sheets) {
            Iterator<SRow> rowIter = sheet.getRowIterator();
            while (rowIter.hasNext()) {
                SRow row = rowIter.next();
                row.setCellStyle(this.hitStyle(defaultStyle, row.getCellStyle(), stylePool));
                Iterator<SCell> cellIter = sheet.getCellIterator(row.getIndex());
                while (cellIter.hasNext()) {
                    SCell cell = cellIter.next();
                    cell.setCellStyle(this.hitStyle(defaultStyle, cell.getCellStyle(), stylePool));
                }
            }
            Iterator<SColumnArray> colIter = sheet.getColumnArrayIterator();
            while (colIter.hasNext()) {
                SColumnArray colarr = colIter.next();
                colarr.setCellStyle(this.hitStyle(defaultStyle, colarr.getCellStyle(), stylePool));
            }
        }
        this._cellStyles.addAll(((HashMap)stylePool).values());
        LinkedHashMap<String, SFont> fontPool = new LinkedHashMap<String, SFont>();
        fontPool.put(((AbstractFontAdv)defaultFont).getStyleKey(), defaultFont);
        for (AbstractCellStyleAdv style : this._cellStyles) {
            SFont font = style.getFont();
            String key = ((AbstractFontAdv)font).getStyleKey();
            if (((HashMap)fontPool).get(key) != null) continue;
            fontPool.put(key, font);
        }
        this._fonts.addAll(((HashMap)fontPool).values());
        this._colors.clear();
    }

    public List<SCellStyle> getCellStyleTable() {
        return Collections.unmodifiableList(this._cellStyles);
    }

    public List<SFont> getFontTable() {
        return Collections.unmodifiableList(this._fonts);
    }

    private SCellStyle hitStyle(SCellStyle defaultStyle, SCellStyle currSytle, HashMap<String, SCellStyle> stylePool) {
        if (currSytle == defaultStyle) {
            return defaultStyle;
        }
        String key = ((AbstractCellStyleAdv)currSytle).getStyleKey();
        SCellStyle hit = stylePool.get(key);
        if (hit == null) {
            hit = currSytle;
            stylePool.put(key, hit);
        }
        return hit;
    }

    @Override
    public void addEventListener(ModelEventListener listener) {
        if (listener instanceof EventQueueModelEventListener) {
            if (this._queueListeners == null) {
                String scope = this.getShareScope();
                if (scope == null) {
                    scope = "desktop";
                }
                this._queueListeners = new EventQueueListenerAdaptor(scope, this.getId());
            }
            this._queueListeners.addEventListener(listener);
        } else {
            if (this._listeners == null) {
                this._listeners = new DirectEventListenerAdaptor();
            }
            this._listeners.addEventListener(listener);
        }
    }

    @Override
    public void removeEventListener(ModelEventListener listener) {
        if (listener instanceof EventQueueModelEventListener && this._queueListeners != null) {
            this._queueListeners.removeEventListener(listener);
            if (this._queueListeners.size() == 0) {
                this._queueListeners = null;
            }
        } else if (this._listeners != null) {
            this._listeners.removeEventListener(listener);
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes == null ? null : this._attributes.get(name);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        return this._attributes.put(name, value);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attributes == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this._attributes);
    }

    @Override
    public SColor createColor(byte r, byte g, byte b) {
        ColorImpl newcolor = new ColorImpl(r, g, b);
        AbstractColorAdv color = this._colors.get(newcolor);
        if (color == null) {
            color = newcolor;
            this._colors.put(newcolor, color);
        }
        return color;
    }

    @Override
    public SColor createColor(String htmlColor) {
        ColorImpl newcolor = new ColorImpl(htmlColor);
        AbstractColorAdv color = this._colors.get(newcolor);
        if (color == null) {
            color = newcolor;
            this._colors.put(newcolor, color);
        }
        return color;
    }

    @Override
    public List<SSheet> getSheets() {
        return Collections.unmodifiableList(this._sheets);
    }

    @Override
    public SName createName(String namename) {
        return this.createName(namename, null);
    }

    @Override
    public SName createName(String namename, String sheetName) {
        this.checkLegalNameName(namename, sheetName);
        NameImpl name = new NameImpl(this, this.nextObjId("name"), namename, sheetName);
        if (this._names == null) {
            this._names = new LinkedList<AbstractNameAdv>();
        }
        this._names.add(name);
        return name;
    }

    @Override
    public void setNameName(SName name, String newname) {
        this.setNameName(name, newname, null);
    }

    @Override
    public void setNameName(SName name, String newname, String sheetName) {
        this.checkLegalNameName(newname, sheetName);
        this.checkOwnership(name);
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        ModelUpdateUtil.handlePrecedentUpdate(this.getBookSeries(), new NameRefImpl((AbstractNameAdv)name));
        String oldName = name.getName();
        ((AbstractNameAdv)name).setName(newname, sheetName);
        this.renameNameFormula(name, oldName, newname, sheetName);
    }

    private void renameNameFormula(SName name, String oldName, String newName, String sheetName) {
        NameRefImpl ref;
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)this.getBookSeries();
        FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
        DependencyTable dt = bs.getDependencyTable();
        Set<Ref> dependents = dt.getDirectDependents(ref = new NameRefImpl(name.getBook().getBookName(), name.getApplyToSheetName(), oldName));
        if (dependents.size() > 0) {
            for (Ref dependent : dependents) {
                dt.clearDependents(dependent);
            }
            int sheetIndex = sheetName == null ? -1 : this.getSheetIndex(sheetName);
            tuner.renameName(this, oldName, newName, dependents, sheetIndex);
        }
    }

    @Override
    public void deleteName(SName name) {
        this.checkOwnership(name);
        ((AbstractNameAdv)name).destroy();
        int index = this._names.indexOf(name);
        this._names.remove(index);
    }

    @Override
    public int getNumOfName() {
        return this._names == null ? 0 : this._names.size();
    }

    @Override
    public SName getName(int idx) {
        if (this._names == null) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return this._names.get(idx);
    }

    @Override
    public SName getNameByName(String namename) {
        return this.getNameByName(namename, null);
    }

    @Override
    public SName getNameByName(String namename, String sheetName) {
        if (this._names == null) {
            return null;
        }
        for (AbstractNameAdv name : this._names) {
            String scopeSheetName = name.getApplyToSheetName();
            if (sheetName != scopeSheetName && (sheetName == null || !sheetName.equalsIgnoreCase(scopeSheetName)) || !name.getName().equalsIgnoreCase(namename)) continue;
            return name;
        }
        return null;
    }

    @Override
    public List<SName> getNames() {
        return this._names == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._names);
    }

    @Override
    public int getSheetIndex(SSheet sheet) {
        return this._sheets.indexOf(sheet);
    }

    @Override
    public int getSheetIndex(String sheetName) {
        int i = 0;
        for (AbstractSheetAdv sheet : this._sheets) {
            if (sheet.getSheetName().equals(sheetName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void setShareScope(String scope) {
        if (!Objects.equals((Object)this._shareScope, (Object)scope)) {
            if ("disable".equals(scope)) {
                if (this._listeners != null) {
                    this._listeners.clear();
                }
                if (this._queueListeners != null) {
                    this._queueListeners.clear();
                }
                return;
            }
            if (this._queueListeners != null && this._queueListeners.size() > 0) {
                throw new IllegalStateException("can't change share scope after registed any queue model event listener");
            }
            this._shareScope = scope;
        }
    }

    @Override
    public String getShareScope() {
        return this._shareScope;
    }

    @Override
    void setBookSeries(SBookSeries bookSeries) {
        this._bookSeries = bookSeries;
    }

    @Override
    public EvaluationContributor getEvaluationContributor() {
        return this._evalContributor;
    }

    @Override
    public void setEvaluationContributor(EvaluationContributor contributor) {
        this._evalContributor = contributor;
    }

    @Override
    public int getMaxRowIndex() {
        return this.getMaxRowSize() - 1;
    }

    @Override
    public int getMaxColumnIndex() {
        return this.getMaxColumnSize() - 1;
    }

    @Override
    public String getId() {
        return this._bookId;
    }

    @Override
    public SPictureData addPictureData(SPicture.Format format, byte[] data) {
        if (this._picDatas == null) {
            this._picDatas = new ArrayList(4);
        }
        int index = this._picDatas.size();
        PictureDataImpl picData = new PictureDataImpl(index, format, data);
        this._picDatas.add(picData);
        return picData;
    }

    @Override
    public SPictureData getPictureData(int index) {
        if (index < 0 || this._picDatas == null || index >= this._picDatas.size()) {
            return null;
        }
        return this._picDatas.get(index);
    }

    @Override
    public Collection<SPictureData> getPicturesDatas() {
        if (this._picDatas == null) {
            return Collections.emptyList();
        }
        ArrayList<SPictureData> list = new ArrayList<SPictureData>(this._picDatas.size());
        for (SPictureData picData : this._picDatas) {
            if (picData == null) continue;
            list.add(picData);
        }
        return list;
    }
}

