/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zss.model;

import java.io.Serializable;
import org.zkoss.zss.model.SSheet;

public class ViewAnchor
implements Serializable {
    private int rowIndex;
    private int columnIndex;
    private int xOffset;
    private int yOffset;
    private int width;
    private int height;

    public ViewAnchor(int rowIndex, int columnIndex, int width, int height) {
        this(rowIndex, columnIndex, 0, 0, width, height);
    }

    public ViewAnchor(int rowIndex, int columnIndex, int xOffset, int yOffset, int width, int height) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.width = width;
        this.height = height;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public ViewAnchor getRightBottomAnchor(SSheet sheet) {
        int offsetPlusChartWidth = this.getXOffset() + this.getWidth();
        int lastColumn = this.getColumnIndex();
        int xOffsetInLastColumn = 0;
        int column = this.getColumnIndex();
        while (true) {
            int interColumnWidth;
            if (offsetPlusChartWidth - (interColumnWidth = sheet.getColumn(column).getWidth()) < 0) break;
            offsetPlusChartWidth -= interColumnWidth;
            ++column;
        }
        lastColumn = column;
        xOffsetInLastColumn = offsetPlusChartWidth;
        int offsetPlusChartHeight = this.getYOffset() + this.getHeight();
        int lastRow = this.getRowIndex();
        int yOffsetInLastRow = 0;
        int row = this.getRowIndex();
        while (true) {
            int interRowHeight;
            if (offsetPlusChartHeight - (interRowHeight = sheet.getRow(row).getHeight()) < 0) break;
            offsetPlusChartHeight -= interRowHeight;
            ++row;
        }
        lastRow = row;
        yOffsetInLastRow = offsetPlusChartHeight;
        return new ViewAnchor(lastRow, lastColumn, xOffsetInLastColumn, yOffsetInLastRow, 0, 0);
    }

    public ViewAnchor cloneViewAnchor() {
        return new ViewAnchor(this.rowIndex, this.columnIndex, this.xOffset, this.yOffset, this.width, this.height);
    }
}

