/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.ckez;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.UploadContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkforge.ckez.CKeditor;
import org.zkoss.lang.Strings;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.au.http.AuExtension;
import org.zkoss.zk.au.http.DHtmlUpdateServlet;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class CkezUploadExtension
implements AuExtension {
    private static Logger logger = LoggerFactory.getLogger(CkezUploadExtension.class);
    private static final String nextURI = "~./ckez/html/fileupload-done.html.dsp";
    private ServletContext _ctx;

    public void init(DHtmlUpdateServlet servlet) throws ServletException {
        this._ctx = servlet.getServletContext();
    }

    public void destroy() {
    }

    public void service(HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        Session sess = Sessions.getCurrent((boolean)false);
        if (sess == null) {
            response.setIntHeader("ZK-Error", 410);
            return;
        }
        String dtid = request.getParameter("dtid");
        String uuid = request.getParameter("uuid");
        FileItem item = this.parseFileItem(this.toRequestContext(request));
        if (item == null) {
            return;
        }
        Desktop desktop = ((WebAppCtrl)sess.getWebApp()).getDesktopCache(sess).getDesktopIfAny(dtid);
        if (desktop == null) {
            return;
        }
        CKeditor ckez = (CKeditor)desktop.getComponentByUuidIfAny(uuid);
        if (ckez == null) {
            return;
        }
        String url = ckez.getSimpleUploadUrl();
        if (url == null) {
            logger.error("Upload failed because simpleUploadUrl was not set");
            return;
        }
        url = CkezUploadExtension.getFolderUrl(url);
        String path = request.getContextPath() + url;
        HashMap<String, String> attrs = new HashMap<String, String>();
        String serverPath = ckez.writeFileItem(path, desktop.getWebApp().getRealPath(url), item);
        String itemName = item.getName();
        attrs.put("path", serverPath.replace(itemName, URLEncoder.encode(itemName, "UTF-8").replace("+", "%20")));
        Servlets.forward((ServletContext)this._ctx, (ServletRequest)request, (ServletResponse)response, (String)nextURI, attrs, (int)3);
    }

    private RequestContext toRequestContext(final HttpServletRequest request) {
        return new UploadContext(){

            public String getCharacterEncoding() {
                return request.getCharacterEncoding();
            }

            public String getContentType() {
                return request.getContentType();
            }

            public int getContentLength() {
                return request.getContentLength();
            }

            public long contentLength() {
                long size;
                try {
                    size = Long.parseLong(request.getHeader("Content-length"));
                }
                catch (NumberFormatException e) {
                    size = request.getContentLength();
                }
                return size;
            }

            public InputStream getInputStream() throws IOException {
                return request.getInputStream();
            }
        };
    }

    private FileItem parseFileItem(RequestContext request) {
        if (ServletFileUpload.isMultipartContent((RequestContext)request)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)factory);
            servletFileUpload.setHeaderEncoding("UTF-8");
            try {
                List fileItemsList = servletFileUpload.parseRequest(request);
                for (FileItem item : fileItemsList) {
                    if (item.isFormField()) continue;
                    return item;
                }
            }
            catch (FileUploadException e) {
                logger.error("Upload failed", (Throwable)e);
            }
        }
        return null;
    }

    static String getFolderUrl(String url) {
        if (Strings.isBlank((String)url)) {
            return "";
        }
        if (((String)url).startsWith("./")) {
            url = ((String)url).substring(1);
        }
        if (!((String)url).startsWith("/")) {
            url = "/" + (String)url;
        }
        return url;
    }
}

