/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.ckez;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.zkforge.ckez.CkezFileWriter;
import org.zkoss.io.Files;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;

public final class CKeditor
extends AbstractComponent {
    private static String _fileUploadHandlePage = "";
    private String _simpleUploadUrl;
    private CkezFileWriter fileWriter;
    private String _type = "";
    private String _value = "";
    private String _height;
    private String _width = "100%";
    private boolean _readOnly = false;
    private String _customConfigurationsPath;
    private Map<String, Object> _config;
    private JavaScriptValue _customConfigContent;
    private String _txtByClient;
    private String _hflex;
    private String _vflex;
    private static final CkezFileWriter _defWriter;

    public static void setFileUploadHandlePage(String uri) {
        if (Strings.isEmpty((String)uri)) {
            throw new IllegalArgumentException("empty");
        }
        _fileUploadHandlePage = uri;
    }

    public static String getFileUploadHandlePage() {
        return _fileUploadHandlePage;
    }

    public String getSimpleUploadUrl() {
        return this._simpleUploadUrl;
    }

    public void setSimpleUploadUrl(String simpleUploadUrl) {
        if (!Objects.equals((Object)this._simpleUploadUrl, (Object)simpleUploadUrl)) {
            this._simpleUploadUrl = simpleUploadUrl;
            this.smartUpdate("simpleUploadUrl", simpleUploadUrl);
        }
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        if (!Objects.equals((Object)this._type, (Object)type)) {
            this._type = type;
            this.smartUpdate("type", type);
        }
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!value.equals(this._value)) {
            this._value = value;
            if (this._txtByClient == null || !Objects.equals((Object)this._txtByClient, (Object)value)) {
                this._txtByClient = null;
                this.smartUpdate("value", value);
            }
        }
    }

    public String getHeight() {
        return this._height;
    }

    public void setHeight(String height) {
        if (height != null && Strings.isEmpty((String)height)) {
            height = null;
        }
        if (!Objects.equals((Object)height, (Object)this._height)) {
            this._height = height;
            this.smartUpdate("height", height);
        }
    }

    public String getWidth() {
        return this._width;
    }

    public void setWidth(String width) {
        if (width != null && Strings.isEmpty((String)width)) {
            width = null;
        }
        if (!Objects.equals((Object)width, (Object)this._width)) {
            this._width = width;
            this.smartUpdate("width", width);
        }
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (!Objects.equals((Object)readOnly, (Object)this._readOnly)) {
            this._readOnly = readOnly;
            this.smartUpdate("readOnly", readOnly);
        }
    }

    public void setVflex(String flex) {
        if (flex != null && Strings.isEmpty((String)flex)) {
            flex = null;
        }
        if (!Objects.equals((Object)this._vflex, (Object)flex)) {
            this._vflex = flex;
            this.smartUpdate("vflex", flex);
        }
    }

    public String getVflex() {
        return this._vflex;
    }

    public void setHflex(String flex) {
        if (flex != null && Strings.isEmpty((String)flex)) {
            flex = null;
        }
        if (!Objects.equals((Object)this._hflex, (Object)flex)) {
            this._hflex = flex;
            this.smartUpdate("hflex", flex);
        }
    }

    public String getHflex() {
        return this._hflex;
    }

    public void setCustomConfigurationsPath(String url) {
        if (!Objects.equals((Object)this._customConfigurationsPath, (Object)url)) {
            this._customConfigurationsPath = url;
            this.readConfigFile(this._customConfigurationsPath);
        }
    }

    public String getCustomConfigurationsPath() {
        return this._customConfigurationsPath;
    }

    public void setConfig(Map<String, Object> config) {
        if (config != null) {
            this._config = config;
            this.smartUpdate("config", this._config);
        }
    }

    private String getCKSourceUrl() {
        return this.getEncodedURL(Library.getProperty((String)"org.zkforge.ckez.CKSource"));
    }

    private String[] getCKCssSourceUrls() {
        List urls = Library.getProperties((String)"org.zkforge.ckez.CKCssSource");
        if (urls == null) {
            return null;
        }
        return (String[])urls.stream().map(this::getEncodedURL).toArray(String[]::new);
    }

    public Map<String, Object> getConfig() {
        return this._config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        LocalDate endDate = LocalDate.parse("2025-06-30", DateTimeFormatter.ISO_DATE);
        LocalDate currentDate = LocalDate.now();
        if (currentDate.isAfter(endDate)) {
            throw new UiException("This is an evaluation copy of ZK CKEditor and has reached its uptime limit. Should you require a commercial license for ZK CKEditor, please contact us at info@zkoss.org.");
        }
        String cmd = request.getCommand();
        if (cmd.equals("onChange")) {
            String value;
            InputEvent evt = InputEvent.getInputEvent((AuRequest)request, (Object)this._value);
            this._txtByClient = value = evt.getValue();
            try {
                String oldval = this._value;
                this.setValue(value);
                if (oldval == this._value) {
                    return;
                }
            }
            finally {
                this._txtByClient = null;
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onChanging")) {
            Events.postEvent((Event)InputEvent.getInputEvent((AuRequest)request, (Object)this._value));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "type", this._type);
        this.render(renderer, "value", this._value);
        if (this._height != null) {
            this.render(renderer, "height", this._height);
        }
        if (!"100%".equals(this._width)) {
            this.render(renderer, "width", this._width);
        }
        this.render(renderer, "readOnly", this._readOnly);
        this.render(renderer, "config", this._config);
        this.render(renderer, "customConfigContent", this._customConfigContent);
        if (this._hflex != null) {
            this.render(renderer, "hflex", this._hflex);
        }
        if (this._vflex != null) {
            this.render(renderer, "vflex", this._vflex);
        }
        this.render(renderer, "fileUploadTemp", this.getEncodedURL(_fileUploadHandlePage));
        if (!Strings.isBlank((String)this._simpleUploadUrl)) {
            this.render(renderer, "simpleUploadUrl", this._simpleUploadUrl);
        }
        this.render(renderer, "ckSourceUrl", this.getCKSourceUrl());
        this.render(renderer, "cssSourceUrls", this.getCKCssSourceUrls());
    }

    private void readConfigFile(String path) {
        StringBuilder result = new StringBuilder();
        if (path != null) {
            InputStream inputStream = WebApps.getCurrent().getResourceAsStream(path);
            if (inputStream == null) {
                throw new UiException("Unable to load " + path);
            }
            try {
                byte[] bytes = Files.readAll((InputStream)inputStream);
                if (bytes.length > 0) {
                    result.append(new String(bytes, "UTF-8"));
                }
            }
            catch (IOException e) {
                throw new UiException("Unable to load " + path);
            }
            Files.close((InputStream)inputStream);
        }
        this._customConfigContent = new JavaScriptValue(result.toString());
    }

    private String getEncodedURL(String path) {
        if (path == null) {
            return "";
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(path) : "";
    }

    protected String writeFileItem(String uploadUrl, String realPath, FileItem item) {
        return (this.fileWriter != null ? this.fileWriter : _defWriter).writeFileItem(uploadUrl, realPath, item);
    }

    static {
        CKeditor.addClientEvent(CKeditor.class, (String)"onChange", (int)16385);
        CKeditor.addClientEvent(CKeditor.class, (String)"onChanging", (int)4096);
        _defWriter = new CkezFileWriter(){

            @Override
            public String writeFileItem(String uploadUrl, String realPath, FileItem item) {
                String fileName = item.getName();
                if (Strings.isEmpty((String)fileName)) {
                    throw new UiException("Empty filename: " + fileName);
                }
                File file = new File(realPath + "/" + (fileName = FilenameUtils.getName((String)fileName)));
                if (!file.getParentFile().exists()) {
                    throw new UiException("Folder not found: " + realPath);
                }
                try {
                    item.write(file);
                }
                catch (Exception e) {
                    throw new UiException("Failed to write file item", (Throwable)e);
                }
                return uploadUrl + "/" + fileName;
            }
        };
    }
}

