/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.util;

import java.util.List;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.GroupHandler;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotHeaderTree;
import org.zkoss.pivot.impl.util.Texts;

public class Trees {
    public static int getSubtotalCount(PivotHeaderNode node) {
        return Trees.getSubtotalCount(node, false);
    }

    public static int getSubtotalCount(PivotHeaderNode node, boolean open) {
        return (!open ? Trees.isTerminal(node) : node.isLeaf()) || Trees.isRoot(node) ? 0 : Trees.getSubtotalCount(node.getField());
    }

    public static int getSubtotalCount(PivotField field) {
        if (field == null) {
            return 0;
        }
        Calculator[] cals = field.getSubtotals();
        return cals == null ? 0 : cals.length;
    }

    public static Calculator getCalculator(PivotHeaderNode node, int index) {
        return Trees.getCalculator(node.getField(), index);
    }

    public static Calculator getCalculator(PivotField field, int index) {
        if (field == null) {
            return null;
        }
        if (index < 0) {
            return field.getSummary();
        }
        Calculator[] cals = field.getSubtotals();
        return cals != null && index < cals.length ? cals[index] : null;
    }

    public static Object getKey(PivotField field, Object value) {
        GroupHandler gh = field.getGroupHandler();
        return gh != null ? gh.getGroup(value) : value;
    }

    public static int getSize(PivotHeaderTree tree) {
        return Trees.getSize(tree, false);
    }

    public static int getSize(PivotHeaderTree tree, boolean open) {
        return Trees.getSize(tree.getRoot(), open);
    }

    public static boolean isTerminal(PivotHeaderNode node) {
        return node.isLeaf() || !node.isOpen();
    }

    public static boolean isRoot(PivotHeaderNode node) {
        return node.getDepth() == 0;
    }

    public static PivotHeaderNode getNode(PivotHeaderTree tree, Object[] keys) {
        PivotHeaderNode n = tree.getRoot();
        for (Object key : keys) {
            if ((n = Trees.getChild(n, key)) != null) continue;
            return null;
        }
        return n;
    }

    public static PivotHeaderNode getNode(PivotHeaderTree tree, int[] indicies) {
        PivotHeaderNode n = tree.getRoot();
        for (int i : indicies) {
            if (i >= 0) {
                n = Trees.getChild(n, i);
            }
            if (n != null) continue;
            return null;
        }
        return n;
    }

    public static void openDown(PivotHeaderNode node, boolean open) {
        if (node == null) {
            return;
        }
        node.setOpen(open);
        if (!node.isLeaf()) {
            for (PivotHeaderNode pivotHeaderNode : node.getChildren()) {
                Trees.openDown(pivotHeaderNode, open);
            }
        }
    }

    public static void traverse(PivotHeaderTree tree, NodeRunner runner) {
        Trees.traverse(tree, false, runner);
    }

    public static void traverse(PivotHeaderTree tree, boolean open, NodeRunner runner) {
        Trees.traverse(tree, open, 0, -1, runner);
    }

    public static void traverse(PivotHeaderTree tree, boolean asIfOpenAll, int offset, int limit, NodeRunner runner) {
        Trees.traverse(tree.getRoot(), new TreeTravCtx(asIfOpenAll), runner, offset, limit, 0, "");
    }

    private static void traverse(PivotHeaderNode node, TreeTravCtx tctx, NodeRunner runner, int offset, int limit, int dispIndex, String key) {
        int calsize;
        boolean asIfOpen = tctx.open;
        int nsize = node.getSize(asIfOpen);
        int tsize = nsize + (calsize = node.getSubtotalCount(asIfOpen));
        if (dispIndex + tsize < offset || limit > -1 && dispIndex > offset + limit) {
            return;
        }
        if (!node.isLeaf() && (node.isOpen() || asIfOpen)) {
            int i = 0;
            int cDispIndex = dispIndex;
            int keyDepth = node.getDepth();
            for (PivotHeaderNode pivotHeaderNode : node.getChildren()) {
                boolean afterRange;
                int chtsize = pivotHeaderNode.getSize(asIfOpen) + pivotHeaderNode.getSubtotalCount(asIfOpen);
                boolean beforeRange = cDispIndex + chtsize <= offset;
                boolean bl = afterRange = limit > -1 && cDispIndex >= offset + limit;
                if (!beforeRange && !afterRange) {
                    String ckey = key + Texts.getRankKey(i++, keyDepth);
                    Trees.traverse(pivotHeaderNode, tctx, runner, offset, limit, cDispIndex, ckey);
                }
                if (afterRange) break;
                cDispIndex += chtsize;
            }
        }
        tctx.index = dispIndex;
        tctx.calsize = calsize;
        tctx.nodesize = nsize;
        tctx.postindex = dispIndex + tsize;
        tctx.key = key;
        runner.onNode(node, tctx);
    }

    private static int getSize(PivotHeaderNode node, boolean alwaysOpen) {
        if (alwaysOpen ? node.isLeaf() : Trees.isTerminal(node)) {
            return Trees.isRoot(node) ? 0 : 1;
        }
        int size = Trees.getSubtotalCount(node, alwaysOpen);
        for (PivotHeaderNode pivotHeaderNode : node.getChildren()) {
            size += Trees.getSize(pivotHeaderNode, alwaysOpen);
        }
        return size;
    }

    private static PivotHeaderNode getChild(PivotHeaderNode node, Object key) {
        if (node == null || node.isLeaf()) {
            return null;
        }
        for (PivotHeaderNode pivotHeaderNode : node.getChildren()) {
            Object cElem = pivotHeaderNode.getKey();
            if ((cElem != null || key != null) && !cElem.equals(key)) continue;
            return pivotHeaderNode;
        }
        return null;
    }

    private static PivotHeaderNode getChild(PivotHeaderNode node, int index) {
        if (node == null || node.isLeaf()) {
            return null;
        }
        List<? extends PivotHeaderNode> list = node.getChildren();
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public static interface NodeRunner {
        public void onNode(PivotHeaderNode var1, TreeTravCtx var2);
    }

    public static class TreeTravCtx {
        final boolean open;
        int index = 0;
        int postindex = 0;
        int nodesize = 0;
        int calsize = 0;
        String key = "";

        public TreeTravCtx(boolean open) {
            this.open = open;
        }

        public boolean open() {
            return this.open;
        }

        public int index() {
            return this.index;
        }

        public int postindex() {
            return this.postindex;
        }

        public int nodesize() {
            return this.nodesize;
        }

        public int calsize() {
            return this.calsize;
        }

        public String key() {
            return this.key;
        }
    }
}

