/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.ui.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotModelExt;
import org.zkoss.pivot.ui.PivotFieldControl;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.GenericForwardComposer;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Window;

public class SubtotalSelectionController
extends GenericForwardComposer {
    private static final long serialVersionUID = 393767088129147286L;
    private PivotFieldControl _pfc;
    private PivotModelExt _model;
    private PivotField _field;
    private Window modalSubtotal;
    private Listbox subs;

    public void onClick$okBtn(Event event) {
        this._pfc.setSubtotals(this._field, this.getSelectedCalculators());
        this.modalSubtotal.detach();
    }

    public void onClick$cancelBtn(Event event) {
        this.modalSubtotal.detach();
    }

    private Calculator[] getSelectedCalculators() {
        LinkedList<Calculator> selected = new LinkedList<Calculator>();
        for (Object obj : this.subs.getItems()) {
            Listitem item = (Listitem)obj;
            if (!item.isSelected()) continue;
            selected.add((Calculator)item.getValue());
        }
        if (selected.isEmpty()) {
            return null;
        }
        return selected.toArray(new Calculator[0]);
    }

    private Listitem createListitem(Calculator cal, boolean selected) {
        String name = Labels.getLabel((String)cal.getLabelKey(), (String)cal.getLabel());
        Listitem item = new Listitem(name);
        item.setSelected(selected);
        item.setValue((Object)cal);
        return item;
    }

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        this._field = (PivotField)this.arg.get("_field");
        this._model = (PivotModelExt)this.arg.get("_model");
        this._pfc = (PivotFieldControl)((Object)this.arg.get("_pfc"));
        Calculator[] cals = this._model.getSupportedCalculators();
        Calculator[] selectedArr = this._pfc.getSubtotals(this._field);
        List<Calculator> selected = selectedArr == null ? null : Arrays.asList(selectedArr);
        for (Calculator cal : cals) {
            this.subs.appendChild((Component)this.createListitem(cal, selected != null && selected.contains(cal)));
        }
    }
}

