/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.rt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.pivot.lic.LicenseContent;
import org.zkoss.pivot.lic.LicenseManager;
import org.zkoss.pivot.lic.LicenseParam;
import org.zkoss.pivot.lic.util.ObfuscatedString;
import org.zkoss.pivot.rt.Refresh;
import org.zkoss.pivot.rt.Runtime;
import org.zkoss.util.Cleanups;
import org.zkoss.util.Dates;
import org.zkoss.zk.ui.WebApp;

public class RuntimeLicenseManager
extends LicenseManager {
    private final Object _lock = new Object();
    private volatile Timer _timer;
    private volatile WebApp _wapp;
    private List<LicenseContent> _contents;
    private volatile String _dirName;
    private volatile long _latest;
    private final Refresh _refresh;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMMM dd, yyyy", Locale.US);
    private static final int HOUR = 3600000;
    private static final String IN_JAR_LIC_PATH = new ObfuscatedString(new long[]{334623128646881506L, 4210166967390230177L, 2867482134077832772L, 1664671143354443148L, 7636913026727141768L, -8073997860721665973L, 5055377157582512975L, 3608693130409156462L}).toString();
    private static final String WARNING_UNKNOWN_MSG = new ObfuscatedString(new long[]{4307748939090133289L, 3763454470649753422L, -6872730590590579063L, -4639536792232415440L, -5784189857893158816L, 7307901420180268778L, -627643376646394353L, -7420280774293424959L, 2656306477204072694L, -2499488659900337288L, -8059070027533673028L, 7471492367409620715L, 822853263747496262L, -2451111032939294087L, 5181597043837345221L, -5675751368559367806L, 5049843703446154799L, 9141315134085574909L, -6165825001738499911L, -8027923838117731411L, -6842157638029734249L}).toString();

    public static RuntimeLicenseManager getInstance(LicenseParam param, Refresh refresh) {
        return new RuntimeLicenseManager(param, refresh);
    }

    public void setWapp(WebApp wapp) {
        this._wapp = wapp;
    }

    private RuntimeLicenseManager(LicenseParam param, Refresh refresh) {
        super(param);
        this._refresh = refresh;
    }

    public boolean install(String dirName) {
        File dir = new File(dirName);
        boolean isDir = dir.isDirectory();
        if (!isDir) {
            return false;
        }
        File[] files = isDir ? dir.listFiles() : new File[]{};
        this._dirName = dirName;
        this.install0(files);
        return true;
    }

    public LicenseContent install(byte[] b) throws Exception {
        return this.install(b, this.getLicenseNotary());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install0(File[] files) {
        Object object = this._lock;
        synchronized (object) {
            this._contents = new ArrayList<LicenseContent>(files.length + 1);
            HashMap<String, Object> _certMap = new HashMap<String, Object>();
            this._latest = 0L;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                this._latest += f.lastModified() + f.length();
                try {
                    LicenseContent lc = this.install(f);
                    if (lc != null && this.install1(lc, _certMap, f.getPath())) continue;
                }
                catch (Exception e) {
                    RuntimeLicenseManager.log(WARNING_UNKNOWN_MSG + files[i].getPath());
                }
            }
            this._latest *= (long)files.length;
            if (this._refresh != null) {
                this._refresh.refresh(this._contents);
            }
            if (this._contents.isEmpty() && this._latest == 0L) {
                RuntimeLicenseManager.log(new ObfuscatedString(new long[]{-6899918244677316866L, 2946753050424552565L, -1166500401249160465L, -6361152391287683152L, -1012658505712928448L, 2102941868302252760L, 3901913952577343105L, 1861727708660677834L, -3196033244540681827L, -1179475304557705732L, -8292713655681148352L, 1846152504906808191L, -5915587415450046371L, 7423933818392029259L, -8624164244204572166L, -1535967842794712539L, 8072868225759836711L, -3862751912709119543L}).toString());
            }
        }
    }

    private boolean install1(LicenseContent lc, Map<String, Object> certMap, String resPath) {
        Object mapobj = lc.getExtra();
        if (!(mapobj instanceof Map)) {
            RuntimeLicenseManager.log(WARNING_UNKNOWN_MSG + resPath);
            return false;
        }
        Map mapInfo = (Map)lc.getExtra();
        if (!this._refresh.isTargetSubject(mapInfo)) {
            return false;
        }
        String number = (String)mapInfo.get(Runtime.VERIFICATION_NUMBER);
        if (number == null || certMap.containsKey(number)) {
            RuntimeLicenseManager.log(mapInfo.get(Runtime.WARNING_NUMBER) + resPath);
            return false;
        }
        certMap.put(number, Boolean.TRUE);
        if (!this._refresh.checkVersion(mapInfo)) {
            RuntimeLicenseManager.log(mapInfo.get(Runtime.WARNING_VERSION) + resPath);
            return false;
        }
        if (Dates.today().after(this.getExpiryDate(lc))) {
            RuntimeLicenseManager.log(mapInfo.get(Runtime.WARNING_EXPIRY) + resPath);
            return false;
        }
        this._contents.add(lc);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getInJarLic() throws Exception {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(IN_JAR_LIC_PATH);
        ArrayList<Integer> list = new ArrayList<Integer>();
        int b = 0;
        try {
            while ((b = in.read()) > -1) {
                list.add(b);
            }
            byte[] bs = new byte[list.size()];
            for (int i = 0; i < bs.length; ++i) {
                bs[i] = (byte)((Integer)list.get(i)).intValue();
            }
            byte[] byArray = bs;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScheduler() {
        if (this._timer != null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._timer == null) {
                this._timer = new Timer();
                Cleanups.add((Cleanups.Cleanup)new Cleanups.Cleanup(){

                    public void cleanup() {
                        RuntimeLicenseManager.this.stopScheduler();
                    }
                });
            }
        }
        this.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScheduler() {
        Object object = this._lock;
        synchronized (object) {
            if (this._timer != null) {
                this._timer.cancel();
                this._timer = null;
            }
        }
    }

    private void check() {
        try {
            this.checkLatest();
            if (this._timer != null) {
                this._timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        RuntimeLicenseManager.this.check();
                    }
                }, this.getDelay());
            }
        }
        catch (FileNotFoundException e) {
            RuntimeLicenseManager.log(Runtime.EVAL_ONLY + ". " + Runtime.WARNING_EVALUATION);
            if (this._wapp != null) {
                this._wapp.setAttribute(Runtime.ZK_NOTICE, (Object)Runtime.getEvalNotice(this._wapp));
            }
            this.stopScheduler();
        }
    }

    private boolean hasInJarLic() {
        return Thread.currentThread().getContextClassLoader().getResource(IN_JAR_LIC_PATH) != null;
    }

    private void checkLatest() throws FileNotFoundException {
        File[] files;
        File dir = new File(this._dirName);
        boolean isDir = dir.isDirectory();
        File[] fileArray = files = isDir ? dir.listFiles() : new File[]{};
        if (!isDir && !this.hasInJarLic()) {
            throw new FileNotFoundException();
        }
        long latest = 0L;
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            latest += f.lastModified() + f.length();
        }
        LicenseContent lc = this.getMaximum();
        if (this._latest != (latest *= (long)files.length) || lc != null && Dates.today().after(this.getExpiryDate(lc))) {
            this.install0(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseContent getMaximum() {
        LicenseContent lc = null;
        Object object = this._lock;
        synchronized (object) {
            for (int i = 0; i < this._contents.size(); ++i) {
                LicenseContent lc1 = this._contents.get(i);
                if (lc != null && !this.getExpiryDate(lc).before(this.getExpiryDate(lc1))) continue;
                lc = lc1;
            }
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDelay() {
        Object object = this._lock;
        synchronized (object) {
            if (this._contents.isEmpty()) {
                return 3600000L;
            }
            int delay = 0;
            for (int i = 0; i < this._contents.size(); ++i) {
                int d = (Integer)((Map)this._contents.get(i).getExtra()).get(Runtime.CHECK_PERIOD);
                if (delay == 0) {
                    delay = d;
                    continue;
                }
                if (delay <= d) continue;
                delay = d;
            }
            return delay * 3600000;
        }
    }

    private Date getExpiryDate(LicenseContent lc) {
        try {
            String dt = (String)((Map)lc.getExtra()).get(Runtime.EXPIRY_DATE);
            return DATE_FORMAT.parse(dt);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static void info(String msg) {
        msg = "\n" + (String)msg + "\n";
        Logger log = LoggerFactory.getLogger((String)"global");
        if (log.isInfoEnabled()) {
            log.info((String)msg);
        } else {
            System.out.println((String)msg);
        }
    }

    public static void log(String msg) {
        msg = "\n" + (String)msg + "\n";
        Logger log = LoggerFactory.getLogger((String)"global");
        if (log.isErrorEnabled()) {
            log.error((String)msg);
        } else {
            System.err.println((String)msg);
        }
    }
}

