/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.rt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;
import org.zkoss.io.Files;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.pivot.Pivottable;
import org.zkoss.pivot.lic.CipherParam;
import org.zkoss.pivot.lic.KeyStoreParam;
import org.zkoss.pivot.lic.LicenseContent;
import org.zkoss.pivot.lic.LicenseParam;
import org.zkoss.pivot.lic.util.ObfuscatedString;
import org.zkoss.pivot.rt.Refresh;
import org.zkoss.pivot.rt.RuntimeInfo;
import org.zkoss.pivot.rt.RuntimeLicenseManager;
import org.zkoss.util.Dates;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zul.Window;

public class Runtime {
    static final String ACTIVE_CODE = new ObfuscatedString(new long[]{2927261568102559820L, 5003116366233426486L, -19977163214018644L}).toString();
    static final String LICENSE_SUBJECT = new ObfuscatedString(new long[]{3902422651215371349L, 8624385350820619417L, -642393240400619653L}).toString();
    static final String UP_TIME = new ObfuscatedString(new long[]{7735875781470822017L, 7449797441543358756L}).toString();
    static final String SESSION_COUNT = new ObfuscatedString(new long[]{3229559844559651902L, 4507837234696327046L, 7727269190283665611L}).toString();
    static final String USER_NAME = new ObfuscatedString(new long[]{-7156956517562311570L, -4569457626895068567L, -9130454531809692735L}).toString();
    static final String COMPANY_ID = new ObfuscatedString(new long[]{-3429614419320347732L, 5284083613633888871L, -2962259370126176133L}).toString();
    static final String COMPANY_UNIT = new ObfuscatedString(new long[]{4535911707703337843L, -5339041739265159617L, -8006648055853745059L}).toString();
    static final String COMPANY_NAME = new ObfuscatedString(new long[]{-7340139527016707886L, -5203243759892677212L, 8714822623115369524L}).toString();
    static final String COMPANY_CITY = new ObfuscatedString(new long[]{-6925611054058810462L, 2143563004714040551L, 1994584055053707741L}).toString();
    static final String COMPANY_ADDRESS = new ObfuscatedString(new long[]{-8691848786421899489L, -4370996558863340632L, -2709933490946981238L}).toString();
    static final String COMPANY_ZIPCODE = new ObfuscatedString(new long[]{-4934501068656857753L, -6913828373145765012L, 1063193634233753528L}).toString();
    static final String COUNTRY = new ObfuscatedString(new long[]{-4504969373906269801L, 5248137891553083335L}).toString();
    static final String PROJECT_NAME = new ObfuscatedString(new long[]{830623621279886032L, 459360910074040759L, 4178520520701877821L}).toString();
    static final String PRODUCT_NAME = new ObfuscatedString(new long[]{5504882338648710617L, -4761731334749763195L, 996375918662338065L}).toString();
    static final String PACKAGE = new ObfuscatedString(new long[]{-8439029564924938530L, -4878278112849633009L}).toString();
    static final String VERSION = new ObfuscatedString(new long[]{-4847689528984584834L, 2493253216426408014L}).toString();
    static final String ISSUE_DATE = new ObfuscatedString(new long[]{-4228764154858292882L, -6898004159031332466L, 6328666951570048917L}).toString();
    static final String EXPIRY_DATE = new ObfuscatedString(new long[]{-7233890858958970371L, -3423973165832030856L, -5810612950970282077L}).toString();
    static final String TERM = new ObfuscatedString(new long[]{-6725301182108235475L, -8691110408124621856L}).toString();
    static final String VERIFICATION_NUMBER = new ObfuscatedString(new long[]{3823288740853721680L, -6436340937747658512L, 891079956768101415L, 751513662528431611L}).toString();
    static final String INFORMATION = new ObfuscatedString(new long[]{378870925371295609L, 1418863983102047429L, -5017007170548372422L}).toString();
    static final String KEY_SIGNATURE = new ObfuscatedString(new long[]{-2573177027008659676L, 5066716785755217927L, 5769746383701090690L}).toString();
    static final String CHECK_PERIOD = new ObfuscatedString(new long[]{-2439022525501632135L, 6139476070014855270L, -297657911147084449L}).toString();
    static final String LICENSE_VERSION = new ObfuscatedString(new long[]{-7080462743270045357L, 6928867389785115158L, -154565539896996742L}).toString();
    static final String WARNING_EXPIRY = new ObfuscatedString(new long[]{-2088056424898980973L, -3616911578495445651L, -8353968737700076168L}).toString();
    static final String WARNING_PACKAGE = new ObfuscatedString(new long[]{7436618834759965309L, 8220698497085578148L, -6394078374620879850L}).toString();
    static final String WARNING_VERSION = new ObfuscatedString(new long[]{7417971821667979026L, 7464186339852802771L, 7986314911006223431L}).toString();
    static final String WARNING_COUNT = new ObfuscatedString(new long[]{-1510608780643214737L, 6313704540210276937L, 4115504365890483558L}).toString();
    static final String WARNING_NUMBER = new ObfuscatedString(new long[]{8367990676393660796L, -7163797910637480555L, -8349581027556623805L}).toString();
    public static final String WARNING_EVALUATION = new ObfuscatedString(new long[]{-1740773785183900298L, -4881158860774983859L, -2991397620302467737L, -7349736881088356839L, 3666021725650647666L, 2849025875216884186L, 6660668579281019946L, 4226985007913783712L, 8440943835454794245L, 4192589650040076978L, -5657238731441515411L, -7601306589842657464L, -650642122472051042L, -1164923849505093869L, 5963126032792595172L, -3662216251649290372L, -9185488927650810783L, -8181212859736233334L, -6194755614340367034L, -356791608270490811L, -8932791912237566908L, -7006948351671313493L, -3345335953648875623L, -6810966096394011062L, -3372888729994393543L, 6066588212675724663L, 2151122845438705311L, 6238587147596355970L, 8920728957506721934L, -2643684496001829973L, 8995865330399708419L, 4126492294715186738L, -8994700697801964845L, -3176976168679850228L}).toString();
    static final String ZKPVT = new ObfuscatedString(new long[]{117548193744805329L, 6243716141877698774L, -6719441228854306328L}).toString();
    private static final String PUB_STORE = new ObfuscatedString(new long[]{7619320954481364735L, -2511560626409573909L, -2106924332709135221L, -3273324157582547059L}).toString();
    private static final String ALIAS = new ObfuscatedString(new long[]{-2751357802016299199L, 4066217211348802619L, -2064662869185498634L, 4043793295118034741L, 6227175189710674534L}).toString();
    private static final String STORE_PASS = new ObfuscatedString(new long[]{-8677088790027852212L, 4602056908258993522L, 8019503246186939872L, -1944004741470673738L, -7033589056015316549L}).toString();
    private static final ThreadLocal<Boolean> _pass = new ThreadLocal();
    private static boolean _ck;
    private static LicenseParam _licenseParam;
    private static KeyStoreParam _keystoreParam;
    private static CipherParam _cipherParam;
    private static final RuntimeLicenseManager _licManager;
    private static WebApp _wapp;
    private static final String V0;
    private static final String V1;
    private static final String MD5STR;
    public static final String EVAL_ONLY;
    static final String UNIVERSAL_ACTIVE_CODE;
    static final String ZK_NOTICE;
    static final String LICENSE_DIRECTORY_PROPERTY;
    private static final String DEFAULT_LICENSE_DIRECTORY;

    private static final String read(String path) {
        try {
            InputStream is = Runtime.class.getResourceAsStream("/metainfo/zkpvt/" + path);
            if (is != null) {
                return new String(Files.readAll((InputStream)is));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static final boolean init(WebApp wapp, boolean ck) {
        boolean b = true;
        if (ck && !_ck) {
            boolean hasLicenseFieOrFolder;
            _ck = true;
            boolean pvt = "ZK PVT".equals(Runtime.read("pvt"));
            boolean init = true;
            boolean bl = hasLicenseFieOrFolder = Library.getProperty((String)LICENSE_DIRECTORY_PROPERTY) != null || Runtime.class.getResource(DEFAULT_LICENSE_DIRECTORY) != null;
            if (pvt && !hasLicenseFieOrFolder) {
                init = false;
            }
            if (init) {
                wapp.setAttribute(ACTIVE_CODE, (Object)Runtime.getActiveCode());
                try {
                    b = Runtime.init1(wapp);
                    wapp.getConfiguration().addListener(Init.class);
                    b = b && _pass.get() != false;
                    _pass.remove();
                }
                catch (Exception e) {
                    b = false;
                }
            }
            if (pvt) {
                wapp = null;
            }
            if (!b && wapp != null) {
                wapp.setAttribute(ZK_NOTICE, (Object)Runtime.getEvalNotice(wapp));
            }
        }
        return b;
    }

    private static final String getActiveCode() {
        Preferences pref = _licenseParam.getPreferences();
        if (pref != null) {
            long leastv = pref.getLong(V0, 0L);
            long mostv = pref.getLong(V1, 0L);
            if (leastv == 0L && mostv == 0L) {
                UUID uuid = UUID.randomUUID();
                long most = uuid.getMostSignificantBits();
                long least = uuid.getLeastSignificantBits();
                pref.putLong(V0, least);
                pref.putLong(V1, most);
                if (least == pref.getLong(V0, 0L) && most == pref.getLong(V1, 0L)) {
                    return Runtime.uuidToMD5(most, least);
                }
            } else {
                return Runtime.uuidToMD5(mostv, leastv);
            }
        }
        return null;
    }

    private static final String uuidToMD5(long most, long least) {
        String hostname = null;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                InetAddress ia;
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isVirtual()) continue;
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements() && "localhost".equals(hostname = (ia = ias.nextElement()).getHostName())) {
                    hostname = null;
                }
                if (hostname == null) continue;
                break;
            }
        }
        catch (SocketException nis) {
            // empty catch block
        }
        try {
            int j;
            long mostsalt = -8556922120573852888L;
            long leastsalt = -7110043422976597898L;
            if (hostname == null) {
                hostname = "ZK Host";
            }
            byte[] hostbytes = hostname.getBytes("UTF-8");
            long host = 0L;
            for (j = 0; j < hostbytes.length && j < 8; ++j) {
                host |= ((long)hostbytes[j] & 0xFFL) << j * 8;
            }
            leastsalt ^= host;
            if (hostbytes.length > 8) {
                host = 0L;
                int len = hostbytes.length - 8;
                for (j = 0; j < len && j < 8; ++j) {
                    host |= ((long)hostbytes[j + 8] & 0xFFL) << j * 8;
                }
                mostsalt ^= host;
            }
            String uuidStr = new UUID(most ^ mostsalt, least ^ leastsalt).toString();
            MessageDigest digest = MessageDigest.getInstance(MD5STR);
            if (digest != null) {
                digest.reset();
                digest.update(uuidStr.getBytes("UTF-8"));
                byte[] digested = digest.digest();
                BigInteger bigInt = new BigInteger(1, digested);
                String result = bigInt.toString(36);
                StringBuffer sb = new StringBuffer(32);
                for (int j2 = 0; j2 < result.length(); ++j2) {
                    if (j2 > 0 && j2 % 5 == 0) {
                        sb.append("-");
                    }
                    sb.append(result.charAt(j2));
                }
                return sb.toString().toUpperCase();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    static String getEvalNotice(WebApp wapp) {
        StringBuffer sb = new StringBuffer();
        Object o = wapp.getAttribute(ZK_NOTICE);
        if (o != null) {
            sb.append(o);
        }
        sb.append(" -->\n").append("<!-- ").append(ZKPVT).append(" ").append("3.1.0");
        sb.append(EVAL_ONLY);
        return sb.toString();
    }

    private static final boolean init1(WebApp wapp) {
        _wapp = wapp;
        String dir = Library.getProperty((String)LICENSE_DIRECTORY_PROPERTY);
        boolean isScheduled = false;
        if (dir != null) {
            isScheduled = _licManager.install(dir);
        } else {
            URL url = Runtime.class.getResource(DEFAULT_LICENSE_DIRECTORY);
            if (url != null) {
                isScheduled = _licManager.install(url.getFile());
            }
        }
        if (isScheduled) {
            _licManager.setWapp(wapp);
            _licManager.startScheduler();
            return true;
        }
        Runtime.init1().init2(null);
        return false;
    }

    private static Init1 init1() {
        return Init1._init1;
    }

    public static final void token(Object exec, Object exec2) {
        Runtime.token0(exec, exec2);
    }

    public static final boolean token(Object exec) {
        return Runtime.token0(exec);
    }

    private static final boolean token0(Object exec) {
        if (exec instanceof Execution) {
            return ((Execution)exec).getAttribute(Runtime.token1(exec)) != null;
        }
        if (exec instanceof Session) {
            return ((Session)exec).getAttribute(Runtime.token1(exec)) != null;
        }
        return false;
    }

    private static final void token0(Object exec, Object exec2) {
        if (exec instanceof Execution) {
            ((Execution)exec2).setAttribute(Runtime.token1(exec), (Object)Boolean.TRUE);
        } else if (exec instanceof Session) {
            ((Session)exec2).setAttribute(Runtime.token1(exec), (Object)Boolean.TRUE);
        }
    }

    private static final String token1(Object exec) {
        Desktop desktop;
        MessageDigest digest;
        Execution exec0 = Executions.getCurrent();
        String plaintext = "mgws" + (exec instanceof Execution ? ((Execution)exec).getDesktop().getId() : (exec instanceof Desktop ? ((Desktop)exec).getId() : (exec0 != null ? exec0.getRemoteAddr() : null))) + "wysb";
        if (exec0 != null && (digest = (MessageDigest)(desktop = exec0.getDesktop()).getAttribute("md_" + desktop.getId())) != null) {
            digest.reset();
            try {
                digest.update(plaintext.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            byte[] digested = digest.digest();
            BigInteger bigInt = new BigInteger(1, digested);
            return bigInt.toString(36);
        }
        return plaintext;
    }

    private static int stringHash(String value) {
        if (value == null) {
            return 0;
        }
        int off = 0;
        int h = 0;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            h = 31 * h + value.charAt(off++);
        }
        return h;
    }

    public static long getCheckSum(RuntimeInfo result) {
        long checksum = 0L;
        X500Principal hobj = result.getHolder();
        checksum += hobj == null ? 0L : (long)Runtime.stringHash(hobj.getName());
        X500Principal iobj = result.getIssuer();
        checksum += iobj == null ? 0L : (long)Runtime.stringHash(iobj.getName());
        int count = result.getConsumerAmount();
        checksum += (long)count;
        String type = result.getConsumerType();
        checksum += (long)Runtime.stringHash(type);
        String info = result.getInfo();
        checksum += (long)Runtime.stringHash(info);
        Date issued = result.getIssued();
        checksum += issued.getTime();
        Date start = result.getNotBefore();
        checksum += start == null ? 0L : start.getTime();
        Date end = result.getNotAfter();
        checksum += end == null ? 0L : end.getTime();
        String subject = result.getSubject();
        checksum += (long)Runtime.stringHash(subject);
        String licId = result.getLicId();
        checksum += (long)Runtime.stringHash(licId);
        String licVer = result.getLicVer();
        checksum += (long)Runtime.stringHash(licVer);
        String userId = result.getUserId();
        checksum += (long)Runtime.stringHash(userId);
        String userName = result.getUserName();
        checksum += (long)Runtime.stringHash(userName);
        String companyId = result.getCompanyId();
        checksum += (long)Runtime.stringHash(companyId);
        String companyName = result.getCompanyName();
        checksum += (long)Runtime.stringHash(companyName);
        long sessionCount = result.getSessionCount();
        checksum += sessionCount;
        String zkpvtVer = result.getZkpvtVer();
        return checksum += (long)Runtime.stringHash(zkpvtVer);
    }

    static {
        _licenseParam = new LicenseParam(){

            @Override
            public String getSubject() {
                return ZKPVT;
            }

            @Override
            public Preferences getPreferences() {
                return null;
            }

            @Override
            public KeyStoreParam getKeyStoreParam() {
                return _keystoreParam;
            }

            @Override
            public CipherParam getCipherParam() {
                return _cipherParam;
            }
        };
        _keystoreParam = new KeyStoreParam(){

            @Override
            public InputStream getStream() throws IOException {
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PUB_STORE);
                if (in == null) {
                    throw new FileNotFoundException(PUB_STORE);
                }
                return in;
            }

            @Override
            public String getAlias() {
                return ALIAS;
            }

            @Override
            public String getStorePwd() {
                return STORE_PASS;
            }

            @Override
            public String getKeyPwd() {
                return null;
            }
        };
        _cipherParam = new CipherParam(){

            @Override
            public String getKeyPwd() {
                return new ObfuscatedString(new long[]{-9017617134232705315L, -3067316756544620689L, -7174741455541659722L, 9223059116147577819L, -7389013047307896124L}).toString();
            }
        };
        _licManager = RuntimeLicenseManager.getInstance(_licenseParam, new Refresh(){

            @Override
            public boolean checkVersion(Map<String, Object> map) {
                String version = (String)map.get(VERSION);
                return Strings.isBlank((String)version) || "3.1.0".startsWith(version);
            }

            @Override
            public boolean isTargetSubject(Map<String, Object> map) {
                String subject = (String)map.get(LICENSE_SUBJECT);
                return ZKPVT.equals(subject);
            }

            @Override
            public Object refresh(List<LicenseContent> contents) {
                Runtime.init1().init2(contents);
                this.printInfo(contents);
                return null;
            }

            private void printInfo(List<LicenseContent> contents) {
                for (int i = 0; i < contents.size(); ++i) {
                    Map map;
                    LicenseContent lc = contents.get(i);
                    Object mapObj = lc.getExtra();
                    if (!(mapObj instanceof Map) || !this.isTargetSubject(map = (Map)mapObj)) continue;
                    this.info((String)map.get(INFORMATION));
                }
            }

            private void info(String msg) {
                RuntimeLicenseManager.info(msg);
            }
        });
        V0 = new ObfuscatedString(new long[]{6780048183396145217L, -3514785424911510459L}).toString();
        V1 = new ObfuscatedString(new long[]{-8556922120573852888L, 708543790670807158L}).toString();
        MD5STR = new ObfuscatedString(new long[]{-5121064899839768052L, 3334273322282769989L}).toString();
        EVAL_ONLY = new ObfuscatedString(new long[]{8330515038476062730L, -435229286498387605L, -3853053404258091660L}).toString();
        UNIVERSAL_ACTIVE_CODE = new ObfuscatedString(new long[]{-8406957250436102276L, 7739080853276730995L, 2446544582485916568L, 4141763441450886800L, 9163385588230618037L, 3078723322430394289L}).toString();
        ZK_NOTICE = new ObfuscatedString(new long[]{-8347842002405430398L, 3574087500300642980L, -6273607823570371127L, -5524402949239665762L}).toString();
        LICENSE_DIRECTORY_PROPERTY = new ObfuscatedString(new long[]{5816649691849930674L, -5761991303987013008L, 4331060779597072695L, 7388509901079910646L, 2126659729105730467L, -3530608022047837130L}).toString();
        DEFAULT_LICENSE_DIRECTORY = new ObfuscatedString(new long[]{7214678189709147251L, 7657587572523939480L, -1488928056934183008L, 1423567538836833602L}).toString();
    }

    static final class LicenseEvent
    extends Event {
        private static final long serialVersionUID = 201011241551L;

        private LicenseEvent(Event event) {
            super("onLicense", event.getTarget());
        }
    }

    private static abstract class Init0
    implements ExecutionInit,
    DesktopInit,
    DesktopCleanup,
    EventInterceptor {
        private Init0() {
            this.init1();
        }

        private final void init0(Desktop desktop, Object request) throws Exception {
            this.init1().init0(desktop, request);
        }

        private final void cleanup0(Desktop desktop) throws Exception {
            this.init1().cleanup0(desktop);
        }

        private final void init2(Execution exec, Execution parent) throws Exception {
            this.init1().init2(exec, parent);
        }

        private final Init1 init1() {
            return Init1._init1;
        }

        private final void afterProcessEvent0(Event event) {
            this.init1().afterProcessEvent0(event);
        }

        private final Event beforePostEvent0(Event event) {
            return this.init1().beforePostEvent0(event);
        }

        private final Event beforeProcessEvent0(Event event) {
            return this.init1().beforeProcessEvent0(event);
        }

        private final Event beforeSendEvent0(Event event) {
            return this.init1().beforeSendEvent0(event);
        }
    }

    public static final class Init
    extends Init0 {
        public void init(Desktop desktop, Object request) throws Exception {
            super.init0(desktop, request);
        }

        public void cleanup(Desktop desktop) throws Exception {
            super.cleanup0(desktop);
        }

        public void init(Execution exec, Execution parent) throws Exception {
            super.init2(exec, parent);
        }

        public void afterProcessEvent(Event event) {
            super.afterProcessEvent0(event);
        }

        public Event beforePostEvent(Event event) {
            return super.beforePostEvent0(event);
        }

        public Event beforeProcessEvent(Event event) {
            return super.beforeProcessEvent0(event);
        }

        public Event beforeSendEvent(Event event) {
            return super.beforeSendEvent0(event);
        }
    }

    private static final class Init2 {
        private static final BigInteger _pkey = new BigInteger("123");
        private static final String EVAL_LIC_ID = new ObfuscatedString(new long[]{-2799362229550136139L, -8991339801923478651L, 2054766831045471090L}).toString();
        private static final String EVAL_LIC_VER = new ObfuscatedString(new long[]{4515837249784318634L, -483965117545718936L}).toString();
        private static final String EVAL_USER_NAME = new ObfuscatedString(new long[]{6700787382705499563L, 2359114071391082446L, 1949693015831576717L}).toString();
        private static final String EVAL_COMPANY_ID = new ObfuscatedString(new long[]{8997629646135421336L, -7459597106373371040L, 3324566901651534592L}).toString();
        private static final String EVAL_COMPANY_NAME = new ObfuscatedString(new long[]{-7105953592593293452L, -8116579615415252408L, -3117127378177258899L, 9036340616621476990L}).toString();
        private SimpleDateFormat _dateFormat = new SimpleDateFormat("MMMM dd, yyyy", Locale.US);
        private Map<String, Object> _keys = new HashMap<String, Object>();
        private Object _licid;
        private Object _licversion;
        private Object _username;
        private Object _companyid;
        private Object _companyname;
        private Object _validbegin;
        private Object _validend;
        private Object _zkpvtversion;
        private Object _uptime;

        private Init2() {
        }

        private Date getNotBefore(Map map) {
            try {
                return this._dateFormat.parse((String)map.get(ISSUE_DATE));
            }
            catch (ParseException e) {
                return new Date(Long.MAX_VALUE);
            }
        }

        private Date getExpiryDate(Map map) {
            try {
                return this._dateFormat.parse((String)map.get(EXPIRY_DATE));
            }
            catch (ParseException e) {
                return new Date(Long.MIN_VALUE);
            }
        }

        private long getUpTime(Map<String, Object> map) {
            Long utime = (Long)map.get(UP_TIME);
            return utime == null ? 0L : utime;
        }

        private void init2(List<LicenseContent> contents) {
            if (contents == null) {
                this.installEval();
                return;
            }
            Date today = Dates.today();
            boolean valid = false;
            Date mindate = new Date(Long.MAX_VALUE);
            Date maxdate = new Date(Long.MIN_VALUE);
            Date maxIssueDate = new Date(Long.MIN_VALUE);
            long uptime = 0L;
            String machine = (String)_wapp.getAttribute(ACTIVE_CODE);
            for (LicenseContent lc : contents) {
                Object mapobj = lc.getExtra();
                if (!(mapobj instanceof Map)) continue;
                Map map = (Map)mapobj;
                Date bdate = this.getNotBefore(map);
                Date edate = this.getExpiryDate(map);
                if (today.before(bdate) || today.after(edate)) continue;
                if (bdate.before(mindate)) {
                    mindate = bdate;
                }
                if (edate.after(maxdate)) {
                    maxdate = edate;
                }
                String activecode = (String)map.get(ACTIVE_CODE);
                Date issueDate = lc.getIssued();
                if (!issueDate.after(maxIssueDate) || !UNIVERSAL_ACTIVE_CODE.equals(activecode) && (machine == null || !machine.equals(activecode))) continue;
                valid = true;
                maxIssueDate = issueDate;
                this._zkpvtversion = map.get(VERSION);
                this._username = map.get(USER_NAME);
                this._companyid = map.get(COMPANY_ID);
                this._companyname = map.get(COMPANY_NAME);
                this._keys = map;
                this._licid = map.get(VERIFICATION_NUMBER);
                this._licversion = map.get(LICENSE_VERSION);
                long utime = this.getUpTime(map);
                if (uptime >= utime) continue;
                uptime = utime;
            }
            if (valid) {
                this._validbegin = mindate;
                this._validend = maxdate;
                this._uptime = uptime <= 0L ? Long.valueOf(maxdate.getTime() - mindate.getTime() + (long)new Random(new Date().getTime()).nextInt(1800000)) : uptime;
            }
            if (!valid || !this.validateLicenseFile()) {
                this.installEval();
            }
        }

        private final void installEval() {
            this._username = EVAL_USER_NAME;
            this._companyid = EVAL_COMPANY_ID;
            this._companyname = EVAL_COMPANY_NAME;
            this._validbegin = new Date();
            this._uptime = (long)(43200000 + new Random(new Date().getTime()).nextInt(1800000));
            this._validend = new Date(((Date)this._validbegin).getTime() + (Long)this._uptime + 3600000L);
            this._keys = new HashMap<String, Object>();
            this._keys.put(COMPANY_ID, this._companyid);
        }

        private final boolean validateLicenseFile() {
            return this._licid != null && this._licversion != null && this._username != null && this._companyid != null && this._companyname != null && this._validbegin != null && this._validend != null && this._zkpvtversion != null && this._uptime != null;
        }

        private final String encode(byte[] lic) {
            try {
                return new String(lic, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }

        private final byte[] decryption(byte[] lic) {
            return lic;
        }
    }

    private static final class Init1 {
        private static final int FREQ = 3;
        private static final String WIN = new ObfuscatedString(new long[]{5321153595986820916L, 6399668227042605266L, -5602491487233658872L, 2066377234886365691L, 203726272017906087L, -3409963818121804467L, -290525610284193589L, 5360349214446654186L, 7126235572874868104L, 6443646263932522040L, -2888496393462639896L}).toString() + new ObfuscatedString(new long[]{8156116825536686571L, -7933011286180755110L, 8429279178335537173L, 5140564363110783572L, -4587992236270359981L, -1850871503295801036L, -7368992273418428298L, -9139769631895394533L, 901440478462063480L, 1371905052599390164L, -5107498036593385759L, -5563648405980080527L, 2015340681356193425L, 916270472538173639L, 7391668993988648096L, 5028903049363742715L, -2699427368479864385L, -2350362590362555178L}).toString();
        private static final Init1 _init1 = new Init1();
        private boolean _stoplicense;
        private boolean _stopuptime;
        private int _inModal;
        private final long _uptime = new Date().getTime();
        private final Init2 _init2 = new Init2();
        private static final String MD5STR = new ObfuscatedString(new long[]{-5121064899839768052L, 3334273322282769989L}).toString();
        private static final String MD = new ObfuscatedString(new long[]{2345590606122015185L, -5069608179148319545L}).toString();
        private static final String TITLE = new ObfuscatedString(new long[]{6290325967589686282L, 5925669707962544096L}).toString();
        private static final String BORDER = new ObfuscatedString(new long[]{1517003640222100403L, -5881717338632855477L}).toString();
        private static final String MODE = new ObfuscatedString(new long[]{2063230648775789892L, -7765346573662599107L, -3183841938540764871L}).toString();
        private static final String WIDTH = new ObfuscatedString(new long[]{-2028303217529921622L, 6478417485293582031L}).toString();
        private static final String HEIGHT = new ObfuscatedString(new long[]{2974696421778732584L, -3701582788618461277L}).toString();
        private static final String ARG = new ObfuscatedString(new long[]{3689490926743112102L, -8583085698292004623L}).toString();
        private static final String PVT_LOCK = new ObfuscatedString(new long[]{8462929522515545295L, 6582226017496064308L, -7191389067685260418L, -4065217573984192165L, -5554800077453076786L}).toString();
        private static final String UPTIME_EXP = new ObfuscatedString(new long[]{-7255507497028916113L, 3985800447471402999L, -2428551027265213584L, 6589691791824192903L, 7085888350675314644L, 8765502600947093081L, -6053156446409996614L, -3987595299556611263L}).toString();
        private static final String TRIAL_EXP = new ObfuscatedString(new long[]{-6261619575057798279L, -8689435690878424899L, -4450687286400992404L, 3898535178026726887L, 2185825549642861995L, -4226059650868469936L}).toString();
        private static final String UPTIME_INFO = new ObfuscatedString(new long[]{-140629977948033438L, 8411039821423448906L, -3474650949739896324L, 2772224587032503194L}).toString();
        private static final String LIC_INFO = new ObfuscatedString(new long[]{-1327671782532263310L, 840490956016971870L, 3061901067660749900L}).toString();
        private static final String MASK_HEAD = new ObfuscatedString(new long[]{2610432342261686015L, 2813741495629532862L, -1181939021078443460L, -7375419926652952589L}).toString();
        private static final String MASK_BODY = new ObfuscatedString(new long[]{-7924049674768767620L, -5640807885409979664L, 7029203202109863500L, 8437967762489256364L, -309579538571070286L}).toString();
        private static final String MASK_FOOT = new ObfuscatedString(new long[]{812264288056794049L, -2332289316366425421L}).toString();

        private Init1() {
        }

        private void init2(List<LicenseContent> contents) {
            this._init2.init2(contents);
            _pass.set(!this._init2._keys.isEmpty());
        }

        private final void afterProcessEvent0(Event event) {
            if (!this.validate(event)) {
                ++this._inModal;
            }
        }

        private final Event beforePostEvent0(Event event) {
            return event;
        }

        private final Event beforeProcessEvent0(Event event) {
            Component comp = event.getTarget();
            if (comp instanceof Pivottable) {
                if (this._stopuptime) {
                    this.maskPvtUptime(comp.getUuid());
                    return null;
                }
                if (this._stoplicense) {
                    this.maskPvtLicense(comp.getUuid());
                    return null;
                }
            }
            return event;
        }

        private final Event beforeSendEvent0(Event event) {
            return event;
        }

        private final void init0(Desktop desktop, Object request) {
            try {
                MessageDigest digest = MessageDigest.getInstance(MD5STR);
                desktop.setAttribute(MD + desktop.getId(), (Object)digest);
            }
            catch (NoSuchAlgorithmException digest) {
                // empty catch block
            }
            Init init = new Init();
            desktop.setAttribute(Runtime.token1(desktop), (Object)init);
            desktop.addListener((Object)init);
        }

        private final void cleanup0(Desktop desktop) {
            Object init = desktop.getAttribute(Runtime.token1(desktop));
            desktop.removeListener(init);
        }

        private final void init2(Execution exec, Execution parent) {
            Runtime.token0(exec, exec);
        }

        private final boolean validate(Event event) {
            return !this.validUptime(event) || !this.validLicense(event);
        }

        private final boolean validLicense(Event event) {
            if (this._init2._keys.isEmpty()) {
                this.complainLicense(event);
                return false;
            }
            long time = new Date().getTime();
            if (((Date)this._init2._validbegin).getTime() > time || time > ((Date)this._init2._validend).getTime()) {
                this.complainLicense(event);
                return false;
            }
            return true;
        }

        private final boolean validUptime(Event event) {
            if (this._init2._keys.isEmpty() || this._init2._uptime == null) {
                this.complainLicense(event);
                return false;
            }
            long time = new Date().getTime();
            if (this._uptime > time || time > this._uptime + (Long)this._init2._uptime) {
                this.complainUptime(event);
                return false;
            }
            return true;
        }

        private final void showWin(Page pg, String message) {
            Window win = new Window(TITLE, BORDER, true);
            Library.setProperty((String)PVT_LOCK, null);
            try {
                win.setMode(MODE);
                win.setWidth(WIDTH);
                win.setHeight(HEIGHT);
                win.setPage(pg);
                HashMap<String, String> arg = new HashMap<String, String>();
                arg.put(ARG, message);
                Component[] comps = Executions.getCurrent().createComponentsDirectly(WIN, "zul", arg);
                for (int j = 0; j < comps.length; ++j) {
                    comps[j].setParent((Component)win);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private final void complainLicense(Event event) {
            Page pg;
            Component comp;
            ++this._inModal;
            if (!this._stoplicense && (this._inModal & 3) == 0 && (comp = event.getTarget()) instanceof Pivottable && (pg = comp.getPage()) != null) {
                this.showWin(pg, TRIAL_EXP);
                this._stoplicense = true;
                this.maskPvtLicense(comp.getUuid());
            }
        }

        private final void complainUptime(Event event) {
            Page pg;
            Component comp;
            ++this._inModal;
            if (!this._stopuptime && (this._inModal & 3) == 0 && (comp = event.getTarget()) instanceof Pivottable && (pg = comp.getPage()) != null) {
                this.showWin(pg, UPTIME_EXP);
                this._stopuptime = true;
                this.maskPvtUptime(comp.getUuid());
            }
        }

        private final void maskPvtUptime(String uuid) {
            this.maskPvt(uuid, UPTIME_INFO);
        }

        private final void maskPvtLicense(String uuid) {
            this.maskPvt(uuid, LIC_INFO);
        }

        private final void maskPvt(String uuid, String txt) {
            Clients.evalJavaScript((String)(MASK_HEAD + uuid + MASK_BODY + txt + MASK_FOOT));
        }
    }
}

