/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderContext;
import org.zkoss.pivot.PivotModel;
import org.zkoss.pivot.PivotRenderer;
import org.zkoss.pivot.Pivottable;
import org.zkoss.pivot.impl.util.HeaderSizeFiller;

public class HeaderSizeInfo {
    private final int _rowDispOffset;
    private final int _colDispOffset;
    private final HeaderSizeFiller _rowFiller;
    private final HeaderSizeFiller _colFiller;

    public HeaderSizeInfo(final Pivottable table, final PivotRenderer renderer, PivotModel model, boolean isColumnOrient) {
        PivotField[] dataPF = model.getFields(PivotField.Type.DATA);
        final PivotField[] rowPF = model.getFields(PivotField.Type.ROW);
        final PivotField[] colPF = model.getFields(PivotField.Type.COLUMN);
        int rowDispOffset = Math.max(colPF.length, 1);
        int colDispOffset = Math.max(rowPF.length, 1);
        if (dataPF.length > 1) {
            if (isColumnOrient && colPF.length > 0) {
                ++rowDispOffset;
            } else if (!isColumnOrient && rowPF.length > 0) {
                ++colDispOffset;
            }
        }
        this._rowDispOffset = rowDispOffset;
        this._colDispOffset = colDispOffset;
        this._rowFiller = new HeaderSizeFiller(dataPF, !isColumnOrient, rowDispOffset + 1, model.getRowHeaderTree()){

            @Override
            protected int getRenderSize(PivotHeaderContext headerCtx, PivotField dataField) {
                return renderer.getRowSize(table, headerCtx, dataField);
            }

            @Override
            protected PivotField getOffsetField(int index) {
                return index == 0 || index > colPF.length ? null : colPF[index - 1];
            }
        };
        this._colFiller = new HeaderSizeFiller(dataPF, isColumnOrient, colDispOffset, model.getColumnHeaderTree()){

            @Override
            protected int getRenderSize(PivotHeaderContext headerCtx, PivotField dataField) {
                return renderer.getColumnSize(table, headerCtx, dataField);
            }

            @Override
            protected PivotField getOffsetField(int index) {
                return index >= rowPF.length ? null : rowPF[index];
            }
        };
    }

    public HeaderSizeFiller getRowFiller() {
        return this._rowFiller;
    }

    public HeaderSizeFiller getColumnFiller() {
        return this._colFiller;
    }

    public int getRowDisplayOffset() {
        return this._rowDispOffset;
    }

    public int getColumnDisplayOffset() {
        return this._colDispOffset;
    }
}

