/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import java.util.List;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotRenderer;
import org.zkoss.pivot.Pivottable;
import org.zkoss.pivot.impl.util.AbstractFiller;
import org.zkoss.pivot.impl.util.HeaderTraverser;
import org.zkoss.pivot.impl.util.IndexMap;
import org.zkoss.pivot.impl.util.PagingInfo;
import org.zkoss.pivot.util.Trees;

public class HeaderLabelFiller
extends AbstractFiller {
    private final Pivottable _table;
    private final PivotRenderer _renderer;
    private int[][] _labels;
    private IndexMap<String> _imap = new IndexMap();

    public HeaderLabelFiller(Pivottable table, PivotRenderer renderer) {
        this._table = table;
        this._renderer = renderer;
    }

    @Override
    public void init(HeaderTraverser context, PagingInfo pgInfo) {
        super.init(context, pgInfo);
        this._labels = new int[context.getRealSize()][context.getDepth()];
    }

    public int[][] getLabelIDs() {
        return this._labels;
    }

    public List<String> getLabelList() {
        return this._imap.getList();
    }

    @Override
    public void forNode(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth) {
        String label = this._renderer.renderField(node.getKey(), this._table, node.getField());
        this._labels[nodeIndex][dispDepth] = this._imap.put(label);
    }

    @Override
    public void forSubtotals(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth, int calIndex) {
        String label = this._renderer.renderSubtotalField(node.getKey(), this._table, node.getField(), Trees.getCalculator(node, calIndex));
        this._labels[nodeIndex][dispDepth] = this._imap.put(label);
    }
}

