/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotRenderer;
import org.zkoss.pivot.Pivottable;
import org.zkoss.pivot.impl.util.AbstractFiller;
import org.zkoss.pivot.impl.util.HeaderTraverser;
import org.zkoss.pivot.impl.util.PagingInfo;
import org.zkoss.pivot.util.PivotExportCell;
import org.zkoss.pivot.util.Trees;

public class ExportHeaderCellFiller
extends AbstractFiller {
    private final Pivottable _table;
    private final PivotRenderer _renderer;
    private PivotExportCell[][] _nodes;
    private final boolean _isCol;
    private final int _dfSize;
    private int _depth;

    public ExportHeaderCellFiller(Pivottable table, PivotRenderer renderer, boolean isColumn, int dataFieldSize) {
        this._table = table;
        this._renderer = renderer;
        this._isCol = isColumn;
        this._dfSize = dataFieldSize;
    }

    public PivotExportCell[][] getExportCells() {
        return this._nodes;
    }

    @Override
    public void init(HeaderTraverser context, PagingInfo pgInfo) {
        super.init(context, pgInfo);
        this._depth = context.getDepth();
        this._nodes = new PivotExportCell[context.getRealSize()][this._depth];
    }

    @Override
    public void forNode(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth) {
        int[] spans = this.getSpans(node, ctx);
        PivotExportCell.Type type = this._isCol ? PivotExportCell.Type.COLUMN : PivotExportCell.Type.ROW;
        Object key = node.getKey();
        String label = this._renderer.renderField(key, this._table, node.getField());
        this._nodes[nodeIndex][dispDepth] = new PivotExportCell(type, label, key, spans, node.getField().getFieldName());
    }

    @Override
    public void forSubtotals(PivotHeaderNode node, Trees.TreeTravCtx ctx, int nodeIndex, int dispDepth, int calIndex) {
        int[] nArray;
        int vspan = this._depth + 1 - node.getDepth();
        if (this._isCol) {
            int[] nArray2 = new int[2];
            nArray2[0] = this._dfSize;
            nArray = nArray2;
            nArray2[1] = vspan;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = vspan;
            nArray = nArray3;
            nArray3[1] = this._dfSize;
        }
        int[] spans = nArray;
        PivotExportCell.Type type = this._isCol ? PivotExportCell.Type.COLUMN_SUBTOTAL : PivotExportCell.Type.ROW_SUBTOTAL;
        Object key = node.getKey();
        Calculator calculator = Trees.getCalculator(node, calIndex);
        String label = this._renderer.renderSubtotalField(key, this._table, node.getField(), calculator);
        this._nodes[nodeIndex][dispDepth] = new PivotExportCell(type, label, key, spans, node.getField().getFieldName(), calculator);
    }

    private int[] getSpans(PivotHeaderNode node, Trees.TreeTravCtx ctx) {
        int[] nArray;
        int vspan;
        boolean open = ctx.open() || node.isOpen();
        int hspan = this._dfSize * (node.isLeaf() || !open ? 1 : ctx.nodesize());
        int n = vspan = node.isLeaf() || open ? 1 : this._depth + 1 - node.getDepth();
        if (this._isCol) {
            int[] nArray2 = new int[2];
            nArray2[0] = hspan;
            nArray = nArray2;
            nArray2[1] = vspan;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = vspan;
            nArray = nArray3;
            nArray3[1] = hspan;
        }
        return nArray;
    }
}

