/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.calc;

import org.zkoss.pivot.impl.calc.Context;
import org.zkoss.pivot.impl.calc.ContextFactory;

public class VarianceContext
implements Context<VarianceContext> {
    protected double _sqsum = 0.0;
    protected double _sum = 0.0;
    protected int _ncount = 0;
    public static final ContextFactory<VarianceContext> FACTORY = new ContextFactory<VarianceContext>(){

        public VarianceContext create() {
            return new VarianceContext();
        }
    };

    @Override
    public void add(Object item) {
        if (item != null && item instanceof Number) {
            double n = ((Number)item).doubleValue();
            this._sqsum += n * n;
            this._sum += n;
            ++this._ncount;
        }
    }

    @Override
    public void merge(VarianceContext ctx) {
        this._sqsum += ctx._sqsum;
        this._sum += ctx._sum;
        this._ncount += ctx._ncount;
    }

    public double getSumOfSquare() {
        return this._sqsum;
    }

    public double getSum() {
        return this._sum;
    }

    public int getNumberCount() {
        return this._ncount;
    }

    public Double getVar() {
        return this._ncount < 2 ? null : Double.valueOf((this._sqsum - this._sum / (double)this._ncount) / (double)(this._ncount - 1));
    }

    public Double getVarP() {
        return this._ncount == 0 ? null : Double.valueOf((this._sqsum - this._sum / (double)this._ncount) / (double)this._ncount);
    }
}

