/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.calc;

import org.zkoss.pivot.impl.calc.Context;
import org.zkoss.pivot.impl.calc.ContextFactory;
import org.zkoss.pivot.impl.calc.Numbers;

public class SumCountContext
implements Context<SumCountContext> {
    protected Numbers.MixedTypedNumber _sum = new Numbers.MixedTypedNumber(){

        @Override
        protected int operateInt(int operand1, int operand2) {
            return operand1 + operand2;
        }

        @Override
        protected long operateLong(long operand1, long operand2) {
            return operand1 + operand2;
        }

        @Override
        protected double operateDouble(double operand1, double operand2) {
            return operand1 + operand2;
        }
    };
    protected int _numCount = 0;
    protected int _count = 0;
    public static final ContextFactory<SumCountContext> FACTORY = new ContextFactory<SumCountContext>(){

        public SumCountContext create() {
            return new SumCountContext();
        }
    };

    @Override
    public void add(Object item) {
        if (item == null) {
            return;
        }
        ++this._count;
        if (item instanceof Number) {
            ++this._numCount;
            this._sum.operate((Number)item);
        }
    }

    @Override
    public void merge(SumCountContext ctx) {
        this._count += ctx._count;
        this._numCount += ctx._numCount;
        this._sum.operate(ctx._sum);
    }

    public int getCount() {
        return this._count;
    }

    public int getNumberCount() {
        return this._numCount;
    }

    public Number getSum() {
        return this._sum.getValue();
    }
}

