/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotHeaderTree;
import org.zkoss.pivot.impl.SimplePivotHeaderNode;
import org.zkoss.pivot.impl.util.Calculations;
import org.zkoss.pivot.util.Trees;

public class SimplePivotHeaderTree
implements PivotHeaderTree {
    private final PivotField[] _fields;
    private final SimplePivotHeaderNode _root = new SimplePivotHeaderNode(this);
    private final int _depth;
    private static final Comparator<PivotHeaderNode> _DEF_CMPR = new Comparator<PivotHeaderNode>(){

        @Override
        public int compare(PivotHeaderNode n1, PivotHeaderNode n2) {
            Object o1 = n1.getKey();
            Object o2 = n2.getKey();
            return Calculations.compare(o1, o2);
        }
    };

    public SimplePivotHeaderTree(PivotField[] fields) {
        this._root.setOpen(true);
        this._fields = fields;
        this._depth = fields.length + 1;
    }

    SimplePivotHeaderNode appendKey(Object[] values, int offset) {
        if (values == null) {
            return this._root;
        }
        SimplePivotHeaderNode n = this._root;
        for (int i = 0; i < this._depth - 1; ++i) {
            n = SimplePivotHeaderTree.createChild(n, values[offset + i]);
        }
        return n;
    }

    public void sort() {
        this.sort(null);
    }

    public void sort(Comparator<PivotHeaderNode> comparator) {
        SimplePivotHeaderTree.sort(this._root, comparator);
    }

    @Override
    public int getDepth() {
        return this._depth;
    }

    @Override
    public SimplePivotHeaderNode getRoot() {
        return this._root;
    }

    PivotField[] getFields() {
        return this._fields;
    }

    private static void sort(SimplePivotHeaderNode node, Comparator<PivotHeaderNode> comparator) {
        if (node.isLeaf()) {
            return;
        }
        List<SimplePivotHeaderNode> children = node.getChildren();
        if (comparator == null) {
            comparator = _DEF_CMPR;
        }
        Collections.sort(children, comparator);
        for (SimplePivotHeaderNode child : children) {
            SimplePivotHeaderTree.sort(child, comparator);
        }
    }

    private static SimplePivotHeaderNode createChild(SimplePivotHeaderNode node, Object value) {
        Object key = Trees.getKey(node.getTree().getFields()[node.getDepth()], value);
        SimplePivotHeaderNode n = node.getChild(key);
        if (n == null) {
            n = new SimplePivotHeaderNode(key, node);
        }
        return n;
    }
}

