/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.GroupHandler;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.event.FieldDataEvent;
import org.zkoss.pivot.event.FieldDataListener;

public class SimplePivotField
implements PivotField {
    protected String _name;
    protected String _title;
    protected PivotField.Type _type = PivotField.Type.UNUSED;
    protected GroupHandler _groupHandler;
    private List<FieldDataListener> _listeners = new LinkedList<FieldDataListener>();
    protected Calculator[] _subtotals;
    protected Calculator _summary;

    public SimplePivotField() {
    }

    public SimplePivotField(String name) {
        this._name = name;
        this.setTitle(name);
    }

    public void setTitle(String title) {
        if (!Objects.equals((Object)title, (Object)this._title)) {
            String origin = this._title;
            this._title = title;
            this.fireEvent("title", origin, this._title);
        }
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public PivotField.Type getType() {
        return this._type;
    }

    void setType(PivotField.Type type) {
        if (type != this._type) {
            PivotField.Type origin = this._type;
            this._type = type;
            this.fireEvent("type", (Object)origin, (Object)this._type);
        }
    }

    @Override
    public String getFieldName() {
        return this._name;
    }

    public void setFieldName(String fieldName) {
        if (!Objects.equals((Object)fieldName, (Object)this._name)) {
            String original = this._name;
            this._name = fieldName;
            this.fireEvent("fieldName", original, this._name);
        }
    }

    public void setGroupHandler(GroupHandler groupHandler) {
        if (groupHandler != this._groupHandler) {
            GroupHandler original = this._groupHandler;
            this._groupHandler = groupHandler;
            this.fireEvent("groupHandler", original, this._groupHandler);
        }
    }

    @Override
    public GroupHandler getGroupHandler() {
        return this._groupHandler;
    }

    @Override
    public void addFieldDataListener(FieldDataListener f) {
        this._listeners.add(f);
    }

    @Override
    public void removeFieldDataListener(FieldDataListener f) {
        this._listeners.remove(f);
    }

    protected void fireEvent(String type, Object original, Object current) {
        FieldDataEvent evt = new FieldDataEvent(this, type, original, current);
        for (FieldDataListener f : this._listeners) {
            f.onChange(evt);
        }
    }

    protected void setSubtotals(Calculator[] subtotals) {
        if (!Arrays.equals(this._subtotals, subtotals)) {
            Calculator[] original = this._subtotals;
            this._subtotals = subtotals;
            this.fireEvent("subtotals", original, this._subtotals);
        }
    }

    @Override
    public Calculator[] getSubtotals() {
        return this._subtotals;
    }

    @Override
    public Calculator getSubtotal(int index) {
        return this._subtotals == null || index < 0 || index >= this._subtotals.length ? null : this._subtotals[index];
    }

    protected void setSummary(Calculator summary) {
        if (this._summary != summary) {
            Calculator original = this._summary;
            this._summary = summary;
            this.fireEvent("summary", original, this._summary);
        }
    }

    @Override
    public Calculator getSummary() {
        return this._summary;
    }
}

