/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.util;

import org.zkoss.pivot.Calculator;

public class PivotExportCell {
    private final Number _value;
    private final String _label;
    private final Object _key;
    private final int _rspan;
    private final int _cspan;
    private final Type _type;
    private final String _fieldName;
    private final Calculator _calculator;

    public PivotExportCell(Number value) {
        this(Type.DATA, value, null, null, null, null, null);
    }

    public PivotExportCell(Number value, String fieldName) {
        this(Type.DATA, value, null, null, null, fieldName, null);
    }

    public PivotExportCell(Type type, String label, int[] span) {
        this(type, null, label, null, span, null, null);
    }

    public PivotExportCell(Type type, String label, Object key, int[] span, String fieldName) {
        this(type, null, label, key, span, fieldName, null);
    }

    public PivotExportCell(Type type, String label, Object key, int[] span, String fieldName, Calculator calculator) {
        this(type, null, label, key, span, fieldName, calculator);
    }

    private PivotExportCell(Type type, Number value, String label, Object key, int[] span, String fieldName, Calculator calculator) {
        this._type = type;
        this._value = value;
        this._label = label;
        this._key = key;
        this._cspan = span == null ? 1 : span[0];
        this._rspan = span == null ? 1 : span[1];
        this._fieldName = fieldName;
        this._calculator = calculator;
    }

    public Type getType() {
        return this._type;
    }

    public Number getValue() {
        return this._value;
    }

    public String getLabel() {
        return this._label;
    }

    public Object getKey() {
        return this._key;
    }

    public int getRowSpan() {
        return this._rspan;
    }

    public int getColumnSpan() {
        return this._cspan;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public Calculator getCalcuator() {
        return this._calculator;
    }

    public String toString() {
        String v;
        String string = v = this._value != null ? this._value.toString() : this._label;
        if (v == null) {
            v = "(null)";
        }
        return v + " (" + this._rspan + "*" + this._cspan + ")";
    }

    public static enum Type {
        TITLE_DATA,
        TITLE_COLUMN,
        TITLE_ROW,
        COLUMN,
        COLUMN_SUBTOTAL,
        COLUMN_DATA,
        COLUMN_GRAND_TOTAL,
        ROW,
        ROW_SUBTOTAL,
        ROW_DATA,
        ROW_GRAND_TOTAL,
        DATA;


        public static boolean isTitle(Type type) {
            switch (type) {
                case TITLE_DATA: 
                case TITLE_COLUMN: 
                case TITLE_ROW: {
                    return true;
                }
            }
            return false;
        }
    }
}

