/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.ui;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotModelExt;
import org.zkoss.pivot.ui.PivotFieldControlChangeEvent;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.util.ConventionWires;
import org.zkoss.zul.Div;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.Window;

public class PivotFieldControl
extends Div
implements IdSpace,
AfterCompose {
    private static final long serialVersionUID = -231161691096467273L;
    protected boolean _deferred = false;
    protected String _layout = "square";
    protected PivotModelExt _model;
    protected final Map<String, Calculator> _calmap = new HashMap<String, Calculator>();
    private boolean _dirty = false;
    private boolean _afterCompose;
    private PivotField _currPF;
    private final Map<PivotField, Calculator> _fieldCals = new HashMap<PivotField, Calculator>();
    private final Map<PivotField, Calculator[]> _fieldSubs = new HashMap<PivotField, Calculator[]>();
    protected Grid ulist;
    protected Grid clist;
    protected Grid rlist;
    protected Grid dlist;
    protected Menupopup menuRCF;
    protected Menupopup menuDF;
    protected Menupopup menuSummary;
    protected Menupopup menuFilterList;
    protected Menuitem menuSortA;
    protected Menuitem menuSortZ;
    protected final EventListener SUMMARY_CLICK_LISTENER = new EventListener(){

        public void onEvent(Event event) throws Exception {
            Menuitem item = (Menuitem)event.getTarget();
            Calculator cal = PivotFieldControl.this._calmap.get(item.getValue());
            if (!PivotFieldControl.this._deferred) {
                PivotFieldControl.this._model.setFieldSummary(PivotFieldControl.this._currPF, cal);
            } else {
                PivotFieldControl.this._fieldCals.put(PivotFieldControl.this._currPF, cal);
                PivotFieldControl.this._dirty = true;
            }
            PivotFieldControlChangeEvent evt = new PivotFieldControlChangeEvent((Component)PivotFieldControl.this, PivotFieldControl.this._currPF, null, null);
            Events.postEvent((Event)evt);
        }
    };
    protected final EventListener ITEM_DROP_LISTENER = new EventListener(){

        public void onEvent(Event event) throws Exception {
            DropEvent devt = (DropEvent)event;
            Component target = event.getTarget();
            Row row = (Row)devt.getDragged();
            Grid drag = row.getGrid();
            boolean insert = target instanceof Row;
            Grid drop = insert ? ((Row)target).getGrid() : (Grid)target;
            ListModelList dragModel = (ListModelList)drag.getModel();
            ListModelList dropModel = (ListModelList)drop.getModel();
            PivotField field = (PivotField)row.getValue();
            PivotField.Type oldType = field.getType();
            PivotField.Type type = PivotFieldControl.this.getFieldType(drop);
            if (insert) {
                int index = target.getParent().getChildren().indexOf(target);
                dragModel.remove((Object)field);
                dropModel.add(index, (Object)field);
                if (!PivotFieldControl.this._deferred) {
                    PivotFieldControl.this._model.setFieldType(field, type, index);
                } else {
                    PivotFieldControl.this._dirty = true;
                }
            } else {
                dragModel.remove((Object)field);
                dropModel.add((Object)field);
                if (!PivotFieldControl.this._deferred) {
                    PivotFieldControl.this._model.setFieldType(field, type);
                } else {
                    PivotFieldControl.this._dirty = true;
                }
            }
            PivotFieldControlChangeEvent evt = new PivotFieldControlChangeEvent((Component)PivotFieldControl.this, field, oldType, type);
            Events.postEvent((Event)evt);
        }
    };
    protected final EventListener FIELD_BTN_LISTENER = new EventListener(){

        public void onEvent(Event event) throws Exception {
            Component c = event.getTarget().getParent().getParent();
            if (!(c instanceof Row)) {
                throw new IllegalStateException();
            }
            Row row = (Row)c;
            PivotFieldControl.this._currPF = (PivotField)row.getValue();
            boolean sortable = PivotFieldControl.this.isSortable(row);
            PivotFieldControl.this.menuSortA.setDisabled(!sortable);
            PivotFieldControl.this.menuSortZ.setDisabled(!sortable);
            if (PivotFieldControl.this.isRowOrColumnField(row)) {
                PivotFieldControl.this.menuRCF.open((Component)row, "after_end");
            } else if (PivotFieldControl.this.isDataField(row)) {
                Calculator rcal = PivotFieldControl.this._fieldCals.get(PivotFieldControl.this._currPF);
                if (rcal == null) {
                    rcal = PivotFieldControl.this._currPF.getSummary();
                }
                for (Object obj : PivotFieldControl.this.menuSummary.getChildren()) {
                    Menuitem item;
                    Calculator cal = PivotFieldControl.this._calmap.get((item = (Menuitem)obj).getValue());
                    item.setImage(Objects.equals((Object)rcal, (Object)cal) ? PivotFieldControl.CHECKMARK_URI : PivotFieldControl.CHECKMARK_NULL_URI);
                }
                PivotFieldControl.this.menuDF.open((Component)row, "after_end");
            }
        }
    };
    protected final RowRenderer FIELD_RENDERER = new RowRenderer(){

        public void render(Row row, Object data) throws Exception {
            boolean hasMenu = PivotFieldControl.this.isRowOrColumnField(row) || PivotFieldControl.this.isDataField(row);
            String group = PivotFieldControl.this.getDragGroup();
            row.setDraggable(group);
            row.setDroppable(group);
            PivotField field = (PivotField)data;
            row.setValue(data);
            Div div = new Div();
            row.appendChild((Component)div);
            div.appendChild((Component)new Label(field.getTitle()));
            if (hasMenu) {
                Div btn = new Div();
                btn.setParent((Component)div);
                btn.setSclass("pfc-field-btn");
                btn.addEventListener("onClick", PivotFieldControl.this.FIELD_BTN_LISTENER);
            }
            row.addEventListener("onDrop", PivotFieldControl.this.ITEM_DROP_LISTENER);
        }

        public void render(Row row, Object data, int index) throws Exception {
            this.render(row, data);
        }
    };
    public static final String LAYOUT_SQUARE = "square";
    public static final String LAYOUT_VERTICAL = "vertical";
    public static final String LAYOUT_HORIZONTAL = "horizontal";
    protected static final Map<String, String> VIEW_URI = new HashMap<String, String>();
    protected static final String DATA_FIELD_MENU_URI = "~./zul/pivot/pfc-data-field-menu.zul";
    protected static final String RC_FIELD_MENU_URI = "~./zul/pivot/pfc-rc-field-menu.zul";
    protected static final String SUBTOTAL_MODAL_URI = "~./zul/pivot/pfc-subtotal-modal.zul";
    public static final String LABEL_RES_PREFIX = "pivot.control.";
    protected static final Map<String, String> LABELS;
    public static final String DRAG_GROUP_KEY = "dragGroup";
    protected static final String DRAG_GROUP = "_PVT_FIELD_CONTROL_";
    protected static final String CHECKMARK_URI = "~./pivot/img/menu-checkmark.png";
    protected static final String CHECKMARK_NULL_URI = "~./pivot/img/menu-checkmark-null.png";

    public void setDeferredUpdate(boolean deferred) {
        if (deferred != this._deferred) {
            if (!deferred && this._dirty) {
                this.update();
            }
            this._deferred = deferred;
        }
    }

    public boolean isDeferredUpdate() {
        return this._deferred;
    }

    public void update() {
        if (this._dirty) {
            this.updatePivotFields(this.rlist, PivotField.Type.ROW);
            this.updatePivotFields(this.clist, PivotField.Type.COLUMN);
            this.updatePivotFields(this.dlist, PivotField.Type.DATA);
            this.updatePivotFields(this.ulist, PivotField.Type.UNUSED);
            for (Map.Entry<PivotField, Calculator> entry : this._fieldCals.entrySet()) {
                this._model.setFieldSummary(entry.getKey(), entry.getValue());
            }
            this._fieldCals.clear();
            for (Map.Entry<PivotField, Calculator> entry : this._fieldSubs.entrySet()) {
                this._model.setFieldSubtotals(entry.getKey(), (Calculator[])entry.getValue());
            }
            this._fieldSubs.clear();
            this._dirty = false;
        }
    }

    protected void updatePivotFields(Grid grid, PivotField.Type type) {
        ListModel m = grid.getModel();
        for (int i = 0; i < m.getSize(); ++i) {
            this._model.setFieldType((PivotField)m.getElementAt(i), type);
        }
    }

    public boolean isUpdated() {
        return !this._dirty;
    }

    public String getLayout() {
        return this._layout;
    }

    public void setLayout(String layout) {
        if (layout == null) {
            layout = LAYOUT_SQUARE;
        }
        if (!VIEW_URI.keySet().contains(layout)) {
            throw new WrongValueException("Unknown layout: " + layout);
        }
        if (!Objects.equals((Object)this._layout, (Object)layout)) {
            this._layout = layout;
            if (this._afterCompose) {
                this.loadLayout();
            }
        }
    }

    public PivotModelExt getModel() {
        return this._model;
    }

    public void setModel(PivotModelExt model) {
        this._model = model;
        this.syncModel();
    }

    public void syncModel() {
        this.syncModel(this.rlist, PivotField.Type.ROW);
        this.syncModel(this.clist, PivotField.Type.COLUMN);
        this.syncModel(this.dlist, PivotField.Type.DATA);
        this.syncModel(this.ulist, PivotField.Type.UNUSED);
        PivotFieldControl.clearChildren((Component)this.menuSummary);
        this._calmap.clear();
        if (this._model != null) {
            int index = 0;
            for (Calculator cal : this._model.getSupportedCalculators()) {
                String calKey = "cal-" + index++;
                this._calmap.put(calKey, cal);
                String name = Labels.getLabel((String)cal.getLabelKey(), (String)cal.getLabel());
                Menuitem mi = new Menuitem(name);
                mi.setValue(calKey);
                mi.addEventListener("onClick", this.SUMMARY_CLICK_LISTENER);
                this.menuSummary.appendChild((Component)mi);
            }
        }
    }

    public void afterCompose() {
        this.loadLayout();
        this._afterCompose = true;
    }

    protected void syncModel(Grid grid, PivotField.Type type) {
        Object[] fields = this._model == null ? new PivotField[]{} : this._model.getFields(type);
        grid.setModel((ListModel)new ListModelList(fields));
    }

    protected void loadLayout() {
        this.setZclass("z-pivot-field-control");
        this.dlist = null;
        this.clist = null;
        this.rlist = null;
        this.ulist = null;
        this.menuSortZ = null;
        this.menuSortA = null;
        this.menuFilterList = null;
        this.menuDF = null;
        this.menuRCF = null;
        this.menuSummary = null;
        PivotFieldControl.clearChildren((Component)this);
        Map<String, Object> args = this.getLabels();
        Executions.createComponents((String)VIEW_URI.get(this._layout), (Component)this, args);
        Executions.createComponents((String)this.getRowColumnFieldContextMenuURI(), (Component)this, args);
        Executions.createComponents((String)this.getDataFieldContextMenuURI(), (Component)this, args);
        ConventionWires.wireFellows((IdSpace)this, (Object)((Object)this));
        ConventionWires.addForwards((Component)this, (Object)((Object)this));
        this.initGrid(this.rlist);
        this.initGrid(this.clist);
        this.initGrid(this.dlist);
        this.initGrid(this.ulist);
        this.syncModel();
    }

    protected void initGrid(Grid grid) {
        grid.setDroppable(this.getDragGroup());
        grid.setRowRenderer(this.FIELD_RENDERER);
        grid.addEventListener("onDrop", this.ITEM_DROP_LISTENER);
    }

    public void onClick$menuSortA(Event event) {
        this.sortField(true);
    }

    public void onClick$menuSortZ(Event event) {
        this.sortField(false);
    }

    protected void sortField(boolean ascending) {
        if (this._model instanceof PivotModelExt.SortCtrl) {
            ((PivotModelExt.SortCtrl)((Object)this._model)).setFieldKeyOrder(this._currPF, ascending);
        }
    }

    public void onClick$menuSubtotal(Event event) throws Exception {
        Map<String, Object> args = this.getLabels();
        args.put("_model", this._model);
        args.put("_field", this._currPF);
        args.put("_pfc", (Object)this);
        String uri = this.getSubtotalModalWindowURI();
        Window win = (Window)Executions.createComponents((String)uri, (Component)this, args);
        win.doModal();
    }

    public Calculator[] getSubtotals(PivotField field) {
        Calculator[] cals = this._fieldSubs.get(field);
        return cals != null ? cals : field.getSubtotals();
    }

    public void setSubtotals(PivotField field, Calculator[] selected) {
        if (!this._deferred) {
            this._model.setFieldSubtotals(field, selected);
        } else {
            this._fieldSubs.put(field, selected);
            this._dirty = true;
        }
        PivotFieldControlChangeEvent evt = new PivotFieldControlChangeEvent((Component)this, this._currPF, null, null);
        Events.postEvent((Event)evt);
    }

    protected String getRowColumnFieldContextMenuURI() {
        return RC_FIELD_MENU_URI;
    }

    protected String getDataFieldContextMenuURI() {
        return DATA_FIELD_MENU_URI;
    }

    protected String getSubtotalModalWindowURI() {
        return SUBTOTAL_MODAL_URI;
    }

    protected final Map<String, Object> getLabels() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<String, String> e : this.getDefaultLabels().entrySet()) {
            String key = e.getKey();
            Object value = this.getAttribute(key);
            if (value == null) {
                value = Labels.getLabel((String)(LABEL_RES_PREFIX + key));
            }
            m.put(key, value != null ? value : e.getValue());
        }
        return m;
    }

    protected Map<String, String> getDefaultLabels() {
        return LABELS;
    }

    protected static final void clearChildren(Component c) {
        Component c0;
        while ((c0 = c.getFirstChild()) != null) {
            c0.detach();
        }
    }

    protected final PivotField.Type getFieldType(Grid grid) {
        return grid == this.rlist ? PivotField.Type.ROW : (grid == this.clist ? PivotField.Type.COLUMN : (grid == this.dlist ? PivotField.Type.DATA : PivotField.Type.UNUSED));
    }

    protected final boolean isDataField(Row row) {
        return row.getGrid() == this.dlist;
    }

    protected final boolean isRowOrColumnField(Row row) {
        Grid grid = row.getGrid();
        return grid == this.rlist || grid == this.clist;
    }

    protected final boolean isSortable(Row row) {
        if (!(this._model instanceof PivotModelExt.SortCtrl)) {
            return false;
        }
        Grid grid = row.getGrid();
        return grid == this.rlist || grid == this.clist;
    }

    protected final String getDragGroup() {
        Object value = this.getAttribute(DRAG_GROUP_KEY);
        return value != null && value instanceof String ? (String)value : DRAG_GROUP;
    }

    static {
        VIEW_URI.put(LAYOUT_SQUARE, "~./zul/pivot/pfc-layout-s.zul");
        VIEW_URI.put(LAYOUT_VERTICAL, "~./zul/pivot/pfc-layout-v.zul");
        VIEW_URI.put(LAYOUT_HORIZONTAL, "~./zul/pivot/pfc-layout-h.zul");
        LABELS = new HashMap<String, String>();
        LABELS.put("rowListTitle", "Rows:");
        LABELS.put("columnListTitle", "Columns:");
        LABELS.put("dataListTitle", "Values:");
        LABELS.put("unusedListTitle", "Unused:");
        LABELS.put("sortAsc", "Sort Ascending");
        LABELS.put("sortDesc", "Sort Descending");
        LABELS.put("summary", "Summary");
        LABELS.put("subtotals", "Subtotals...");
        LABELS.put("buttonOK", "OK");
        LABELS.put("buttonCancel", "Cancel");
    }
}

