/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import java.util.List;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Strings;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderContext;
import org.zkoss.pivot.PivotRendererExt;
import org.zkoss.pivot.Pivottable;
import org.zkoss.pivot.impl.util.DataCellTraverser;
import org.zkoss.pivot.impl.util.IndexMap;

public class CellStyleFiller
implements DataCellTraverser.CellFiller {
    private final Pivottable _table;
    private final PivotRendererExt _renderer;
    private final String[][] _dataCellClasses;
    private final String[][] _rowGTCellClasses;
    private boolean _dataCellClsNonempty = false;
    private boolean _rowGTCellClsNonempty = false;
    private IndexMap<String> _styleIMap;
    private JSONObject _styleKMap;

    public CellStyleFiller(Pivottable table, PivotRendererExt renderer, DataCellTraverser trav) {
        this._table = table;
        this._renderer = renderer;
        int colSize = trav.getCellColumnSize();
        this._dataCellClasses = new String[trav.getCellRowSize()][colSize];
        this._rowGTCellClasses = new String[trav.getCellRowGTSize()][colSize];
    }

    public String[][] getDataCellClasses() {
        return this._dataCellClsNonempty ? this._dataCellClasses : null;
    }

    public String[][] getRowGrandTotalCellClasses() {
        return this._rowGTCellClsNonempty ? this._rowGTCellClasses : null;
    }

    public List<String> getStyleValues() {
        return this._styleIMap == null ? null : this._styleIMap.getList();
    }

    public JSONObject getStyleKeys() {
        return this._styleKMap;
    }

    @Override
    public void fill(Number summary, PivotHeaderContext rowCtx, PivotHeaderContext colCtx, PivotField dataField, int ri, int ci, boolean isRowGT) {
        String sclass = this._renderer.renderCellSClass(summary, this._table, rowCtx, colCtx, dataField);
        if (sclass == null) {
            sclass = "";
        } else if (isRowGT) {
            this._rowGTCellClsNonempty = true;
        } else {
            this._dataCellClsNonempty = true;
        }
        (isRowGT ? this._rowGTCellClasses : this._dataCellClasses)[ri][ci] = sclass;
        String style = this._renderer.renderCellStyle(summary, this._table, rowCtx, colCtx, dataField);
        if (!Strings.isBlank((String)style)) {
            if (this._styleIMap == null) {
                this._styleIMap = new IndexMap();
            }
            if (this._styleKMap == null) {
                this._styleKMap = new JSONObject();
            }
            int i = this._styleIMap.put(style);
            String key = (isRowGT ? "gt#" : "") + ri + "#" + ci;
            this._styleKMap.put((Object)key, (Object)i);
        }
    }
}

